/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchException;
import org.opensearch.client.Requests;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.AbstractObjectParser;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.InstantiatingObjectParser;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ObjectParserHelper;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentHelper;
import org.opensearch.tasks.TaskInfo;

@PublicApi(since="1.0.0")
public final class TaskResult
implements Writeable,
ToXContentObject {
    private final boolean completed;
    private final TaskInfo task;
    @Nullable
    private final BytesReference error;
    @Nullable
    private final BytesReference response;
    public static final InstantiatingObjectParser<TaskResult, Void> PARSER;

    public TaskResult(boolean completed, TaskInfo task) {
        this(completed, task, null, null);
    }

    public TaskResult(TaskInfo task, Exception error) throws IOException {
        this(true, task, TaskResult.toXContent(error), null);
    }

    public TaskResult(TaskInfo task, ToXContent response) throws IOException {
        this(true, task, null, XContentHelper.toXContent((ToXContent)response, (MediaType)Requests.INDEX_CONTENT_TYPE, (boolean)true));
    }

    public TaskResult(boolean completed, TaskInfo task, @Nullable BytesReference error, @Nullable BytesReference result) {
        this.completed = completed;
        this.task = Objects.requireNonNull(task, "task is required");
        this.error = error;
        this.response = result;
    }

    public TaskResult(StreamInput in) throws IOException {
        this.completed = in.readBoolean();
        this.task = new TaskInfo(in);
        this.error = in.readOptionalBytesReference();
        this.response = in.readOptionalBytesReference();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.completed);
        this.task.writeTo(out);
        out.writeOptionalBytesReference(this.error);
        out.writeOptionalBytesReference(this.response);
    }

    public TaskInfo getTask() {
        return this.task;
    }

    public BytesReference getError() {
        return this.error;
    }

    public Map<String, Object> getErrorAsMap() {
        if (this.error == null) {
            return Collections.emptyMap();
        }
        return (Map)org.opensearch.common.xcontent.XContentHelper.convertToMap(this.error, false).v2();
    }

    public BytesReference getResponse() {
        return this.response;
    }

    public Map<String, Object> getResponseAsMap() {
        if (this.response == null) {
            return Collections.emptyMap();
        }
        return (Map)org.opensearch.common.xcontent.XContentHelper.convertToMap(this.response, false).v2();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        return builder.endObject();
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("completed", this.completed);
        builder.startObject("task");
        this.task.toXContent(builder, params);
        builder.endObject();
        if (this.error != null) {
            org.opensearch.common.xcontent.XContentHelper.writeRawField("error", this.error, builder, params);
        }
        if (this.response != null) {
            org.opensearch.common.xcontent.XContentHelper.writeRawField("response", this.response, builder, params);
        }
        return builder;
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != TaskResult.class) {
            return false;
        }
        TaskResult other = (TaskResult)obj;
        return Objects.equals(this.completed, other.completed) && Objects.equals(this.task, other.task) && Objects.equals(this.getErrorAsMap(), other.getErrorAsMap()) && Objects.equals(this.getResponseAsMap(), other.getResponseAsMap());
    }

    public int hashCode() {
        return Objects.hash(this.completed, this.task, this.getErrorAsMap(), this.getResponseAsMap());
    }

    private static BytesReference toXContent(Exception error) throws IOException {
        try (XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)Requests.INDEX_CONTENT_TYPE);){
            builder.startObject();
            OpenSearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (Throwable)error);
            builder.endObject();
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"stored_task_result", (boolean)true, TaskResult.class);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("completed", new String[0]));
        parser.declareObject(ConstructingObjectParser.constructorArg(), TaskInfo.PARSER, new ParseField("task", new String[0]));
        ObjectParserHelper parserHelper = new ObjectParserHelper();
        parserHelper.declareRawObject((AbstractObjectParser)parser, ConstructingObjectParser.optionalConstructorArg(), new ParseField("error", new String[0]));
        parserHelper.declareRawObject((AbstractObjectParser)parser, ConstructingObjectParser.optionalConstructorArg(), new ParseField("response", new String[0]));
        PARSER = parser.build();
    }
}

