/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.KDFOperatorFactory;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.SCryptImpl;
import org.bouncycastle.util.Arrays;

public final class Scrypt {
    public static final ParametersBuilder ALGORITHM = new ParametersBuilder(new FipsAlgorithm("scrypt"));

    private Scrypt() {
    }

    public static final class KDFFactory
    implements KDFOperatorFactory<Parameters> {
        @Override
        public KDFCalculator<Parameters> createKDFCalculator(final Parameters parameters) {
            return new KDFCalculator<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public void generateBytes(byte[] byArray) {
                    byte[] byArray2 = SCryptImpl.generate(parameters.seed, parameters.salt, parameters.n, parameters.r, parameters.p, byArray.length);
                    System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                    Arrays.fill(byArray2, (byte)0);
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    byte[] byArray2 = SCryptImpl.generate(parameters.seed, parameters.salt, parameters.n, parameters.r, parameters.p, n2);
                    System.arraycopy(byArray2, 0, byArray, n, n2);
                    Arrays.fill(byArray2, (byte)0);
                }
            };
        }
    }

    public static final class Parameters
    extends FipsParameters {
        final int n;
        final int r;
        final int p;
        final byte[] salt;
        final byte[] seed;

        private Parameters(int n, byte[] byArray, int n2, int n3, byte[] byArray2) {
            super(ALGORITHM.getAlgorithm());
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                if (byArray2.length < 16) {
                    throw new FipsUnapprovedOperationError("salt must be at least 128 bits");
                }
                if (byArray.length < 14) {
                    throw new FipsUnapprovedOperationError("password must be at least 112 bits");
                }
            }
            this.seed = byArray;
            this.n = n;
            this.r = n2;
            this.p = n3;
            this.salt = byArray2;
        }
    }

    public static final class ParametersBuilder
    extends FipsParameters {
        ParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }

        public Parameters using(byte[] byArray, int n, int n2, int n3, byte[] byArray2) {
            return new Parameters(n, Arrays.clone(byArray2), n2, n3, Arrays.clone(byArray));
        }

        public Parameters using(byte[] byArray, int n, int n2, int n3, PasswordConverter passwordConverter, char[] cArray) {
            return new Parameters(n, passwordConverter.convert(cArray), n2, n3, Arrays.clone(byArray));
        }
    }
}

