/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.round;

import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.round.BidirectionalLinearSearcher;
import org.opensearch.common.round.BinarySearcher;
import org.opensearch.common.round.Roundable;

@InternalApi
public final class RoundableFactory {
    private static final int LINEAR_SEARCH_MAX_SIZE = 64;

    private RoundableFactory() {
    }

    public static Roundable create(long[] values, int size) {
        if (size <= 64) {
            return new BidirectionalLinearSearcher(values, size);
        }
        return new BinarySearcher(values, size);
    }
}

