"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.registerAlertingRoutes = registerAlertingRoutes;
var _lodash = require("lodash");
var _constants = require("../utils/constants");
var _adHelpers = require("./utils/adHelpers");
var _helpers = require("../utils/helpers");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ //@ts-ignore
function registerAlertingRoutes(apiRouter, alertingService) {
  apiRouter.post('/monitors/_search', alertingService.searchMonitors);
  apiRouter.post('/monitors/_search/{dataSourceId}', alertingService.searchMonitors);
  apiRouter.get('/monitors/alerts', alertingService.searchAlerts);
  apiRouter.get('/monitors/alerts/{dataSourceId}', alertingService.searchAlerts);
}
class AlertingService {
  constructor(client, dataSourceEnabled) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "dataSourceEnabled", void 0);
    _defineProperty(this, "searchMonitors", async (context, request, opensearchDashboardsResponse) => {
      try {
        const {
          dataSourceId = ''
        } = request.params;
        const requestBody = {
          size: _constants.MAX_MONITORS,
          query: {
            nested: {
              path: 'monitor.inputs',
              query: {
                bool: {
                  should: [{
                    term: {
                      'monitor.inputs.search.indices.keyword': {
                        value: '.opendistro-anomaly-results*'
                      }
                    }
                  }, {
                    match_phrase_prefix: {
                      'monitor.inputs.search.indices': 'opensearch-ad-plugin-result-'
                    }
                  }]
                }
              }
            }
          }
        };
        const callWithRequest = (0, _helpers.getClientBasedOnDataSource)(context, this.dataSourceEnabled, request, dataSourceId, this.client);
        const response = await callWithRequest('alerting.searchMonitors', {
          body: requestBody
        });
        const totalMonitors = (0, _lodash.get)(response, 'hits.total.value', 0);
        const allMonitors = (0, _lodash.get)(response, 'hits.hits', []).reduce((acc, monitor) => ({
          ...acc,
          [monitor._id]: {
            id: monitor._id,
            name: (0, _lodash.get)(monitor, '_source.name'),
            enabled: (0, _lodash.get)(monitor, '_source.enabled', false),
            enabledTime: (0, _lodash.get)(monitor, '_source.enabled_time'),
            schedule: (0, _lodash.get)(monitor, '_source.schedule'),
            inputs: (0, _lodash.get)(monitor, '_source.inputs'),
            triggers: (0, _lodash.get)(monitor, '_source.triggers'),
            lastUpdateTime: (0, _lodash.get)(monitor, '_source.last_update_time')
          }
        }), {});
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true,
            response: {
              totalMonitors,
              monitors: Object.values(allMonitors)
            }
          }
        });
      } catch (err) {
        console.log('Unable to get monitor on top of detector', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: (0, _adHelpers.getErrorMessage)(err)
          }
        });
      }
    });
    _defineProperty(this, "searchAlerts", async (context, request, opensearchDashboardsResponse) => {
      try {
        const {
          monitorId,
          startTime,
          endTime
        } = request.query;
        const {
          dataSourceId = ''
        } = request.params;
        const callWithRequest = (0, _helpers.getClientBasedOnDataSource)(context, this.dataSourceEnabled, request, dataSourceId, this.client);
        const response = callWithRequest('alerting.searchAlerts', {
          monitorId: monitorId,
          startTime: startTime,
          endTime: endTime
        });
        return opensearchDashboardsResponse.ok({
          body: {
            ok: true,
            response
          }
        });
      } catch (err) {
        console.log('Unable to search alerts', err);
        return opensearchDashboardsResponse.ok({
          body: {
            ok: false,
            error: (0, _adHelpers.getErrorMessage)(err)
          }
        });
      }
    });
    this.client = client;
    this.dataSourceEnabled = dataSourceEnabled;
  }
}
exports.default = AlertingService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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