/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.utils.ExprValueOrdering;
import org.opensearch.sql.expression.Expression;

public interface SortHelper {
    public static Comparator<ExprValue> constructExprComparator(List<Pair<Sort.SortOption, Expression>> sortList) {
        return (o1, o2) -> SortHelper.compareWithExpressions(o1, o2, SortHelper.constructComparator(sortList));
    }

    public static Ordering<ExprValue> constructExprOrdering(List<Pair<Sort.SortOption, Expression>> sortList) {
        return Ordering.from(SortHelper.constructExprComparator(sortList));
    }

    private static List<Pair<Expression, Comparator<ExprValue>>> constructComparator(List<Pair<Sort.SortOption, Expression>> sortList) {
        ArrayList<Pair<Expression, Comparator<ExprValue>>> comparators = new ArrayList<Pair<Expression, Comparator<ExprValue>>>();
        for (Pair<Sort.SortOption, Expression> pair : sortList) {
            Sort.SortOption option = (Sort.SortOption)pair.getLeft();
            ExprValueOrdering ordering = Sort.SortOrder.ASC.equals((Object)option.getSortOrder()) ? ExprValueOrdering.natural() : ExprValueOrdering.natural().reverse();
            ordering = Sort.NullOrder.NULL_FIRST.equals((Object)option.getNullOrder()) ? ordering.nullsFirst() : ordering.nullsLast();
            comparators.add((Pair<Expression, Comparator<ExprValue>>)Pair.of((Object)((Expression)pair.getRight()), (Object)ordering));
        }
        return comparators;
    }

    private static int compareWithExpressions(ExprValue o1, ExprValue o2, List<Pair<Expression, Comparator<ExprValue>>> comparators) {
        for (Pair<Expression, Comparator<ExprValue>> comparator : comparators) {
            Expression expression = (Expression)comparator.getKey();
            int result = ((Comparator)comparator.getValue()).compare(expression.valueOf(o1.bindingTuples()), expression.valueOf(o2.bindingTuples()));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

