/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.visitor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opensearch.sql.legacy.antlr.SimilarSymbols;
import org.opensearch.sql.legacy.antlr.semantic.SemanticAnalysisException;
import org.opensearch.sql.legacy.antlr.semantic.scope.Environment;
import org.opensearch.sql.legacy.antlr.semantic.scope.Namespace;
import org.opensearch.sql.legacy.antlr.semantic.scope.SemanticContext;
import org.opensearch.sql.legacy.antlr.semantic.scope.Symbol;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;
import org.opensearch.sql.legacy.antlr.semantic.types.TypeExpression;
import org.opensearch.sql.legacy.antlr.semantic.types.base.OpenSearchDataType;
import org.opensearch.sql.legacy.antlr.semantic.types.function.AggregateFunction;
import org.opensearch.sql.legacy.antlr.semantic.types.function.OpenSearchScalarFunction;
import org.opensearch.sql.legacy.antlr.semantic.types.function.ScalarFunction;
import org.opensearch.sql.legacy.antlr.semantic.types.operator.ComparisonOperator;
import org.opensearch.sql.legacy.antlr.semantic.types.operator.JoinOperator;
import org.opensearch.sql.legacy.antlr.semantic.types.operator.SetOperator;
import org.opensearch.sql.legacy.antlr.semantic.types.special.Product;
import org.opensearch.sql.legacy.antlr.visitor.GenericSqlParseTreeVisitor;
import org.opensearch.sql.legacy.utils.StringUtils;

public class TypeChecker
implements GenericSqlParseTreeVisitor<Type> {
    private static final Type NULL_TYPE = new Type(){

        @Override
        public String getName() {
            return "NULL";
        }

        @Override
        public boolean isCompatible(Type other) {
            throw new IllegalStateException("Compatibility check on NULL type with " + String.valueOf(other));
        }

        @Override
        public Type construct(List<Type> others) {
            throw new IllegalStateException("Construct operation on NULL type with " + String.valueOf(others));
        }

        @Override
        public String usage() {
            throw new IllegalStateException("Usage print operation on NULL type");
        }
    };
    private final SemanticContext context;
    private final boolean isSuggestEnabled;

    public TypeChecker(SemanticContext context) {
        this.context = context;
        this.isSuggestEnabled = false;
    }

    public TypeChecker(SemanticContext context, boolean isSuggestEnabled) {
        this.context = context;
        this.isSuggestEnabled = isSuggestEnabled;
    }

    @Override
    public void visitRoot() {
        this.defineFunctionNames(ScalarFunction.values());
        this.defineFunctionNames(OpenSearchScalarFunction.values());
        this.defineFunctionNames(AggregateFunction.values());
        this.defineOperatorNames(ComparisonOperator.values());
        this.defineOperatorNames(SetOperator.values());
        this.defineOperatorNames(JoinOperator.values());
    }

    @Override
    public void visitQuery() {
        this.context.push();
    }

    @Override
    public void endVisitQuery() {
        this.context.pop();
    }

    @Override
    public Type visitSelect(List<Type> itemTypes) {
        if (itemTypes.size() == 1) {
            return itemTypes.get(0);
        }
        if (itemTypes.size() == 0) {
            return this.visitSelectAllColumn();
        }
        return new Product(itemTypes);
    }

    @Override
    public Type visitSelectAllColumn() {
        return this.resolveAllColumn();
    }

    @Override
    public void visitAs(String alias, Type type) {
        this.defineFieldName(alias, type);
    }

    @Override
    public Type visitIndexName(String indexName) {
        return this.resolve(new Symbol(Namespace.FIELD_NAME, indexName));
    }

    @Override
    public Type visitFieldName(String fieldName) {
        if (fieldName.startsWith("_")) {
            return OpenSearchDataType.UNKNOWN;
        }
        return this.resolve(new Symbol(Namespace.FIELD_NAME, fieldName));
    }

    @Override
    public Type visitFunctionName(String funcName) {
        return this.resolve(new Symbol(Namespace.FUNCTION_NAME, StringUtils.toUpper(funcName)));
    }

    @Override
    public Type visitOperator(String opName) {
        return this.resolve(new Symbol(Namespace.OPERATOR_NAME, StringUtils.toUpper(opName)));
    }

    @Override
    public Type visitString(String text) {
        return OpenSearchDataType.STRING;
    }

    @Override
    public Type visitInteger(String text) {
        return OpenSearchDataType.INTEGER;
    }

    @Override
    public Type visitFloat(String text) {
        return OpenSearchDataType.FLOAT;
    }

    @Override
    public Type visitBoolean(String text) {
        return "MISSING".equalsIgnoreCase(text) ? OpenSearchDataType.UNKNOWN : OpenSearchDataType.BOOLEAN;
    }

    @Override
    public Type visitDate(String text) {
        return OpenSearchDataType.DATE;
    }

    @Override
    public Type visitNull() {
        return OpenSearchDataType.UNKNOWN;
    }

    @Override
    public Type visitConvertedType(String text) {
        return OpenSearchDataType.typeOf(text);
    }

    @Override
    public Type defaultValue() {
        return NULL_TYPE;
    }

    private void defineFieldName(String fieldName, Type type) {
        Symbol symbol = new Symbol(Namespace.FIELD_NAME, fieldName);
        if (!this.environment().resolve(symbol).isPresent()) {
            this.environment().define(symbol, type);
        }
    }

    private void defineFunctionNames(TypeExpression[] expressions) {
        for (TypeExpression expr : expressions) {
            this.environment().define(new Symbol(Namespace.FUNCTION_NAME, expr.getName()), expr);
        }
    }

    private void defineOperatorNames(Type[] expressions) {
        for (Type expr : expressions) {
            this.environment().define(new Symbol(Namespace.OPERATOR_NAME, expr.getName()), expr);
        }
    }

    private Type resolve(Symbol symbol) {
        Optional<Type> type = this.environment().resolve(symbol);
        if (type.isPresent()) {
            return type.get();
        }
        Object errorMsg = StringUtils.format("%s cannot be found or used here.", symbol);
        if (this.isSuggestEnabled || symbol.getNamespace() != Namespace.FIELD_NAME) {
            Set<String> allSymbolsInScope = this.environment().resolveAll(symbol.getNamespace()).keySet();
            String suggestedWord = new SimilarSymbols(allSymbolsInScope).mostSimilarTo(symbol.getName());
            errorMsg = (String)errorMsg + StringUtils.format(" Did you mean [%s]?", suggestedWord);
        }
        throw new SemanticAnalysisException((String)errorMsg);
    }

    private Type resolveAllColumn() {
        this.environment().resolveAll(Namespace.FIELD_NAME);
        return new Product((List<Type>)ImmutableList.of());
    }

    private Environment environment() {
        return this.context.peek();
    }
}

