/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUCache;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.impl.UResource;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberingSystem;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

class CompactDecimalDataCache {
    private static final String SHORT_STYLE = "short";
    private static final String LONG_STYLE = "long";
    private static final String SHORT_CURRENCY_STYLE = "shortCurrency";
    private static final String NUMBER_ELEMENTS = "NumberElements";
    private static final String PATTERNS_LONG = "patternsLong";
    private static final String PATTERNS_SHORT = "patternsShort";
    private static final String DECIMAL_FORMAT = "decimalFormat";
    private static final String CURRENCY_FORMAT = "currencyFormat";
    private static final String LATIN_NUMBERING_SYSTEM = "latn";
    public static final String OTHER = "other";
    static final int MAX_DIGITS = 15;
    private final ICUCache<ULocale, DataBundle> cache = new SimpleCache<ULocale, DataBundle>();

    CompactDecimalDataCache() {
    }

    DataBundle get(ULocale locale) {
        DataBundle result = this.cache.get(locale);
        if (result == null) {
            result = CompactDecimalDataCache.load(locale);
            this.cache.put(locale, result);
        }
        return result;
    }

    private static DataBundle load(ULocale ulocale) throws MissingResourceException {
        DataBundle dataBundle = DataBundle.createEmpty();
        String nsName = NumberingSystem.getInstance(ulocale).getName();
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt58b", ulocale);
        CompactDecimalDataSink sink = new CompactDecimalDataSink(dataBundle, ulocale);
        sink.isFallback = false;
        if (!nsName.equals(LATIN_NUMBERING_SYSTEM)) {
            sink.isLatin = false;
            try {
                r.getAllItemsWithFallback("NumberElements/" + nsName, sink);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            sink.isFallback = true;
        }
        sink.isLatin = true;
        r.getAllItemsWithFallback("NumberElements/latn", sink);
        if (dataBundle.longData.isEmpty()) {
            dataBundle.longData = dataBundle.shortData;
        }
        CompactDecimalDataCache.checkForOtherVariants(dataBundle.longData, ulocale, LONG_STYLE);
        CompactDecimalDataCache.checkForOtherVariants(dataBundle.shortData, ulocale, SHORT_STYLE);
        CompactDecimalDataCache.checkForOtherVariants(dataBundle.shortCurrencyData, ulocale, SHORT_CURRENCY_STYLE);
        CompactDecimalDataCache.fillInMissing(dataBundle.longData);
        CompactDecimalDataCache.fillInMissing(dataBundle.shortData);
        CompactDecimalDataCache.fillInMissing(dataBundle.shortCurrencyData);
        return dataBundle;
    }

    private static int populatePrefixSuffix(String pluralVariant, int idx, String template, ULocale locale, String style, Data destination, boolean overwrite) {
        int i;
        String suffix;
        int firstIdx = template.indexOf("0");
        int lastIdx = template.lastIndexOf("0");
        if (firstIdx == -1) {
            throw new IllegalArgumentException("Expect at least one zero in template '" + template + "' for variant '" + pluralVariant + "' for 10^" + idx + " in " + CompactDecimalDataCache.localeAndStyle(locale, style));
        }
        String prefix = template.substring(0, firstIdx);
        boolean saved = CompactDecimalDataCache.saveUnit(new DecimalFormat.Unit(prefix, suffix = template.substring(lastIdx + 1)), pluralVariant, idx, destination.units, overwrite);
        if (!saved) {
            return -1;
        }
        if (prefix.trim().length() == 0 && suffix.trim().length() == 0) {
            return idx + 1;
        }
        for (i = firstIdx + 1; i <= lastIdx && template.charAt(i) == '0'; ++i) {
        }
        return i - firstIdx;
    }

    private static long calculateDivisor(long power10, int numZeros) {
        long divisor = power10;
        for (int i = 1; i < numZeros; ++i) {
            divisor /= 10L;
        }
        return divisor;
    }

    private static String localeAndStyle(ULocale locale, String style) {
        return "locale '" + locale + "' style '" + style + "'";
    }

    private static void checkForOtherVariants(Data data, ULocale locale, String style) {
        DecimalFormat.Unit[] otherByBase = data.units.get(OTHER);
        if (otherByBase == null) {
            throw new IllegalArgumentException("No 'other' plural variants defined in " + CompactDecimalDataCache.localeAndStyle(locale, style));
        }
        for (Map.Entry<String, DecimalFormat.Unit[]> entry : data.units.entrySet()) {
            if (entry.getKey() == OTHER) continue;
            DecimalFormat.Unit[] variantByBase = entry.getValue();
            for (int log10Value = 0; log10Value < 15; ++log10Value) {
                if (variantByBase[log10Value] == null || otherByBase[log10Value] != null) continue;
                throw new IllegalArgumentException("No 'other' plural variant defined for 10^" + log10Value + " but a '" + entry.getKey() + "' variant is defined in " + CompactDecimalDataCache.localeAndStyle(locale, style));
            }
        }
    }

    private static void fillInMissing(Data result) {
        long lastDivisor = 1L;
        for (int i = 0; i < result.divisors.length; ++i) {
            if (result.units.get(OTHER)[i] == null) {
                result.divisors[i] = lastDivisor;
                CompactDecimalDataCache.copyFromPreviousIndex(i, result.units);
                continue;
            }
            lastDivisor = result.divisors[i];
            CompactDecimalDataCache.propagateOtherToMissing(i, result.units);
        }
    }

    private static void propagateOtherToMissing(int idx, Map<String, DecimalFormat.Unit[]> units) {
        DecimalFormat.Unit otherVariantValue = units.get(OTHER)[idx];
        for (DecimalFormat.Unit[] byBase : units.values()) {
            if (byBase[idx] != null) continue;
            byBase[idx] = otherVariantValue;
        }
    }

    private static void copyFromPreviousIndex(int idx, Map<String, DecimalFormat.Unit[]> units) {
        for (DecimalFormat.Unit[] byBase : units.values()) {
            if (idx == 0) {
                byBase[idx] = DecimalFormat.NULL_UNIT;
                continue;
            }
            byBase[idx] = byBase[idx - 1];
        }
    }

    private static boolean saveUnit(DecimalFormat.Unit unit, String pluralVariant, int idx, Map<String, DecimalFormat.Unit[]> units, boolean overwrite) {
        DecimalFormat.Unit[] byBase = units.get(pluralVariant);
        if (byBase == null) {
            byBase = new DecimalFormat.Unit[15];
            units.put(pluralVariant, byBase);
        }
        if (!overwrite && byBase[idx] != null) {
            return false;
        }
        byBase[idx] = unit;
        return true;
    }

    static DecimalFormat.Unit getUnit(Map<String, DecimalFormat.Unit[]> units, String variant, int base) {
        DecimalFormat.Unit[] byBase = units.get(variant);
        if (byBase == null) {
            byBase = units.get(OTHER);
        }
        return byBase[base];
    }

    private static final class CompactDecimalDataSink
    extends UResource.Sink {
        private DataBundle dataBundle;
        private ULocale locale;
        private boolean isLatin;
        private boolean isFallback;

        public CompactDecimalDataSink(DataBundle dataBundle, ULocale locale) {
            this.dataBundle = dataBundle;
            this.locale = locale;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean isRoot) {
            if (isRoot && !this.isLatin) {
                return;
            }
            UResource.Table patternsTable = value.getTable();
            int i1 = 0;
            while (patternsTable.getKeyAndValue(i1, key, value)) {
                block14: {
                    PatternsTableKey patternsTableKey;
                    block13: {
                        block12: {
                            if (!key.contentEquals(CompactDecimalDataCache.PATTERNS_SHORT)) break block12;
                            patternsTableKey = PatternsTableKey.PATTERNS_SHORT;
                            break block13;
                        }
                        if (!key.contentEquals(CompactDecimalDataCache.PATTERNS_LONG)) break block14;
                        patternsTableKey = PatternsTableKey.PATTERNS_LONG;
                    }
                    UResource.Table formatsTable = value.getTable();
                    int i2 = 0;
                    while (formatsTable.getKeyAndValue(i2, key, value)) {
                        block17: {
                            Data destination;
                            String style;
                            block19: {
                                FormatsTableKey formatsTableKey;
                                block20: {
                                    block18: {
                                        block16: {
                                            block15: {
                                                if (!key.contentEquals(CompactDecimalDataCache.DECIMAL_FORMAT)) break block15;
                                                formatsTableKey = FormatsTableKey.DECIMAL_FORMAT;
                                                break block16;
                                            }
                                            if (!key.contentEquals(CompactDecimalDataCache.CURRENCY_FORMAT)) break block17;
                                            formatsTableKey = FormatsTableKey.CURRENCY_FORMAT;
                                        }
                                        style = null;
                                        destination = null;
                                        if (patternsTableKey != PatternsTableKey.PATTERNS_LONG || formatsTableKey != FormatsTableKey.DECIMAL_FORMAT) break block18;
                                        style = CompactDecimalDataCache.LONG_STYLE;
                                        destination = this.dataBundle.longData;
                                        break block19;
                                    }
                                    if (patternsTableKey != PatternsTableKey.PATTERNS_SHORT || formatsTableKey != FormatsTableKey.DECIMAL_FORMAT) break block20;
                                    style = CompactDecimalDataCache.SHORT_STYLE;
                                    destination = this.dataBundle.shortData;
                                    break block19;
                                }
                                if (patternsTableKey != PatternsTableKey.PATTERNS_SHORT || formatsTableKey != FormatsTableKey.CURRENCY_FORMAT) break block17;
                                style = CompactDecimalDataCache.SHORT_CURRENCY_STYLE;
                                destination = this.dataBundle.shortCurrencyData;
                            }
                            if (!(this.isFallback && style == CompactDecimalDataCache.LONG_STYLE && !this.dataBundle.shortData.isEmpty() && !this.dataBundle.shortData.fromFallback || isRoot && style == CompactDecimalDataCache.LONG_STYLE && this.dataBundle.longData.isEmpty() && !this.dataBundle.shortData.isEmpty())) {
                                destination.fromFallback = this.isFallback;
                                UResource.Table powersOfTenTable = value.getTable();
                                int i3 = 0;
                                while (powersOfTenTable.getKeyAndValue(i3, key, value)) {
                                    long power10 = Long.parseLong(key.toString());
                                    int log10Value = (int)Math.log10(power10);
                                    if (log10Value < 15) {
                                        UResource.Table pluralVariantsTable = value.getTable();
                                        int i4 = 0;
                                        while (pluralVariantsTable.getKeyAndValue(i4, key, value)) {
                                            String template;
                                            String pluralVariant = key.toString();
                                            int numZeros = CompactDecimalDataCache.populatePrefixSuffix(pluralVariant, log10Value, template = value.toString(), this.locale, style, destination, false);
                                            if (numZeros >= 0) {
                                                long divisor = CompactDecimalDataCache.calculateDivisor(power10, numZeros);
                                                if (destination.divisors[log10Value] != 0L && destination.divisors[log10Value] != divisor) {
                                                    throw new IllegalArgumentException("Plural variant '" + pluralVariant + "' template '" + template + "' for 10^" + log10Value + " has wrong number of zeros in " + CompactDecimalDataCache.localeAndStyle(this.locale, style));
                                                }
                                                destination.divisors[log10Value] = divisor;
                                            }
                                            ++i4;
                                        }
                                    }
                                    ++i3;
                                }
                            }
                        }
                        ++i2;
                    }
                }
                ++i1;
            }
        }
    }

    static class DataBundle {
        Data shortData;
        Data longData;
        Data shortCurrencyData;

        private DataBundle(Data shortData, Data longData, Data shortCurrencyData) {
            this.shortData = shortData;
            this.longData = longData;
            this.shortCurrencyData = shortCurrencyData;
        }

        private static DataBundle createEmpty() {
            return new DataBundle(new Data(new long[15], new HashMap<String, DecimalFormat.Unit[]>()), new Data(new long[15], new HashMap<String, DecimalFormat.Unit[]>()), new Data(new long[15], new HashMap<String, DecimalFormat.Unit[]>()));
        }
    }

    static class Data {
        long[] divisors;
        Map<String, DecimalFormat.Unit[]> units;
        boolean fromFallback;

        Data(long[] divisors, Map<String, DecimalFormat.Unit[]> units) {
            this.divisors = divisors;
            this.units = units;
        }

        public boolean isEmpty() {
            return this.units == null || this.units.isEmpty();
        }
    }

    private static enum FormatsTableKey {
        DECIMAL_FORMAT,
        CURRENCY_FORMAT;

    }

    private static enum PatternsTableKey {
        PATTERNS_LONG,
        PATTERNS_SHORT;

    }
}

