/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import com.google.common.collect.ImmutableMap;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.index.query.MatchBoolPrefixQueryBuilder;
import org.opensearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.MultiMatchQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.SimpleQueryStringBuilder;
import org.opensearch.index.query.SimpleQueryStringFlag;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.index.query.support.QueryParsers;
import org.opensearch.index.search.MatchQuery;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.RelevanceQuery;

public final class FunctionParameterRepository {
    public static final Map<String, RelevanceQuery.QueryBuilderStep<MatchBoolPrefixQueryBuilder>> MatchBoolPrefixQueryBuildActions = ImmutableMap.builder().put((Object)"analyzer", (b, v) -> b.analyzer(v.stringValue())).put((Object)"boost", (b, v) -> (MatchBoolPrefixQueryBuilder)b.boost(FunctionParameterRepository.convertFloatValue(v, "boost"))).put((Object)"fuzziness", (b, v) -> b.fuzziness(FunctionParameterRepository.convertFuzziness(v))).put((Object)"fuzzy_rewrite", (b, v) -> b.fuzzyRewrite(FunctionParameterRepository.checkRewrite(v, "fuzzy_rewrite"))).put((Object)"fuzzy_transpositions", (b, v) -> b.fuzzyTranspositions(FunctionParameterRepository.convertBoolValue(v, "fuzzy_transpositions"))).put((Object)"max_expansions", (b, v) -> b.maxExpansions(FunctionParameterRepository.convertIntValue(v, "max_expansions"))).put((Object)"minimum_should_match", (b, v) -> b.minimumShouldMatch(v.stringValue())).put((Object)"operator", (b, v) -> b.operator(FunctionParameterRepository.convertOperator(v, "operator"))).put((Object)"prefix_length", (b, v) -> b.prefixLength(FunctionParameterRepository.convertIntValue(v, "prefix_length"))).build();
    public static final Map<String, RelevanceQuery.QueryBuilderStep<MatchPhrasePrefixQueryBuilder>> MatchPhrasePrefixQueryBuildActions = ImmutableMap.builder().put((Object)"analyzer", (b, v) -> b.analyzer(v.stringValue())).put((Object)"boost", (b, v) -> (MatchPhrasePrefixQueryBuilder)b.boost(FunctionParameterRepository.convertFloatValue(v, "boost"))).put((Object)"max_expansions", (b, v) -> b.maxExpansions(FunctionParameterRepository.convertIntValue(v, "max_expansions"))).put((Object)"slop", (b, v) -> b.slop(FunctionParameterRepository.convertIntValue(v, "slop"))).put((Object)"zero_terms_query", (b, v) -> b.zeroTermsQuery(FunctionParameterRepository.convertZeroTermsQuery(v))).build();
    public static final Map<String, RelevanceQuery.QueryBuilderStep<MatchPhraseQueryBuilder>> MatchPhraseQueryBuildActions = ImmutableMap.builder().put((Object)"analyzer", (b, v) -> b.analyzer(v.stringValue())).put((Object)"boost", (b, v) -> (MatchPhraseQueryBuilder)b.boost(FunctionParameterRepository.convertFloatValue(v, "boost"))).put((Object)"slop", (b, v) -> b.slop(FunctionParameterRepository.convertIntValue(v, "slop"))).put((Object)"zero_terms_query", (b, v) -> b.zeroTermsQuery(FunctionParameterRepository.convertZeroTermsQuery(v))).build();
    public static final Map<String, RelevanceQuery.QueryBuilderStep<MatchQueryBuilder>> MatchQueryBuildActions = ImmutableMap.builder().put((Object)"analyzer", (b, v) -> b.analyzer(v.stringValue())).put((Object)"auto_generate_synonyms_phrase_query", (b, v) -> b.autoGenerateSynonymsPhraseQuery(FunctionParameterRepository.convertBoolValue(v, "auto_generate_synonyms_phrase_query"))).put((Object)"boost", (b, v) -> (MatchQueryBuilder)b.boost(FunctionParameterRepository.convertFloatValue(v, "boost"))).put((Object)"fuzziness", (b, v) -> b.fuzziness(FunctionParameterRepository.convertFuzziness(v))).put((Object)"fuzzy_rewrite", (b, v) -> b.fuzzyRewrite(FunctionParameterRepository.checkRewrite(v, "fuzzy_rewrite"))).put((Object)"fuzzy_transpositions", (b, v) -> b.fuzzyTranspositions(FunctionParameterRepository.convertBoolValue(v, "fuzzy_transpositions"))).put((Object)"lenient", (b, v) -> b.lenient(FunctionParameterRepository.convertBoolValue(v, "lenient"))).put((Object)"minimum_should_match", (b, v) -> b.minimumShouldMatch(v.stringValue())).put((Object)"max_expansions", (b, v) -> b.maxExpansions(FunctionParameterRepository.convertIntValue(v, "max_expansions"))).put((Object)"operator", (b, v) -> b.operator(FunctionParameterRepository.convertOperator(v, "operator"))).put((Object)"prefix_length", (b, v) -> b.prefixLength(FunctionParameterRepository.convertIntValue(v, "prefix_length"))).put((Object)"zero_terms_query", (b, v) -> b.zeroTermsQuery(FunctionParameterRepository.convertZeroTermsQuery(v))).build();
    public static final Map<String, RelevanceQuery.QueryBuilderStep<MultiMatchQueryBuilder>> MultiMatchQueryBuildActions = ImmutableMap.builder().put((Object)"analyzer", (b, v) -> b.analyzer(v.stringValue())).put((Object)"auto_generate_synonyms_phrase_query", (b, v) -> b.autoGenerateSynonymsPhraseQuery(FunctionParameterRepository.convertBoolValue(v, "auto_generate_synonyms_phrase_query"))).put((Object)"boost", (b, v) -> (MultiMatchQueryBuilder)b.boost(FunctionParameterRepository.convertFloatValue(v, "boost"))).put((Object)"cutoff_frequency", (b, v) -> b.cutoffFrequency(FunctionParameterRepository.convertFloatValue(v, "cutoff_frequency"))).put((Object)"fuzziness", (b, v) -> b.fuzziness(FunctionParameterRepository.convertFuzziness(v))).put((Object)"fuzzy_transpositions", (b, v) -> b.fuzzyTranspositions(FunctionParameterRepository.convertBoolValue(v, "fuzzy_transpositions"))).put((Object)"lenient", (b, v) -> b.lenient(FunctionParameterRepository.convertBoolValue(v, "lenient"))).put((Object)"max_expansions", (b, v) -> b.maxExpansions(FunctionParameterRepository.convertIntValue(v, "max_expansions"))).put((Object)"minimum_should_match", (b, v) -> b.minimumShouldMatch(v.stringValue())).put((Object)"operator", (b, v) -> b.operator(FunctionParameterRepository.convertOperator(v, "operator"))).put((Object)"prefix_length", (b, v) -> b.prefixLength(FunctionParameterRepository.convertIntValue(v, "prefix_length"))).put((Object)"slop", (b, v) -> b.slop(FunctionParameterRepository.convertIntValue(v, "slop"))).put((Object)"tie_breaker", (b, v) -> b.tieBreaker(FunctionParameterRepository.convertFloatValue(v, "tie_breaker"))).put((Object)"type", (b, v) -> b.type(FunctionParameterRepository.convertType(v))).put((Object)"zero_terms_query", (b, v) -> b.zeroTermsQuery(FunctionParameterRepository.convertZeroTermsQuery(v))).build();
    public static final Map<String, RelevanceQuery.QueryBuilderStep<QueryStringQueryBuilder>> QueryStringQueryBuildActions = ImmutableMap.builder().put((Object)"allow_leading_wildcard", (b, v) -> b.allowLeadingWildcard(Boolean.valueOf(FunctionParameterRepository.convertBoolValue(v, "allow_leading_wildcard")))).put((Object)"analyzer", (b, v) -> b.analyzer(v.stringValue())).put((Object)"analyze_wildcard", (b, v) -> b.analyzeWildcard(Boolean.valueOf(FunctionParameterRepository.convertBoolValue(v, "analyze_wildcard")))).put((Object)"auto_generate_synonyms_phrase_query", (b, v) -> b.autoGenerateSynonymsPhraseQuery(FunctionParameterRepository.convertBoolValue(v, "auto_generate_synonyms_phrase_query"))).put((Object)"boost", (b, v) -> (QueryStringQueryBuilder)b.boost(FunctionParameterRepository.convertFloatValue(v, "boost"))).put((Object)"default_operator", (b, v) -> b.defaultOperator(FunctionParameterRepository.convertOperator(v, "default_operator"))).put((Object)"enable_position_increments", (b, v) -> b.enablePositionIncrements(FunctionParameterRepository.convertBoolValue(v, "enable_position_increments"))).put((Object)"escape", (b, v) -> b.escape(FunctionParameterRepository.convertBoolValue(v, "escape"))).put((Object)"fuzziness", (b, v) -> b.fuzziness(FunctionParameterRepository.convertFuzziness(v))).put((Object)"fuzzy_max_expansions", (b, v) -> b.fuzzyMaxExpansions(FunctionParameterRepository.convertIntValue(v, "fuzzy_max_expansions"))).put((Object)"fuzzy_prefix_length", (b, v) -> b.fuzzyPrefixLength(FunctionParameterRepository.convertIntValue(v, "fuzzy_prefix_length"))).put((Object)"fuzzy_rewrite", (b, v) -> b.fuzzyRewrite(FunctionParameterRepository.checkRewrite(v, "fuzzy_rewrite"))).put((Object)"fuzzy_transpositions", (b, v) -> b.fuzzyTranspositions(FunctionParameterRepository.convertBoolValue(v, "fuzzy_transpositions"))).put((Object)"lenient", (b, v) -> b.lenient(Boolean.valueOf(FunctionParameterRepository.convertBoolValue(v, "lenient")))).put((Object)"max_determinized_states", (b, v) -> b.maxDeterminizedStates(FunctionParameterRepository.convertIntValue(v, "max_determinized_states"))).put((Object)"minimum_should_match", (b, v) -> b.minimumShouldMatch(v.stringValue())).put((Object)"phrase_slop", (b, v) -> b.phraseSlop(FunctionParameterRepository.convertIntValue(v, "phrase_slop"))).put((Object)"quote_analyzer", (b, v) -> b.quoteAnalyzer(v.stringValue())).put((Object)"quote_field_suffix", (b, v) -> b.quoteFieldSuffix(v.stringValue())).put((Object)"rewrite", (b, v) -> b.rewrite(FunctionParameterRepository.checkRewrite(v, "rewrite"))).put((Object)"tie_breaker", (b, v) -> b.tieBreaker(FunctionParameterRepository.convertFloatValue(v, "tie_breaker"))).put((Object)"time_zone", (b, v) -> b.timeZone(FunctionParameterRepository.checkTimeZone(v))).put((Object)"type", (b, v) -> b.type(FunctionParameterRepository.convertType(v))).build();
    public static final Map<String, RelevanceQuery.QueryBuilderStep<SimpleQueryStringBuilder>> SimpleQueryStringQueryBuildActions = ImmutableMap.builder().put((Object)"analyzer", (b, v) -> b.analyzer(v.stringValue())).put((Object)"analyze_wildcard", (b, v) -> b.analyzeWildcard(FunctionParameterRepository.convertBoolValue(v, "analyze_wildcard"))).put((Object)"auto_generate_synonyms_phrase_query", (b, v) -> b.autoGenerateSynonymsPhraseQuery(FunctionParameterRepository.convertBoolValue(v, "auto_generate_synonyms_phrase_query"))).put((Object)"boost", (b, v) -> (SimpleQueryStringBuilder)b.boost(FunctionParameterRepository.convertFloatValue(v, "boost"))).put((Object)"default_operator", (b, v) -> b.defaultOperator(FunctionParameterRepository.convertOperator(v, "default_operator"))).put((Object)"flags", (b, v) -> b.flags(FunctionParameterRepository.convertFlags(v))).put((Object)"fuzzy_max_expansions", (b, v) -> b.fuzzyMaxExpansions(FunctionParameterRepository.convertIntValue(v, "fuzzy_max_expansions"))).put((Object)"fuzzy_prefix_length", (b, v) -> b.fuzzyPrefixLength(FunctionParameterRepository.convertIntValue(v, "fuzzy_prefix_length"))).put((Object)"fuzzy_transpositions", (b, v) -> b.fuzzyTranspositions(FunctionParameterRepository.convertBoolValue(v, "fuzzy_transpositions"))).put((Object)"lenient", (b, v) -> b.lenient(FunctionParameterRepository.convertBoolValue(v, "lenient"))).put((Object)"minimum_should_match", (b, v) -> b.minimumShouldMatch(v.stringValue())).put((Object)"quote_field_suffix", (b, v) -> b.quoteFieldSuffix(v.stringValue())).build();
    public static final Map<String, RelevanceQuery.QueryBuilderStep<WildcardQueryBuilder>> WildcardQueryBuildActions = ImmutableMap.builder().put((Object)"boost", (b, v) -> (WildcardQueryBuilder)b.boost(FunctionParameterRepository.convertFloatValue(v, "boost"))).put((Object)"case_insensitive", (b, v) -> b.caseInsensitive(FunctionParameterRepository.convertBoolValue(v, "case_insensitive"))).put((Object)"rewrite", (b, v) -> b.rewrite(FunctionParameterRepository.checkRewrite(v, "rewrite"))).build();
    public static final Map<String, String> ArgumentLimitations = ImmutableMap.builder().put((Object)"boost", (Object)"Accepts only floating point values greater than 0.").put((Object)"tie_breaker", (Object)"Accepts only floating point values in range 0 to 1.").put((Object)"rewrite", (Object)"Available values are: constant_score, scoring_boolean, constant_score_boolean, top_terms_X, top_terms_boost_X, top_terms_blended_freqs_X, where X is an integer value.").put((Object)"flags", (Object)String.format("Available values are: %s and any combinations of these separated by '|'.", Arrays.stream((SimpleQueryStringFlag[])SimpleQueryStringFlag.class.getEnumConstants()).map(Enum::toString).collect(Collectors.joining(", ")))).put((Object)"time_zone", (Object)"For more information, follow this link: https://docs.oracle.com/javase/8/docs/api/java/time/ZoneId.html#of-java.lang.String-").put((Object)"fuzziness", (Object)"Available values are: 'AUTO', 'AUTO:x,y' or z, where x, y, z - integer values.").put((Object)"operator", (Object)String.format("Available values are: %s.", Arrays.stream((Operator[])Operator.class.getEnumConstants()).map(Enum::toString).collect(Collectors.joining(", ")))).put((Object)"type", (Object)String.format("Available values are: %s.", Arrays.stream((MultiMatchQueryBuilder.Type[])MultiMatchQueryBuilder.Type.class.getEnumConstants()).map(Enum::toString).collect(Collectors.joining(", ")))).put((Object)"zero_terms_query", (Object)String.format("Available values are: %s.", Arrays.stream((MatchQuery.ZeroTermsQuery[])MatchQuery.ZeroTermsQuery.class.getEnumConstants()).map(Enum::toString).collect(Collectors.joining(", ")))).put((Object)"int", (Object)"Accepts only integer values.").put((Object)"float", (Object)"Accepts only floating point values.").put((Object)"bool", (Object)"Accepts only boolean values: 'true' or 'false'.").build();

    private static String formatErrorMessage(String name, String value) {
        return FunctionParameterRepository.formatErrorMessage(name, value, name);
    }

    private static String formatErrorMessage(String name, String value, String limitationName) {
        return String.format("Invalid %s value: '%s'. %s", name, value, ArgumentLimitations.containsKey(name) ? ArgumentLimitations.get(name) : ArgumentLimitations.getOrDefault(limitationName, ""));
    }

    public static String checkRewrite(ExprValue value, String name) {
        try {
            QueryParsers.parseRewriteMethod((String)value.stringValue().toLowerCase(), null, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
            return value.stringValue();
        }
        catch (Exception e) {
            throw new RuntimeException(FunctionParameterRepository.formatErrorMessage(name, value.stringValue(), "rewrite"));
        }
    }

    public static SimpleQueryStringFlag[] convertFlags(ExprValue value) {
        try {
            return (SimpleQueryStringFlag[])Arrays.stream(value.stringValue().toUpperCase().split("\\|")).map(SimpleQueryStringFlag::valueOf).toArray(SimpleQueryStringFlag[]::new);
        }
        catch (Exception e) {
            throw new RuntimeException(FunctionParameterRepository.formatErrorMessage("flags", value.stringValue()), e);
        }
    }

    public static String checkTimeZone(ExprValue value) {
        try {
            ZoneId.of(value.stringValue());
            return value.stringValue();
        }
        catch (Exception e) {
            throw new RuntimeException(FunctionParameterRepository.formatErrorMessage("time_zone", value.stringValue()), e);
        }
    }

    public static Fuzziness convertFuzziness(ExprValue value) {
        try {
            return Fuzziness.build((Object)value.stringValue().toUpperCase());
        }
        catch (Exception e) {
            throw new RuntimeException(FunctionParameterRepository.formatErrorMessage("fuzziness", value.stringValue()), e);
        }
    }

    public static Operator convertOperator(ExprValue value, String name) {
        try {
            return Operator.fromString((String)value.stringValue().toUpperCase());
        }
        catch (Exception e) {
            throw new RuntimeException(FunctionParameterRepository.formatErrorMessage(name, value.stringValue(), "operator"));
        }
    }

    public static MultiMatchQueryBuilder.Type convertType(ExprValue value) {
        try {
            return MultiMatchQueryBuilder.Type.parse((String)value.stringValue().toLowerCase(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        }
        catch (Exception e) {
            throw new RuntimeException(FunctionParameterRepository.formatErrorMessage("type", value.stringValue()), e);
        }
    }

    public static MatchQuery.ZeroTermsQuery convertZeroTermsQuery(ExprValue value) {
        try {
            return MatchQuery.ZeroTermsQuery.valueOf((String)value.stringValue().toUpperCase());
        }
        catch (Exception e) {
            throw new RuntimeException(FunctionParameterRepository.formatErrorMessage("zero_terms_query", value.stringValue()), e);
        }
    }

    public static int convertIntValue(ExprValue value, String name) {
        try {
            return Integer.parseInt(value.stringValue());
        }
        catch (Exception e) {
            throw new RuntimeException(FunctionParameterRepository.formatErrorMessage(name, value.stringValue(), "int"), e);
        }
    }

    public static float convertFloatValue(ExprValue value, String name) {
        try {
            return Float.parseFloat(value.stringValue());
        }
        catch (Exception e) {
            throw new RuntimeException(FunctionParameterRepository.formatErrorMessage(name, value.stringValue(), "float"), e);
        }
    }

    public static boolean convertBoolValue(ExprValue value, String name) {
        try {
            Boolean res = Boolean.parseBoolean(value.stringValue());
            if (value.stringValue().equalsIgnoreCase(res.toString())) {
                return res;
            }
            throw new Exception("Invalid boolean value");
        }
        catch (Exception e) {
            throw new RuntimeException(FunctionParameterRepository.formatErrorMessage(name, value.stringValue(), "bool"), e);
        }
    }

    @Generated
    private FunctionParameterRepository() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

