/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nio;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.AbstractRefCounted;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.nio.ChannelFactory;
import org.opensearch.nio.EventHandler;
import org.opensearch.nio.NioGroup;
import org.opensearch.nio.NioSelectorGroup;
import org.opensearch.nio.NioServerSocketChannel;
import org.opensearch.nio.NioSocketChannel;
import org.opensearch.transport.nio.NioTransportPlugin;

public final class NioGroupFactory {
    private final Logger logger;
    private final Settings settings;
    private final int httpWorkerCount;
    private RefCountedNioGroup refCountedGroup;

    public NioGroupFactory(Settings settings, Logger logger) {
        this.logger = logger;
        this.settings = settings;
        this.httpWorkerCount = (Integer)NioTransportPlugin.NIO_HTTP_WORKER_COUNT.get(settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public synchronized NioGroup getTransportGroup() throws IOException {
        return this.getGenericGroup();
    }

    public synchronized NioGroup getHttpGroup() throws IOException {
        if (this.httpWorkerCount == 0) {
            return this.getGenericGroup();
        }
        return new NioSelectorGroup(OpenSearchExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_worker"), this.httpWorkerCount, s -> new EventHandler(this::onException, s));
    }

    private NioGroup getGenericGroup() throws IOException {
        if (this.refCountedGroup == null) {
            ThreadFactory threadFactory = OpenSearchExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_worker");
            NioSelectorGroup nioGroup = new NioSelectorGroup(threadFactory, ((Integer)NioTransportPlugin.NIO_WORKER_COUNT.get(this.settings)).intValue(), s -> new EventHandler(this::onException, s));
            this.refCountedGroup = new RefCountedNioGroup(nioGroup);
            return new WrappedNioGroup(this.refCountedGroup);
        }
        this.refCountedGroup.incRef();
        return new WrappedNioGroup(this.refCountedGroup);
    }

    private void onException(Exception exception) {
        this.logger.warn((Message)new ParameterizedMessage("exception caught on transport layer [thread={}]", (Object)Thread.currentThread().getName()), (Throwable)exception);
    }

    private static class RefCountedNioGroup
    extends AbstractRefCounted
    implements NioGroup {
        public static final String NAME = "ref-counted-nio-group";
        private final NioSelectorGroup nioGroup;

        private RefCountedNioGroup(NioSelectorGroup nioGroup) {
            super(NAME);
            this.nioGroup = nioGroup;
        }

        protected void closeInternal() {
            try {
                this.nioGroup.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public <S extends NioServerSocketChannel> S bindServerChannel(InetSocketAddress address, ChannelFactory<S, ?> factory) throws IOException {
            return (S)this.nioGroup.bindServerChannel(address, factory);
        }

        public <S extends NioSocketChannel> S openChannel(InetSocketAddress address, ChannelFactory<?, S> factory) throws IOException {
            return (S)this.nioGroup.openChannel(address, factory);
        }

        public void close() throws IOException {
            throw new UnsupportedOperationException("Should not close. Instead use decRef call.");
        }
    }

    private static class WrappedNioGroup
    implements NioGroup {
        private final RefCountedNioGroup refCountedNioGroup;
        private final AtomicBoolean isOpen = new AtomicBoolean(true);

        private WrappedNioGroup(RefCountedNioGroup refCountedNioGroup) {
            this.refCountedNioGroup = refCountedNioGroup;
        }

        public <S extends NioServerSocketChannel> S bindServerChannel(InetSocketAddress address, ChannelFactory<S, ?> factory) throws IOException {
            this.ensureOpen();
            return this.refCountedNioGroup.bindServerChannel(address, factory);
        }

        public <S extends NioSocketChannel> S openChannel(InetSocketAddress address, ChannelFactory<?, S> factory) throws IOException {
            this.ensureOpen();
            return this.refCountedNioGroup.openChannel(address, factory);
        }

        public void close() {
            if (this.isOpen.compareAndSet(true, false)) {
                this.refCountedNioGroup.decRef();
            }
        }

        private void ensureOpen() {
            if (!this.isOpen.get()) {
                throw new IllegalStateException("NioGroup is closed.");
            }
        }
    }
}

