/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sdot;

import h.ST_Agedge_s;
import h.ST_Agedgeinfo_t;
import h.ST_bezier;
import h.ST_pointf;
import h.ST_splines;
import h.ST_textlabel_t;
import java.util.EnumMap;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkStrategy;
import net.sourceforge.plantuml.cruise.XAbstractEdge;
import net.sourceforge.plantuml.cruise.XEdge;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.RectangleArea;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.sdot.BoxInfo;
import net.sourceforge.plantuml.sdot.YMirror;
import net.sourceforge.plantuml.skin.LineParam;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.Direction;

public class SmetanaEdge
extends XAbstractEdge
implements XEdge,
UDrawable {
    private final ST_Agedge_s edge;
    private final YMirror ymirror;
    private final TextBlock label;
    private final TextBlock headLabel;
    private final TextBlock tailLabel;

    public SmetanaEdge(Link link, ST_Agedge_s edge, YMirror ymirror, TextBlock label, TextBlock tailLabel, TextBlock headLabel, Bibliotekon bibliotekon, ISkinParam skinParam) {
        super(link, skinParam, bibliotekon);
        this.edge = edge;
        this.ymirror = ymirror;
        this.label = label;
        this.tailLabel = tailLabel;
        this.headLabel = headLabel;
    }

    private LinkStrategy getLinkStrategy() {
        return this.link.getLinkStrategy();
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.link.isHidden()) {
            return;
        }
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "link");
        typeIDent.put(UGroupType.ID, "link_" + this.link.getEntity1().getName() + "_" + this.link.getEntity2().getName());
        typeIDent.put(UGroupType.DATA_UID, this.link.getUid());
        typeIDent.put(UGroupType.DATA_ENTITY_1, this.link.getEntity1().getName());
        typeIDent.put(UGroupType.DATA_ENTITY_2, this.link.getEntity2().getName());
        typeIDent.put(UGroupType.DATA_ENTITY_1_UID, this.link.getEntity1().getUid());
        typeIDent.put(UGroupType.DATA_ENTITY_2_UID, this.link.getEntity2().getUid());
        ug.startGroup(typeIDent);
        DotPath dotPath = this.getDotPathInternal();
        if (dotPath != null) {
            Url url;
            if (this.ymirror != null) {
                dotPath = this.ymirror.getMirrored(dotPath);
            }
            RectangleArea rectangleArea1 = null;
            RectangleArea rectangleArea2 = null;
            if (this.link.getEntity1().isGroup()) {
                Cluster cluster1 = this.bibliotekon.getCluster(this.link.getEntity1());
                rectangleArea1 = cluster1.getRectangleArea();
            }
            if (this.link.getEntity2().isGroup()) {
                Cluster cluster2 = this.bibliotekon.getCluster(this.link.getEntity2());
                rectangleArea2 = cluster2.getRectangleArea();
            }
            dotPath = dotPath.simulateCompound(rectangleArea2, rectangleArea1);
            Style styleLine = this.getStyle();
            Rainbow rainbow = Rainbow.build(styleLine, this.skinParam.getIHtmlColorSet());
            HColor arrowHeadColor = rainbow.getArrowHeadColor();
            HColor color = rainbow.getColor();
            if (this.link.getColors() != null) {
                HColor newColor = this.link.getColors().getColor(ColorType.ARROW, ColorType.LINE);
                if (newColor != null) {
                    arrowHeadColor = color = newColor;
                }
            } else if (this.link.getSpecificColor() != null) {
                arrowHeadColor = color = this.link.getSpecificColor();
            }
            ug = ug.apply(HColors.none().bg()).apply(color);
            LinkType linkType = this.link.getType();
            UStroke suggestedStroke = styleLine.getStroke();
            UStroke defaultThickness = this.skinParam.getThickness(LineParam.arrow, null);
            UStroke stroke = suggestedStroke == null || !linkType.getStyle().isNormal() ? linkType.getStroke3(defaultThickness) : linkType.getStroke3(suggestedStroke);
            if (this.link.getColors() != null && this.link.getColors().getSpecificLineStroke() != null) {
                stroke = this.link.getColors().getSpecificLineStroke();
            }
            if ((url = this.link.getUrl()) != null) {
                ug.startUrl(url);
            }
            this.printExtremityAtStart(dotPath, ug.apply(color));
            this.printExtremityAtEnd(dotPath, ug.apply(color));
            ug.apply(stroke).apply(color).draw(dotPath);
            if (url != null) {
                ug.closeUrl();
            }
        }
        if (this.getLabelRectangleTranslate("label") != null) {
            this.label.drawU(ug.apply(this.getLabelRectangleTranslate("label")));
        }
        if (this.getLabelRectangleTranslate("head_label") != null) {
            this.headLabel.drawU(ug.apply(this.getLabelRectangleTranslate("head_label")));
        }
        if (this.getLabelRectangleTranslate("tail_label") != null) {
            this.tailLabel.drawU(ug.apply(this.getLabelRectangleTranslate("tail_label")));
        }
        ug.closeGroup();
    }

    private Style getStyle() {
        StyleSignature result = StyleSignatureBasic.of(SName.root, SName.element, this.diagramType().getStyleName(), SName.arrow).withTOBECHANGED(this.link.getStereotype());
        return result.getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    public XPoint2D getStartPoint() {
        DotPath dotPath = this.getDotPathInternal();
        XPoint2D pt = dotPath.getStartPoint();
        if (this.ymirror != null) {
            pt = this.ymirror.getMirrored(pt);
        }
        return pt;
    }

    public XPoint2D getEndPoint() {
        DotPath dotPath = this.getDotPathInternal();
        XPoint2D pt = dotPath.getEndPoint();
        if (this.ymirror != null) {
            pt = this.ymirror.getMirrored(pt);
        }
        return pt;
    }

    private void printExtremityAtStart(DotPath dotPath, UGraphic ug) {
        ExtremityFactory extremityFactory2 = this.link.getType().getDecor2().getExtremityFactoryComplete(this.skinParam.getBackgroundColor());
        if (extremityFactory2 == null) {
            return;
        }
        XPoint2D p0 = dotPath.getStartPoint();
        double startAngle = dotPath.getStartAngle() + Math.PI;
        try {
            Extremity extremity2 = (Extremity)extremityFactory2.createUDrawable(p0, startAngle, null);
            if (extremity2 != null) {
                if (this.getLinkStrategy() == LinkStrategy.SIMPLIER) {
                    double decorationLength = extremity2.getDecorationLength();
                    dotPath.moveStartPoint(new UTranslate(decorationLength, 0.0).rotate(startAngle - Math.PI));
                }
                extremity2.drawU(ug);
            }
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
            System.err.println("CANNOT DRAW printExtremityAtStart");
        }
    }

    private void printExtremityAtEnd(DotPath dotPath, UGraphic ug) {
        ExtremityFactory extremityFactory1 = this.link.getType().getDecor1().getExtremityFactoryComplete(this.skinParam.getBackgroundColor());
        if (extremityFactory1 == null) {
            return;
        }
        XPoint2D p0 = dotPath.getEndPoint();
        double endAngle = dotPath.getEndAngle();
        try {
            Extremity extremity1 = (Extremity)extremityFactory1.createUDrawable(p0, endAngle, null);
            if (extremity1 != null) {
                if (this.getLinkStrategy() == LinkStrategy.SIMPLIER) {
                    double decorationLength = extremity1.getDecorationLength();
                    dotPath.moveEndPoint(new UTranslate(decorationLength, 0.0).rotate(endAngle - Math.PI));
                }
                extremity1.drawU(ug);
            }
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
            System.err.println("CANNOT DRAW printExtremityAtEnd");
        }
    }

    private URectangle getLabelURectangle() {
        ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)this.edge.data.castTo(ST_Agedgeinfo_t.class);
        ST_textlabel_t label = data.label;
        if (label == null) {
            return null;
        }
        BoxInfo boxInfo = BoxInfo.fromTextlabel(label);
        return URectangle.build(boxInfo.getDimension());
    }

    private UTranslate getLabelRectangleTranslate(String fieldName) {
        ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)this.edge.data;
        ST_textlabel_t label = null;
        if (fieldName.equals("label")) {
            label = data.label;
        } else if (fieldName.equals("head_label")) {
            label = data.head_label;
        } else if (fieldName.equals("tail_label")) {
            label = data.tail_label;
        }
        if (label == null) {
            return null;
        }
        BoxInfo boxInfo = BoxInfo.fromTextlabel(label);
        if (this.ymirror == null) {
            return new UTranslate(boxInfo.getLowerLeft().getX(), boxInfo.getUpperRight().getY());
        }
        return this.ymirror.getMirrored(UTranslate.point(boxInfo.getLowerLeft()));
    }

    private DotPath getDotPathInternal() {
        ST_Agedgeinfo_t data = (ST_Agedgeinfo_t)this.edge.data;
        ST_splines splines = data.spl;
        DotPath dotPath = new DotPath();
        ST_bezier beziers = splines.list.get__(0);
        XPoint2D pt1 = this.getPoint(splines, 0);
        XPoint2D pt2 = this.getPoint(splines, 1);
        XPoint2D pt3 = this.getPoint(splines, 2);
        XPoint2D pt4 = this.getPoint(splines, 3);
        dotPath = dotPath.addCurve(pt1, pt2, pt3, pt4);
        int n = beziers.size;
        for (int i = 4; i < n; i += 3) {
            XPoint2D ppt2 = this.getPoint(splines, i);
            XPoint2D ppt3 = this.getPoint(splines, i + 1);
            XPoint2D ppt4 = this.getPoint(splines, i + 2);
            dotPath = dotPath.addCurve(ppt2, ppt3, ppt4);
        }
        return dotPath;
    }

    private XPoint2D getPoint(ST_splines splines, int i) {
        ST_bezier beziers = splines.list.get__(0);
        ST_pointf pt = beziers.list.get__(i);
        return new XPoint2D(pt.x, pt.y);
    }

    @Override
    public void moveDelta(double deltaX, double deltaY) {
        throw new UnsupportedOperationException("refactor in progress");
    }

    @Override
    public boolean isHidden() {
        throw new UnsupportedOperationException("refactor in progress");
    }

    @Override
    public Direction getArrowDirection() {
        throw new UnsupportedOperationException("refactor in progress");
    }

    @Override
    public double getArrowDirectionInRadian() {
        throw new UnsupportedOperationException("refactor in progress");
    }
}

