#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-FM7RN3wou0G5sg4PyxEf0M
key:                  postgrest-10.0.0-FM7RN3wou0G5sg4PyxEf0M
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  3eeb48bc1a16567839556276ae8cbb96
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-FM7RN3wou0G5sg4PyxEf0M
depends:
    HTTP-4000.4.1-7X5JzBgO5jsBEogelWzCVb
    Ranged-sets-0.4.0-LfLbNTa41KfB0WlZnjBzBg
    aeson-2.1.2.1-GOr0sGsn8HVJzt9KhewtB0
    auto-update-0.1.6-LUPhxSHb2MK6rH2te3fcTq base-4.17.2.1
    base64-bytestring-1.2.1.0-20QKryWonJ0FfyBIVqw9dX
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-9695IAuXzI9BpRD3yNxY1D
    cassava-0.5.3.2-3kQEydgDNwL3aYF4wMBiY3
    configurator-pg-0.2.10-HcaedbG2ZZ2DNaAZRbfjyY containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.2-6pxn4ZHF0O12s0wetU12Eh
    gitrev-1.3.1-HLNMuiuWFFhIgYmYImJML
    hasql-1.5.0.5-4WNvcMIDFz5Ccwx8TicRYq
    hasql-dynamic-statements-0.3.1.1-5kOngblSmVQ9RFik9mKNwP
    hasql-notifications-0.2.0.4-JUs2WPmfw9M9QdEJoNGCY1
    hasql-pool-0.5.2.2-AvXMgdtObStBYtZN4iskDq
    hasql-transaction-1.0.1.1-HSeCQR6U7LJKzmpPBG05St
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-8b2vqk4ytrNGMVbZZ8fq7J
    insert-ordered-containers-0.2.5.3-Cxns96RKzfQ4jTFnCUhaPC
    interpolatedstring-perl6-1.0.2-HLNYRTj196QBThhlnOuf00
    jose-0.10-ELtDYARxf2XAbfHgbRemBB lens-5.2.3-J1GK3I4tdtMEzlekK9vBY2
    lens-aeson-1.2.3-JetefLYKfnRfnFjLXrFSF mtl-2.2.2
    network-3.1.4.0-29qUxJkoDip75hxElAm7gZ
    network-uri-2.6.4.2-2Sr7Eg9Bhz3KcJ8Mdx9CYP
    optparse-applicative-0.17.1.0-CKO7Hv5HIMoIThZFruc57S
    parsec-3.1.16.1 protolude-0.3.5-92FjBUcoLhA9gyv0M28i4c
    regex-tdfa-1.3.2.4-DyGMbh1NpFc9rSkmhAEdJe
    retry-0.9.3.1-2L2WLzaSnW6QnbEYskcZN
    scientific-0.3.7.0-6O6FbUTzbTcBhAh2dckDIt
    swagger2-2.8.9-1t6IePBIwAdD0auGCXbQ0A text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-Jl6TkouWI2i1D1jczNV0uv
    vault-0.3.1.5-5e7UPRpTdU3Hv4JOD2zFGu
    vector-0.13.2.0-F0gUvA5SUIr11j4RVHYOTP
    wai-3.2.4-KfCBQ4hW2dQ3UrOuZjE7QX
    wai-cors-0.2.7-An0MSFb9xyDIdFWK2a9oxX
    wai-extra-3.1.17-EQaSVqAPuPrWMOXJ9Zed7
    wai-logger-2.5.0-63KDL9XUIzf9sjLIiukQm7
    warp-3.3.30-ERGSsAnOLVE9tSaRUWrkfD

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

