/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.serialize;

import schemacrawler.tools.command.serialize.SerializationCommand;
import schemacrawler.tools.command.serialize.options.SerializationFormat;
import schemacrawler.tools.command.serialize.options.SerializationOptions;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.property.PropertyName;

public class SerializationCommandProvider
extends BaseCommandProvider {
    private static final String DESCRIPTION_HEADER = "Create an offline catalog snapshot";

    public SerializationCommandProvider() {
        super(new PropertyName("serialize", DESCRIPTION_HEADER));
    }

    public PluginCommand getCommandLineCommand() {
        PluginCommand pluginCommand = PluginCommand.newPluginCommand((String)"serialize", (String)"** Create an offline catalog snapshot", () -> new String[]{"For more information, see https://www.schemacrawler.com/serialize.html %n"}, () -> new String[]{"Deserialization is possible with the \"offline\" command for Java serialization"});
        return pluginCommand;
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = this.getCommandLineCommand();
        pluginCommand.addOption("output-format", SerializationFormat.class, new String[]{"Supported serialization formats", "<output-format> is one of ${COMPLETION-CANDIDATES}", "Optional, inferred from the extension of the output file"});
        return pluginCommand;
    }

    public SerializationCommand newSchemaCrawlerCommand(String command, Config config) {
        SerializationCommand scCommand = new SerializationCommand();
        scCommand.setCommandOptions(new SerializationOptions());
        return scCommand;
    }

    public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
        return this.supportsOutputFormat(command, outputOptions, SerializationFormat::isSupportedFormat);
    }
}

