/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.serialize.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.io.Serializable;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import us.fatehi.utility.Utility;

@JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"schemaName", "tableName", "columnName"})
public final class ReferencedColumnDocument
implements Serializable {
    private static final long serialVersionUID = -2159895984317222363L;
    private final String tableName;
    private final String schemaName;
    private final String columnName;

    public ReferencedColumnDocument(Column column) {
        Objects.requireNonNull(column, "No column provided");
        Table table = (Table)column.getParent();
        this.tableName = table.getName();
        String schema = table.getSchema().getFullName();
        this.schemaName = !Utility.isBlank((CharSequence)schema) ? schema : null;
        this.columnName = column.getName();
    }

    @JsonProperty(value="column")
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty(value="schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="table")
    public String getTableName() {
        return this.tableName;
    }
}

