/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.serialize.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Table;
import schemacrawler.tools.command.serialize.model.ColumnDocument;
import us.fatehi.utility.Utility;

@JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"schema", "table", "remarks", "columns", "dependents"})
public final class TableDocument
implements Serializable {
    private static final long serialVersionUID = 1873929712139211255L;
    private final String tableName;
    private final String schemaName;
    private final List<ColumnDocument> columns;
    private final String remarks;
    private final Collection<TableDocument> dependentTables;

    public TableDocument(Table table) {
        Objects.requireNonNull(table, "No table provided");
        this.tableName = table.getName();
        String schema = table.getSchema().getFullName();
        this.schemaName = !Utility.isBlank((CharSequence)schema) ? schema : null;
        this.columns = new ArrayList<ColumnDocument>();
        String remarks = table.getRemarks();
        this.remarks = !Utility.isBlank((CharSequence)remarks) ? remarks : null;
        this.dependentTables = new ArrayList<TableDocument>();
    }

    public List<ColumnDocument> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="dependents")
    public Collection<TableDocument> getDependentTables() {
        return this.dependentTables;
    }

    @JsonProperty(value="remarks")
    public String getRemarks() {
        return this.remarks;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schemaName;
    }

    @JsonProperty(value="table")
    public String getTableName() {
        return this.tableName;
    }

    public String toJson() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return super.toString();
        }
    }

    public String toString() {
        return this.toJson();
    }

    void addColumn(ColumnDocument column) {
        if (column != null) {
            this.columns.add(column);
        }
    }

    void addDependentTable(TableDocument dependentTable) {
        if (dependentTable != null) {
            this.dependentTables.add(dependentTable);
        }
    }
}

