/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.util.Comparator;
import java.util.TreeMap;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorData
extends RowSetNavigator
implements Comparator<Object[]> {
    public static final Object[][] emptyTable = new Object[0][];
    private Object[][] dataTable = emptyTable;
    int visibleColumnCount;
    boolean isAggregate;
    boolean isSimpleAggregate;
    Object[] simpleAggregateData;
    boolean reindexTable;
    Index mainIndex;
    Index fullIndex;
    Index orderIndex;
    Index groupIndex;
    Index idIndex;
    final SortAndSlice sortAndSlice;
    TreeMap<Object[], Integer> groupMap;
    LongKeyHashMap<Object[]> idMap;

    RowSetNavigatorData(Session session, SortAndSlice sortAndSlice) {
        this.session = session;
        this.sortAndSlice = sortAndSlice;
    }

    public RowSetNavigatorData(Session session, QuerySpecification querySpecification) {
        this.session = session;
        this.rangePosition = querySpecification.resultRangePosition;
        this.visibleColumnCount = querySpecification.getColumnCount();
        this.isSimpleAggregate = querySpecification.isAggregated && !querySpecification.isGrouped;
        this.mainIndex = querySpecification.mainIndex;
        this.fullIndex = querySpecification.fullIndex;
        this.orderIndex = querySpecification.orderIndex;
        this.sortAndSlice = querySpecification.sortAndSlice;
        if (querySpecification.isGrouped) {
            this.mainIndex = querySpecification.groupIndex;
            this.groupMap = new TreeMap(this);
        }
        if (querySpecification.idIndex != null) {
            this.idMap = new LongKeyHashMap();
        }
    }

    public RowSetNavigatorData(Session session, QueryExpression queryExpression) {
        this.session = session;
        this.mainIndex = queryExpression.mainIndex;
        this.fullIndex = queryExpression.fullIndex;
        this.orderIndex = queryExpression.orderIndex;
        this.visibleColumnCount = queryExpression.getColumnCount();
        this.sortAndSlice = queryExpression.sortAndSlice;
    }

    public RowSetNavigatorData(Session session, RowSetNavigator rowSetNavigator) {
        this.session = session;
        this.sortAndSlice = SortAndSlice.noSort;
        this.setCapacity(rowSetNavigator.size);
        while (rowSetNavigator.next()) {
            this.add(rowSetNavigator.getCurrent());
        }
    }

    public void sortFull() {
        this.mainIndex = this.fullIndex;
        ArraySort.sort((Object[])this.dataTable, this.size, this);
        this.reset();
    }

    public void sortOrder() {
        if (this.orderIndex != null) {
            this.mainIndex = this.orderIndex;
            ArraySort.sort((Object[])this.dataTable, this.size, this);
        }
        this.reset();
    }

    public void sortOrderUnion(SortAndSlice sortAndSlice) {
        if (sortAndSlice.index != null) {
            this.mainIndex = sortAndSlice.index;
            ArraySort.sort((Object[])this.dataTable, this.size, this);
            this.reset();
        }
    }

    @Override
    public void add(Object[] objectArray) {
        this.ensureCapacity();
        this.dataTable[this.size] = objectArray;
        if (this.groupMap != null) {
            this.groupMap.put(objectArray, this.size);
        }
        if (this.idMap != null) {
            Long l = (Long)objectArray[this.visibleColumnCount];
            this.idMap.put((long)l, objectArray);
        }
        ++this.size;
    }

    public void setPosition(Object[] objectArray) {
        int n;
        Integer n2 = this.groupMap.get(objectArray);
        if (n2 == null) {
            return;
        }
        this.currentPos = n = n2.intValue();
    }

    @Override
    public boolean addRow(Row row) {
        throw Error.runtimeError(201, "RowSetNavigatorData");
    }

    public void update(Object[] objectArray, Object[] objectArray2) {
    }

    void addAdjusted(Object[] objectArray, int[] nArray) {
        objectArray = this.projectData(objectArray, nArray);
        this.add(objectArray);
    }

    void insertAdjusted(Object[] objectArray, int[] nArray) {
        objectArray = this.projectData(objectArray, nArray);
        this.insert(objectArray);
    }

    Object[] projectData(Object[] objectArray, int[] nArray) {
        if (nArray == null) {
            objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.visibleColumnCount);
        } else {
            Object[] objectArray2 = new Object[this.visibleColumnCount];
            ArrayUtil.projectRow(objectArray, nArray, objectArray2);
            objectArray = objectArray2;
        }
        return objectArray;
    }

    void insert(Object[] objectArray) {
        this.ensureCapacity();
        System.arraycopy(this.dataTable, this.currentPos, this.dataTable, this.currentPos + 1, this.size - this.currentPos);
        this.dataTable[this.currentPos] = objectArray;
        ++this.size;
    }

    public Object[][] getDataTable() {
        return this.dataTable;
    }

    @Override
    public void release() {
        this.dataTable = emptyTable;
        this.size = 0;
        this.reset();
        this.isClosed = true;
    }

    @Override
    public void clear() {
        this.dataTable = emptyTable;
        this.size = 0;
        this.reset();
    }

    public void resetRowMap() {
        this.groupMap = new TreeMap(this);
    }

    @Override
    public boolean absolute(int n) {
        return super.absolute(n);
    }

    @Override
    public Object[] getCurrent() {
        if (this.currentPos < 0 || this.currentPos >= this.size) {
            return null;
        }
        return this.dataTable[this.currentPos];
    }

    @Override
    public Row getCurrentRow() {
        throw Error.runtimeError(201, "RowSetNavigatorData");
    }

    public Object[] getNextRowData() {
        return this.next() ? this.getCurrent() : null;
    }

    @Override
    public boolean next() {
        return super.next();
    }

    @Override
    public void removeCurrent() {
        System.arraycopy(this.dataTable, this.currentPos + 1, this.dataTable, this.currentPos, this.size - this.currentPos - 1);
        this.dataTable[this.size - 1] = null;
        --this.currentPos;
        --this.size;
    }

    public void removeRange(int n, int n2) {
        ArrayUtil.adjustArray(76, this.dataTable, this.size, n, -n2);
        if (this.currentPos >= n + n2) {
            this.currentPos -= n2;
        } else if (this.currentPos >= n) {
            this.currentPos = n;
        }
        this.size -= n2;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) {
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) {
        this.reset();
        rowOutputInterface.writeLong(this.id);
        rowOutputInterface.writeInt(this.size);
        rowOutputInterface.writeInt(0);
        rowOutputInterface.writeInt(this.size);
        while (this.next()) {
            Object[] objectArray = this.getCurrent();
            rowOutputInterface.writeData(resultMetaData.getExtendedColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
        this.reset();
    }

    public Object[] getData(long l) {
        return this.idMap.get(l);
    }

    public void copy(RowIterator rowIterator, int[] nArray) {
        while (rowIterator.next()) {
            Object[] objectArray = rowIterator.getCurrent();
            this.addAdjusted(objectArray, nArray);
        }
    }

    public void union(RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates();
        rowSetNavigatorData.removeDuplicates();
        this.mainIndex = this.fullIndex;
        while (rowSetNavigatorData.next()) {
            Object[] objectArray = rowSetNavigatorData.getCurrent();
            int n = ArraySort.searchFirst((Object[])this.dataTable, 0, this.size, objectArray, this);
            if (n >= 0) continue;
            this.currentPos = n = -n - 1;
            this.insert(objectArray);
        }
        this.reset();
    }

    public void unionAll(RowSetNavigatorData rowSetNavigatorData) {
        this.mainIndex = this.fullIndex;
        rowSetNavigatorData.reset();
        while (rowSetNavigatorData.next()) {
            Object[] objectArray = rowSetNavigatorData.getCurrent();
            this.add(objectArray);
        }
        this.reset();
    }

    public void intersect(RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates();
        rowSetNavigatorData.sortFull();
        while (this.next()) {
            Object[] objectArray = this.getCurrent();
            boolean bl = rowSetNavigatorData.containsRow(objectArray);
            if (bl) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    public void intersectAll(RowSetNavigatorData rowSetNavigatorData) {
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        this.sortFull();
        rowSetNavigatorData.sortFull();
        RowIterator rowIterator = RowIterator.emptyRowIterator;
        while (this.next()) {
            boolean bl;
            Object[] objectArray3 = this.getCurrent();
            boolean bl2 = bl = objectArray == null || this.fullIndex.compareRowNonUnique((Session)this.session, objectArray3, objectArray, this.visibleColumnCount) != 0;
            if (bl) {
                objectArray = objectArray3;
                rowIterator = rowSetNavigatorData.findFirstRow(objectArray3);
            }
            if (rowIterator.next() && this.fullIndex.compareRowNonUnique((Session)this.session, objectArray3, objectArray2 = rowIterator.getCurrent(), this.visibleColumnCount) == 0) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    public void except(RowSetNavigatorData rowSetNavigatorData) {
        this.removeDuplicates();
        rowSetNavigatorData.sortFull();
        while (this.next()) {
            Object[] objectArray = this.getCurrent();
            boolean bl = rowSetNavigatorData.containsRow(objectArray);
            if (!bl) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    public void exceptNoDedup(RowSetNavigatorData rowSetNavigatorData) {
        rowSetNavigatorData.sortFull();
        this.reset();
        while (this.next()) {
            Object[] objectArray = this.getCurrent();
            boolean bl = rowSetNavigatorData.containsRow(objectArray);
            if (!bl) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    public void exceptAll(RowSetNavigatorData rowSetNavigatorData) {
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        this.sortFull();
        rowSetNavigatorData.sortFull();
        RowIterator rowIterator = RowIterator.emptyRowIterator;
        while (this.next()) {
            boolean bl;
            Object[] objectArray3 = this.getCurrent();
            boolean bl2 = bl = objectArray == null || this.fullIndex.compareRowNonUnique((Session)this.session, objectArray3, objectArray, this.fullIndex.getColumnCount()) != 0;
            if (bl) {
                objectArray = objectArray3;
                rowIterator = rowSetNavigatorData.findFirstRow(objectArray3);
            }
            if (!rowIterator.next() || this.fullIndex.compareRowNonUnique((Session)this.session, objectArray3, objectArray2 = rowIterator.getCurrent(), this.fullIndex.getColumnCount()) != 0) continue;
            this.removeCurrent();
        }
        this.reset();
    }

    public boolean hasUniqueNotNullRows() {
        this.sortFull();
        this.reset();
        Object[] objectArray = null;
        while (this.next()) {
            Object[] objectArray2 = this.getCurrent();
            if (this.hasNull(objectArray2)) continue;
            if (objectArray != null && this.fullIndex.compareRow((Session)this.session, objectArray, objectArray2) == 0) {
                return false;
            }
            objectArray = objectArray2;
        }
        return true;
    }

    public void removeDuplicates() {
        this.sortFull();
        this.reset();
        int n = -1;
        Object[] objectArray = null;
        while (this.next()) {
            Object[] objectArray2 = this.getCurrent();
            if (objectArray == null) {
                n = this.currentPos;
                objectArray = objectArray2;
                continue;
            }
            if (this.fullIndex.compareRow((Session)this.session, objectArray, objectArray2) == 0) continue;
            objectArray = objectArray2;
            this.dataTable[++n] = objectArray2;
        }
        for (int i = n + 1; i < this.size; ++i) {
            this.dataTable[i] = null;
        }
        this.size = n + 1;
        this.reset();
    }

    public void trim(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        if (n >= this.size) {
            this.clear();
            return;
        }
        if ((long)n + (long)n2 < (long)this.size) {
            this.reset();
            this.removeRange(n + n2, this.size - n - n2);
        }
        this.removeRange(0, n);
    }

    boolean hasNull(Object[] objectArray) {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (objectArray[i] != null) continue;
            return true;
        }
        return false;
    }

    public Object[] getGroupData(Object[] objectArray) {
        if (this.isSimpleAggregate) {
            if (this.simpleAggregateData == null) {
                this.simpleAggregateData = objectArray;
                return null;
            }
            return this.simpleAggregateData;
        }
        Integer n = this.groupMap.get(objectArray);
        if (n == null) {
            return null;
        }
        int n2 = n;
        return this.dataTable[n2];
    }

    public Object[] getGroupDataAndPosition(Object[] objectArray) {
        int n;
        Integer n2 = this.groupMap.get(objectArray);
        if (n2 == null) {
            return null;
        }
        this.currentPos = n = n2.intValue();
        return this.dataTable[n];
    }

    boolean containsRow(Object[] objectArray) {
        int n = ArraySort.searchFirst((Object[])this.dataTable, 0, this.size, objectArray, this);
        return n >= 0;
    }

    RowIterator findFirstRow(Object[] objectArray) {
        int n = ArraySort.searchFirst((Object[])this.dataTable, 0, this.size, objectArray, this);
        n = n < 0 ? this.size : --n;
        return new DataIterator(n);
    }

    void getBlock(int n) {
    }

    private void setCapacity(int n) {
        if (this.size > this.dataTable.length) {
            this.dataTable = new Object[n][];
        }
    }

    private void ensureCapacity() {
        if (this.size == this.dataTable.length) {
            int n = this.size == 0 ? 4 : this.size * 2;
            Object[][] objectArrayArray = new Object[n][];
            System.arraycopy(this.dataTable, 0, objectArrayArray, 0, this.size);
            this.dataTable = objectArrayArray;
        }
    }

    @Override
    public int compare(Object[] objectArray, Object[] objectArray2) {
        return this.mainIndex.compareRow((Session)this.session, objectArray, objectArray2);
    }

    class DataIterator
    implements RowIterator {
        int pos;

        DataIterator(int n) {
            this.pos = n;
        }

        @Override
        public Object getField(int n) {
            if (this.pos < RowSetNavigatorData.this.size) {
                return RowSetNavigatorData.this.dataTable[this.pos][n];
            }
            return null;
        }

        @Override
        public boolean next() {
            if (this.pos < RowSetNavigatorData.this.size - 1) {
                ++this.pos;
                return true;
            }
            return false;
        }

        @Override
        public Row getCurrentRow() {
            return null;
        }

        @Override
        public Object[] getCurrent() {
            if (this.pos < RowSetNavigatorData.this.size) {
                return RowSetNavigatorData.this.dataTable[this.pos];
            }
            return null;
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public void release() {
        }

        @Override
        public long getRowId() {
            return 0L;
        }
    }
}

