/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.event;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.firebirdsql.event.DatabaseEvent;
import org.firebirdsql.event.DatabaseEventImpl;
import org.firebirdsql.event.EventListener;
import org.firebirdsql.event.EventManager;
import org.firebirdsql.event.OneTimeEventListener;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.EventHandler;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbConnectionProperties;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.WireCrypt;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBEventManager
implements EventManager {
    private static final Logger log = LoggerFactory.getLogger(FBEventManager.class);
    private final Lock lock = new ReentrantLock();
    private final LockCloseable unlock = this.lock::unlock;
    private final GDSType gdsType;
    private FbDatabase fbDatabase;
    private final IConnectionProperties connectionProperties;
    private final EventManagerBehaviour eventManagerBehaviour;
    private volatile boolean connected = false;
    private final Map<String, Set<EventListener>> listenerMap = new HashMap<String, Set<EventListener>>();
    private final Map<String, GdsEventHandler> handlerMap = new HashMap<String, GdsEventHandler>();
    private final BlockingQueue<DatabaseEvent> eventQueue = new LinkedBlockingQueue<DatabaseEvent>();
    private EventDispatcher eventDispatcher;
    private Thread dispatchThread;
    private volatile long waitTimeout = 1000L;

    public FBEventManager() {
        this(GDSFactory.getDefaultGDSType());
    }

    public FBEventManager(GDSType gdsType) {
        this.gdsType = gdsType;
        this.connectionProperties = new FbConnectionProperties();
        this.eventManagerBehaviour = new DefaultEventManagerBehaviour();
        this.connectionProperties.setType(gdsType.toString());
    }

    private FBEventManager(Connection connection) throws SQLException {
        this.fbDatabase = connection.unwrap(FirebirdConnection.class).getFbDatabase();
        this.gdsType = null;
        this.connectionProperties = this.fbDatabase.getConnectionProperties().asImmutable();
        this.fbDatabase.addDatabaseListener(new DatabaseListener(){

            @Override
            public void detaching(FbDatabase database) {
                try {
                    if (!FBEventManager.this.isConnected()) {
                        return;
                    }
                    try {
                        FBEventManager.this.disconnect();
                    }
                    catch (SQLException e) {
                        log.error("Exception on disconnect of event manager on connection detaching.", e);
                    }
                }
                finally {
                    database.removeDatabaseListener(this);
                    FBEventManager.this.fbDatabase = null;
                }
            }
        });
        this.eventManagerBehaviour = new ManagedEventManagerBehaviour();
    }

    public static EventManager createFor(Connection connection) throws SQLException {
        return new FBEventManager(connection);
    }

    protected final LockCloseable withLock() {
        this.lock.lock();
        return this.unlock;
    }

    @Override
    public final void setType(String type) {
        throw new IllegalStateException("Type must be specified on construction");
    }

    @Override
    public void connect() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.connected) {
                throw new IllegalStateException("Connect called while already connected");
            }
            this.eventManagerBehaviour.connectDatabase();
            this.connected = true;
            this.eventDispatcher = new EventDispatcher();
            this.dispatchThread = new Thread(this.eventDispatcher);
            this.dispatchThread.setDaemon(true);
            this.dispatchThread.start();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.connected) {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() throws SQLException {
        if (!this.connected) {
            throw new IllegalStateException("Disconnect called while not connected");
        }
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        try (LockCloseable ignored = this.withLock();){
            try {
                for (String eventName : new HashSet<String>(this.handlerMap.keySet())) {
                    try {
                        this.unregisterListener(eventName);
                    }
                    catch (SQLException e) {
                        chain.append(e);
                    }
                    catch (Exception e) {
                        chain.append(new SQLException(e));
                    }
                }
            }
            finally {
                this.handlerMap.clear();
                this.listenerMap.clear();
                try {
                    this.eventManagerBehaviour.disconnectDatabase();
                }
                catch (SQLException e) {
                    chain.append(e);
                }
                this.connected = false;
            }
        }
        finally {
            EventDispatcher eventDispatcher = this.eventDispatcher;
            if (eventDispatcher != null) {
                eventDispatcher.stop();
                this.dispatchThread.interrupt();
                try {
                    this.dispatchThread.join();
                }
                catch (InterruptedException ex) {
                    chain.append(new FBSQLException(ex));
                }
                finally {
                    this.eventDispatcher = null;
                    this.dispatchThread = null;
                }
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void setUser(String user) {
        EventManager.super.setUser(user);
    }

    @Override
    public String getUser() {
        return EventManager.super.getUser();
    }

    @Override
    public void setPassword(String password) {
        EventManager.super.setPassword(password);
    }

    @Override
    public String getPassword() {
        return EventManager.super.getPassword();
    }

    @Override
    public String getServerName() {
        return EventManager.super.getServerName();
    }

    @Override
    public void setServerName(String serverName) {
        EventManager.super.setServerName(serverName);
    }

    @Override
    public int getPortNumber() {
        return EventManager.super.getPortNumber();
    }

    @Override
    public void setPortNumber(int portNumber) {
        EventManager.super.setPortNumber(portNumber);
    }

    @Override
    public String getDatabaseName() {
        return this.connectionProperties.getDatabaseName();
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.connectionProperties.setDatabaseName(databaseName);
    }

    @Override
    @Deprecated
    public void setDatabase(String database) {
        this.setDatabaseName(database);
    }

    @Override
    @Deprecated
    public String getDatabase() {
        return this.getDatabaseName();
    }

    @Override
    @Deprecated
    public String getHost() {
        return this.getServerName();
    }

    @Override
    @Deprecated
    public void setHost(String host) {
        this.setServerName(host);
    }

    @Override
    @Deprecated
    public int getPort() {
        return this.getPortNumber();
    }

    @Override
    @Deprecated
    public void setPort(int port) {
        this.setPortNumber(port);
    }

    @Override
    public WireCrypt getWireCryptAsEnum() {
        return this.connectionProperties.getWireCryptAsEnum();
    }

    @Override
    public void setWireCryptAsEnum(WireCrypt wireCrypt) {
        this.connectionProperties.setWireCryptAsEnum(wireCrypt);
    }

    @Override
    public String getWireCrypt() {
        return EventManager.super.getWireCrypt();
    }

    @Override
    public void setWireCrypt(String wireCrypt) {
        EventManager.super.setWireCrypt(wireCrypt);
    }

    @Override
    public String getDbCryptConfig() {
        return EventManager.super.getDbCryptConfig();
    }

    @Override
    public void setDbCryptConfig(String dbCryptConfig) {
        EventManager.super.setDbCryptConfig(dbCryptConfig);
    }

    @Override
    public String getAuthPlugins() {
        return EventManager.super.getAuthPlugins();
    }

    @Override
    public void setAuthPlugins(String authPlugins) {
        EventManager.super.setAuthPlugins(authPlugins);
    }

    @Override
    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public void setWaitTimeout(long waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    @Override
    public void addEventListener(String eventName, EventListener listener) throws SQLException {
        if (listener == null || eventName == null) {
            throw new NullPointerException();
        }
        if (!this.connected) {
            throw new IllegalStateException("Can't add event listeners to disconnected EventManager");
        }
        try (LockCloseable ignored = this.withLock();){
            Set<EventListener> listenerSet = this.listenerMap.get(eventName);
            if (listenerSet == null) {
                this.registerListener(eventName);
                listenerSet = new HashSet<EventListener>();
                this.listenerMap.put(eventName, listenerSet);
            }
            listenerSet.add(listener);
        }
    }

    @Override
    public void removeEventListener(String eventName, EventListener listener) throws SQLException {
        if (eventName == null || listener == null) {
            throw new NullPointerException();
        }
        try (LockCloseable ignored = this.withLock();){
            Set<EventListener> listenerSet = this.listenerMap.get(eventName);
            if (listenerSet != null) {
                listenerSet.remove(listener);
                if (listenerSet.isEmpty()) {
                    this.listenerMap.remove(eventName);
                    this.unregisterListener(eventName);
                }
            }
        }
    }

    @Override
    public int waitForEvent(String eventName) throws InterruptedException, SQLException {
        return this.waitForEvent(eventName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForEvent(String eventName, int timeout) throws InterruptedException, SQLException {
        if (eventName == null) {
            throw new NullPointerException();
        }
        if (!this.connected) {
            throw new IllegalStateException("Can't wait for events with disconnected EventManager");
        }
        OneTimeEventListener listener = new OneTimeEventListener();
        try {
            this.addEventListener(eventName, listener);
            listener.await(timeout, TimeUnit.MILLISECONDS);
        }
        finally {
            this.removeEventListener(eventName, listener);
        }
        return listener.getEventCount();
    }

    private void registerListener(String eventName) throws SQLException {
        GdsEventHandler handler = new GdsEventHandler(eventName);
        try (LockCloseable ignored = this.withLock();){
            this.handlerMap.put(eventName, handler);
            handler.register();
        }
    }

    private void unregisterListener(String eventName) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            GdsEventHandler handler = this.handlerMap.remove(eventName);
            if (handler != null) {
                handler.unregister();
            }
        }
    }

    @Override
    public String getProperty(String name) {
        return this.connectionProperties.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) {
        if ("type".equals(name)) {
            this.setType(value);
        }
        this.connectionProperties.setProperty(name, value);
    }

    @Override
    public Integer getIntProperty(String name) {
        return this.connectionProperties.getIntProperty(name);
    }

    @Override
    public void setIntProperty(String name, Integer value) {
        this.connectionProperties.setIntProperty(name, value);
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        return this.connectionProperties.getBooleanProperty(name);
    }

    @Override
    public void setBooleanProperty(String name, Boolean value) {
        this.connectionProperties.setBooleanProperty(name, value);
    }

    @Override
    public Map<ConnectionProperty, Object> connectionPropertyValues() {
        return this.connectionProperties.connectionPropertyValues();
    }

    final class EventDispatcher
    implements Runnable {
        private volatile boolean running = true;

        EventDispatcher() {
        }

        void stop() {
            this.running = false;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    DatabaseEvent event = (DatabaseEvent)FBEventManager.this.eventQueue.poll(FBEventManager.this.waitTimeout, TimeUnit.MILLISECONDS);
                    if (event == null) continue;
                    LockCloseable ignored = FBEventManager.this.withLock();
                    Throwable throwable = null;
                    try {
                        Set listenerSet = (Set)FBEventManager.this.listenerMap.get(event.getEventName());
                        if (listenerSet == null) continue;
                        for (EventListener listener : listenerSet) {
                            listener.eventOccurred(event);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ignored == null) continue;
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ignored.close();
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    final class GdsEventHandler
    implements EventHandler {
        private final EventHandle eventHandle;
        private volatile boolean initialized = false;
        private volatile boolean cancelled = false;

        GdsEventHandler(String eventName) throws SQLException {
            this.eventHandle = FBEventManager.this.fbDatabase.createEventHandle(eventName, this);
        }

        void register() throws SQLException {
            if (this.cancelled) {
                throw new IllegalStateException("Trying to register a cancelled event handler");
            }
            FBEventManager.this.fbDatabase.queueEvent(this.eventHandle);
        }

        void unregister() throws SQLException {
            if (this.cancelled) {
                return;
            }
            FBEventManager.this.fbDatabase.cancelEvent(this.eventHandle);
            this.cancelled = true;
        }

        @Override
        public void eventOccurred(EventHandle eventHandle) {
            if (this.cancelled) {
                return;
            }
            try {
                FBEventManager.this.fbDatabase.countEvents(eventHandle);
            }
            catch (SQLException e) {
                log.warnDebug("Exception processing event counts", e);
            }
            if (this.initialized && !this.cancelled) {
                FBEventManager.this.eventQueue.add(new DatabaseEventImpl(eventHandle.getEventName(), eventHandle.getEventCount()));
            } else {
                this.initialized = true;
            }
            try {
                this.register();
            }
            catch (SQLException e) {
                log.warnDebug("Exception registering for event", e);
            }
        }
    }

    private final class ManagedEventManagerBehaviour
    implements EventManagerBehaviour {
        private ManagedEventManagerBehaviour() {
        }

        @Override
        public void connectDatabase() throws SQLException {
            if (FBEventManager.this.fbDatabase == null) {
                throw FbExceptionBuilder.forException(337248273).toSQLException();
            }
        }

        @Override
        public void disconnectDatabase() {
        }
    }

    private final class DefaultEventManagerBehaviour
    implements EventManagerBehaviour {
        private DefaultEventManagerBehaviour() {
        }

        @Override
        public void connectDatabase() throws SQLException {
            FbDatabaseFactory databaseFactory = GDSFactory.getDatabaseFactoryForType(FBEventManager.this.gdsType);
            FBEventManager.this.fbDatabase = databaseFactory.connect(FBEventManager.this.connectionProperties);
            FBEventManager.this.fbDatabase.attach();
        }

        @Override
        public void disconnectDatabase() throws SQLException {
            FBEventManager.this.fbDatabase.close();
        }
    }

    private static interface EventManagerBehaviour {
        public void connectDatabase() throws SQLException;

        public void disconnectDatabase() throws SQLException;
    }
}

