/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.ServiceParameterBufferImp;
import org.firebirdsql.gds.impl.ServiceRequestBufferImp;
import org.firebirdsql.gds.ng.ParameterConverter;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.wire.AbstractProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.DefaultBlrCalculator;
import org.firebirdsql.gds.ng.wire.FbWireAsynchronousChannel;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.FbWireService;
import org.firebirdsql.gds.ng.wire.FbWireStatement;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.WireServiceConnection;
import org.firebirdsql.gds.ng.wire.version10.V10AsynchronousChannel;
import org.firebirdsql.gds.ng.wire.version10.V10Database;
import org.firebirdsql.gds.ng.wire.version10.V10InputBlob;
import org.firebirdsql.gds.ng.wire.version10.V10OutputBlob;
import org.firebirdsql.gds.ng.wire.version10.V10ParameterConverter;
import org.firebirdsql.gds.ng.wire.version10.V10Service;
import org.firebirdsql.gds.ng.wire.version10.V10Statement;
import org.firebirdsql.gds.ng.wire.version10.V10Transaction;
import org.firebirdsql.gds.ng.wire.version10.V10WireOperations;

public final class Version10Descriptor
extends AbstractProtocolDescriptor
implements ProtocolDescriptor {
    public Version10Descriptor() {
        super(10, 1, 2, 3, false, 1);
    }

    @Override
    public FbWireDatabase createDatabase(WireDatabaseConnection connection) {
        return new V10Database(connection, this);
    }

    @Override
    public FbWireService createService(WireServiceConnection connection) {
        return new V10Service(connection, this);
    }

    @Override
    public ServiceParameterBuffer createServiceParameterBuffer(WireServiceConnection connection) {
        return new ServiceParameterBufferImp(ServiceParameterBufferImp.SpbMetaData.SPB_VERSION_2, connection.getEncoding());
    }

    @Override
    public ServiceRequestBuffer createServiceRequestBuffer(WireServiceConnection connection) {
        return new ServiceRequestBufferImp(ServiceRequestBufferImp.SrbMetaData.SRB_VERSION_2, connection.getEncoding());
    }

    @Override
    public FbWireTransaction createTransaction(FbWireDatabase database, int transactionHandle, TransactionState initialState) {
        return new V10Transaction(database, transactionHandle, initialState);
    }

    @Override
    public FbWireStatement createStatement(FbWireDatabase database) {
        return new V10Statement(database);
    }

    @Override
    public BlrCalculator createBlrCalculator(FbWireDatabase database) {
        short connectionDialect = database.getConnectionDialect();
        return connectionDialect == 3 ? DefaultBlrCalculator.CALCULATOR_DIALECT_3 : new DefaultBlrCalculator(connectionDialect);
    }

    @Override
    public FbWireBlob createOutputBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        return new V10OutputBlob(database, transaction, blobParameterBuffer);
    }

    @Override
    public FbWireBlob createInputBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer, long blobId) {
        return new V10InputBlob(database, transaction, blobParameterBuffer, blobId);
    }

    @Override
    public FbWireAsynchronousChannel createAsynchronousChannel(FbWireDatabase database) {
        return new V10AsynchronousChannel(database);
    }

    @Override
    public FbWireOperations createWireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback) {
        return new V10WireOperations(connection, defaultWarningMessageCallback);
    }

    @Override
    protected ParameterConverter<WireDatabaseConnection, WireServiceConnection> getParameterConverter() {
        return new V10ParameterConverter();
    }
}

