/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.ioresource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.ioresource.InputResourceUtility;
import us.fatehi.utility.string.StringFormat;

public class FileInputResource
implements InputResource {
    private static final Logger LOGGER = Logger.getLogger(FileInputResource.class.getName());
    private final Path inputFile;

    public FileInputResource(Path filePath) throws IOException {
        this.inputFile = Objects.requireNonNull(filePath, "No file path provided").normalize().toAbsolutePath();
        if (!IOUtility.isFileReadable(this.inputFile)) {
            IOException e = new IOException("Cannot read file, " + this.inputFile);
            LOGGER.log(Level.FINE, e.getMessage(), e);
            throw e;
        }
    }

    public Path getInputFile() {
        return this.inputFile;
    }

    @Override
    public Reader openNewInputReader(Charset charset) throws IOException {
        Objects.requireNonNull(charset, "No input charset provided");
        if (!Files.exists(this.inputFile, new LinkOption[0])) {
            return new StringReader("");
        }
        BufferedReader reader = Files.newBufferedReader(this.inputFile, charset);
        LOGGER.log(Level.FINE, new StringFormat("Opened input reader to file <%s>", this.inputFile));
        return InputResourceUtility.wrapReader(this.getDescription(), reader, true);
    }

    public String toString() {
        return this.inputFile.toString();
    }
}

