/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class OrderedLongKeyHashMap<V>
extends BaseHashMap
implements Map<Long, V> {
    private Set<Long> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Long, V>> entries;

    public OrderedLongKeyHashMap() {
        this(8);
    }

    public OrderedLongKeyHashMap(int n) throws IllegalArgumentException {
        super(n, 2, 3, false);
        this.isList = true;
    }

    public OrderedLongKeyHashMap(int n, boolean bl) throws IllegalArgumentException {
        super(n, 2, 3, false);
        this.objectKeyTable = new Object[this.objectValueTable.length];
        this.isTwoObjectValue = true;
        this.isList = true;
        if (bl) {
            this.objectValueTable2 = new Object[this.objectValueTable.length];
        }
        this.minimizeOnEmpty = true;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Long) {
            long l = (Long)object;
            return this.containsLongKey(l);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean containsKey(long l) {
        return super.containsLongKey(l);
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public V get(Long l) {
        if (l == null) {
            throw new NullPointerException();
        }
        long l2 = l;
        return this.get(l2);
    }

    @Override
    public V get(long l) {
        int n = this.getLookup(l);
        if (n != -1) {
            return (V)this.objectValueTable[n];
        }
        return null;
    }

    public long getKeyAt(int n) {
        this.checkRange(n);
        return this.longKeyTable[n];
    }

    public V getValueAt(int n) {
        this.checkRange(n);
        return (V)this.objectValueTable[n];
    }

    public Object getSecondValueAt(int n) {
        this.checkRange(n);
        return this.objectKeyTable[n];
    }

    public Object getThirdValueAt(int n) {
        this.checkRange(n);
        return this.objectValueTable2[n];
    }

    public V setValueAt(int n, V v) {
        this.checkRange(n);
        Object object = this.objectValueTable[n];
        this.objectValueTable[n] = v;
        return (V)object;
    }

    public Object setSecondValueAt(int n, Object object) {
        this.checkRange(n);
        Object object2 = this.objectKeyTable[n];
        this.objectKeyTable[n] = object;
        return object2;
    }

    public Object setThirdValueAt(int n, Object object) {
        this.checkRange(n);
        Object object2 = this.objectValueTable2[n];
        this.objectValueTable2[n] = object;
        return object2;
    }

    public boolean insert(int n, long l, V v) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.getLookup(l);
        if (n2 >= 0) {
            return false;
        }
        if (n < this.size()) {
            super.insertRow(n);
        }
        this.put(l, v);
        return true;
    }

    public boolean set(int n, long l, V v) throws IndexOutOfBoundsException {
        this.checkRange(n);
        if (this.keySet().contains(l) && this.getIndex(l) != n) {
            return false;
        }
        super.remove(this.longKeyTable[n], 0L, null, null, false, false);
        this.put(l, v);
        return true;
    }

    public boolean setKeyAt(int n, long l) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object = this.objectValueTable[n];
        return this.set(n, l, object);
    }

    public int getIndex(long l) {
        return this.getLookup(l);
    }

    @Override
    public V put(Long l, V v) {
        if (l == null) {
            throw new NullPointerException();
        }
        long l2 = l;
        return this.put(l2, v);
    }

    @Override
    public V put(long l, V v) {
        return (V)super.addOrUpdate(l, 0L, null, v);
    }

    @Override
    public V remove(Object object) {
        if (object instanceof Long) {
            long l = (Long)object;
            return this.remove(l);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V remove(long l) {
        Object object = super.remove(l, 0L, null, null, false, true);
        return (V)object;
    }

    public void removeEntry(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        long l = this.longKeyTable[n];
        super.remove(l, 0L, null, null, false, true);
    }

    @Override
    public int getLookup(long l) {
        return super.getLookup(l);
    }

    public void putAll(LongKeyHashMap<V> longKeyHashMap) {
        Iterator iterator = longKeyHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            long l = iterator.nextLong();
            this.put(l, longKeyHashMap.get(l));
        }
    }

    public long[] keysToArray(long[] lArray) {
        return this.toLongArray(lArray, true);
    }

    public Object[] valuesToArray() {
        return this.toArray(false);
    }

    public <T> T[] valuesToArray(T[] TArray) {
        return this.toArray(TArray, false);
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private class Values
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<V> iterator() {
            OrderedLongKeyHashMap orderedLongKeyHashMap = OrderedLongKeyHashMap.this;
            orderedLongKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(orderedLongKeyHashMap, false);
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            OrderedLongKeyHashMap orderedLongKeyHashMap = OrderedLongKeyHashMap.this;
            orderedLongKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(orderedLongKeyHashMap, true);
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(OrderedLongKeyHashMap.this, true);
        }

        @Override
        public Map.Entry<Long, V> next() {
            Long l = super.nextLong();
            Object object = OrderedLongKeyHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Long, Object>(l, object);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, V>>
    implements Set<Map.Entry<Long, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

