/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.metadata;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.ing.data.cassandra.jdbc.CassandraMetadataResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.ColumnDefinitions;
import com.ing.data.cassandra.jdbc.metadata.AbstractMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.MetadataResultSet;
import com.ing.data.cassandra.jdbc.metadata.MetadataRow;
import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.types.TypesMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FunctionMetadataResultSetBuilder
extends AbstractMetadataResultSetBuilder {
    public FunctionMetadataResultSetBuilder(CassandraStatement statement) throws SQLException {
        super(statement);
    }

    public CassandraMetadataResultSet buildFunctions(String schemaPattern, String functionNamePattern) throws SQLException {
        String catalog = this.connection.getCatalog();
        ArrayList<MetadataRow> functionsRows = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("REMARKS", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_TYPE", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SPECIFIC_NAME", DataTypes.TEXT));
        this.filterBySchemaNamePattern(schemaPattern, keyspaceMetadata -> this.filterByFunctionNamePattern(functionNamePattern, (KeyspaceMetadata)keyspaceMetadata, (functionSignature, functionMetadata) -> {
            MetadataRow row = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), functionSignature.getName().asInternal(), "", (short)1, functionSignature.getName().asInternal());
            functionsRows.add(row);
        }), null);
        functionsRows.sort(Comparator.comparing(row -> ((MetadataRow)row).getString("FUNCTION_SCHEM")).thenComparing(row -> ((MetadataRow)row).getString("FUNCTION_NAME")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(functionsRows));
    }

    public CassandraMetadataResultSet buildFunctionColumns(String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        String catalog = this.connection.getCatalog();
        ArrayList<MetadataRow> functionParamsRows = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FUNCTION_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_TYPE", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("DATA_TYPE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("PRECISION", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("LENGTH", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SCALE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("RADIX", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("NULLABLE", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("REMARKS", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("CHAR_OCTET_LENGTH", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("ORDINAL_POSITION", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("IS_NULLABLE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SPECIFIC_NAME", DataTypes.TEXT));
        this.filterBySchemaNamePattern(schemaPattern, keyspaceMetadata -> this.filterByFunctionNamePattern(functionNamePattern, (KeyspaceMetadata)keyspaceMetadata, (functionSignature, functionMetadata) -> {
            AbstractJdbcType<?> returnJdbcType = TypesMap.getTypeForComparator(functionMetadata.getReturnType().asCql(false, true));
            MetadataRow row = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), functionSignature.getName().asInternal(), "", (short)4, returnJdbcType.getJdbcType(), functionMetadata.getReturnType().toString(), returnJdbcType.getPrecision(null), Integer.MAX_VALUE, returnJdbcType.getScale(null), (short)returnJdbcType.getPrecision(null), (short)1, "", null, 0, "YES", functionSignature.getName().asInternal());
            functionParamsRows.add(row);
            List paramNames = functionMetadata.getParameterNames();
            for (int i = 0; i < paramNames.size(); ++i) {
                if (columnNamePattern != null && !this.matchesPattern(columnNamePattern, ((CqlIdentifier)paramNames.get(i)).asInternal())) continue;
                AbstractJdbcType<?> paramJdbcType = TypesMap.getTypeForComparator(((DataType)functionSignature.getParameterTypes().get(i)).asCql(false, true));
                MetadataRow paramRow = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), functionSignature.getName().asInternal(), ((CqlIdentifier)paramNames.get(i)).asInternal(), (short)1, paramJdbcType.getJdbcType(), ((DataType)functionSignature.getParameterTypes().get(i)).toString(), paramJdbcType.getPrecision(null), Integer.MAX_VALUE, paramJdbcType.getScale(null), (short)paramJdbcType.getPrecision(null), (short)1, "", null, i + 1, "YES", functionSignature.getName().asInternal());
                functionParamsRows.add(paramRow);
            }
        }), null);
        functionParamsRows.sort(Comparator.comparing(row -> ((MetadataRow)row).getString("FUNCTION_SCHEM")).thenComparing(row -> ((MetadataRow)row).getString("FUNCTION_NAME")).thenComparing(row -> ((MetadataRow)row).getString("SPECIFIC_NAME")).thenComparing(row -> ((MetadataRow)row).getInt("ORDINAL_POSITION")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(functionParamsRows));
    }
}

