/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.utils;

import java.net.InetSocketAddress;
import java.util.Objects;

public final class ContactPoint {
    private final String host;
    private final int port;

    private ContactPoint(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static ContactPoint of(String host, Integer port) {
        if (port == null) {
            return new ContactPoint(host, 9042);
        }
        return new ContactPoint(host, port);
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public InetSocketAddress toInetSocketAddress() {
        return InetSocketAddress.createUnresolved(this.host, this.port);
    }

    public String toString() {
        return String.format("%s:%d", this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactPoint that = (ContactPoint)o;
        return this.port == that.getPort() && Objects.equals(this.host, that.getHost());
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }
}

