/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.incubator.semconv.db;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class RedisCommandSanitizer {
    private static final Map<String, CommandSanitizer> SANITIZERS;
    private static final CommandSanitizer DEFAULT;
    private final boolean statementSanitizationEnabled;

    public static RedisCommandSanitizer create(boolean statementSanitizationEnabled) {
        return new RedisCommandSanitizer(statementSanitizationEnabled);
    }

    private RedisCommandSanitizer(boolean statementSanitizationEnabled) {
        this.statementSanitizationEnabled = statementSanitizationEnabled;
    }

    public String sanitize(String command, List<?> args2) {
        if (!this.statementSanitizationEnabled) {
            return KeepAllArgs.INSTANCE.sanitize(command, args2);
        }
        return SANITIZERS.getOrDefault(command.toUpperCase(Locale.ROOT), DEFAULT).sanitize(command, args2);
    }

    static String argToString(Object arg) {
        if (arg instanceof byte[]) {
            return new String((byte[])arg, StandardCharsets.UTF_8);
        }
        return String.valueOf(arg);
    }

    static {
        DEFAULT = new CommandAndNumArgs(0);
        HashMap<String, CommandSanitizer> sanitizers = new HashMap<String, CommandSanitizer>();
        CommandAndNumArgs keepOneArg = new CommandAndNumArgs(1);
        CommandAndNumArgs keepTwoArgs = new CommandAndNumArgs(2);
        MultiKeyValue setMultiHashField = new MultiKeyValue(1);
        MultiKeyValue setMultiField = new MultiKeyValue(0);
        for (String command : Arrays.asList("CLUSTER", "FAILOVER", "READONLY", "READWRITE")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("AUTH", DEFAULT);
        sanitizers.put("HELLO", keepTwoArgs);
        for (String command : Arrays.asList("CLIENT", "ECHO", "PING", "QUIT", "RESET", "SELECT")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        for (String command : Arrays.asList("GEOADD", "GEODIST", "GEOHASH", "GEOPOS", "GEORADIUS", "GEORADIUS_RO", "GEORADIUSBYMEMBER", "GEORADIUSBYMEMBER_RO", "GEOSEARCH", "GEOSEARCHSTORE")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("HMSET", setMultiHashField);
        sanitizers.put("HSET", setMultiHashField);
        sanitizers.put("HSETNX", keepTwoArgs);
        for (String command : Arrays.asList("HDEL", "HEXISTS", "HGET", "HGETALL", "HINCRBY", "HINCRBYFLOAT", "HKEYS", "HLEN", "HMGET", "HRANDFIELD", "HSCAN", "HSTRLEN", "HVALS")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("PFADD", keepOneArg);
        for (String command : Arrays.asList("PFCOUNT", "PFMERGE")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("MIGRATE", new CommandAndNumArgs(6));
        sanitizers.put("RESTORE", keepTwoArgs);
        for (String command : Arrays.asList("COPY", "DEL", "DUMP", "EXISTS", "EXPIRE", "EXPIREAT", "EXPIRETIME", "KEYS", "MOVE", "OBJECT", "PERSIST", "PEXPIRE", "PEXPIREAT", "PEXPIRETIME", "PTTL", "RANDOMKEY", "RENAME", "RENAMENX", "SCAN", "SORT", "SORT_RO", "TOUCH", "TTL", "TYPE", "UNLINK", "WAIT")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("LINSERT", keepTwoArgs);
        sanitizers.put("LPOS", keepOneArg);
        sanitizers.put("LPUSH", keepOneArg);
        sanitizers.put("LPUSHX", keepOneArg);
        sanitizers.put("LREM", keepOneArg);
        sanitizers.put("LSET", keepOneArg);
        sanitizers.put("RPUSH", keepOneArg);
        sanitizers.put("RPUSHX", keepOneArg);
        for (String command : Arrays.asList("BLMOVE", "BLMPOP", "BLPOP", "BRPOP", "BRPOPLPUSH", "LINDEX", "LLEN", "LMOVE", "LMPOP", "LPOP", "LRANGE", "LTRIM", "RPOP", "RPOPLPUSH")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("PUBLISH", keepOneArg);
        for (String command : Arrays.asList("PSUBSCRIBE", "PUBSUB", "PUNSUBSCRIBE", "SPUBLISH", "SSUBSCRIBE", "SUBSCRIBE", "SUNSUBSCRIBE", "UNSUBSCRIBE")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("EVAL", Eval.INSTANCE);
        sanitizers.put("EVAL_RO", Eval.INSTANCE);
        sanitizers.put("EVALSHA", Eval.INSTANCE);
        sanitizers.put("EVALSHA_RO", Eval.INSTANCE);
        sanitizers.put("SCRIPT", KeepAllArgs.INSTANCE);
        sanitizers.put("CONFIG", keepTwoArgs);
        for (String command : Arrays.asList("ACL", "BGREWRITEAOF", "BGSAVE", "COMMAND", "DBSIZE", "DEBUG", "FLUSHALL", "FLUSHDB", "INFO", "LASTSAVE", "LATENCY", "LOLWUT", "MEMORY", "MODULE", "MONITOR", "PSYNC", "REPLICAOF", "ROLE", "SAVE", "SHUTDOWN", "SLAVEOF", "SLOWLOG", "SWAPDB", "SYNC", "TIME")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("SADD", keepOneArg);
        sanitizers.put("SISMEMBER", keepOneArg);
        sanitizers.put("SMISMEMBER", keepOneArg);
        sanitizers.put("SMOVE", keepTwoArgs);
        sanitizers.put("SREM", keepOneArg);
        for (String command : Arrays.asList("SCARD", "SDIFF", "SDIFFSTORE", "SINTER", "SINTERCARD", "SINTERSTORE", "SMEMBERS", "SPOP", "SRANDMEMBER", "SSCAN", "SUNION", "SUNIONSTORE")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("ZADD", keepOneArg);
        sanitizers.put("ZCOUNT", keepOneArg);
        sanitizers.put("ZINCRBY", keepOneArg);
        sanitizers.put("ZLEXCOUNT", keepOneArg);
        sanitizers.put("ZMSCORE", keepOneArg);
        sanitizers.put("ZRANGEBYLEX", keepOneArg);
        sanitizers.put("ZRANGEBYSCORE", keepOneArg);
        sanitizers.put("ZRANK", keepOneArg);
        sanitizers.put("ZREM", keepOneArg);
        sanitizers.put("ZREMRANGEBYLEX", keepOneArg);
        sanitizers.put("ZREMRANGEBYSCORE", keepOneArg);
        sanitizers.put("ZREVRANGEBYLEX", keepOneArg);
        sanitizers.put("ZREVRANGEBYSCORE", keepOneArg);
        sanitizers.put("ZREVRANK", keepOneArg);
        sanitizers.put("ZSCORE", keepOneArg);
        for (String command : Arrays.asList("BZMPOP", "BZPOPMAX", "BZPOPMIN", "ZCARD", "ZDIFF", "ZDIFFSTORE", "ZINTER", "ZINTERCARD", "ZINTERSTORE", "ZMPOP", "ZPOPMAX", "ZPOPMIN", "ZRANDMEMBER", "ZRANGE", "ZRANGESTORE", "ZREMRANGEBYRANK", "ZREVRANGE", "ZSCAN", "ZUNION", "ZUNIONSTORE")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("XADD", new MultiKeyValue(2));
        for (String command : Arrays.asList("XACK", "XAUTOCLAIM", "XCLAIM", "XDEL", "XGROUP", "XINFO", "XLEN", "XPENDING", "XRANGE", "XREAD", "XREADGROUP", "XREVRANGE", "XTRIM")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        sanitizers.put("APPEND", keepOneArg);
        sanitizers.put("GETSET", keepOneArg);
        sanitizers.put("MSET", setMultiField);
        sanitizers.put("MSETNX", setMultiField);
        sanitizers.put("PSETEX", keepTwoArgs);
        sanitizers.put("SET", keepOneArg);
        sanitizers.put("SETEX", keepTwoArgs);
        sanitizers.put("SETNX", keepOneArg);
        sanitizers.put("SETRANGE", keepOneArg);
        for (String command : Arrays.asList("BITCOUNT", "BITFIELD", "BITFIELD_RO", "BITOP", "BITPOS", "DECR", "DECRBY", "GET", "GETBIT", "GETDEL", "GETEX", "GETRANGE", "INCR", "INCRBY", "INCRBYFLOAT", "LCS", "MGET", "SETBIT", "STRALGO", "STRLEN")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        for (String command : Arrays.asList("DISCARD", "EXEC", "MULTI", "UNWATCH", "WATCH")) {
            sanitizers.put(command, KeepAllArgs.INSTANCE);
        }
        SANITIZERS = Collections.unmodifiableMap(sanitizers);
    }

    static enum KeepAllArgs implements CommandSanitizer
    {
        INSTANCE;


        @Override
        public String sanitize(String command, List<?> args2) {
            StringBuilder sanitized = new StringBuilder(command);
            for (Object arg : args2) {
                sanitized.append(" ").append(RedisCommandSanitizer.argToString(arg));
            }
            return sanitized.toString();
        }
    }

    static interface CommandSanitizer {
        public String sanitize(String var1, List<?> var2);
    }

    static final class CommandAndNumArgs
    implements CommandSanitizer {
        private final int numOfArgsToKeep;

        CommandAndNumArgs(int numOfArgsToKeep) {
            this.numOfArgsToKeep = numOfArgsToKeep;
        }

        @Override
        public String sanitize(String command, List<?> args2) {
            int i;
            StringBuilder sanitized = new StringBuilder(command);
            for (i = 0; i < this.numOfArgsToKeep && i < args2.size(); ++i) {
                sanitized.append(" ").append(RedisCommandSanitizer.argToString(args2.get(i)));
            }
            for (i = this.numOfArgsToKeep; i < args2.size(); ++i) {
                sanitized.append(" ?");
            }
            return sanitized.toString();
        }
    }

    static final class MultiKeyValue
    implements CommandSanitizer {
        private final int numOfArgsBeforeKeyValue;

        MultiKeyValue(int numOfArgsBeforeKeyValue) {
            this.numOfArgsBeforeKeyValue = numOfArgsBeforeKeyValue;
        }

        @Override
        public String sanitize(String command, List<?> args2) {
            int i;
            StringBuilder sanitized = new StringBuilder(command);
            for (i = 0; i < this.numOfArgsBeforeKeyValue && i < args2.size(); ++i) {
                sanitized.append(" ").append(RedisCommandSanitizer.argToString(args2.get(i)));
            }
            for (i = this.numOfArgsBeforeKeyValue; i < args2.size(); i += 2) {
                sanitized.append(" ").append(RedisCommandSanitizer.argToString(args2.get(i))).append(" ?");
            }
            return sanitized.toString();
        }
    }

    static enum Eval implements CommandSanitizer
    {
        INSTANCE;


        @Override
        public String sanitize(String command, List<?> args2) {
            int i;
            StringBuilder sanitized = new StringBuilder(command);
            int numberOfKeys = 0;
            if (args2.size() > 2) {
                try {
                    numberOfKeys = Integer.parseInt(RedisCommandSanitizer.argToString(args2.get(1)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (i = 0; i < numberOfKeys + 2 && i < args2.size(); ++i) {
                sanitized.append(" ").append(RedisCommandSanitizer.argToString(args2.get(i)));
            }
            while (i < args2.size()) {
                sanitized.append(" ?");
                ++i;
            }
            return sanitized.toString();
        }
    }
}

