/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.offline.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.Objects;
import schemacrawler.tools.offline.jdbc.OfflineConnection;
import schemacrawler.tools.offline.jdbc.OfflineDatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

public class OfflineConnectionUtility {
    public static DatabaseConnectionSource newOfflineDatabaseConnectionSource(Path offlineDatabasePath) {
        Objects.requireNonNull(offlineDatabasePath, "No offline catalog snapshot path provided");
        Path absoluteOfflineDatabasePath = offlineDatabasePath.toAbsolutePath();
        OfflineConnection offlineConnection = (OfflineConnection)Proxy.newProxyInstance(OfflineConnectionUtility.class.getClassLoader(), new Class[]{OfflineConnection.class}, (InvocationHandler)new OfflineConnectionInvocationHandler(absoluteOfflineDatabasePath));
        return new OfflineDatabaseConnectionSource(offlineConnection);
    }

    private OfflineConnectionUtility() {
    }

    private static class OfflineConnectionInvocationHandler
    implements InvocationHandler {
        private final Path offlineDatabasePath;

        public OfflineConnectionInvocationHandler(Path offlineDatabasePath) {
            this.offlineDatabasePath = offlineDatabasePath;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws SQLFeatureNotSupportedException {
            String methodName;
            switch (methodName = method.getName()) {
                case "close": 
                case "setAutoCommit": {
                    return null;
                }
                case "getOfflineDatabasePath": {
                    return this.offlineDatabasePath;
                }
                case "isWrapperFor": {
                    if (args[0] == null) {
                        return false;
                    }
                    Class clazz = (Class)args[0];
                    return clazz.isAssignableFrom(Connection.class);
                }
                case "unwrap": {
                    return proxy;
                }
                case "isClosed": {
                    return false;
                }
                case "isValid": {
                    return true;
                }
                case "getTypeMap": {
                    return Collections.emptyMap();
                }
                case "hashCode": {
                    return this.offlineDatabasePath.hashCode();
                }
                case "toString": {
                    return String.format("schemacrawler.tools.offline.jdbc.OfflineConnection@%s", this.offlineDatabasePath.hashCode());
                }
                case "equals": {
                    if (args == null || args.length <= 0 || !(args[0] instanceof OfflineConnection)) break;
                    OfflineConnection otherOfflineConnection = (OfflineConnection)args[0];
                    return otherOfflineConnection.hashCode() == this.offlineDatabasePath.hashCode();
                }
            }
            throw new SQLFeatureNotSupportedException(String.format("Offline catalog snapshot connection does not support method <%s>", methodName), "HYC00");
        }
    }
}

