/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt;

import com.theokanning.openai.model.Model;
import com.theokanning.openai.service.OpenAiService;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.command.chatgpt.ChatGPTConsole;
import schemacrawler.tools.command.chatgpt.options.ChatGPTCommandOptions;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;

public final class ChatGPTCommand
extends BaseSchemaCrawlerCommand<ChatGPTCommandOptions> {
    private static final Logger LOGGER = Logger.getLogger(ChatGPTCommand.class.getName());
    static final String COMMAND = "chatgpt";

    protected ChatGPTCommand() {
        super(COMMAND);
    }

    public void checkAvailability() throws RuntimeException {
        OpenAiService service = new OpenAiService(((ChatGPTCommandOptions)this.commandOptions).getApiKey());
        Model model = service.getModel(((ChatGPTCommandOptions)this.commandOptions).getModel());
        LOGGER.log(Level.CONFIG, String.format("Using ChatGPT model:%n%s", model));
    }

    public void execute() {
        try (ChatGPTConsole chatGPTConsole = new ChatGPTConsole((ChatGPTCommandOptions)this.commandOptions, this.catalog, this.connection);){
            chatGPTConsole.console();
        }
    }

    public boolean usesConnection() {
        return true;
    }
}

