/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.embeddings;

import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.service.OpenAiService;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.command.chatgpt.embeddings.TextEmbedding;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class EmbeddingService {
    private static final Logger LOGGER = Logger.getLogger(EmbeddingService.class.getCanonicalName());
    private static final String TEXT_EMBEDDING_MODEL = "text-embedding-3-small";
    private final OpenAiService service;

    public EmbeddingService(OpenAiService service) {
        this.service = Objects.requireNonNull(service, "No Open AI service provided");
    }

    public TextEmbedding embed(String text) {
        Utility.requireNotBlank((String)text, (String)"No text provided");
        try {
            EmbeddingRequest embeddingRequest = EmbeddingRequest.builder().model(TEXT_EMBEDDING_MODEL).input(Collections.singletonList(text)).build();
            EmbeddingResult embeddingResult = this.service.createEmbeddings(embeddingRequest);
            return new TextEmbedding(text, embeddingResult);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not embed text", new Object[0]));
            return new TextEmbedding(text);
        }
    }
}

