/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.embeddings;

import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import com.theokanning.openai.service.OpenAiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.tools.command.chatgpt.embeddings.EmbeddedTable;
import schemacrawler.tools.command.chatgpt.embeddings.EmbeddingService;
import schemacrawler.tools.command.chatgpt.embeddings.TableEmbeddingService;
import schemacrawler.tools.command.chatgpt.embeddings.TableSimilarityService;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

public final class QueryService {
    private static final Logger LOGGER = Logger.getLogger(QueryService.class.getCanonicalName());
    private static final int MAX_TOKENS = 8000;
    private final String metadataPriming;
    private final TableEmbeddingService tableEmbeddingService;
    private final TableSimilarityService tableSimilarityService;

    public QueryService(OpenAiService service) {
        Objects.requireNonNull(service, "No Open AI service provided");
        EmbeddingService embeddingService = new EmbeddingService(service);
        this.tableEmbeddingService = new TableEmbeddingService(embeddingService);
        this.tableSimilarityService = new TableSimilarityService(embeddingService);
        this.metadataPriming = IOUtility.readResourceFully((String)"/metadata-priming.txt");
        if (Utility.isBlank((CharSequence)this.metadataPriming)) {
            throw new ConfigurationException("Could not load metadata priming text");
        }
    }

    public void addTables(Collection<Table> tables) {
        Objects.requireNonNull(tables, "No tables provided");
        LOGGER.log(Level.INFO, "Embedding all tables in the catalog");
        for (Table table : tables) {
            EmbeddedTable embeddingTable = this.tableEmbeddingService.embedTable(table);
            this.tableSimilarityService.addTable(embeddingTable);
        }
    }

    public Collection<ChatMessage> query(String prompt) {
        LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Searching for tables matching prompt:%n%s", new Object[]{prompt}));
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        Collection<EmbeddedTable> matchedTables = this.tableSimilarityService.query(prompt, 8000L);
        LOGGER.log(Level.CONFIG, (Supplier<String>)new ObjectToStringFormat("Tables matching prompt", matchedTables));
        if (matchedTables.isEmpty()) {
            return messages;
        }
        messages.add(new ChatMessage(ChatMessageRole.SYSTEM.value(), this.metadataPriming));
        for (EmbeddedTable embeddedTable : matchedTables) {
            ChatMessage chatMessage = new ChatMessage(ChatMessageRole.SYSTEM.value(), embeddedTable.toJson());
            messages.add(chatMessage);
        }
        return messages;
    }
}

