/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.options;

import schemacrawler.tools.command.chatgpt.utility.ChatGPTUtility;
import schemacrawler.tools.executable.CommandOptions;
import us.fatehi.utility.Utility;

public class ChatGPTCommandOptions
implements CommandOptions {
    private static final int DEFAULT_CONTEXT = 10;
    private static final int MAXIMUM_CONTEXT = 50;
    private static final int DEFAULT_TIMEOUT = 10;
    private static final int MAXIMUM_TIMEOUT = 180;
    private final String apiKey;
    private final String model;
    private final int timeout;
    private final int context;
    private final boolean useMetadata;

    public ChatGPTCommandOptions(String apiKey, String model, int timeout, int context, boolean useMetadata) {
        this.apiKey = Utility.requireNotBlank((String)apiKey, (String)"No OpenAI API key provided");
        this.model = Utility.requireNotBlank((String)model, (String)"No ChatGPT model provided");
        this.timeout = ChatGPTUtility.inIntegerRange(timeout, -1, 180) ? timeout : 10;
        this.context = ChatGPTUtility.inIntegerRange(context, 0, 50) ? context : 10;
        this.useMetadata = useMetadata;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getContext() {
        return this.context;
    }

    public String getModel() {
        return this.model;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isUseMetadata() {
        return this.useMetadata;
    }
}

