/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.options;

import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.tools.command.chatgpt.options.ChatGPTCommandOptions;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.ConfigOptionsBuilder;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.Utility;

public final class ChatGPTCommandOptionsBuilder
implements OptionsBuilder<ChatGPTCommandOptionsBuilder, ChatGPTCommandOptions>,
ConfigOptionsBuilder<ChatGPTCommandOptionsBuilder, ChatGPTCommandOptions> {
    private static final int DEFAULT_CONTEXT = 10;
    private static final int DEFAULT_TIMEOUT = 10;
    private String apiKey;
    private String model = "gpt-3.5-turbo";
    private int timeout = 10;
    private int context = 10;
    private boolean useMetadata;

    public static ChatGPTCommandOptionsBuilder builder() {
        return new ChatGPTCommandOptionsBuilder();
    }

    private ChatGPTCommandOptionsBuilder() {
    }

    public ChatGPTCommandOptionsBuilder fromConfig(Config config) {
        if (config != null) {
            this.apiKey = this.getApiKey(config);
            this.model = config.getStringValue("model", this.model);
            this.timeout = config.getIntegerValue("timeout", 10);
            this.context = config.getIntegerValue("context", 10);
            this.useMetadata = config.getBooleanValue("use-metadata");
        }
        return this;
    }

    public ChatGPTCommandOptionsBuilder fromOptions(ChatGPTCommandOptions options) {
        if (options != null) {
            this.apiKey = options.getApiKey();
            this.model = options.getModel();
            this.timeout = options.getTimeout();
            this.context = options.getContext();
            this.useMetadata = options.isUseMetadata();
        }
        return this;
    }

    public Config toConfig() {
        throw new UnsupportedOperationException();
    }

    public ChatGPTCommandOptions toOptions() {
        return new ChatGPTCommandOptions(this.apiKey, this.model, this.timeout, this.context, this.useMetadata);
    }

    public ChatGPTCommandOptionsBuilder withApiKey(String apiKey) {
        if (!Utility.isBlank((CharSequence)apiKey)) {
            this.apiKey = apiKey;
        }
        return this;
    }

    public ChatGPTCommandOptionsBuilder withContext(int context) {
        this.context = context;
        return this;
    }

    public ChatGPTCommandOptionsBuilder withModel(String model) {
        if (!Utility.isBlank((CharSequence)model)) {
            this.model = model;
        }
        return this;
    }

    public ChatGPTCommandOptionsBuilder withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public ChatGPTCommandOptionsBuilder withUseMetadata(boolean useMetadata) {
        this.useMetadata = useMetadata;
        return this;
    }

    private String getApiKey(Config config) {
        String apikeyVar;
        String apiKey = config.getStringValue("api-key", null);
        if (Utility.isBlank((CharSequence)apiKey) && !Utility.isBlank((CharSequence)(apikeyVar = config.getStringValue("api-key:env", "OPENAI_API_KEY")))) {
            apiKey = PropertiesUtility.getSystemConfigurationProperty((String)apikeyVar, null);
        }
        return apiKey;
    }
}

