/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.utility;

import com.theokanning.openai.completion.chat.ChatFunction;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.service.FunctionExecutor;
import java.io.PrintStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.command.chatgpt.FunctionDefinition;
import schemacrawler.tools.command.chatgpt.functions.ExitFunctionDefinition;
import schemacrawler.tools.command.chatgpt.functions.FunctionDefinitionRegistry;

public class ChatGPTUtility {
    public static boolean inIntegerRange(int value, int min, int max) {
        return value > min && value <= max;
    }

    public static boolean isExitCondition(List<ChatMessage> completions) {
        Objects.requireNonNull(completions, "No completions provided");
        String exitFunctionName = new ExitFunctionDefinition().getName();
        for (ChatMessage c : completions) {
            if (c.getFunctionCall() == null || !c.getName().equals(exitFunctionName)) continue;
            return true;
        }
        return false;
    }

    public static FunctionExecutor newFunctionExecutor(Catalog catalog, Connection connection) {
        Objects.requireNonNull(catalog, "No catalog provided");
        Objects.requireNonNull(connection, "No connection provided");
        ArrayList<ChatFunction> chatFunctions = new ArrayList<ChatFunction>();
        for (FunctionDefinition functionDefinition : FunctionDefinitionRegistry.getFunctionDefinitionRegistry().getFunctionDefinitions()) {
            if (functionDefinition.getFunctionType() != FunctionDefinition.FunctionType.USER) continue;
            functionDefinition.setCatalog(catalog);
            functionDefinition.setConnection(connection);
            ChatFunction chatFunction = ChatFunction.builder().name(functionDefinition.getName()).description(functionDefinition.getDescription()).executor(functionDefinition.getParameters(), functionDefinition.getExecutor()).build();
            chatFunctions.add(chatFunction);
        }
        return new FunctionExecutor(chatFunctions);
    }

    public static void printResponse(List<ChatMessage> completions, PrintStream out) {
        Objects.requireNonNull(out, "No ouput stream provided");
        Objects.requireNonNull(completions, "No completions provided");
        for (ChatMessage chatMessage : completions) {
            out.println(chatMessage.getContent());
        }
    }

    private ChatGPTUtility() {
    }
}

