/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.loader;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.AnalysisError;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryUtility;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryVersionImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.Constants;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.SourceInfo;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.SourceLocation;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.ExplainSQLInfo;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.LoaderError;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.LoaderInfo;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.MetadataCache;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.MetadataCacheLoader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.MetadataCacheResults;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.MetadataLoaderUtils;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.AppWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.DBInfoWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataSourceWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadatasourceStmtWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.ProjectWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.SourceStatementWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.SourceWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.StackWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.StmtWriter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.parser.MetadataListener;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.parser.MetadataParser;
import com.ibm.db2.cmx.runtime.internal.repository.util.DataBufferOutputStream;
import com.ibm.db2.cmx.runtime.internal.repository.util.Filter;
import com.ibm.db2.cmx.runtime.internal.repository.util.TeeInputStream;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xml.sax.SAXException;

public abstract class BaseMetadataLoader
implements MetadataListener {
    private static ExplainSQLInfo NullExplainValues = new ExplainSQLInfo(0, "dummyNullValues", null);
    private String appName = null;
    private String appVersion = null;
    protected String projectName;
    private static Filter StackTracePackageNameFilter = null;
    protected Connection connection;
    private LoaderInfo loaderInfo = new LoaderInfo();
    private MetadataCache cache;
    private String currentSourceFile = null;
    private boolean skipParseOfQueryText = false;
    protected String metadataSchema;
    protected RepositoryVersionImpl metadataVersion = null;
    private String defaultSchemaForSQLStatements = null;
    private String callPath = null;
    private boolean repositoryV221 = true;

    protected abstract Object parseQuery(String var1, String var2);

    protected abstract String getStatementType(Object var1);

    protected abstract void writeDependencies(Connection var1, int var2, Object var3) throws MetadataException;

    public BaseMetadataLoader(Connection connection, String string, String string2, String string3, String string4) {
        this.metadataSchema = string;
        this.connection = connection;
        this.appName = string2;
        this.appVersion = string3;
        this.projectName = string4;
        this.cache = new MetadataCache();
    }

    public void loadAndSaveContent(InputStream inputStream, String string, String string2, String string3) throws MetadataException {
        this.defaultSchemaForSQLStatements = string2;
        this.callPath = string3;
        InputStream inputStream2 = null;
        String string4 = "data";
        this.currentSourceFile = string;
        if (this.currentSourceFile != null && this.currentSourceFile.length() > 0) {
            string4 = this.currentSourceFile;
        }
        try {
            Object object;
            DataBufferOutputStream dataBufferOutputStream = new DataBufferOutputStream();
            if (this.metadataVersion == null && this.connection != null && this.metadataSchema != null) {
                this.metadataVersion = RepositoryUtility.getPQRepositoryVersion(this.connection, this.metadataSchema);
                object = new RepositoryVersionImpl("com.ibm.pureQuery", 2, 2, 1);
                this.repositoryV221 = this.metadataVersion.compareTo((RepositoryVersion)object) <= 0;
            }
            this.cache.setMetadataSourceKey(null);
            object = new MetadataParser();
            ZipOutputStream zipOutputStream = new ZipOutputStream(dataBufferOutputStream);
            ZipEntry zipEntry = new ZipEntry(string4);
            zipOutputStream.putNextEntry(zipEntry);
            TeeInputStream teeInputStream = new TeeInputStream(inputStream, zipOutputStream);
            ((MetadataParser)object).parse(teeInputStream, this, false);
            zipOutputStream.close();
            inputStream2 = dataBufferOutputStream.getInputStream();
            this.writeSourceData(inputStream2, teeInputStream.getBytesRead());
        }
        catch (IOException iOException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_PARSE_PUREQUERY_METADATA", new Object[0]), iOException);
        }
        catch (SAXException sAXException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_PARSE_PUREQUERY_METADATA", new Object[0]), sAXException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new MetadataException(Messages.getText("ERR_CANNOT_PARSE_PUREQUERY_METADATA", new Object[0]), throwable);
        }
        finally {
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void load(InputStream inputStream, String string, String string2, String string3, int n2) throws MetadataException {
        this.defaultSchemaForSQLStatements = string2;
        this.callPath = string3;
        this.currentSourceFile = string;
        try {
            Object object;
            if (this.metadataVersion == null && this.connection != null && this.metadataSchema != null) {
                this.metadataVersion = RepositoryUtility.getPQRepositoryVersion(this.connection, this.metadataSchema);
                object = new RepositoryVersionImpl("com.ibm.pureQuery", 2, 2, 1);
                this.repositoryV221 = this.metadataVersion.compareTo((RepositoryVersion)object) <= 0;
            }
            this.cache.setMetadataSourceKey(n2);
            object = new MetadataParser();
            ((MetadataParser)object).parse(inputStream, this, false);
        }
        catch (IOException iOException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_PARSE_PUREQUERY_METADATA", new Object[0]), iOException);
        }
        catch (SAXException sAXException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_PARSE_PUREQUERY_METADATA", new Object[0]), sAXException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new MetadataException(Messages.getText("ERR_CANNOT_PARSE_PUREQUERY_METADATA", new Object[0]), throwable);
        }
    }

    public LoaderInfo getLoaderInfo() {
        return this.loaderInfo;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String string) throws MetadataException {
        if (string != null) {
            try {
                MetadataCacheLoader.loadProjectValues(this.cache, string, this.connection, this.metadataSchema);
            }
            catch (DataRuntimeException dataRuntimeException) {
                throw new MetadataException(Messages.getText("ERR_CANNOT_SETUP_REPOSITORY", new Object[0]), dataRuntimeException);
            }
        } else {
            this.cache.clearProjectKey();
        }
        this.projectName = string;
    }

    private void writeSourceData(InputStream inputStream, long l2) throws MetadataException, IOException {
        Integer n2 = this.cache.getMetadataSrcKey();
        if (n2 != null) {
            int n3 = n2;
            int n4 = (int)l2;
            MetadataSourceWriter.getInstance(this.metadataSchema).setContent(this.connection, n3, inputStream, n4);
        }
    }

    private void addProjectNameToSourceEntries(SourceLocation sourceLocation) {
        for (SourceInfo sourceInfo : sourceLocation) {
            sourceInfo.setProjectName(this.projectName);
        }
    }

    private Properties parseSpecialRegisters(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = ":";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken(string5).replace(':', ' ').replace('|', ' ').trim();
            if (string5.equals(":")) {
                string3 = string2;
                string5 = "|";
                continue;
            }
            if (!string5.equals("|")) continue;
            string4 = string2;
            properties.put(string3, string4);
            string5 = ":";
        }
        return properties;
    }

    @Override
    public void updateSQL(String string, HashMap<Constants.SourceOpType, List<List<SourceInfo>>> hashMap, String string2, String string3, String string4, String string5, String string6, String string7, int n2, String string8, boolean bl2, char c10, boolean bl3, char c11, String string9, boolean bl4, String string10, Integer n3, String string11, String string12) throws MetadataException {
        try {
            Object object;
            String string13;
            Object object2;
            char c12 = this.convertIsBindable(bl2);
            char c13 = this.convertIsBindable(bl4);
            HashMap<Constants.SourceOpType, List<SourceLocation>> hashMap2 = MetadataLoaderUtils.convertSourceInfoMap(hashMap);
            String string14 = this.defaultSchemaForSQLStatements;
            String string15 = this.callPath;
            if (string10 != null) {
                object2 = this.parseSpecialRegisters(string10);
                string13 = ((Properties)object2).getProperty("SCHEMA");
                if (string13 != null) {
                    string14 = string13;
                }
                if ((object = ((Properties)object2).getProperty("PATH")) != null) {
                    string15 = object;
                }
            }
            object2 = MetadataCache.generateStmtTextKey(string5, string6, string7, string8, bl2, string3, string2, bl4, string14, string15, string10);
            string13 = null;
            if (string5 != null || string6 != null || string7 != null || string8 != null) {
                string13 = MetadataCache.generatePackageTextKey(string5, string6, string7, string8, bl2);
            }
            if (string2 != null) {
                string2 = string2.trim();
            }
            if (string3 != null) {
                string3 = string3.trim();
            }
            if (string4 != null) {
                string4 = string4.trim();
            }
            if (this.cache.getAppKey() == null && (this.appName != null || this.appVersion != null)) {
                object = AppWriter.getInstance(this.metadataSchema).createEntry(this.connection, this.appName, this.appVersion);
                this.cache.setAppKey((Integer)object);
            }
            this.filterStackTrace(hashMap2);
            boolean bl5 = false;
            for (Constants.SourceOpType sourceOpType : hashMap2.keySet()) {
                List<SourceLocation> list = hashMap2.get((Object)sourceOpType);
                for (SourceLocation sourceLocation : list) {
                    bl5 = true;
                    this.addProjectNameToSourceEntries(sourceLocation);
                    MetadataCacheResults metadataCacheResults = this.cache.searchCache(sourceLocation, sourceOpType, (String)object2, string13);
                    this.notifySQL(string, metadataCacheResults, string2, string3, string4, string5, string6, string7, n2, string8, c12, c10, sourceOpType, c11, string9, c13, string14, string15, string10, n3, string11);
                }
            }
            if (!bl5) {
                MetadataCacheResults metadataCacheResults = this.cache.searchCache(null, null, (String)object2, string13);
                this.notifySQL(string, metadataCacheResults, string2, string3, string4, string5, string6, string7, n2, string8, c12, c10, null, c11, string9, c13, string14, string15, string10, n3, string11);
            }
            this.loaderInfo.incrementStatementsAdded();
        }
        catch (Exception exception) {
            LoaderError loaderError = new LoaderError(this.currentSourceFile, string9, n2, string3, string2, exception);
            this.loaderInfo.getErrors().add(loaderError);
        }
    }

    private char convertIsBindable(boolean bl2) {
        if (bl2) {
            return 'Y';
        }
        return 'N';
    }

    private void filterStackTrace(HashMap<Constants.SourceOpType, List<SourceLocation>> hashMap) {
        Constants.SourceOpType[] sourceOpTypeArray;
        for (Constants.SourceOpType sourceOpType : sourceOpTypeArray = Constants.SourceOpType.values()) {
            List<SourceLocation> list = hashMap.get((Object)sourceOpType);
            if (list == null) continue;
            List<SourceLocation> list2 = this.filterSourceEntries(list);
            if (list2.size() > 0) {
                hashMap.put(sourceOpType, list2);
                continue;
            }
            hashMap.remove((Object)sourceOpType);
        }
    }

    private void notifySQL(String string, MetadataCacheResults metadataCacheResults, String string2, String string3, String string4, String string5, String string6, String string7, int n2, String string8, char c10, char c11, Constants.SourceOpType sourceOpType, char c12, String string9, char c13, String string10, String string11, String string12, Integer n3, String string13) throws MetadataException {
        Object object;
        Object object2;
        Object object3 = null;
        String string14 = null;
        if (string3 != null && metadataCacheResults.statementNew && c12 == 'S') {
            if (!this.skipParseOfQueryText) {
                object3 = this.parseQuery(string10, string3);
                string14 = this.getStatementType(object3);
            } else {
                string14 = "OTHER";
            }
        }
        if (metadataCacheResults.projectNew) {
            metadataCacheResults.projectKey = this.projectName != null ? Integer.valueOf(ProjectWriter.getInstance(this.metadataSchema).createEntry(this.connection, this.projectName)) : null;
        }
        if (metadataCacheResults.metadataSrcKey == null) {
            metadataCacheResults.metadataSrcKey = MetadataSourceWriter.getInstance(this.metadataSchema).createEntry(this.connection, string, this.currentSourceFile);
        }
        if (metadataCacheResults.dbInfoNew) {
            metadataCacheResults.dbInfoKey = DBInfoWriter.getInstance(this.metadataSchema).createDBInfo(this.connection, string5, string6, string7, string8, c10);
        }
        if (metadataCacheResults.statementNew) {
            object2 = null;
            if (string5 != null) {
                object2 = metadataCacheResults.dbInfoKey;
            }
            object = this.getExplainValuesFor(string3);
            metadataCacheResults.stmtKey = this.repositoryV221 ? StmtWriter.getInstance(this.metadataSchema).createStmtV221(this.connection, string2, string3, string4, string14, c11, c12, n2, string9, (Integer)object2, c13, ((ExplainSQLInfo)object).getTotalCost(), ((ExplainSQLInfo)object).getCardinality(), ((ExplainSQLInfo)object).getJoinCount(), ((ExplainSQLInfo)object).getTbScanCount(), ((ExplainSQLInfo)object).getIxScanCount()) : StmtWriter.getInstance(this.metadataSchema).createStmt(this.connection, string2, string3, string4, string14, c11, c12, n2, string9, (Integer)object2, c13, ((ExplainSQLInfo)object).getTotalCost(), ((ExplainSQLInfo)object).getCardinality(), ((ExplainSQLInfo)object).getJoinCount(), ((ExplainSQLInfo)object).getTbScanCount(), ((ExplainSQLInfo)object).getIxScanCount(), string10, string11, string12, n3, string13);
        }
        if (metadataCacheResults.mdSrcStmtNew) {
            MetadatasourceStmtWriter.getInstance(this.metadataSchema).createEntry(this.connection, metadataCacheResults.metadataSrcKey, metadataCacheResults.stmtKey, this.cache.getAppKey(), metadataCacheResults.projectKey);
        }
        if (metadataCacheResults.newStack != null) {
            object2 = metadataCacheResults.newStack.iterator();
            int n4 = 0;
            metadataCacheResults.stackKey = StackWriter.getInstance(this.metadataSchema).createStackId(this.connection, metadataCacheResults.metadataSrcKey);
            while (object2.hasNext()) {
                SourceInfo sourceInfo = (SourceInfo)object2.next();
                if (this.repositoryV221) {
                    SourceWriter.getInstance(this.metadataSchema).createSource_V221(this.connection, metadataCacheResults.projectKey, sourceInfo.getPath(), 0, sourceInfo.getLineNumber(), sourceInfo.getPackageName(), sourceInfo.getClassName(), sourceInfo.getMethodName(), sourceInfo.getMethodSignature(), sourceInfo.getNativeMethod(), sourceInfo.getFileExtension(), n4++, metadataCacheResults.stackKey);
                    continue;
                }
                SourceWriter.getInstance(this.metadataSchema).createSource(this.connection, metadataCacheResults.projectKey, sourceInfo.getPath(), 0, sourceInfo.getLineNumber(), sourceInfo.getPackageName(), sourceInfo.getClassName(), sourceInfo.getMethodName(), sourceInfo.getMethodSignature(), sourceInfo.getNativeMethod(), sourceInfo.getFileExtension(), n4++, metadataCacheResults.stackKey, sourceInfo.getLabel(), sourceInfo.getLabelType());
            }
        }
        if (metadataCacheResults.relationshipNew && sourceOpType != null && metadataCacheResults.stackKey != null) {
            SourceStatementWriter.getInstance(this.metadataSchema).createEntry(this.connection, (int)metadataCacheResults.stackKey, metadataCacheResults.stmtKey, this.cache.getAppKey(), sourceOpType);
        }
        if (string3 != null && metadataCacheResults.statementNew) {
            try {
                this.writeDependencies(this.connection, metadataCacheResults.stmtKey, object3);
            }
            catch (Exception exception) {
                object = new LoaderError(this.currentSourceFile, string9, n2, string3, string2, exception);
                this.loaderInfo.getErrors().add((AnalysisError)object);
            }
        }
        this.cache.notifyKeysCreated(metadataCacheResults);
    }

    private ExplainSQLInfo getExplainValuesFor(String string) {
        ExplainSQLInfo explainSQLInfo = this.cache.getExplainValuesFor(string);
        if (explainSQLInfo == null) {
            explainSQLInfo = NullExplainValues;
        }
        return explainSQLInfo;
    }

    public static void setStackTraceFilter(Filter filter) {
        StackTracePackageNameFilter = filter;
    }

    public static Filter getStackTraceFilter() {
        return StackTracePackageNameFilter;
    }

    private List<SourceLocation> filterSourceEntries(List<SourceLocation> list) {
        ArrayList<SourceLocation> arrayList = new ArrayList<SourceLocation>();
        for (List list2 : list) {
            SourceLocation sourceLocation = new SourceLocation();
            for (SourceInfo sourceInfo : list2) {
                String string = sourceInfo.getPackageName();
                if (StackTracePackageNameFilter != null && StackTracePackageNameFilter.contains(string)) continue;
                sourceLocation.add(sourceInfo);
            }
            if (sourceLocation.size() <= 0) continue;
            arrayList.add(sourceLocation);
        }
        return arrayList;
    }

    public MetadataCache getMetadataCache() {
        return this.cache;
    }

    public void setSkipParseOfQueryText(boolean bl2) {
        this.skipParseOfQueryText = bl2;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected Connection getConnection() {
        return this.connection;
    }
}

