/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.utility;

import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import picocli.CommandLine;
import schemacrawler.JvmSystemInfo;
import schemacrawler.OperatingSystemInfo;
import schemacrawler.Version;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.tools.catalogloader.CatalogLoaderRegistry;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.executable.commandline.PluginCommandOption;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.property.BaseProductVersion;
import us.fatehi.utility.property.ProductVersion;

public class CommandLineUtility {
    public static final Supplier<Collection<PluginCommand>> catalogLoaderPluginCommands = () -> CatalogLoaderRegistry.getCatalogLoaderRegistry().getCommandLineCommands();
    public static final Supplier<Collection<PluginCommand>> catalogLoaderPluginHelpCommands = () -> CatalogLoaderRegistry.getCatalogLoaderRegistry().getHelpCommands();
    public static final Supplier<Collection<PluginCommand>> commandPluginCommands = () -> CommandRegistry.getCommandRegistry().getCommandLineCommands();
    public static final Supplier<Collection<PluginCommand>> commandPluginHelpCommands = () -> CommandRegistry.getCommandRegistry().getHelpCommands();
    public static final Supplier<Collection<PluginCommand>> serverPluginHelpCommands = () -> DatabaseConnectorRegistry.getDatabaseConnectorRegistry().getHelpCommands();

    public static void addPluginCommands(CommandLine commandLine, Supplier<Collection<PluginCommand>> pluginCommands) {
        CommandLineUtility.addPluginCommands(commandLine, pluginCommands, true);
    }

    public static void addPluginHelpCommands(CommandLine commandLine, Supplier<Collection<PluginCommand>> pluginCommands) {
        CommandLineUtility.addPluginCommands(commandLine, pluginCommands, false);
    }

    public static CommandLine configureCommandLine(CommandLine commandLine) {
        commandLine.setUnmatchedArgumentsAllowed(true);
        commandLine.setCaseInsensitiveEnumValuesAllowed(true);
        commandLine.setTrimQuotes(true);
        commandLine.setToggleBooleanFlags(false);
        return commandLine;
    }

    public static String getConnectionInfo(DatabaseConnectionSource dbConnectionSource) {
        String string;
        block9: {
            String connectionInfoString = "";
            if (dbConnectionSource == null) {
                return "";
            }
            Connection connection = (Connection)dbConnectionSource.get();
            try {
                ConnectionInfoBuilder connectionInfoBuilder = ConnectionInfoBuilder.builder((Connection)connection);
                BaseProductVersion databaseInfo = new BaseProductVersion((ProductVersion)connectionInfoBuilder.buildDatabaseInfo());
                BaseProductVersion jdbcDriverInfo = new BaseProductVersion((ProductVersion)connectionInfoBuilder.buildJdbcDriverInfo());
                string = String.format("  %s%n  %s%n", databaseInfo, jdbcDriverInfo);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return "";
                }
            }
            connection.close();
        }
        return string;
    }

    public static String getEnvironment(ShellState state) {
        if (state == null) {
            return "";
        }
        return String.format("Environment:%n  %s%n  %s%n  %s%n%s", Version.version(), OperatingSystemInfo.operatingSystemInfo(), JvmSystemInfo.jvmSystemInfo(), CommandLineUtility.getConnectionInfo(state.getDataSource()));
    }

    public static Map<String, Object> matchedOptionValues(CommandLine.ParseResult parseResult) {
        Objects.requireNonNull(parseResult, "No parse result provided");
        HashMap<String, Object> options = new HashMap<String, Object>();
        List matchedOptionSpecs = parseResult.matchedOptions();
        for (CommandLine.Model.OptionSpec matchedOptionSpec : matchedOptionSpecs) {
            Object optionValue;
            if (matchedOptionSpec.userObject() != null || (optionValue = matchedOptionSpec.getValue()) == null) continue;
            String optionName = matchedOptionSpec.longestName().replaceFirst("^\\-{0,2}", "");
            options.put(optionName, optionValue);
        }
        return options;
    }

    public static CommandLine newCommandLine(Object object, CommandLine.IFactory factory) {
        CommandLine commandLine = factory == null ? new CommandLine(object) : new CommandLine(object, factory);
        CommandLineUtility.configureCommandLine(commandLine);
        return commandLine;
    }

    public static void printCommandLineErrorMessage(String errorMessage, ShellState state) {
        System.err.printf("%s%n%n", Version.version());
        if (!Utility.isBlank((CharSequence)errorMessage)) {
            System.err.printf("Error: %s%n%n", errorMessage);
        } else {
            System.err.printf("Error: Unknown error%n%n", new Object[0]);
        }
        System.err.println(IOUtility.readResourceFully((String)"/command-line-error.footer.txt"));
        System.err.println();
        System.err.println(CommandLineUtility.getEnvironment(state));
    }

    public static CommandLine.Model.CommandSpec toCommandSpec(PluginCommand pluginCommand) {
        Objects.requireNonNull(pluginCommand, "No plugin command provided");
        if (pluginCommand.isEmpty()) {
            throw new NullPointerException("Empty plugin command provided");
        }
        String pluginCommandName = pluginCommand.getName();
        CommandLine.Model.UsageMessageSpec usageMessageSpec = new CommandLine.Model.UsageMessageSpec();
        usageMessageSpec.header(new String[]{pluginCommand.getHelpHeader()});
        if (pluginCommand.hasHelpDescription()) {
            usageMessageSpec.description((String[])pluginCommand.getHelpDescription().get());
        } else {
            usageMessageSpec.description(new String[]{""});
        }
        usageMessageSpec.synopsisHeading("Command:%n");
        usageMessageSpec.customSynopsis(new String[]{pluginCommandName});
        usageMessageSpec.optionListHeading("Options:%n");
        if (pluginCommand.hasHelpFooter()) {
            usageMessageSpec.footer((String[])pluginCommand.getHelpFooter().get());
        }
        CommandLine.Model.CommandSpec pluginCommandSpec = CommandLine.Model.CommandSpec.create().name(pluginCommandName).usageMessage(usageMessageSpec);
        for (PluginCommandOption option : pluginCommand) {
            pluginCommandSpec.addOption(CommandLineUtility.toOptionSpec(option));
        }
        return pluginCommandSpec;
    }

    private static void addPluginCommand(CommandLine commandLine, PluginCommand pluginCommand, boolean addAsMixins) {
        Objects.requireNonNull(commandLine, "No command-line provided");
        if (pluginCommand == null || pluginCommand.isEmpty()) {
            return;
        }
        CommandLine.Model.CommandSpec pluginCommandSpec = CommandLineUtility.toCommandSpec(pluginCommand);
        String pluginCommandName = pluginCommandSpec.name();
        if (addAsMixins) {
            commandLine.addMixin(pluginCommandName, (Object)pluginCommandSpec);
        } else {
            commandLine.addSubcommand(pluginCommandName, (Object)pluginCommandSpec);
        }
    }

    private static void addPluginCommands(CommandLine commandLine, Supplier<Collection<PluginCommand>> pluginCommands, boolean addAsMixins) {
        Objects.requireNonNull(commandLine, "No command-line provided");
        Objects.requireNonNull(pluginCommands, "No plugin commands supplier provided");
        for (PluginCommand pluginCommand : pluginCommands.get()) {
            CommandLineUtility.addPluginCommand(commandLine, pluginCommand, addAsMixins);
        }
    }

    private static CommandLine.Model.OptionSpec toOptionSpec(PluginCommandOption option) {
        String optionName = option.getName();
        String paramName = String.format("<%s>", optionName);
        String[] helpText = option.getValueClass().isEnum() ? new String[]{String.format("%s%nUse one of ${COMPLETION-CANDIDATES}", option.getHelpText()[0])} : option.getHelpText();
        return ((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)("--" + optionName), (String[])new String[0]).description(helpText)).paramLabel(paramName)).type(option.getValueClass())).build();
    }

    private CommandLineUtility() {
    }
}

