/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.database;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.Utility;
import us.fatehi.utility.UtilityLogger;
import us.fatehi.utility.string.StringFormat;

public final class DatabaseUtility {
    private static final Logger LOGGER = Logger.getLogger(DatabaseUtility.class.getName());

    public static Connection checkConnection(Connection connection) throws SQLException {
        try {
            Objects.requireNonNull(connection, "No database connection provided");
            if (connection.isClosed()) {
                throw new SQLException("Connection is closed");
            }
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
        return connection;
    }

    public static ResultSet checkResultSet(ResultSet resultSet) throws SQLException {
        try {
            Objects.requireNonNull(resultSet, "No result-set provided");
            if (resultSet.isClosed()) {
                throw new SQLException("Result-set is closed");
            }
        }
        catch (NullPointerException e) {
            throw new SQLException(e);
        }
        return resultSet;
    }

    public static Statement createStatement(Connection connection) throws SQLException {
        DatabaseUtility.checkConnection(connection);
        return connection.createStatement();
    }

    public static Collection<Driver> getAvailableJdbcDrivers() throws SQLException {
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        try {
            ServiceLoader<Driver> serviceLoader = ServiceLoader.load(Driver.class);
            for (Driver driver : serviceLoader) {
                drivers.add(driver);
            }
        }
        catch (Throwable e) {
            throw new SQLException(String.format("Could not load database drivers: %s", e.getMessage()), e);
        }
        if (drivers.isEmpty()) {
            throw new SQLException("No database drivers are available");
        }
        return drivers;
    }

    public static ResultSet executeSql(Statement statement, String sql) throws SQLException {
        if (statement == null) {
            return null;
        }
        if (Utility.isBlank(sql)) {
            LOGGER.log(Level.FINE, "No SQL provided", new RuntimeException("No SQL provided"));
            return null;
        }
        try {
            statement.clearWarnings();
            boolean hasResults = statement.execute(sql);
            new UtilityLogger(LOGGER).logSQLWarnings(statement);
            if (hasResults) {
                return statement.getResultSet();
            }
            int updateCount = statement.getUpdateCount();
            LOGGER.log(Level.FINE, new StringFormat("No results. Update count of %d for query: %s", updateCount, sql));
            return null;
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e, new StringFormat("Error executing SQL <%s>", sql));
            throw e;
        }
    }

    public static long executeSqlForLong(Connection connection, String sql) throws SQLException {
        Object longValue = DatabaseUtility.executeSqlForScalar(connection, sql);
        if (longValue == null || !(longValue instanceof Number)) {
            throw new SQLException("Cannot get a long value result from SQL query");
        }
        return ((Number)longValue).longValue();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object executeSqlForScalar(Connection connection, String sql) throws SQLException {
        try (Statement statement = DatabaseUtility.createStatement(connection);){
            Object object;
            block23: {
                Object scalar;
                ResultSet resultSet;
                block21: {
                    Object var4_6;
                    block22: {
                        resultSet = DatabaseUtility.executeSql(statement, sql);
                        try {
                            if (resultSet != null) break block21;
                            var4_6 = null;
                            if (resultSet == null) break block22;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return var4_6;
                }
                if (resultSet.getMetaData().getColumnCount() != 1) {
                    throw new SQLException("Too many columns of data returned");
                }
                if (resultSet.next()) {
                    scalar = resultSet.getObject(1);
                    if (resultSet.wasNull()) {
                        scalar = null;
                    }
                } else {
                    LOGGER.log(Level.WARNING, new StringFormat("No rows of data returned for query <%s>", sql));
                    scalar = null;
                }
                if (resultSet.next()) {
                    throw new SQLException("Too many rows of data returned");
                }
                object = scalar;
                if (resultSet == null) break block23;
                resultSet.close();
            }
            return object;
        }
        catch (SQLException e) {
            throw new SQLException(String.format("%s%n%s", e.getMessage(), sql), e);
        }
    }

    public static List<String> readResultsVector(ResultSet results) throws SQLException {
        ArrayList<String> values = new ArrayList<String>();
        if (results == null) {
            return values;
        }
        try {
            while (results.next()) {
                String value = results.getString(1);
                if (results.wasNull() || Utility.isBlank(value)) continue;
                values.add(value.trim());
            }
        }
        finally {
            results.close();
        }
        return values;
    }

    private DatabaseUtility() {
    }
}

