/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplexInput;
import com.informix.jdbc.IfxComplexOutput;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.IfxTypes;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import com.informix.util.stringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class IfxComplex
extends IfxObject {
    private static final Object logger = Trace.getLoggerForClass(IfxComplex.class);
    protected IfxComplexInput inputStream;
    protected IfxComplexOutput outputStream;
    private short identsize = 0;
    private boolean allocateNewByteArray = true;
    protected static final int IFX_CT_NULL = Integer.MIN_VALUE;
    protected static final int IFX_CT_LONGLEN = 32;
    protected static final short CLROW_HDRSZ = 136;
    protected static final short CLROW_ROWSZ = 414;
    protected static final short OLDCLROW_HDRSZ = 26;
    protected static final short OLDCLROW_ROWSZ = 84;

    IfxComplex() {
    }

    @Override
    public void clear() {
        super.setExtendedTypeName("");
        super.setExtendedOwner("");
    }

    @Override
    public void fromIfx(byte[] b) throws SQLException {
        this.allocateNewByteArray = false;
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) throws SQLException {
        int i;
        byte[] bint = new byte[4];
        byte[] bshort = new byte[2];
        int serializedDataSize = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplex.fromIfx() called");
            this.trace.writeTrace(logger, 2, "   fromIfx() offset: " + offset);
            this.trace.writeTrace(logger, 2, "   fromIfx() length: " + length);
        }
        this.clear();
        this.setIdentSize();
        byte[] bident = new byte[this.identsize];
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "fromIfx() typeMap: " + this.typeMap);
        }
        offset += 4;
        offset += 4;
        offset += 2;
        System.arraycopy(b, offset += this.identsize, bshort, 0, 2);
        int typeInfoCount = IfxToJavaType.IfxToJavaSmallInt(bshort);
        offset += 2;
        IfxColumnInfo[] typeInfoArray = new IfxColumnInfo[typeInfoCount];
        for (i = 0; i < typeInfoCount; ++i) {
            typeInfoArray[i] = new IfxColumnInfo();
        }
        for (i = 0; i < typeInfoCount; ++i) {
            String str;
            System.arraycopy(b, offset += 2, bshort, 0, 2);
            typeInfoArray[i].Levelno = IfxToJavaType.IfxToJavaSmallInt(bshort);
            offset += 2;
            System.arraycopy(b, offset += 2, bshort, 0, 2);
            short stringLength = IfxToJavaType.IfxToJavaSmallInt(bshort);
            System.arraycopy(b, offset += 2, bident, 0, this.identsize);
            try {
                IfxToJavaType cfr_ignored_0 = ((IfxSqliConnect)this.conn).ifxtojava;
                str = IfxToJavaType.IfxToJavaChar(bident, ((IfxSqliConnect)this.conn).encoption);
            }
            catch (IOException ex) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
            typeInfoArray[i].ColName = stringUtil.fixLength(str, stringLength, '\u0000');
            offset += this.identsize;
            System.arraycopy(b, offset += 2, bshort, 0, 2);
            short ifxType = IfxToJavaType.IfxToJavaSmallInt(bshort);
            IfxResultSetMetaData.setTypeBooleanFields(typeInfoArray[i], ifxType);
            offset += 2;
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    ifxType: " + ifxType);
            }
            System.arraycopy(b, offset, bshort, 0, 2);
            typeInfoArray[i].ColLength = IfxToJavaType.IfxToJavaSmallInt(bshort);
            offset += 2;
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    length: " + typeInfoArray[i].ColLength);
            }
            System.arraycopy(b, offset, bint, 0, 4);
            typeInfoArray[i].ExtendedId = IfxToJavaType.IfxToJavaInt(bint);
            offset += 4;
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    xid: " + typeInfoArray[i].ExtendedId);
            }
            System.arraycopy(b, offset += 2, bshort, 0, 2);
            stringLength = IfxToJavaType.IfxToJavaSmallInt(bshort);
            offset += 2;
            if (stringLength > 0 && (!IfxTypes.isComplexType(typeInfoArray[i].SQLtype) || typeInfoArray[i].IsNamedRow)) {
                System.arraycopy(b, offset, bident, 0, this.identsize);
                try {
                    IfxToJavaType cfr_ignored_1 = ((IfxSqliConnect)this.conn).ifxtojava;
                    str = IfxToJavaType.IfxToJavaChar(bident, ((IfxSqliConnect)this.conn).encoption);
                }
                catch (IOException ex) {
                    throw IfxErrMsg.getSQLException(-79716, this.conn);
                }
                typeInfoArray[i].ExtendedName = stringUtil.fixLength(str, stringLength, '\u0000');
            }
            System.arraycopy(b, offset += this.identsize, bshort, 0, 2);
            stringLength = IfxToJavaType.IfxToJavaSmallInt(bshort);
            System.arraycopy(b, offset += 2, bident, 0, this.identsize);
            try {
                IfxToJavaType cfr_ignored_2 = ((IfxSqliConnect)this.conn).ifxtojava;
                str = IfxToJavaType.IfxToJavaChar(bident, ((IfxSqliConnect)this.conn).encoption);
            }
            catch (IOException ex) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
            typeInfoArray[i].ExtendedOwner = stringUtil.fixLength(str, stringLength, '\u0000');
            if (typeInfoArray[i].ExtendedOwner.equals("informix")) {
                typeInfoArray[i].ExtendedOwner = "";
            }
            System.arraycopy(b, offset += this.identsize, bshort, 0, 2);
            typeInfoArray[i].Alignment = IfxToJavaType.IfxToJavaSmallInt(bshort);
            System.arraycopy(b, offset += 2, bint, 0, 4);
            typeInfoArray[i].SourceType = IfxToJavaType.IfxToJavaInt(bint);
            offset += 4;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.dumpTypeArray(typeInfoArray, 4);
        }
        System.arraycopy(b, offset += 4, bint, 0, 4);
        serializedDataSize = IfxToJavaType.IfxToJavaInt(bint);
        offset += 4;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    serializedDataSize: " + serializedDataSize);
        }
        System.arraycopy(b, offset, bint, 0, 4);
        int flags = IfxToJavaType.IfxToJavaInt(bint);
        offset += 4;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    flags: " + flags);
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            this.nullify();
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    is NULL");
            }
        } else {
            this.unnullify();
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    is not NULL");
            }
        }
        boolean isLargeCollection = (flags & 0x20) != 0;
        Vector<IfxColumnInfo> typeInfoVector = new Vector<IfxColumnInfo>();
        this.convertTypeArraytoVector(0, typeInfoArray, typeInfoVector, typeInfoArray[0].Levelno);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "   ***** dump typeInfoVector begin *****");
            IfxComplex.dumpTypeInfoVector(typeInfoVector, this.trace, 4);
            this.trace.writeTrace(logger, 2, "   ***** dump typeInfoVector end *****");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "before IfxComplexInput() constructor");
            this.trace.writeTrace(logger, 2, "isNull(): " + this.isNull());
        }
        if (!this.isNull()) {
            if (TraceFlag.isTraceEnabled()) {
                byte[] dump = new byte[serializedDataSize];
                System.arraycopy(b, offset, dump, 0, serializedDataSize);
                this.trace.writeTrace(logger, 2, "   fromIfx() data:");
                this.trace.writeTrace(logger, 2, dump, 'B');
            }
            if (this.allocateNewByteArray) {
                byte[] tmpbuffer = new byte[serializedDataSize];
                System.arraycopy(b, offset, tmpbuffer, 0, serializedDataSize);
                this.inputStream = new IfxComplexInput(tmpbuffer, 0, serializedDataSize, typeInfoVector, false, this.conn, isLargeCollection);
            } else {
                this.inputStream = new IfxComplexInput(b, offset, serializedDataSize, typeInfoVector, false, this.conn, isLargeCollection);
                this.allocateNewByteArray = false;
            }
            this.inputStream.setTypeMap(this.typeMap);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "after IfxComplexInput() constructor");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplex.fromIfx() exited");
        }
    }

    private int convertTypeArraytoVector(int arrayIndex, IfxColumnInfo[] colInfoArray, Vector<IfxColumnInfo> typeInfoVector, int last_level) throws SQLException {
        IfxColumnInfo colInfo = null;
        IfxColumnInfo childColInfo = null;
        while (arrayIndex < colInfoArray.length) {
            if (last_level == colInfoArray[arrayIndex].Levelno) {
                colInfo = (IfxColumnInfo)colInfoArray[arrayIndex].clone();
                typeInfoVector.add(colInfo);
                ++arrayIndex;
                continue;
            }
            if (colInfoArray[arrayIndex].Levelno <= last_level) break;
            colInfo = typeInfoVector.lastElement();
            Vector<IfxColumnInfo> newVector = new Vector<IfxColumnInfo>();
            childColInfo = (IfxColumnInfo)colInfoArray[arrayIndex].clone();
            newVector.add(childColInfo);
            colInfo.child = newVector;
            if (arrayIndex >= colInfoArray.length) continue;
            arrayIndex = this.convertTypeArraytoVector(arrayIndex + 1, colInfoArray, newVector, colInfoArray[arrayIndex].Levelno);
        }
        return arrayIndex;
    }

    public void fromIfx(byte[] b, IfxColumnInfo typeInfo, boolean isNull) throws SQLException {
        int offset = 0;
        this.clear();
        this.setIdentSize();
        if (isNull) {
            this.nullify();
        } else {
            this.unnullify();
        }
        ArrayList<IfxColumnInfo> tmpVector = new ArrayList<IfxColumnInfo>(1);
        tmpVector.add(typeInfo);
        if (!this.isNull()) {
            this.inputStream = new IfxComplexInput(b, offset, b.length, tmpVector, true, this.conn, b.length > Short.MAX_VALUE);
            this.inputStream.setTypeMap(this.typeMap);
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplex.toIfx() entered");
        }
        if (this.isNull() || this.outputStream == null) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.setIdentSize();
        byte[] bTypeInfo = this.outputStream.getSerializedTypeInfo();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  toIfx() bTypeInfoArray size: " + bTypeInfo.length);
        }
        int typeInfoCount = this.outputStream.getTypeCount();
        int typeSize = this.identsize == 18 ? 26 + 84 * typeInfoCount : 136 + 414 * typeInfoCount;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  toIfx() type size: " + typeSize);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  toIfx() type count: " + typeInfoCount);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  toIfx() outputStream.length(): " + this.outputStream.length());
        }
        int totalSize = typeSize + this.outputStream.length() + 12;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  toIfx() totalSize: " + totalSize);
        }
        byte[] b = JavaToIfxType.JavaToIfxInt(totalSize);
        bStream.write(b, 0, b.length);
        b = JavaToIfxType.JavaToIfxInt(0);
        bStream.write(b, 0, b.length);
        b = JavaToIfxType.JavaToIfxSmallInt((short)0);
        bStream.write(b, 0, b.length);
        String s = stringUtil.fixLength(null, this.identsize, '\u0000');
        try {
            b = stringUtil.getBytes(s, this.conn);
        }
        catch (Exception ex) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        bStream.write(b, 0, b.length);
        b = JavaToIfxType.JavaToIfxSmallInt((short)typeInfoCount);
        bStream.write(b, 0, b.length);
        bStream.write(bTypeInfo, 0, bTypeInfo.length);
        b = JavaToIfxType.JavaToIfxInt(0);
        bStream.write(b, 0, b.length);
        b = JavaToIfxType.JavaToIfxInt(this.outputStream.length());
        bStream.write(b, 0, b.length);
        if (this.outputStream.length() > 0) {
            int flag = 1;
            b = JavaToIfxType.JavaToIfxInt(flag);
            bStream.write(b, 0, b.length);
            b = this.outputStream.toByteArray();
            bStream.write(b, 0, this.outputStream.length());
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "   toIfx() data:");
                this.trace.writeTrace(logger, 2, b, 'B');
            }
        } else {
            b = JavaToIfxType.JavaToIfxInt(Integer.MIN_VALUE);
            bStream.write(b, 0, b.length);
        }
        super.setExtendedTypeName(this.outputStream.getExtendedName());
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    toIfx() bStream.size(): " + bStream.size());
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplex.toIfx() exited");
        }
        return bStream.toByteArray();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        return this.toIfx();
    }

    private void setIdentSize() {
        if (this.identsize == 0) {
            this.identsize = this.conn.isLongID() ? (short)128 : (short)18;
        }
    }

    private void dumpTypeArray(IfxColumnInfo[] typeInfoArray, int indent) {
        for (int i = 0; i < typeInfoArray.length; ++i) {
            this.trace.writeTrace(logger, 2, "index : ", i);
            typeInfoArray[i].dumpInfo(this.trace, indent);
        }
    }

    static void dumpTypeInfoVector(List<IfxColumnInfo> typeInfoVector, Trace trace, int indent) {
        if (TraceFlag.isTraceEnabled()) {
            for (int i = 0; i < typeInfoVector.size(); ++i) {
                IfxColumnInfo colInfo = typeInfoVector.get(i);
                colInfo.dumpInfo(trace, indent);
                if (colInfo.child == null) continue;
                IfxComplex.dumpTypeInfoVector(colInfo.child, trace, indent + 4);
            }
        }
    }

    static String getExtendedName(List<IfxColumnInfo> typeInfoVector, Trace trace, String locale) throws SQLException {
        String name = "";
        if (typeInfoVector == null) {
            throw IfxErrMsg.getLocSQLException(-79716, ": getExtendedName(Vector)", locale);
        }
        if (typeInfoVector.isEmpty()) {
            return "";
        }
        IfxColumnInfo colInfo = typeInfoVector.get(0);
        if (colInfo.IsNamedRow) {
            name = colInfo.ExtendedName;
        } else {
            name = IfxComplex.constructExtendedName(typeInfoVector, name, trace, locale);
            name = name.trim();
            name = name.substring(0, name.lastIndexOf(41));
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "    constructed name: " + name);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "IfxComplex(): getExtendedName() exited");
        }
        return name;
    }

    static String constructExtendedName(List<IfxColumnInfo> typeInfoVector, String name, Trace trace, String locale) throws SQLException {
        for (int i = 0; i < typeInfoVector.size(); ++i) {
            if (i > 0) {
                name = name + ", ";
            }
            IfxColumnInfo colInfo = typeInfoVector.get(i);
            if (colInfo.ColName != null) {
                name = name + colInfo.ColName;
                name = name + " ";
            }
            if (colInfo.SQLtype == 49) {
                colInfo.SQLtype = 0;
                colInfo.ColLength = 1;
            }
            if (colInfo.ExtendedName != "" && colInfo.ExtendedName != null) {
                if (TraceFlag.isTraceEnabled()) {
                    trace.writeTrace(logger, 2, "  colInfo.ExtendedName != empty string");
                    trace.writeTrace(logger, 2, "  colInfo.ExtendedName: " + colInfo.ExtendedName);
                }
                if (colInfo.ExtendedOwner != "" && colInfo.ExtendedOwner != null) {
                    name = name + "'" + colInfo.ExtendedOwner + "'.";
                }
                name = name + colInfo.ExtendedName;
            } else {
                int encoded_length;
                String typeName = IfxTypes.IfxTypeToName(colInfo.SQLtype);
                if (TraceFlag.isTraceEnabled()) {
                    trace.writeTrace(logger, 2, "  colInfo.SQLtype: " + colInfo.SQLtype);
                    trace.writeTrace(logger, 2, "  typeName: " + typeName);
                }
                if (typeName.equals("unknown")) {
                    throw IfxErrMsg.getLocSQLException(-79716, locale);
                }
                name = name + typeName;
                int unmasked = colInfo.SQLtype & 0xFF;
                if (unmasked == 0 || unmasked == 13 || unmasked == 15 || unmasked == 16) {
                    name = name + "(" + colInfo.ColLength + ")";
                } else if (unmasked == 10 || unmasked == 14) {
                    name = name + " ";
                    name = name + IfxDateTime.getQualifierName((short)colInfo.ColLength, unmasked);
                } else if ((unmasked == 5 || unmasked == 8) && (encoded_length = colInfo.ColLength) != 0) {
                    int precision = IfxDecimal.precTot(encoded_length);
                    int scale = IfxDecimal.precDec(encoded_length);
                    name = scale == 255 ? name + "(" + precision + ")" : name + "(" + precision + "," + scale + ")";
                }
                name = name + " ";
            }
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "    name before child check: " + name);
                trace.writeTrace(logger, 2, "    type before child check: " + colInfo.SQLtype);
                trace.writeTrace(logger, 2, "    Nullable before child check: " + colInfo.Nullable);
                trace.writeTrace(logger, 2, "    child before child check: " + colInfo.child);
            }
            if (colInfo.child != null && !colInfo.IsNamedRow) {
                name = name + "( ";
                name = IfxComplex.constructExtendedName(colInfo.child, name, trace, locale);
            }
            if (TraceFlag.isTraceEnabled()) {
                trace.writeTrace(logger, 2, "    colInfo.Nullable: " + colInfo.Nullable);
            }
            if (colInfo.Nullable == 0) {
                name = name + " not null";
            }
            if (i + 1 == typeInfoVector.size()) {
                name = name + ") ";
            }
            if (!TraceFlag.isTraceEnabled()) continue;
            trace.writeTrace(logger, 2, "    name after child check: " + name);
        }
        return name;
    }

    static void badTypeException(int targetType, short sourceType, Trace trace, String locale) throws SQLException {
        String msg = IfxErrMsg.getMessage(-79776, locale, IfxTypes.IfxTypeToName(sourceType), IfxTypes.IfxTypeToName(targetType));
        throw new SQLException(msg);
    }
}

