/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CatalogItem;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.TexturesCategory;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class CatalogTexture
implements TextureImage,
CatalogItem,
Comparable<CatalogTexture> {
    private static final long serialVersionUID = 1L;
    private static final byte[][] EMPTY_CRITERIA = new byte[0][];
    private final String id;
    private final String name;
    private final Content image;
    private final float width;
    private final float height;
    private final String creator;
    private final boolean modifiable;
    private TexturesCategory category;
    private byte[] filterCollationKey;
    private static final Collator COMPARATOR = Collator.getInstance();
    private static final Map<String, byte[][]> recentFilters;

    public CatalogTexture(String string, Content content, float f, float f2) {
        this(null, string, content, f, f2, null);
    }

    public CatalogTexture(String string, String string2, Content content, float f, float f2, String string3) {
        this(string, string2, content, f, f2, string3, false);
    }

    public CatalogTexture(String string, Content content, float f, float f2, boolean bl) {
        this(null, string, content, f, f2, null, bl);
    }

    public CatalogTexture(String string, String string2, Content content, float f, float f2, String string3, boolean bl) {
        this.id = string;
        this.name = string2;
        this.image = content;
        this.width = f;
        this.height = f2;
        this.creator = string3;
        this.modifiable = bl;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Content getImage() {
        return this.image;
    }

    @Override
    public Content getIcon() {
        return this.getImage();
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public TexturesCategory getCategory() {
        return this.category;
    }

    void setCategory(TexturesCategory texturesCategory) {
        this.category = texturesCategory;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(CatalogTexture catalogTexture) {
        int n = COMPARATOR.compare(this.name, catalogTexture.name);
        if (n != 0) {
            return n;
        }
        return this.modifiable == catalogTexture.modifiable ? 0 : (this.modifiable ? 1 : -1);
    }

    public boolean matchesFilter(String string) {
        byte[][] byArray = this.getFilterCollationKeys(string);
        int n = 0;
        if (byArray.length > 0) {
            byte[] byArray2 = this.getTextureCollationKey();
            for (int i = 0; i < byArray.length && this.isSubCollationKey(byArray2, byArray[i], 0); ++i) {
                ++n;
            }
        }
        return n == byArray.length;
    }

    private byte[][] getFilterCollationKeys(String string) {
        if (string.length() == 0) {
            return EMPTY_CRITERIA;
        }
        byte[][] byArray = recentFilters.get(string);
        if (byArray == null) {
            String[] stringArray = string.split("\\s|\\p{Punct}|\\|");
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(stringArray.length);
            for (String string2 : stringArray) {
                if (string2.length() <= 0) continue;
                arrayList.add(COMPARATOR.getCollationKey(string2).toByteArray());
            }
            byArray = arrayList.size() == 0 ? EMPTY_CRITERIA : (byte[][])arrayList.toArray((T[])new byte[arrayList.size()][]);
            recentFilters.put(string, byArray);
        }
        return byArray;
    }

    private byte[] getTextureCollationKey() {
        if (this.filterCollationKey == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getName());
            stringBuilder.append('|');
            if (this.getCategory() != null) {
                stringBuilder.append(this.getCategory().getName());
                stringBuilder.append('|');
            }
            if (this.getCreator() != null) {
                stringBuilder.append(this.getCreator());
                stringBuilder.append('|');
            }
            this.filterCollationKey = COMPARATOR.getCollationKey(stringBuilder.toString()).toByteArray();
        }
        return this.filterCollationKey;
    }

    private boolean isSubCollationKey(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length - 4;
        int n3 = byArray2.length - 4;
        for (int i = n; i < n2 && i < n2 - n3 + 1; ++i) {
            if (byArray[i] != byArray2[0]) continue;
            for (int j = 1; j < n3; ++j) {
                if (byArray[i + j] == byArray2[j]) continue;
                return this.isSubCollationKey(byArray, byArray2, i + 1);
            }
            return true;
        }
        return false;
    }

    static {
        COMPARATOR.setStrength(0);
        recentFilters = Collections.synchronizedMap(new WeakHashMap());
    }
}

