/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.CatCodeChanger;
import com.dickimawbooks.texparserlib.CatCodeList;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.Comment;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Eol;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.FileMapHandler;
import com.dickimawbooks.texparserlib.FileMapType;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Par;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.SkippedEols;
import com.dickimawbooks.texparserlib.SkippedSpaces;
import com.dickimawbooks.texparserlib.Space;
import com.dickimawbooks.texparserlib.SpecialToken;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXMode;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParserActionObject;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXReader;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.TokenRegister;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;

public class TeXParser
extends TeXObjectList {
    private TeXSettings settings;
    private Hashtable<Integer, CountRegister> countAlloc = new Hashtable();
    private Hashtable<Integer, DimenRegister> dimenAlloc = new Hashtable();
    private Hashtable<Integer, TokenRegister> toksAlloc = new Hashtable();
    public static final Integer ALLOC_COUNT = 10;
    public static final Integer ALLOC_DIMEN = 11;
    public static final Integer ALLOC_SKIP = 12;
    public static final Integer ALLOC_MUSKIP = 13;
    public static final Integer ALLOC_BOX = 14;
    public static final Integer ALLOC_TOKS = 15;
    public static final Integer ALLOC_INPUT = 16;
    public static final Integer ALLOC_OUTPUT = 17;
    public static final Integer ALLOC_MATHFAM = 18;
    public static final Integer ALLOC_LANGUAGE = 19;
    public static final Integer INS_COUNT = 20;
    public static final Integer ALLOC_NUMBER = 21;
    public static final Integer MINUS_ONE = 22;
    protected Hashtable<String, ControlSequence> csTable;
    protected Hashtable<Integer, ActiveChar> activeTable;
    private Writer writer;
    private TeXReader reader;
    protected File baseDir = null;
    private TeXParserListener listener;
    public static final int TYPE_ESC = 0;
    public static final int TYPE_BG = 1;
    public static final int TYPE_EG = 2;
    public static final int TYPE_MATH = 3;
    public static final int TYPE_TAB = 4;
    public static final int TYPE_EOL = 5;
    public static final int TYPE_PARAM = 6;
    public static final int TYPE_SP = 7;
    public static final int TYPE_SB = 8;
    public static final int TYPE_IGNORE = 9;
    public static final int TYPE_SPACE = 10;
    public static final int TYPE_LETTER = 11;
    public static final int TYPE_OTHER = 12;
    public static final int TYPE_ACTIVE = 13;
    public static final int TYPE_COMMENT = 14;
    public static final int TYPE_INVALID = 15;
    private CatCodeList[] catcodes;
    private Vector<String> verbatim;
    private String jobname = null;
    private int debugMode = 0;
    private PrintWriter logWriter = null;
    private boolean logging = false;
    private Charset currentInputCharset = null;
    public static final int MAX_TEX_INT = Integer.MAX_VALUE;
    public static final int DEBUG_IO = 1;
    public static final int DEBUG_POPPED = 2;
    public static final int DEBUG_DECL = 4;
    public static final int DEBUG_STY_DATA = 8;
    public static final int DEBUG_EXPANSION = 16;
    public static final int DEBUG_EXPANSION_LIST = 32;
    public static final int DEBUG_PROCESSING = 64;
    public static final int DEBUG_PROCESSING_STACK = 128;
    public static final int DEBUG_PROCESSING_STACK_LIST = 256;
    public static final int DEBUG_CS = 1024;
    public static final int DEBUG_PROCESSING_GENERIC_CS = 2048;
    public static final int DEBUG_EXPANSION_ONCE = 4096;
    public static final int DEBUG_EXPANSION_ONCE_LIST = 8192;
    public static final int DEBUG_CATCODE = 16384;
    public static final int DEBUG_READ = 32768;
    public static final int DEBUG_SETTINGS = 65536;
    public static final String VERSION = "1.3";
    public static final String VERSION_DATE = "2025-01-29";

    public TeXParser(TeXParserListener teXParserListener) {
        this.listener = teXParserListener;
        this.reader = null;
        this.activeTable = new Hashtable();
        this.csTable = new Hashtable();
        this.settings = new TeXSettings(this);
        this.verbatim = new Vector();
        this.verbatim.add("verb");
        this.initDefCatCodes();
        this.initRegisters();
        teXParserListener.setParser(this);
    }

    private TeXParser() {
    }

    @Override
    public TeXObjectList createList() {
        return new TeXParser(this.listener);
    }

    private void initRegisters() {
        CountRegister countRegister = new CountRegister("count@");
        this.allocCount(255, countRegister);
        DimenRegister dimenRegister = new DimenRegister("dimen@");
        this.allocDimen(0, dimenRegister);
        dimenRegister = new DimenRegister("dimen@i");
        this.allocDimen(1, dimenRegister);
        dimenRegister = new DimenRegister("dimen@ii");
        this.allocDimen(2, dimenRegister);
        for (int i = 0; i < 10; ++i) {
            countRegister = new CountRegister("count" + i);
            this.settings.putRegister(countRegister);
            this.allocCount(ALLOC_COUNT, countRegister);
        }
        countRegister = new CountRegister("count" + ALLOC_COUNT, 22);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_COUNT, countRegister);
        countRegister = new CountRegister("count" + ALLOC_DIMEN, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_DIMEN, countRegister);
        countRegister = new CountRegister("count" + ALLOC_SKIP, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_SKIP, countRegister);
        countRegister = new CountRegister("count" + ALLOC_MUSKIP, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_MUSKIP, countRegister);
        countRegister = new CountRegister("count" + ALLOC_BOX, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_BOX, countRegister);
        countRegister = new CountRegister("count" + ALLOC_TOKS, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_TOKS, countRegister);
        countRegister = new CountRegister("count" + ALLOC_INPUT, -1);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_INPUT, countRegister);
        countRegister = new CountRegister("count" + ALLOC_OUTPUT, -1);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_OUTPUT, countRegister);
        countRegister = new CountRegister("count" + ALLOC_MATHFAM, 3);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_MATHFAM, countRegister);
        countRegister = new CountRegister("count" + ALLOC_LANGUAGE, 0);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_LANGUAGE, countRegister);
        countRegister = new CountRegister("insc@unt", 255);
        this.settings.putRegister(countRegister);
        this.allocCount(INS_COUNT, countRegister);
        countRegister = new CountRegister("allocationnumber");
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_NUMBER, countRegister);
        countRegister = new CountRegister("m@ne", -1);
        this.settings.putRegister(countRegister);
        this.allocCount(MINUS_ONE, countRegister);
    }

    private void initDefCatCodes() {
        int n;
        this.catcodes = new CatCodeList[16];
        for (n = 0; n < this.catcodes.length; ++n) {
            this.catcodes[n] = n == 12 ? null : new CatCodeList();
        }
        this.catcodes[0].add('\\');
        this.catcodes[1].add('{');
        this.catcodes[2].add('}');
        this.catcodes[3].add('$');
        this.catcodes[4].add('&');
        this.catcodes[5].add('\n');
        this.catcodes[5].add('\r');
        this.catcodes[6].add('#');
        this.catcodes[7].add('^');
        this.catcodes[8].add('_');
        this.catcodes[10].add(' ');
        this.catcodes[10].add('\t');
        for (n = 65; n <= 90; ++n) {
            this.catcodes[11].add(n);
        }
        for (n = 97; n <= 122; ++n) {
            this.catcodes[11].add(n);
        }
        this.catcodes[13].add('~');
        this.catcodes[14].add('%');
    }

    public boolean isDebugModeOn() {
        return this.debugMode > 0;
    }

    public boolean isDebugMode(int n) {
        return (this.debugMode & n) == n;
    }

    public void setDebugMode(int n) {
        this.debugMode = n;
    }

    public void setDebugMode(int n, PrintWriter printWriter) {
        this.setDebugMode(n, printWriter, printWriter != null);
    }

    public void setDebugMode(int n, PrintWriter printWriter, boolean bl) {
        this.setDebugMode(n);
        this.logWriter = printWriter;
        this.logging = bl;
    }

    public static int getDebugLevelFromModeList(String ... stringArray) throws TeXSyntaxException {
        int n = 0;
        for (String string : stringArray) {
            if ((string = string.trim()).equals("all")) {
                n = Integer.MAX_VALUE;
                continue;
            }
            if (string.equals("io")) {
                n |= 1;
                continue;
            }
            if (string.equals("popped")) {
                n |= 2;
                continue;
            }
            if (string.equals("decl")) {
                n |= 4;
                continue;
            }
            if (string.equals("sty-data")) {
                n |= 8;
                continue;
            }
            if (string.equals("expansion")) {
                n |= 0x10;
                continue;
            }
            if (string.equals("expansion-list")) {
                n |= 0x20;
                continue;
            }
            if (string.equals("process")) {
                n |= 0x40;
                continue;
            }
            if (string.equals("process-stack")) {
                n |= 0x80;
                continue;
            }
            if (string.equals("process-stack-list")) {
                n |= 0x100;
                continue;
            }
            if (string.equals("cs")) {
                n |= 0x400;
                continue;
            }
            if (string.equals("process-generic-cs")) {
                n |= 0x800;
                continue;
            }
            if (string.equals("expansion-once")) {
                n |= 0x1000;
                continue;
            }
            if (string.equals("expansion-once-list")) {
                n |= 0x2000;
                continue;
            }
            if (string.equals("catcode")) {
                n |= 0x4000;
                continue;
            }
            if (string.equals("read")) {
                n |= 0x8000;
                continue;
            }
            if (string.equals("settings")) {
                n |= 0x10000;
                continue;
            }
            throw new TeXSyntaxException(null, "tex.error.invalid.debug_mode", string, "all, io, read, popped, cs, decl, sty-data, expansion, expansion-list, expansion-once, expansion-once-list, process, process-generic-cs, process-stack, process-stack-list, catcode, settings");
        }
        return n;
    }

    @Deprecated
    public int getDebugLevel() {
        return this.debugMode;
    }

    @Deprecated
    public void setDebugLevel(int n) {
        this.setDebugMode(n);
    }

    @Deprecated
    public void setDebugLevel(int n, PrintWriter printWriter) {
        this.setDebugMode(n, printWriter);
    }

    public void debugMessage(int n, String string) {
        if (this.isDebugMode(n)) {
            this.logMessage(string);
        }
    }

    public void logMessage(String string) {
        if (!this.logging) {
            return;
        }
        File file = this.getCurrentFile();
        String string2 = "";
        if (file != null) {
            string2 = file.getName();
            int n = this.getLineNumber();
            if (n > 0) {
                string2 = string2 + ":" + n;
            }
            string2 = string2 + ": ";
        }
        if (this.logWriter == null) {
            System.out.println(string2 + string);
        } else {
            this.logWriter.println(string2 + string);
        }
    }

    public void logMessage(Throwable throwable) {
        if (this.logging) {
            if (this.logWriter == null) {
                throwable.printStackTrace();
            } else {
                if (throwable instanceof TeXSyntaxException) {
                    this.logWriter.println(((TeXSyntaxException)throwable).getMessage(this.getTeXApp()));
                }
                throwable.printStackTrace(this.logWriter);
            }
        }
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setLogging(boolean bl) {
        this.logging = bl;
    }

    public void warning(String string) {
        this.getTeXApp().warning(this, string);
        this.logMessage(string);
    }

    public void warning(Throwable throwable) {
        if (throwable instanceof TeXSyntaxException) {
            this.getTeXApp().warning(this, ((TeXSyntaxException)throwable).getMessage(this.getTeXApp()));
        } else {
            this.getTeXApp().warning(this, throwable.getMessage());
        }
        this.logMessage(throwable);
    }

    public void warningMessage(String string, Object ... objectArray) {
        this.warning(this.getTeXApp().getMessage(string, objectArray));
    }

    public void error(Exception exception) {
        this.getTeXApp().error(exception);
        this.logMessage(exception);
    }

    public void error(Exception exception, int n, String string) {
        this.getTeXApp().error(exception);
        if (this.isDebugMode(n)) {
            this.logMessage(string);
        }
        this.logMessage(exception);
    }

    public void message(String string, Object ... objectArray) {
        TeXApp teXApp = this.getTeXApp();
        String string2 = teXApp.getMessage(string, objectArray);
        teXApp.message(string2);
        this.logMessage(string2);
    }

    public void message(TeXSyntaxException teXSyntaxException) {
        TeXApp teXApp = this.getTeXApp();
        String string = teXSyntaxException.getMessage(teXApp);
        teXApp.message(string);
        this.logMessage(string);
    }

    public void message(TeXObject teXObject) {
        String string = teXObject.toString(this);
        this.getTeXApp().message(string);
        this.logMessage(string);
    }

    public boolean isActive(int n) {
        ActiveChar activeChar = this.getActiveChar(n);
        return activeChar != null;
    }

    public boolean isCatCode(int n, int n2) {
        if (n == 13 && this.isActive(n2)) {
            return true;
        }
        int n3 = this.getCatCode(n2);
        return n == n3;
    }

    public void setCatCode(boolean bl, int n, int n2) {
        if (bl) {
            if (this.isDebugMode(16384)) {
                this.logMessage(String.format("CatCode (local) %s -> %d", new String(Character.toChars(n)), n2));
            }
            this.settings.setCatCode(n, n2);
        } else {
            this.setCatCode(n, n2);
        }
    }

    public void setCatCode(int n, int n2) {
        if (this.isDebugMode(16384)) {
            this.logMessage(String.format("CatCode (global) %s -> %d", new String(Character.toChars(n)), n2));
        }
        Integer n3 = n;
        for (int i = 0; !(i >= this.catcodes.length || this.catcodes[i] != null && this.catcodes[i].remove(n3)); ++i) {
        }
        if (this.catcodes[n2] != null) {
            this.catcodes[n2].add(n3);
        }
    }

    public int getRootCatCode(int n) {
        Integer n2 = n;
        for (int i = 0; i < this.catcodes.length; ++i) {
            if (this.catcodes[i] == null || !this.catcodes[i].contains(n2)) continue;
            return i;
        }
        return 12;
    }

    public int getCatCode(int n) {
        return this.settings.getCatCode(n);
    }

    public int getLineNumber() {
        return this.reader == null ? -1 : this.reader.getLineNumber() + 1;
    }

    public boolean isStack(Object object) {
        return object != null && object instanceof TeXObjectList && ((TeXObjectList)object).isStack();
    }

    public boolean isGroup(Object object) {
        return object != null && object instanceof Group && !((Group)object).isMathGroup();
    }

    public boolean isUndefined(Object object) {
        return object == null || object instanceof Undefined;
    }

    public boolean isLetter(int n) {
        return this.isCatCode(11, n) || Character.isAlphabetic(n) && this.isCatCode(12, n);
    }

    private int read() throws IOException {
        int n = this.reader.read();
        if (this.isDebugMode(32768)) {
            if (n == -1) {
                this.logMessage("READ <EOF>");
            } else {
                this.logMessage(String.format("READ %s (0x%x)", new String(Character.toChars(n)), n));
            }
        }
        return n;
    }

    private void mark() throws IOException {
        this.mark(2);
    }

    private void mark(int n) throws IOException {
        this.reader.mark(n);
    }

    private void reset() throws IOException {
        this.debugMessage(32768, "READER RESET");
        this.reader.reset();
    }

    public void terminate() {
        this.debugMessage(1, "TERMINATE closing all open readers");
        this.reader.closeAll();
    }

    public void scan(String string, TeXObjectList teXObjectList) throws IOException {
        TeXReader teXReader;
        TeXReader teXReader2 = this.reader;
        this.reader = teXReader = new TeXReader(this.getTeXApp(), this.reader, string);
        while (this.reader == teXReader && this.fetchNext(teXObjectList)) {
        }
        this.reader = teXReader2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeXObjectList readLine(TeXReader teXReader, boolean bl) throws IOException {
        if (teXReader.isEnded()) {
            return null;
        }
        TeXReader teXReader2 = this.reader;
        TeXReader teXReader3 = teXReader.getParent();
        TeXObjectList teXObjectList = new TeXObjectList();
        TeXObjectList teXObjectList2 = null;
        try {
            if (this.size() > 0) {
                teXObjectList2 = this.getListener().createStack();
                teXObjectList2.addAll(this);
                this.clear();
            }
            teXReader.setParent(this.reader);
            this.reader = teXReader;
            if (this.isDebugMode(1)) {
                this.logMessage("READLINE switch to " + teXReader + " PENDING: " + teXObjectList2);
            }
            TeXObject teXObject = this.pop();
            while (!(teXObject instanceof Eol) && teXObject != null && !teXReader.isEnded()) {
                teXObjectList.add(teXObject);
                teXObject = this.pop();
            }
            if (bl && teXObject instanceof Eol) {
                teXObjectList.add(teXObject);
            }
            if (teXObjectList.size() > 0 && teXObjectList.lastElement() instanceof Par) {
                teXObjectList.remove(teXObjectList.size() - 1);
            }
        }
        catch (EOFException eOFException) {
            if (teXObjectList.size() == 0) {
                TeXObjectList teXObjectList3 = null;
                return teXObjectList3;
            }
        }
        finally {
            this.reader = teXReader2;
            teXReader.setParent(teXReader3);
            if (this.isDebugMode(1)) {
                this.logMessage("READLINE switching back to " + this.reader + " PENDING: " + teXObjectList2);
            }
            if (teXObjectList2 != null) {
                this.addAll(0, teXObjectList2);
                teXObjectList2.clear();
            }
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.string();
    }

    public TeXObjectList string() throws IOException {
        String string;
        if (this.size() == 0) {
            int n = this.read();
            while (this.isCatCode(10, n)) {
                n = this.read();
            }
            if (this.isCatCode(5, n)) {
                this.parseEOL(n, this);
                string = this.pop().toString(this);
            } else if (this.isCatCode(0, n)) {
                this.readControlSequence(this, true);
                string = this.pop().toString(this);
            } else {
                string = "" + n;
            }
        } else {
            return this.pop().string(this);
        }
        return this.string(string);
    }

    public TeXObjectList string(String string) {
        int n;
        TeXObjectList teXObjectList = new TeXObjectList();
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            teXObjectList.add(this.isLetter(n) ? this.listener.getLetter(n) : this.listener.getOther(n));
        }
        return teXObjectList;
    }

    public void addVerbCommand(String string) {
        this.verbatim.add(string);
    }

    public boolean isVerbCommand(String string) {
        return this.verbatim.contains(string);
    }

    private boolean parseEOL(int n, TeXObjectList teXObjectList) throws IOException {
        return this.parseEOL(n, teXObjectList, false);
    }

    private boolean parseEOL(int n, TeXObjectList teXObjectList, boolean bl) throws IOException {
        boolean bl2 = true;
        if (n == 10) {
            this.mark();
            n = this.read();
            if (n == 10) {
                bl2 = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else if (n == 13) {
                this.mark();
                n = this.read();
                if (this.isCatCode(5, n)) {
                    bl2 = this.skipNextEols(teXObjectList);
                    this.parFound(teXObjectList);
                } else {
                    this.reset();
                    this.eolFound(teXObjectList, bl);
                }
            } else if (this.isCatCode(5, n)) {
                bl2 = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else {
                try {
                    this.reset();
                }
                catch (IOException iOException) {
                    throw new EOFException();
                }
                this.eolFound(teXObjectList, bl);
            }
        } else if (n == 13) {
            this.mark();
            n = this.read();
            if (n == 13) {
                bl2 = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else if (n == 10) {
                this.mark();
                n = this.read();
                if (this.isCatCode(5, n)) {
                    bl2 = this.skipNextEols(teXObjectList);
                    this.parFound(teXObjectList);
                } else {
                    this.reset();
                    this.eolFound(teXObjectList, bl);
                }
            } else if (this.isCatCode(5, n)) {
                bl2 = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else {
                this.reset();
                this.eolFound(teXObjectList, bl);
            }
        } else {
            this.mark();
            n = this.read();
            if (this.isCatCode(5, n)) {
                bl2 = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else {
                this.reset();
                this.eolFound(teXObjectList, bl);
            }
        }
        if (!bl2) {
            return bl2;
        }
        return this.skipNextSpaces(teXObjectList);
    }

    private boolean skipNextEols(TeXObjectList teXObjectList) throws IOException {
        int n = -1;
        this.mark();
        SkippedEols skippedEols = null;
        while ((n = this.read()) != -1) {
            if (!this.isCatCode(5, n)) {
                this.reset();
                break;
            }
            if (skippedEols == null) {
                skippedEols = this.listener.createSkippedEols();
            }
            Eol eol = this.listener.getEol();
            eol.setEol(new String(Character.toChars(n)));
            skippedEols.add(eol);
            this.mark();
        }
        if (skippedEols != null) {
            teXObjectList.add(skippedEols);
        }
        return n != -1;
    }

    private boolean skipNextSpaces(TeXObjectList teXObjectList) throws IOException {
        int n = -1;
        this.mark();
        SkippedSpaces skippedSpaces = null;
        boolean bl = this.settings.inVerb();
        while ((n = this.read()) != -1) {
            if (!this.isCatCode(10, n)) {
                this.reset();
                break;
            }
            Space space = this.listener.getSpace();
            space.setSpace(n);
            if (bl) {
                teXObjectList.add(space);
            } else {
                if (skippedSpaces == null) {
                    skippedSpaces = this.listener.createSkippedSpaces();
                }
                skippedSpaces.add(space);
            }
            this.mark();
        }
        if (n == -1) {
            this.reset();
        }
        if (skippedSpaces != null) {
            teXObjectList.add(skippedSpaces);
        }
        return n != -1;
    }

    private void eolFound(TeXObjectList teXObjectList, boolean bl) throws IOException {
        if (bl) {
            SkippedEols skippedEols = this.listener.createSkippedEols();
            skippedEols.add(this.listener.getEol());
            teXObjectList.add(skippedEols);
        } else {
            teXObjectList.add(this.listener.getEol());
        }
    }

    private void parFound(TeXObjectList teXObjectList) throws IOException {
        teXObjectList.add(this.listener.getPar());
    }

    public static boolean isPar(TeXObject teXObject) {
        return teXObject != null && teXObject.isPar();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readComment(TeXObjectList teXObjectList) throws IOException {
        Comment comment = this.listener.createComment();
        int n = -1;
        while ((n = this.read()) != -1) {
            if (this.isCatCode(5, n)) {
                if (n == 10) {
                    this.mark();
                    n = this.read();
                    if (n == 13) {
                        this.mark();
                        n = this.read();
                        if (this.isCatCode(5, n)) {
                            teXObjectList.add(comment);
                            teXObjectList.add(this.listener.getPar());
                            return this.skipNextEols(teXObjectList);
                        }
                        teXObjectList.add(comment);
                        return true;
                    }
                    if (n == 10) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (this.isCatCode(5, n)) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (n == -1) {
                        teXObjectList.add(comment);
                        return false;
                    }
                    teXObjectList.add(comment);
                    this.reset();
                    return this.skipNextSpaces(teXObjectList);
                }
                if (n == 13) {
                    this.mark();
                    n = this.read();
                    if (n == 10) {
                        this.mark();
                        n = this.read();
                        if (this.isCatCode(5, n)) {
                            teXObjectList.add(comment);
                            teXObjectList.add(this.listener.getPar());
                            return this.skipNextEols(teXObjectList);
                        }
                        teXObjectList.add(comment);
                        return true;
                    }
                    if (n == 13) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (this.isCatCode(5, n)) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (n == -1) {
                        teXObjectList.add(comment);
                        return false;
                    }
                    teXObjectList.add(comment);
                    this.reset();
                    return this.skipNextSpaces(teXObjectList);
                }
                this.mark();
                n = this.read();
                if (this.isCatCode(5, n)) {
                    teXObjectList.add(comment);
                    teXObjectList.add(this.listener.getPar());
                    return this.skipNextEols(teXObjectList);
                }
                if (n == -1) {
                    teXObjectList.add(comment);
                    return false;
                }
                teXObjectList.add(comment);
                this.reset();
                return this.skipNextSpaces(teXObjectList);
            }
            comment.appendCodePoint(n);
        }
        teXObjectList.add(comment);
        if (n == -1) return false;
        return true;
    }

    private boolean readParam(TeXObjectList teXObjectList, DoubleParam doubleParam) throws IOException {
        this.mark();
        int n = this.read();
        if (n == -1) {
            doubleParam.tail().setDigit(0);
            return false;
        }
        if (this.isCatCode(6, n)) {
            DoubleParam doubleParam2 = this.listener.getDoubleParam(doubleParam);
            doubleParam2.setCharCode(n);
            this.readParam(teXObjectList, doubleParam2);
        } else if (n > 48 && n <= 57) {
            doubleParam.tail().setDigit(n - 48);
            teXObjectList.add(doubleParam);
        } else if (this.isCatCode(1, n)) {
            doubleParam.tail().setDigit(-1);
            teXObjectList.add(doubleParam);
            this.reset();
        } else {
            doubleParam.tail().setDigit(0);
            teXObjectList.add(doubleParam);
            this.reset();
        }
        return true;
    }

    private boolean readParam(TeXObjectList teXObjectList, int n) throws IOException {
        this.mark();
        int n2 = this.read();
        Param param = this.listener.getParam(0);
        param.setCharCode(n);
        if (n2 == -1) {
            teXObjectList.add(param);
            return false;
        }
        if (this.isCatCode(6, n2)) {
            DoubleParam doubleParam = this.listener.getDoubleParam(param);
            doubleParam.setCharCode(n2);
            return this.readParam(teXObjectList, doubleParam);
        }
        if (n2 > 48 && n2 <= 57) {
            param.setDigit(n2 - 48);
            teXObjectList.add(param);
        } else if (this.isCatCode(1, n2)) {
            param.setDigit(-1);
            teXObjectList.add(param);
            this.reset();
        } else {
            teXObjectList.add(new SpecialToken(param, n, 6));
            this.reset();
        }
        return true;
    }

    public CatCodeChanger isCatCodeChanger(TeXObject teXObject) {
        if ((teXObject = TeXParserUtils.resolve(teXObject, this)) instanceof CatCodeChanger) {
            return (CatCodeChanger)((Object)teXObject);
        }
        return null;
    }

    public EgChar isEndGroup(TeXObject teXObject) {
        if ((teXObject = TeXParserUtils.resolve(teXObject, this)) instanceof EgChar) {
            return (EgChar)teXObject;
        }
        return null;
    }

    public BgChar isBeginGroup(TeXObject teXObject) {
        if ((teXObject = TeXParserUtils.resolve(teXObject, this)) instanceof BgChar) {
            return (BgChar)teXObject;
        }
        return null;
    }

    @Override
    public boolean popRemainingGroup(TeXParser teXParser, Group group, byte by, BgChar bgChar) throws IOException {
        return this.popRemainingGroup(group, by, bgChar);
    }

    public boolean popRemainingGroup(Group group, byte by, BgChar bgChar) throws IOException {
        this.startGroup();
        try {
            while (true) {
                EgChar egChar;
                if (this.isEmpty() && !this.fetchNext(TeXParser.isShort(by))) {
                    boolean bl = false;
                    return bl;
                }
                TeXObject teXObject = (TeXObject)this.remove(0);
                CatCodeChanger catCodeChanger = this.isCatCodeChanger(teXObject);
                if (catCodeChanger != null) {
                    catCodeChanger.applyCatCodeChange(this);
                }
                if ((egChar = this.isEndGroup(teXObject)) != null) {
                    if (!egChar.matches(bgChar)) {
                        throw new TeXSyntaxException(this, "tex.error.extra_or_forgotten", egChar.toString(this), bgChar.toString(this));
                    }
                    boolean bl = true;
                    return bl;
                }
                bgChar = this.isBeginGroup(teXObject);
                if (TeXParser.isShort(by) && teXObject.isPar()) {
                    throw new TeXSyntaxException(this, "tex.error.par_before_eg", new Object[0]);
                }
                if (bgChar != null) {
                    Group group2 = bgChar.createGroup(this);
                    if (!this.popRemainingGroup(group2, by, bgChar)) {
                        group.add(group2);
                        boolean bl = false;
                        return bl;
                    }
                    group.add(group2);
                    continue;
                }
                group.add(teXObject);
            }
        }
        finally {
            if (this.isDebugMode(65536) || this.isDebugMode(2)) {
                this.logMessage("FINISHED POPPING REMAINING GROUP");
            }
            this.endGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readGroup(Group group, boolean bl) throws IOException {
        int n;
        this.mark();
        this.startGroup();
        try {
            while ((n = this.read()) != -1) {
                EgChar egChar;
                TeXObject teXObject;
                if (this.isCatCode(2, n)) {
                    boolean bl2 = true;
                    return bl2;
                }
                if (this.isCatCode(1, n)) {
                    teXObject = this.listener.createGroup();
                    boolean bl3 = this.readGroup((Group)teXObject, bl);
                    group.add(teXObject);
                    if (bl3) continue;
                    boolean bl4 = false;
                    return bl4;
                }
                this.reset();
                this.fetchNext(group, bl);
                teXObject = (TeXObject)group.lastElement();
                CatCodeChanger catCodeChanger = this.isCatCodeChanger(teXObject);
                if (catCodeChanger != null) {
                    catCodeChanger.applyCatCodeChange(this);
                }
                if ((egChar = this.isEndGroup(teXObject)) != null) {
                    group.remove(group.size() - 1);
                }
                if (bl && TeXParser.isPar(teXObject)) {
                    throw new TeXSyntaxException(this, "tex.error.par_before_eg", new Object[0]);
                }
                this.mark();
            }
            if (n == -1) {
                throw new TeXSyntaxException(this, "tex.error.no_eg", new Object[0]);
            }
        }
        finally {
            if (this.isDebugMode(65536) || this.isDebugMode(32768)) {
                this.logMessage("FINISHED READING GROUP");
            }
            this.endGroup();
        }
        return n != -1;
    }

    private void readMath(MathGroup mathGroup) throws IOException {
        this.mark();
        int n = this.read();
        if (n == -1) {
            throw new TeXSyntaxException(this, "tex.error.missing_endmath", new Object[0]);
        }
        if (this.isCatCode(3, n)) {
            mathGroup.setInLine(false);
            this.readDisplayMath(mathGroup);
        } else {
            this.reset();
            mathGroup.setInLine(true);
            this.readInLineMath(mathGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInLineMath(MathGroup mathGroup) throws IOException {
        this.mark();
        this.startGroup();
        try {
            int n;
            while ((n = this.read()) != -1) {
                if (this.isCatCode(3, n)) {
                    return;
                }
                this.reset();
                this.fetchNext(mathGroup, true);
                TeXObject teXObject = (TeXObject)mathGroup.lastElement();
                CatCodeChanger catCodeChanger = this.isCatCodeChanger(teXObject);
                if (catCodeChanger != null) {
                    catCodeChanger.applyCatCodeChange(this);
                }
                this.mark();
            }
        }
        finally {
            if (this.isDebugMode(65536) || this.isDebugMode(32768)) {
                this.logMessage("FINISHED READING INLINE MATH GROUP");
            }
            this.endGroup();
        }
        throw new EOFException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDisplayMath(MathGroup mathGroup) throws IOException {
        this.mark();
        this.startGroup();
        try {
            int n;
            while ((n = this.read()) != -1) {
                if (this.isCatCode(3, n)) {
                    this.mark();
                    n = this.read();
                    if (n == -1) {
                        throw new TeXSyntaxException(this, "tex.error.missing_endmath", new Object[0]);
                    }
                    if (!this.isCatCode(3, n)) {
                        this.reset();
                        throw new TeXSyntaxException(this, "tex.error.dollar2_ended_with_dollar", new Object[0]);
                    }
                    return;
                }
                this.reset();
                this.fetchNext(mathGroup, true);
                TeXObject teXObject = (TeXObject)mathGroup.lastElement();
                CatCodeChanger catCodeChanger = this.isCatCodeChanger(teXObject);
                if (catCodeChanger != null) {
                    catCodeChanger.applyCatCodeChange(this);
                }
                this.mark();
            }
        }
        finally {
            if (this.isDebugMode(65536) || this.isDebugMode(32768)) {
                this.logMessage("FINISHED READING DISPLAY MATH GROUP");
            }
            this.endGroup();
        }
        throw new EOFException();
    }

    public void readTo(String string, TeXObjectList teXObjectList) throws IOException {
        int n = string.length();
        this.mark(n);
        this.readTo(string, teXObjectList, n, 0);
    }

    private void readTo(String string, TeXObjectList teXObjectList, int n, int n2) throws IOException {
        int n3 = this.read();
        if (n3 == -1) {
            throw new TeXSyntaxException(this, "tex.error.not_found", string);
        }
        if (n3 == string.charAt(n2)) {
            if (++n2 == n) {
                return;
            }
            this.readTo(string, teXObjectList, n, n2);
        } else {
            this.reset();
            if (!this.fetchNext(teXObjectList)) {
                throw new TeXSyntaxException(this, "tex.error.not_found", string);
            }
            this.mark(n);
            this.readTo(string, teXObjectList, n, 0);
        }
    }

    public TeXObjectList popRemainingVerb(int n) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        while (this.size() > 0) {
            int n2;
            TeXObject teXObject = (TeXObject)this.remove(0);
            String string = teXObject.toString(this);
            int n3 = string.length();
            for (int i = 0; i < n3; i += Character.charCount(n2)) {
                n2 = string.codePointAt(i);
                if (n2 == n) {
                    this.addAll(0, this.listener.createString(string.substring(i)));
                    return teXObjectList;
                }
                teXObjectList.add(this.listener.getOther(n2));
            }
        }
        if (this.readVerb(n, teXObjectList) == -1) {
            throw new EOFException();
        }
        return teXObjectList;
    }

    private int readVerb(int n, TeXObjectList teXObjectList) throws IOException {
        int n2;
        while ((n2 = this.read()) != -1) {
            if (n2 == n) {
                return n2;
            }
            teXObjectList.add(this.listener.getOther(n2));
        }
        return -1;
    }

    private boolean readControlSequence(TeXObjectList teXObjectList) throws IOException {
        return this.readControlSequence(teXObjectList, false);
    }

    private boolean readControlSequence(TeXObjectList teXObjectList, boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        this.mark();
        while ((n = this.read()) != -1) {
            if (!this.isLetter(n)) {
                TeXCsRef teXCsRef;
                if (this.isCatCode(5, n)) {
                    teXCsRef = stringBuilder.length() == 0 ? new TeXCsRef(" ") : new TeXCsRef(stringBuilder.toString());
                    teXObjectList.add(teXCsRef);
                    this.parseEOL(n, teXObjectList, true);
                } else if (stringBuilder.length() == 0) {
                    teXCsRef = new TeXCsRef(new String(Character.toChars(n)));
                    teXObjectList.add(teXCsRef);
                } else if (this.isCatCode(10, n)) {
                    teXCsRef = new TeXCsRef(stringBuilder.toString());
                    teXObjectList.add(teXCsRef);
                    this.reset();
                    if (!this.skipNextSpaces(teXObjectList)) {
                        return false;
                    }
                } else {
                    this.reset();
                    teXCsRef = new TeXCsRef(stringBuilder.toString());
                    teXObjectList.add(teXCsRef);
                }
                if (bl) {
                    return true;
                }
                if (this.isVerbCommand(teXCsRef.getName())) {
                    n = this.read();
                    if (n == 42) {
                        teXObjectList.add(this.listener.getOther(n));
                        n = this.read();
                    }
                    int n2 = n;
                    TeXObjectList teXObjectList2 = new TeXObjectList();
                    teXObjectList.add(teXObjectList2, false);
                    teXObjectList2.add(this.listener.getOther(n));
                    n = this.readVerb(n2, teXObjectList2);
                    teXObjectList2.add(this.listener.getOther(n));
                } else if (teXCsRef.getName().equals("detokenize")) {
                    n = this.read();
                    if (this.isCatCode(1, n)) {
                        n = this.read();
                        while (!this.isCatCode(2, n) && n != -1) {
                            teXObjectList.add(this.listener.getOther(n));
                            n = this.read();
                        }
                    } else {
                        teXObjectList.add(this.listener.getOther(n));
                    }
                } else if (teXCsRef.getName().equals("string")) {
                    this.mark();
                    n = this.read();
                    while (this.isCatCode(10, n)) {
                        this.mark();
                        n = this.read();
                    }
                    if (this.isCatCode(0, n)) {
                        this.reset();
                    } else if (this.isCatCode(11, n)) {
                        teXObjectList.add(this.listener.getLetter(n));
                    } else {
                        teXObjectList.add(this.listener.getOther(n));
                    }
                }
                return true;
            }
            this.mark();
            stringBuilder.appendCodePoint(n);
        }
        if (n == -1) {
            teXObjectList.add(new TeXCsRef(" "));
            return false;
        }
        return true;
    }

    public boolean fetchNext() throws IOException {
        return this.fetchNext(this, false);
    }

    public boolean fetchNext(boolean bl) throws IOException {
        return this.fetchNext(this, bl);
    }

    public boolean fetchNext(TeXObjectList teXObjectList) throws IOException {
        return this.fetchNext(teXObjectList, false);
    }

    public boolean fetchNext(TeXObjectList teXObjectList, boolean bl) throws IOException {
        if (this.reader == null) {
            this.logMessage("NULL reader");
            return false;
        }
        int n = this.read();
        if (n == -1) {
            return false;
        }
        if (this.isCatCode(5, n)) {
            this.parseEOL(n, teXObjectList);
        } else {
            if (this.isCatCode(0, n)) {
                return this.readControlSequence(teXObjectList);
            }
            if (this.isCatCode(14, n)) {
                return this.readComment(teXObjectList);
            }
            if (this.isCatCode(6, n)) {
                return this.readParam(teXObjectList, n);
            }
            if (this.isCatCode(13, n)) {
                ActiveChar activeChar = this.listener.getActiveChar(n);
                if (activeChar == null) {
                    throw new TeXSyntaxException(this, "tex.error.undefined_char", new String(Character.toChars(n)));
                }
                teXObjectList.add(activeChar);
            } else if (this.isCatCode(7, n)) {
                teXObjectList.add(this.listener.createSpChar(n));
            } else if (this.isCatCode(8, n)) {
                teXObjectList.add(this.listener.createSbChar(n));
            } else if (this.isCatCode(4, n)) {
                teXObjectList.add(this.listener.getTab(n));
            } else if (this.isCatCode(3, n)) {
                MathGroup mathGroup = this.listener.createMathGroup();
                teXObjectList.add(mathGroup);
                this.readMath(mathGroup);
            } else if (this.isCatCode(1, n)) {
                teXObjectList.add(this.listener.getBgChar(n));
            } else if (this.isCatCode(2, n)) {
                teXObjectList.add(this.listener.getEgChar(n));
            } else {
                if (this.isCatCode(10, n)) {
                    Space space = this.listener.getSpace();
                    space.setSpace(n);
                    teXObjectList.add(space);
                    return this.skipNextSpaces(teXObjectList);
                }
                if (this.isLetter(n)) {
                    teXObjectList.add(this.listener.getLetter(n));
                } else {
                    teXObjectList.add(this.listener.getOther(n));
                }
            }
        }
        try {
            this.mark();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void parse(TeXReader teXReader) throws IOException {
        this.parse(teXReader, TeXMode.INHERIT);
    }

    @Deprecated
    public void parse(TeXReader teXReader, int n) throws IOException {
        switch (n) {
            case -1: {
                this.parse(teXReader, TeXMode.INHERIT);
                break;
            }
            case 0: {
                this.parse(teXReader, TeXMode.TEXT);
                break;
            }
            case 1: {
                this.parse(teXReader, TeXMode.INLINE_MATH);
                break;
            }
            case 2: {
                this.parse(teXReader, TeXMode.DISPLAY_MATH);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode " + n);
            }
        }
    }

    public void parse(TeXReader teXReader, TeXMode teXMode) throws IOException {
        boolean bl;
        if (teXReader != this.reader) {
            TeXObjectList teXObjectList;
            bl = true;
            if (this.reader != null) {
                if (this.isDebugMode(1)) {
                    this.logMessage("CURRENT READER " + this.reader);
                }
                if (this.reader == teXReader.getParent()) {
                    if (this.isDebugMode(1)) {
                        this.logMessage("MOVING DOWN TO NESTED FILE " + teXReader);
                    }
                } else if (this.reader.getParent() == teXReader) {
                    bl = false;
                    if (this.isDebugMode(1)) {
                        this.logMessage("MOVING UP TO PARENT FILE " + teXReader);
                    }
                } else {
                    if (this.isDebugMode(1)) {
                        this.logMessage("MOVING SIDEWAYS(??) TO NESTED FILE " + teXReader);
                    }
                    teXReader.setParent(this.reader);
                }
            }
            if (bl && !this.isEmpty()) {
                teXObjectList = teXReader.getPending();
                if (teXObjectList == null) {
                    teXObjectList = new TeXObjectList(this.size());
                }
                teXObjectList.addAll(this);
                this.clear();
                teXReader.setPending(teXObjectList);
                teXObjectList = null;
            } else if (!bl) {
                teXObjectList = teXReader.getPending();
                if (teXObjectList != null) {
                    this.push(teXObjectList, true);
                }
                teXReader.setPending(null);
            }
            if (this.isDebugMode(1)) {
                this.logMessage("PARSE switching from " + this.reader + " to " + teXReader);
            }
            this.reader = teXReader;
        }
        if (this.isDebugMode(1)) {
            this.logMessage("PARSE setting mode: " + (Object)((Object)teXMode));
        }
        this.settings.setMode(teXMode);
        try {
            bl = false;
            while (!bl) {
                boolean bl2;
                boolean bl3 = bl2 = !this.fetchNext() || this.isEmpty();
                if (this.isDebugMode(1)) {
                    if (bl2) {
                        this.logMessage("PARSE FETCH NEXT EOF FOUND");
                    } else {
                        this.logMessage("PARSE FETCH NEXT " + this.toString());
                    }
                }
                if (bl2) {
                    this.closeReader(teXReader);
                    teXReader = this.reader;
                    if (this.reader == null) {
                        bl = true;
                    }
                }
                while (this.size() > 0) {
                    TeXObject teXObject = this.pop();
                    if (this.isDebugMode(2)) {
                        this.logMessage("PARSE POPPED " + teXObject);
                    }
                    try {
                        teXObject.process(this);
                    }
                    catch (EOFException eOFException) {
                        this.debugMessage(1, "EOF while processing object " + teXObject);
                        if (teXReader != null) {
                            this.closeReader(teXReader);
                        }
                        teXReader = this.reader;
                        if (this.reader != null) continue;
                        bl = true;
                    }
                    catch (TeXSyntaxException teXSyntaxException) {
                        this.error(teXSyntaxException);
                    }
                }
            }
        }
        catch (EOFException eOFException) {
            this.debugMessage(1, "EOF while fetching next from " + this.reader);
            this.closeReader(this.reader);
        }
    }

    private void closeReader(TeXReader teXReader) throws IOException {
        TeXObjectList teXObjectList = teXReader.getPending();
        teXReader.setPending(null);
        teXReader.close();
        this.reader = teXReader.getParent();
        while (this.reader != null) {
            if (this.isDebugMode(1)) {
                this.logMessage("CLOSE READER switching from child " + teXReader + " to parent " + this.reader);
            }
            if (!this.reader.isClosed()) break;
            if (this.reader.hasPending()) {
                if (teXObjectList == null) {
                    teXObjectList = this.reader.getPending();
                } else {
                    teXObjectList.addAll(this.reader.getPending());
                }
                this.reader.setPending(null);
            }
            teXReader = this.reader;
            this.reader = this.reader.getParent();
        }
        if (teXObjectList != null) {
            this.debugMessage(1, "CLOSE READER processing pending");
            teXObjectList.process(this);
        }
    }

    public void processBuffered() throws IOException {
        if (this.isDebugMode(64)) {
            this.logMessage("PROCESS buffered " + this.toString());
        }
        if (!this.isEmpty()) {
            super.process(this);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (this.isDebugMode(64)) {
            this.logMessage("[Do nothing] PROCESS " + this.toString());
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.isDebugMode(64)) {
            this.logMessage("PROCESS " + this.toString() + " SUBSTACK: " + teXObjectList);
        }
        if (teXObjectList != null && teXObjectList != this) {
            this.push(teXObjectList, true);
        }
    }

    public void processAction(TeXParserActionObject teXParserActionObject) throws IOException {
        Object object = teXParserActionObject.getData();
        switch (teXParserActionObject.getAction()) {
            case INPUT_FILE: {
                File file = null;
                Charset charset = null;
                if (object instanceof File) {
                    file = (File)object;
                } else {
                    TeXPath teXPath = (TeXPath)object;
                    file = teXPath.getFile();
                    charset = teXPath.getEncoding();
                }
                if (charset == null) {
                    charset = this.currentInputCharset;
                }
                this.parse(file, charset, teXParserActionObject.getPending());
                break;
            }
            case MODE_CHANGE: {
                this.settings.setMode((TeXMode)((Object)object));
            }
        }
    }

    public void parse(File file) throws IOException {
        this.parse(file, this.getListener().getCharSet());
    }

    public void parse(File file, Charset charset) throws IOException {
        this.parse(file, charset, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File file, Charset charset, TeXObjectList teXObjectList) throws IOException {
        TeXApp teXApp = this.getTeXApp();
        if (this.baseDir == null) {
            this.setBaseDir(file.getParentFile());
            if (this.baseDir == null) {
                this.setBaseDir(new File("."));
            }
        }
        if (charset == null) {
            charset = teXApp.getDefaultCharset();
        }
        this.currentInputCharset = charset;
        if (!teXApp.isReadAccessAllowed(file)) {
            this.warningMessage("message.no.read", file);
            return;
        }
        if (this.jobname == null) {
            this.jobname = file.getName();
            int n = this.jobname.lastIndexOf(".");
            if (n > 0) {
                this.jobname = this.jobname.substring(0, n);
            }
        }
        try {
            this.debugMessage(1, "PARSE FILE: " + file);
            this.listener.beginParse(file, charset);
            TeXReader teXReader = new TeXReader(teXApp, this.reader, file, charset);
            if (teXObjectList != null && teXObjectList != this && !teXObjectList.isEmpty()) {
                teXReader.setPending(teXObjectList);
            }
            this.debugMessage(1, "READER: " + teXReader);
            this.parse(teXReader);
        }
        catch (EOFException eOFException) {
            if (this.isDebugMode(1)) {
                this.logMessage("EOF parsing file: " + file);
                this.logMessage("Current reader: " + this.reader);
            }
        }
        finally {
            this.listener.endParse(file);
            if (this.reader != null) {
                this.reader.close();
                this.reader = this.reader.getParent();
            }
        }
    }

    public void parse(TeXPath teXPath) throws IOException {
        this.parse(teXPath, this.getListener().getCharSet());
    }

    public void parse(TeXPath teXPath, Charset charset) throws IOException {
        this.parse(teXPath, charset, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(TeXPath teXPath, Charset charset, TeXObjectList teXObjectList) throws IOException {
        TeXApp teXApp = this.getTeXApp();
        if (this.baseDir == null) {
            this.setBaseDir(teXPath.getBaseDir());
            if (this.baseDir == null) {
                this.setBaseDir(new File("."));
            }
        }
        if (charset == null) {
            charset = teXApp.getDefaultCharset();
        }
        if (!teXApp.isReadAccessAllowed(teXPath)) {
            this.warningMessage("message.no.read", teXPath);
            return;
        }
        File file = teXPath.getFile();
        if (this.jobname == null) {
            this.jobname = file.getName();
            int n = this.jobname.lastIndexOf(".");
            if (n > 0) {
                this.jobname = this.jobname.substring(0, n);
            }
        }
        try {
            this.listener.beginParse(file, charset);
            TeXReader teXReader = new TeXReader(teXApp, this.reader, file, charset);
            if (teXObjectList != null && teXObjectList != this && !teXObjectList.isEmpty()) {
                teXReader.setPending(teXObjectList);
            }
            this.parse(teXReader);
        }
        catch (EOFException eOFException) {
        }
        finally {
            this.listener.endParse(file);
            if (this.reader != null) {
                this.reader.close();
                this.reader = this.reader.getParent();
            }
        }
    }

    public void fileMap(TeXPath teXPath, FileMapType fileMapType, FileMapHandler fileMapHandler) throws IOException {
        TeXApp teXApp = this.getTeXApp();
        if (!teXApp.isReadAccessAllowed(teXPath)) {
            throw new TeXSyntaxException(this, "message.no.read", teXPath);
        }
        Charset charset = teXPath.getEncoding();
        if (charset == null) {
            charset = this.reader == null ? teXApp.getDefaultCharset() : this.reader.getEncoding();
        }
        int n = this.getLineNumber();
        File file = this.getCurrentFile();
        TeXReader teXReader = this.reader;
        int n2 = 1;
        try {
            TeXObjectList teXObjectList;
            this.reader = new TeXReader(teXApp, teXPath.getFile(), charset);
            if (!this.isEmpty()) {
                teXObjectList = new TeXObjectList();
                teXObjectList.addAll(this);
                this.reader.setPending(teXObjectList);
                this.clear();
            }
            teXApp.message(teXApp.getMessage("message.reading", teXPath));
            while ((teXObjectList = this.fileMapReadLine(fileMapType)) != null) {
                fileMapHandler.processLine(this, teXObjectList, n2);
                ++n2;
            }
            fileMapHandler.processCompleted(this);
        }
        catch (EOFException eOFException) {
        }
        catch (TeXSyntaxException teXSyntaxException) {
            throw new TeXSyntaxException((Throwable)teXSyntaxException, this, n, file, "tex.error.file.mapper", teXPath.getRelativePath(), teXSyntaxException.getMessage(teXApp));
        }
        catch (IOException iOException) {
            throw new TeXSyntaxException((Throwable)iOException, this, n2, teXPath.getFile(), "tex.error.file.mapper", iOException.getMessage());
        }
        finally {
            if (this.reader.hasPending()) {
                this.add(0, this.reader.getPending());
                this.reader.setPending(null);
            }
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = teXReader;
        }
    }

    protected TeXObjectList fileMapReadLine(FileMapType fileMapType) throws IOException {
        int n = this.read();
        if (n == -1) {
            return null;
        }
        TeXObjectList teXObjectList = this.getListener().createStack();
        while (n != -1) {
            if (this.isCatCode(5, n)) {
                if (n == 13) {
                    this.mark();
                    if (this.read() != 10) {
                        this.reset();
                    }
                } else if (n == 10) {
                    this.mark();
                    if (this.read() != 13) {
                        this.reset();
                    }
                }
                return teXObjectList;
            }
            boolean bl = false;
            switch (fileMapType) {
                case VERBATIM: {
                    if (Character.isLetter(n)) {
                        teXObjectList.add(this.listener.getLetter(n));
                        break;
                    }
                    teXObjectList.add(this.listener.getOther(n));
                    break;
                }
                case VERBATIM_EXCEPT_ESC_SYM: {
                    if (this.isCatCode(0, n)) {
                        n = this.read();
                        if (n == -1) {
                            teXObjectList.add(new TeXCsRef("\n"));
                            bl = true;
                            break;
                        }
                        if (this.isCatCode(5, n)) {
                            bl = true;
                            if (n == 13) {
                                this.mark();
                                if (this.read() == 10) {
                                    teXObjectList.add(new TeXCsRef("\r\n"));
                                    break;
                                }
                                this.reset();
                                teXObjectList.add(new TeXCsRef("\r"));
                                break;
                            }
                            if (n == 10) {
                                this.mark();
                                if (this.read() == 13) {
                                    teXObjectList.add(new TeXCsRef("\n\r"));
                                    break;
                                }
                                this.reset();
                                teXObjectList.add(new TeXCsRef("\n"));
                                break;
                            }
                            teXObjectList.add(new TeXCsRef(new String(Character.toChars(n))));
                            break;
                        }
                        teXObjectList.add(new TeXCsRef(new String(Character.toChars(n))));
                        break;
                    }
                    if (Character.isLetter(n)) {
                        teXObjectList.add(this.listener.getLetter(n));
                        break;
                    }
                    teXObjectList.add(this.listener.getOther(n));
                    break;
                }
                case VERBATIM_EXCEPT_ESC_SEQ: {
                    boolean bl2;
                    Object object;
                    if (this.isCatCode(0, n)) {
                        n = this.read();
                        if (n == -1) {
                            bl = true;
                            teXObjectList.add(new TeXCsRef("\n"));
                            break;
                        }
                        if (this.isCatCode(5, n)) {
                            bl = true;
                            if (n == 13) {
                                this.mark();
                                if (this.read() == 10) {
                                    teXObjectList.add(new TeXCsRef("\r\n"));
                                    break;
                                }
                                this.reset();
                                teXObjectList.add(new TeXCsRef("\r"));
                                break;
                            }
                            if (n == 10) {
                                this.mark();
                                if (this.read() == 13) {
                                    teXObjectList.add(new TeXCsRef("\n\r"));
                                    break;
                                }
                                this.reset();
                                teXObjectList.add(new TeXCsRef("\n"));
                                break;
                            }
                            teXObjectList.add(new TeXCsRef(new String(Character.toChars(n))));
                            break;
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).appendCodePoint(n);
                        bl2 = false;
                        while (!bl && !this.isCatCode(5, n) && Character.isLetter(n)) {
                            ((StringBuilder)object).appendCodePoint(n);
                            this.mark();
                            bl2 = true;
                            n = this.read();
                            if (n != -1) continue;
                            bl = true;
                            bl2 = false;
                        }
                        teXObjectList.add(new TeXCsRef(((StringBuilder)object).toString()));
                        if (this.isCatCode(5, n)) {
                            bl = true;
                            if (n == 13) {
                                this.mark();
                                if (this.read() == 10) break;
                                this.reset();
                                break;
                            }
                            if (n != 10) break;
                            this.mark();
                            if (this.read() == 13) break;
                            this.reset();
                            break;
                        }
                        if (!bl2) break;
                        this.reader.reset();
                        break;
                    }
                    if (Character.isLetter(n)) {
                        teXObjectList.add(this.listener.getLetter(n));
                        break;
                    }
                    teXObjectList.add(this.listener.getOther(n));
                    break;
                }
                case TEX: {
                    boolean bl2;
                    Object object;
                    if (this.isCatCode(0, n)) {
                        bl = !this.readControlSequence(teXObjectList);
                        break;
                    }
                    if (this.isCatCode(14, n)) {
                        bl = !this.readComment(teXObjectList);
                        break;
                    }
                    if (this.isCatCode(6, n)) {
                        bl = !this.readParam(teXObjectList, n);
                        break;
                    }
                    if (this.isCatCode(13, n)) {
                        object = this.listener.getActiveChar(n);
                        if (object == null) {
                            throw new TeXSyntaxException(this, "tex.error.undefined_char", new String(Character.toChars(n)));
                        }
                        teXObjectList.add((TeXObject)object);
                        break;
                    }
                    if (this.isCatCode(7, n)) {
                        teXObjectList.add(this.listener.createSpChar(n));
                        break;
                    }
                    if (this.isCatCode(8, n)) {
                        teXObjectList.add(this.listener.createSbChar(n));
                        break;
                    }
                    if (this.isCatCode(4, n)) {
                        teXObjectList.add(this.listener.getTab(n));
                        break;
                    }
                    if (this.isCatCode(3, n)) {
                        object = this.listener.createMathGroup();
                        teXObjectList.add((TeXObject)object);
                        this.readMath((MathGroup)object);
                        break;
                    }
                    if (this.isCatCode(1, n)) {
                        object = this.listener.createGroup();
                        teXObjectList.add((TeXObject)object);
                        bl = !this.readGroup((Group)object, false);
                        break;
                    }
                    if (this.isCatCode(2, n)) {
                        teXObjectList.add(this.listener.getEgChar(n));
                        break;
                    }
                    if (this.isCatCode(10, n)) {
                        object = this.listener.getSpace();
                        ((Space)object).setSpace(n);
                        teXObjectList.add((TeXObject)object);
                        bl2 = true;
                        SkippedSpaces skippedSpaces = null;
                        while (bl2) {
                            this.mark();
                            n = this.read();
                            if (this.isCatCode(5, n)) {
                                bl = true;
                                bl2 = false;
                                if (n == 13) {
                                    this.mark();
                                    if (this.read() == 10) continue;
                                    this.reset();
                                    continue;
                                }
                                if (n != 10) continue;
                                this.mark();
                                if (this.read() == 13) continue;
                                this.reset();
                                continue;
                            }
                            if (this.isCatCode(10, n)) {
                                object = this.listener.getSpace();
                                ((Space)object).setSpace(n);
                                if (skippedSpaces == null) {
                                    skippedSpaces = new SkippedSpaces();
                                    teXObjectList.add(skippedSpaces);
                                }
                                skippedSpaces.add((Space)object);
                                continue;
                            }
                            bl2 = false;
                            this.reset();
                        }
                        break;
                    }
                    if (this.isLetter(n)) {
                        teXObjectList.add(this.listener.getLetter(n));
                        break;
                    }
                    teXObjectList.add(this.listener.getOther(n));
                }
            }
            if (bl) break;
            n = this.read();
        }
        return teXObjectList;
    }

    @Override
    public TeXObject pop() throws IOException {
        if (this.size() == 0) {
            this.fetchNext();
            if (this.size() == 0) {
                throw new EOFException();
            }
        }
        return (TeXObject)this.remove(0);
    }

    public TeXObject popNextArg() throws IOException {
        return this.popNextArg(POP_IGNORE_LEADING_SPACE);
    }

    public TeXObject popNextArg(byte by) throws IOException {
        boolean bl = !TeXParser.isRetainIgnoreables(by);
        boolean bl2 = TeXParser.isIgnoreLeadingSpace(by);
        if (bl && bl2) {
            while (this.size() == 0) {
                if (!this.fetchNext(TeXParser.isShort(by))) {
                    throw new EOFException();
                }
                TeXObject teXObject = (TeXObject)this.get(0);
                if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) {
                    this.pop();
                    continue;
                }
                break;
            }
        } else if (bl) {
            while (this.size() == 0) {
                if (!this.fetchNext(TeXParser.isShort(by))) {
                    throw new EOFException();
                }
                if (this.get(0) instanceof Ignoreable) {
                    this.pop();
                    continue;
                }
                break;
            }
        } else if (bl2) {
            while (this.size() == 0) {
                if (!this.fetchNext(TeXParser.isShort(by))) {
                    throw new EOFException();
                }
                if (this.get(0) instanceof WhiteSpace) {
                    this.pop();
                    continue;
                }
                break;
            }
        } else if (this.size() == 0 && !this.fetchNext(TeXParser.isShort(by))) {
            throw new EOFException();
        }
        return this.popArg(by);
    }

    public TeXObject popNextArg(int n, int n2) throws IOException {
        return this.popNextArg(POP_IGNORE_LEADING_SPACE, n, n2);
    }

    public TeXObject popNextArg(byte by, int n, int n2) throws IOException {
        if (this.size() == 0) {
            this.fetchNext(TeXParser.isShort(by));
        }
        return this.popArg(by, n, n2);
    }

    public Numerical popNumericalArg(int n, int n2) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popNextArg(POP_SHORT, n, n2);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof Numerical) {
            return (Numerical)teXObject;
        }
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(this)) != null) {
            teXObject = teXObjectList;
        }
        if (teXObject instanceof TeXObjectList) {
            return ((TeXObjectList)teXObject).popNumerical(this);
        }
        return new UserNumber(this, teXObject.toString(this));
    }

    public Numerical popNumericalArg() throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popNextArg(POP_SHORT);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof Numerical) {
            return (Numerical)teXObject;
        }
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(this)) != null) {
            teXObject = teXObjectList;
        }
        if (teXObject instanceof TeXObjectList) {
            return ((TeXObjectList)teXObject).popNumerical(this);
        }
        return new UserNumber(this, teXObject.toString(this));
    }

    public TeXObject popArg() throws IOException {
        return super.popArg(this);
    }

    public TeXObject popArg(byte by) throws IOException {
        return super.popArg(this, by);
    }

    public TeXObject popArg(byte by, int n, int n2) throws IOException {
        TeXObject teXObject;
        TeXObjectList teXObjectList;
        block28: {
            boolean bl = !TeXParser.isRetainIgnoreables(by);
            boolean bl2 = TeXParser.isIgnoreLeadingSpace(by);
            teXObjectList = null;
            teXObject = null;
            if (bl && bl2) {
                while (true) {
                    if (this.isEmpty()) {
                        this.fetchNext();
                        if (this.isEmpty()) break block28;
                    }
                    if ((teXObject = (TeXObject)this.get(0)) instanceof Ignoreable || teXObject instanceof WhiteSpace) {
                        this.remove(0);
                        if (teXObjectList == null) {
                            teXObjectList = new TeXObjectList();
                        }
                        teXObjectList.add(teXObject);
                        teXObject = null;
                        continue;
                    }
                    break block28;
                    break;
                }
            }
            if (bl) {
                while (true) {
                    if (this.isEmpty()) {
                        this.fetchNext();
                        if (this.isEmpty()) break block28;
                    }
                    if ((teXObject = (TeXObject)this.get(0)) instanceof Ignoreable) {
                        this.remove(0);
                        if (teXObjectList == null) {
                            teXObjectList = new TeXObjectList();
                        }
                        teXObjectList.add(teXObject);
                        teXObject = null;
                        continue;
                    }
                    break block28;
                    break;
                }
            }
            if (bl2) {
                while (true) {
                    if (this.isEmpty()) {
                        this.fetchNext();
                        if (this.isEmpty()) break;
                    }
                    if (!((teXObject = (TeXObject)this.get(0)) instanceof WhiteSpace)) break;
                    this.remove(0);
                    if (teXObjectList == null) {
                        teXObjectList = new TeXObjectList();
                    }
                    teXObjectList.add(teXObject);
                    teXObject = null;
                }
            }
        }
        if (this.size() == 0 || teXObject == null) {
            if (teXObjectList != null) {
                this.addAll(teXObjectList);
            }
            return null;
        }
        if (!(teXObject instanceof CharObject) || ((CharObject)teXObject).getCharCode() != n) {
            if (teXObjectList != null) {
                this.addAll(0, teXObjectList);
            }
            return null;
        }
        this.remove(0);
        if (TeXParser.isIgnoreLeadingSpace(by)) {
            by = (byte)(by ^ POP_IGNORE_LEADING_SPACE);
        }
        int n3 = this.getLineNumber();
        TeXObjectList teXObjectList2 = new TeXObjectList();
        boolean bl = TeXParser.isShort(by);
        while ((teXObject = this.pop()) != null) {
            BgChar bgChar = this.isBeginGroup(teXObject);
            if (teXObject instanceof CharObject) {
                if (((CharObject)teXObject).getCharCode() == n2) {
                    return teXObjectList2;
                }
            } else if (bgChar != null) {
                Group group = this.getListener().createGroup();
                this.popRemainingGroup(group, by, bgChar);
                teXObject = group;
            } else if (bl && teXObject.isPar()) break;
            teXObjectList2.add(teXObject);
        }
        if (n3 > 0) {
            throw new TeXSyntaxException(this, "tex.error.missing_closing.from_open", new String(Character.toChars(n2)), new String(Character.toChars(n)), n3);
        }
        throw new TeXSyntaxException(this, "tex.error.missing_closing", new String(Character.toChars(n2)));
    }

    @Override
    public TeXObject expandedPopStack(TeXParser teXParser) throws IOException {
        return teXParser.expandedPopStack();
    }

    @Override
    public TeXObject expandedPopStack(TeXParser teXParser, byte by) throws IOException {
        return teXParser.expandedPopStack(by);
    }

    public TeXObject expandedPopStack() throws IOException {
        return this.expandedPopStack((byte)0);
    }

    public TeXObject expandedPopStack(byte by) throws IOException {
        TeXObject teXObject = this.popStack(by);
        BgChar bgChar = this.isBeginGroup(teXObject = TeXParserUtils.resolve(teXObject, this));
        if (bgChar != null) {
            Group group = bgChar.createGroup(this);
            this.popRemainingGroup(group, by, bgChar);
            return group;
        }
        if (!(teXObject instanceof Expandable)) {
            return teXObject;
        }
        TeXObjectList teXObjectList = ((Expandable)((Object)teXObject)).expandfully(this);
        if (teXObjectList != null) {
            if (teXObjectList.size() == 0) {
                return teXObjectList;
            }
            teXObject = (TeXObject)teXObjectList.remove(0);
            bgChar = this.isBeginGroup(teXObject);
            if (bgChar != null) {
                Group group = bgChar.createGroup(this);
                teXObjectList.popRemainingGroup(this, group, by, bgChar);
                this.push(teXObjectList, true);
                return group;
            }
            this.push(teXObjectList, true);
            return teXObject;
        }
        return teXObject;
    }

    @Override
    public TeXObject popStack(TeXParser teXParser) throws IOException {
        return this.popStack();
    }

    @Override
    public TeXObject popStack(TeXParser teXParser, byte by) throws IOException {
        return this.popStack(by);
    }

    public TeXObject popStack() throws IOException {
        return this.popStack((byte)0);
    }

    public TeXObject popStack(byte by) throws IOException {
        BgChar bgChar;
        TeXObject teXObject = null;
        boolean bl = !TeXParser.isRetainIgnoreables(by);
        boolean bl2 = TeXParser.isIgnoreLeadingSpace(by);
        boolean bl3 = false;
        if (bl && bl2) {
            while (!bl3) {
                if (this.isEmpty()) {
                    this.fetchNext();
                }
                if (this.isEmpty()) {
                    throw new EOFException();
                }
                teXObject = (TeXObject)this.remove(0);
                if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) continue;
                bl3 = true;
            }
        } else if (bl) {
            while (!bl3) {
                if (this.isEmpty()) {
                    this.fetchNext();
                }
                if (this.isEmpty()) {
                    throw new EOFException();
                }
                teXObject = (TeXObject)this.remove(0);
                if (teXObject instanceof Ignoreable) continue;
                bl3 = true;
            }
        } else if (bl2) {
            while (!bl3) {
                if (this.isEmpty()) {
                    this.fetchNext();
                }
                if (this.isEmpty()) {
                    throw new EOFException();
                }
                teXObject = (TeXObject)this.remove(0);
                if (teXObject instanceof WhiteSpace) continue;
                bl3 = true;
            }
        } else {
            if (this.isEmpty()) {
                this.fetchNext(TeXParser.isShort(by));
            }
            if (!this.fetchNext()) {
                throw new EOFException();
            }
            teXObject = (TeXObject)this.remove(0);
        }
        if ((bgChar = this.isBeginGroup(teXObject)) != null) {
            Group group = bgChar.createGroup(this);
            this.popRemainingGroup(group, by, bgChar);
            return group;
        }
        return teXObject;
    }

    @Override
    public TeXObject popToken() throws IOException {
        return this.popToken((byte)0);
    }

    @Override
    public TeXObject popToken(byte by) throws IOException {
        if (this.size() == 0) {
            this.fetchNext(TeXParser.isShort(by));
        }
        if (this.size() == 0) {
            throw new EOFException();
        }
        TeXObject teXObject = (TeXObject)this.remove(0);
        if (teXObject instanceof WhiteSpace && TeXParser.isIgnoreLeadingSpace(by)) {
            return this.popToken(by);
        }
        if (teXObject instanceof Ignoreable && !TeXParser.isRetainIgnoreables(by)) {
            this.listener.skipping((Ignoreable)teXObject);
            return this.popToken(by);
        }
        return teXObject;
    }

    public TeXObjectList popToGroup(byte by) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        while (true) {
            if (this.size() == 0) {
                this.fetchNext(TeXParser.isShort(by));
            }
            if (this.size() == 0) {
                throw new EOFException();
            }
            TeXObject teXObject = (TeXObject)this.firstElement();
            BgChar bgChar = this.isBeginGroup(teXObject);
            if (teXObject instanceof Group || bgChar != null) break;
            teXObject = (TeXObject)this.remove(0);
            if (teXObject instanceof Ignoreable && !TeXParser.isRetainIgnoreables(by)) {
                this.listener.skipping((Ignoreable)teXObject);
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public TeXObjectList popVerb() throws IOException {
        Object object;
        int n = -1;
        TeXObjectList teXObjectList = new TeXObjectList();
        while (this.size() > 0 && ((object = (TeXObject)this.firstElement()) instanceof Ignoreable || object instanceof WhiteSpace)) {
            this.remove(0);
        }
        if (this.isEmpty()) {
            n = this.read();
            this.readVerb(n, teXObjectList);
        } else {
            object = "";
            while (((String)object).isEmpty() && this.size() > 0) {
                TeXObject teXObject = (TeXObject)this.remove(0);
                object = teXObject.toString(this);
            }
            if (((String)object).isEmpty()) {
                n = this.read();
                this.readVerb(n, teXObjectList);
            } else {
                n = ((String)object).codePointAt(0);
                int n2 = Character.charCount(n);
                boolean bl = false;
                while (!bl) {
                    while (n2 < ((String)object).length()) {
                        int n3 = ((String)object).codePointAt(n2);
                        n2 += Character.charCount(n3);
                        if (n3 == n) {
                            if (n2 < ((String)object).length()) {
                                this.addAll(0, this.listener.createString(((String)object).substring(n2)));
                            }
                            bl = true;
                            continue;
                        }
                        teXObjectList.add(this.listener.getOther(n3));
                    }
                    if (!bl) {
                        if (this.size() > 0) {
                            TeXObject teXObject = (TeXObject)this.remove(0);
                            object = teXObject.toString(this);
                        } else {
                            this.readVerb(n, teXObjectList);
                            bl = true;
                        }
                    }
                    n2 = 0;
                }
            }
        }
        return teXObjectList;
    }

    public TeXNumber popNumber() throws IOException {
        return this.popNumber(this);
    }

    public TeXDimension popDimension() throws IOException {
        return this.popDimension(this);
    }

    public Numerical popNumerical() throws IOException {
        return this.popNumerical(this);
    }

    public Register popRegister() throws IOException {
        return this.popRegister(this);
    }

    @Override
    public TeXObject peekStack(byte by) throws IOException {
        int n = 0;
        if (this.size() == 0) {
            this.fetchNext();
            if (this.size() == 0) {
                return null;
            }
        }
        TeXObject teXObject = (TeXObject)this.firstElement();
        if (TeXParser.isIgnoreLeadingSpace(by)) {
            while (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) {
                if (this.size() == ++n) {
                    this.fetchNext();
                }
                if (n >= this.size()) {
                    return null;
                }
                teXObject = (TeXObject)this.get(n);
            }
        } else {
            while (teXObject instanceof Ignoreable) {
                if (this.size() == ++n) {
                    this.fetchNext();
                }
                if (n >= this.size()) {
                    return null;
                }
                teXObject = (TeXObject)this.get(n);
            }
        }
        return teXObject;
    }

    public TeXObject peekStack(int n) {
        return this.size() <= n ? null : (TeXObject)this.get(n);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public TeXReader getReader() {
        return this.reader;
    }

    public File getCurrentParentFile() {
        if (this.reader == null) {
            return null;
        }
        Object object = this.reader.getSource();
        if (object != null && object instanceof File) {
            return ((File)object).getParentFile();
        }
        return null;
    }

    public void setBaseDir(File file) {
        this.baseDir = file;
    }

    public void setBaseDir(Path path) {
        this.baseDir = path == null ? null : path.toFile();
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setReader(TeXReader teXReader) {
        this.reader = teXReader;
    }

    public TeXParserListener getListener() {
        return this.listener;
    }

    public TeXApp getTeXApp() {
        return this.listener.getTeXApp();
    }

    public File getCurrentFile() {
        if (this.reader == null) {
            return null;
        }
        Object object = this.reader.getSource();
        return object instanceof File ? (File)object : null;
    }

    public boolean isMathMode() {
        return TeXMode.isMath(this.settings.getMode());
    }

    public void putControlSequence(ControlSequence controlSequence) {
        EndDeclaration endDeclaration;
        this.settings.removeGlobalControlSequence(controlSequence.getName());
        this.settings.getRoot().putControlSequence(controlSequence);
        if (controlSequence instanceof Declaration) {
            endDeclaration = new EndDeclaration(controlSequence.getName());
            this.settings.putControlSequence(endDeclaration);
        }
        this.csTable.put(controlSequence.getName(), controlSequence);
        if (this.isDebugMode(1024)) {
            this.logMessage("Globally defining " + controlSequence);
        }
        if (controlSequence instanceof Declaration && this.isLetter(controlSequence.getName().charAt(0))) {
            endDeclaration = new EndDeclaration(controlSequence.getName());
            this.csTable.put(endDeclaration.getName(), endDeclaration);
            if (this.isDebugMode(1024)) {
                this.logMessage("Globally defining " + endDeclaration);
            }
        }
    }

    public void putControlSequence(boolean bl, ControlSequence controlSequence) {
        if (bl) {
            this.settings.putControlSequence(controlSequence);
            if (this.isDebugMode(1024)) {
                this.logMessage("Locally defining " + controlSequence);
            }
            if (controlSequence instanceof Declaration) {
                EndDeclaration endDeclaration = new EndDeclaration(controlSequence.getName());
                this.settings.putControlSequence(endDeclaration);
                if (this.isDebugMode(1024)) {
                    this.logMessage("Locally defining " + endDeclaration);
                }
            }
        } else {
            this.putControlSequence(controlSequence);
        }
    }

    public ControlSequence getControlSequence(String string) {
        ControlSequence controlSequence = this.settings.getControlSequence(string);
        if (controlSequence != null) {
            if (this.isDebugMode(1024)) {
                this.logMessage("Fetched LOCAL control sequence: " + controlSequence);
            }
            return controlSequence;
        }
        controlSequence = this.csTable.get(string);
        if (this.isDebugMode(1024)) {
            if (controlSequence == null) {
                this.logMessage("No control sequence found for: " + string);
            } else {
                this.logMessage("Fetched GLOBAL control sequence: " + controlSequence);
            }
        }
        return controlSequence;
    }

    public ControlSequence removeControlSequence(boolean bl, String string) {
        ControlSequence controlSequence;
        if (bl && (controlSequence = this.settings.removeLocalControlSequence(string)) != null) {
            return controlSequence;
        }
        return this.csTable.remove(string);
    }

    public ActiveChar removeActiveChar(int n) {
        return this.activeTable.remove(n);
    }

    public ActiveChar removeActiveChar(boolean bl, int n) {
        if (bl) {
            return this.settings.removeActiveChar(n);
        }
        return this.removeActiveChar(n);
    }

    public void putActiveChar(ActiveChar activeChar) {
        this.activeTable.put(activeChar.getCharCode(), activeChar);
    }

    public void putActiveChar(boolean bl, ActiveChar activeChar) {
        if (bl) {
            this.settings.putActiveChar(activeChar);
        } else {
            this.putActiveChar(activeChar);
        }
    }

    public ActiveChar getActiveChar(int n) {
        Integer n2 = n;
        ActiveChar activeChar = this.settings.getActiveChar(n2);
        if (activeChar != null) {
            return activeChar;
        }
        return this.activeTable.get(n2);
    }

    public void startGroup() {
        this.settings = new TeXSettings(this.settings, this);
        if (this.isDebugMode(65536)) {
            this.logMessage("START GROUP ID " + this.settings.getID());
        }
    }

    public void endGroup() throws TeXSyntaxException {
        if (this.isDebugMode(65536)) {
            this.logMessage("ENDING GROUP ID " + this.settings.getID());
        }
        if (this.settings.getParent() == null) {
            throw new TeXSyntaxException(this, "tex.error.unexpected_eg", new Object[0]);
        }
        TeXObjectList teXObjectList = this.settings.getAfterGroup();
        this.settings = this.settings.getParent();
        if (this.isDebugMode(65536)) {
            this.logMessage("RETURNING TO GROUP ID " + this.settings.getID());
        }
        if (teXObjectList != null) {
            if (this.isDebugMode(65536)) {
                this.logMessage("PUSHING AFTER GROUP CONTENT: " + teXObjectList);
            }
            this.addAll(0, teXObjectList);
        }
    }

    public TeXSettings getSettings() {
        return this.settings;
    }

    public int getSpecialChar(int n, int n2) {
        if (this.catcodes[n].size() == 0) {
            return n2;
        }
        return (Integer)this.catcodes[n].firstElement();
    }

    public int getEscChar() {
        return this.getSpecialChar(0, 92);
    }

    public int getMathChar() {
        return this.getSpecialChar(3, 36);
    }

    public String getMathDelim(boolean bl) {
        int n = this.getSpecialChar(3, 36);
        String string = new String(Character.toChars(n));
        return bl ? string : String.format("%s%s", string, string);
    }

    public int getCommentChar() {
        return this.getSpecialChar(14, 37);
    }

    public int getBgChar() {
        return this.getSpecialChar(1, 123);
    }

    public int getEgChar() {
        return this.getSpecialChar(2, 125);
    }

    public int getParamChar() {
        return this.getSpecialChar(6, 35);
    }

    public int getSpChar() {
        return this.getSpecialChar(7, 94);
    }

    public int getSbChar() {
        return this.getSpecialChar(8, 95);
    }

    public int getTabChar() {
        return this.getSpecialChar(4, 38);
    }

    public String getJobname() {
        return this.jobname;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "[reader=" + this.reader + ",buffered: ");
        for (TeXObject teXObject : this) {
            stringBuilder.append(teXObject.toString());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TeXObject teXObject : this) {
            stringBuilder.append(teXObject.toString(teXParser));
        }
        return stringBuilder.toString();
    }

    public TeXObject expandonce(TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        if (this.isDebugMode(8192)) {
            this.logMessage("Attempting to expand once: " + teXObject);
        }
        if (this.isDebugMode(4096)) {
            this.logMessage("Attempting to expand once: " + teXObject.toString(this));
        }
        if (teXObject instanceof Expandable && teXObject.canExpand()) {
            TeXObjectList teXObjectList2 = this == teXObjectList || teXObjectList == null ? ((Expandable)((Object)teXObject)).expandonce(this) : ((Expandable)((Object)teXObject)).expandonce(this, teXObjectList);
            if (teXObjectList2 != null) {
                teXObject = teXObjectList2;
                if (this.isDebugMode(8192)) {
                    this.logMessage("Expanded: " + teXObject);
                }
                if (this.isDebugMode(4096)) {
                    this.logMessage("Expanded: " + teXObject.toString(this));
                }
            } else if (this.isDebugMode(8192) || this.isDebugMode(4096)) {
                this.logMessage("Expansion failed");
            }
        } else if (this.isDebugMode(8192) || this.isDebugMode(4096)) {
            this.logMessage("Can't expand");
        }
        return teXObject;
    }

    public TeXObject expandfully(TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        if (this.isDebugMode(32)) {
            this.logMessage("Attempting to fully expand: " + teXObject);
        }
        if (this.isDebugMode(16)) {
            this.logMessage("Attempting to fully expand: " + teXObject.toString(this));
        }
        if (teXObject instanceof Expandable && teXObject.canExpand()) {
            TeXObjectList teXObjectList2 = this == teXObjectList || teXObjectList == null ? ((Expandable)((Object)teXObject)).expandfully(this) : ((Expandable)((Object)teXObject)).expandfully(this, teXObjectList);
            if (teXObjectList2 != null) {
                teXObject = teXObjectList2;
                if (this.isDebugMode(32)) {
                    this.logMessage("Expanded: " + teXObject);
                }
                if (this.isDebugMode(16)) {
                    this.logMessage("Expanded: " + teXObject.toString(this));
                }
            } else if (this.isDebugMode(32) || this.isDebugMode(16)) {
                this.logMessage("Expansion failed");
            }
        } else if (this.isDebugMode(32) || this.isDebugMode(16)) {
            this.logMessage("Can't expand");
        }
        return teXObject;
    }

    public String expandToString(TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        if (this.isDebugMode(32)) {
            this.logMessage("Expanding to string: " + teXObject);
        }
        if (teXObject == null) {
            return null;
        }
        if (this.isDebugMode(16)) {
            this.logMessage("Expanding to string: " + teXObject.toString(this));
        }
        String string = "";
        if (!teXObject.isEmpty()) {
            string = teXObject instanceof TextualContentCommand ? ((TextualContentCommand)teXObject).getText() : this.expandfully(teXObject, teXObjectList).toString(this);
        }
        if (this.isDebugMode(16) || this.isDebugMode(32)) {
            this.logMessage("String: " + string);
        }
        return string;
    }

    public void allocCount(int n, CountRegister countRegister) {
        this.allocCount((Integer)n, countRegister);
    }

    public void allocCount(Integer n, CountRegister countRegister) {
        this.countAlloc.put(n, countRegister);
        countRegister.setAllocation(n);
    }

    public void allocCount(CountRegister countRegister) {
        CountRegister countRegister2 = this.countAlloc.get(ALLOC_COUNT);
        int n = countRegister2.getValue() + 1;
        while (this.countAlloc.containsKey(n)) {
            ++n;
        }
        this.allocCount(n, countRegister);
        countRegister2.setValue(n);
        this.countAlloc.get(ALLOC_NUMBER).setValue(n);
    }

    public void allocDimen(int n, DimenRegister dimenRegister) {
        this.allocDimen((Integer)n, dimenRegister);
    }

    public void allocDimen(Integer n, DimenRegister dimenRegister) {
        this.dimenAlloc.put(n, dimenRegister);
        dimenRegister.setAllocation(n);
    }

    public void allocDimen(DimenRegister dimenRegister) {
        CountRegister countRegister = this.countAlloc.get(ALLOC_DIMEN);
        int n = countRegister.getValue() + 1;
        while (this.countAlloc.containsKey(n)) {
            ++n;
        }
        this.allocDimen(n, dimenRegister);
        countRegister.setValue(n);
        this.countAlloc.get(ALLOC_NUMBER).setValue(n);
    }

    public void allocToken(int n, TokenRegister tokenRegister) {
        this.allocToken((Integer)n, tokenRegister);
    }

    public void allocToken(Integer n, TokenRegister tokenRegister) {
        this.toksAlloc.put(n, tokenRegister);
        tokenRegister.setAllocation(n);
    }

    public void allocToken(TokenRegister tokenRegister) {
        CountRegister countRegister = this.countAlloc.get(ALLOC_TOKS);
        int n = countRegister.getValue() + 1;
        while (this.countAlloc.containsKey(n)) {
            ++n;
        }
        this.allocToken(n, tokenRegister);
        countRegister.setValue(n);
        this.countAlloc.get(ALLOC_NUMBER).setValue(n);
    }

    public TokenRegister getTokenRegister(Pattern pattern) {
        for (Integer n : this.toksAlloc.keySet()) {
            TokenRegister tokenRegister = this.toksAlloc.get(n);
            if (!pattern.matcher(tokenRegister.getName()).matches()) continue;
            return tokenRegister;
        }
        return null;
    }

    public DimenRegister getDimenRegister(String string) {
        for (Integer n : this.dimenAlloc.keySet()) {
            DimenRegister dimenRegister = this.dimenAlloc.get(n);
            if (!string.equals(dimenRegister.getName())) continue;
            return dimenRegister;
        }
        return null;
    }

    public DimenRegister getDimenRegister(Pattern pattern) {
        for (Integer n : this.dimenAlloc.keySet()) {
            DimenRegister dimenRegister = this.dimenAlloc.get(n);
            if (!pattern.matcher(dimenRegister.getName()).matches()) continue;
            return dimenRegister;
        }
        return null;
    }

    public CountRegister getCountRegister(Pattern pattern) {
        for (Integer n : this.countAlloc.keySet()) {
            CountRegister countRegister = this.countAlloc.get(n);
            if (!pattern.matcher(countRegister.getName()).matches()) continue;
            return countRegister;
        }
        return null;
    }
}

