/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.FilterUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.res.StringManager;

public final class ApplicationFilterFactory {
    private static final Log log = LogFactory.getLog(ApplicationFilterFactory.class);
    private static final StringManager sm = StringManager.getManager(ApplicationFilterFactory.class);

    private ApplicationFilterFactory() {
    }

    public static ApplicationFilterChain createFilterChain(ServletRequest servletRequest, Wrapper wrapper, Servlet servlet) {
        ApplicationFilterConfig applicationFilterConfig;
        Object object;
        if (servlet == null) {
            return null;
        }
        ApplicationFilterChain applicationFilterChain = null;
        if (servletRequest instanceof Request) {
            object = (Request)servletRequest;
            if (Globals.IS_SECURITY_ENABLED) {
                applicationFilterChain = new ApplicationFilterChain();
            } else {
                applicationFilterChain = (ApplicationFilterChain)((Request)object).getFilterChain();
                if (applicationFilterChain == null) {
                    applicationFilterChain = new ApplicationFilterChain();
                    ((Request)object).setFilterChain(applicationFilterChain);
                }
            }
        } else {
            applicationFilterChain = new ApplicationFilterChain();
        }
        applicationFilterChain.setServlet(servlet);
        applicationFilterChain.setServletSupportsAsync(wrapper.isAsyncSupported());
        object = (StandardContext)wrapper.getParent();
        FilterMap[] filterMapArray = ((StandardContext)object).findFilterMaps();
        if (filterMapArray == null || filterMapArray.length == 0) {
            return applicationFilterChain;
        }
        DispatcherType dispatcherType = (DispatcherType)servletRequest.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE");
        String string = FilterUtil.getRequestPath(servletRequest);
        String string2 = wrapper.getName();
        for (FilterMap filterMap : filterMapArray) {
            if (!ApplicationFilterFactory.matchDispatcher(filterMap, dispatcherType) || !FilterUtil.matchFiltersURL(filterMap, string)) continue;
            applicationFilterConfig = (ApplicationFilterConfig)((StandardContext)object).findFilterConfig(filterMap.getFilterName());
            if (applicationFilterConfig == null) {
                log.warn((Object)sm.getString("applicationFilterFactory.noFilterConfig", new Object[]{filterMap.getFilterName()}));
                continue;
            }
            applicationFilterChain.addFilter(applicationFilterConfig);
        }
        for (FilterMap filterMap : filterMapArray) {
            if (!ApplicationFilterFactory.matchDispatcher(filterMap, dispatcherType) || !ApplicationFilterFactory.matchFiltersServlet(filterMap, string2)) continue;
            applicationFilterConfig = (ApplicationFilterConfig)((StandardContext)object).findFilterConfig(filterMap.getFilterName());
            if (applicationFilterConfig == null) {
                log.warn((Object)sm.getString("applicationFilterFactory.noFilterConfig", new Object[]{filterMap.getFilterName()}));
                continue;
            }
            applicationFilterChain.addFilter(applicationFilterConfig);
        }
        return applicationFilterChain;
    }

    private static boolean matchFiltersServlet(FilterMap filterMap, String string) {
        String[] stringArray;
        if (string == null) {
            return false;
        }
        if (filterMap.getMatchAllServletNames()) {
            return true;
        }
        for (String string2 : stringArray = filterMap.getServletNames()) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchDispatcher(FilterMap filterMap, DispatcherType dispatcherType) {
        switch (dispatcherType) {
            case FORWARD: {
                if ((filterMap.getDispatcherMapping() & 2) == 0) break;
                return true;
            }
            case INCLUDE: {
                if ((filterMap.getDispatcherMapping() & 4) == 0) break;
                return true;
            }
            case REQUEST: {
                if ((filterMap.getDispatcherMapping() & 8) == 0) break;
                return true;
            }
            case ERROR: {
                if ((filterMap.getDispatcherMapping() & 1) == 0) break;
                return true;
            }
            case ASYNC: {
                if ((filterMap.getDispatcherMapping() & 0x10) == 0) break;
                return true;
            }
        }
        return false;
    }
}

