#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Phil Morrell
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2020 Mopi
set -o errexit

###
# Anno 1404
# send your bug reports to contact@dotslashplay.it
###

script_version=20250209.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='anno-1404'
GAME_NAME='Anno 1404'

GAME_ID_VENICE="${GAME_ID}-venice"
GAME_NAME_VENICE="$GAME_NAME - Venice"

# Archives

## Single language archives

ARCHIVE_BASE_DE_1_NAME='setup_anno_1404_2.01_v2_gog_0.1_(german)_(76234).exe'
ARCHIVE_BASE_DE_1_MD5='2fb420a6ff653cfa5c99e69f4b18c917'
ARCHIVE_BASE_DE_1_TYPE='innosetup'
ARCHIVE_BASE_DE_1_PART1_NAME='setup_anno_1404_2.01_v2_gog_0.1_(german)_(76234)-1.bin'
ARCHIVE_BASE_DE_1_PART1_MD5='edaced2fd4e8e61891afe297585c8c79'
ARCHIVE_BASE_DE_1_SIZE='4065552'
ARCHIVE_BASE_DE_1_VERSION='2.01.5010-gog76234'
ARCHIVE_BASE_DE_1_URL='https://www.gog.com/game/anno_1404_gold_edition'

ARCHIVE_BASE_EN_1_NAME='setup_anno_1404_2.01_v2_gog_0.1_(76234).exe'
ARCHIVE_BASE_EN_1_MD5='d307aae42bcc14f3358732e374f37b85'
ARCHIVE_BASE_EN_1_TYPE='innosetup'
ARCHIVE_BASE_EN_1_PART1_NAME='setup_anno_1404_2.01_v2_gog_0.1_(76234)-1.bin'
ARCHIVE_BASE_EN_1_PART1_MD5='7867cd6e09aec40e5f36637884249b0b'
ARCHIVE_BASE_EN_1_SIZE='4015390'
ARCHIVE_BASE_EN_1_VERSION='2.01.5010-gog76234'
ARCHIVE_BASE_EN_1_URL='https://www.gog.com/game/anno_1404_gold_edition'

ARCHIVE_BASE_FR_1_NAME='setup_anno_1404_2.01_v2_gog_0.1_(french)_(76234).exe'
ARCHIVE_BASE_FR_1_MD5='45fa9dd36cfb3fc4fc90de9758c16022'
ARCHIVE_BASE_FR_1_TYPE='innosetup'
ARCHIVE_BASE_FR_1_PART1_NAME='setup_anno_1404_2.01_v2_gog_0.1_(french)_(76234)-1.bin'
ARCHIVE_BASE_FR_1_PART1_MD5='d632639d4847f91a37f5d37627c23d3e'
ARCHIVE_BASE_FR_1_SIZE='3987056'
ARCHIVE_BASE_FR_1_VERSION='2.01.5010-gog76234'
ARCHIVE_BASE_FR_1_URL='https://www.gog.com/game/anno_1404_gold_edition'

ARCHIVE_BASE_EN_0_NAME='setup_anno_1404_2.01_v2_(30326).exe'
ARCHIVE_BASE_EN_0_MD5='5b92b95ddd3a60bff25afaca6531dab3'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_PART1_NAME='setup_anno_1404_2.01_v2_(30326)-1.bin'
ARCHIVE_BASE_EN_0_PART1_MD5='3bf8dd4469d43392617df7737cebad04'
ARCHIVE_BASE_EN_0_SIZE='4100000'
ARCHIVE_BASE_EN_0_VERSION='2.01.5010-gog30326'

ARCHIVE_BASE_FR_0_NAME='setup_anno_1404_2.01_v2_(french)_(30326).exe'
ARCHIVE_BASE_FR_0_MD5='24be40c2f1ce714dcc9c505ed62fcdb2'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_PART1_NAME='setup_anno_1404_2.01_v2_(french)_(30326)-1.bin'
ARCHIVE_BASE_FR_0_PART1_MD5='d2bbff77601562218b62b53901edd5e7'
ARCHIVE_BASE_FR_0_SIZE='4000000'
ARCHIVE_BASE_FR_0_VERSION='2.01.5010-gog30326'

## Multi-languages archives

ARCHIVE_BASE_MULTILANG_0_NAME='setup_anno_1404_gold_edition_2.01.5010_(13111).exe'
ARCHIVE_BASE_MULTILANG_0_MD5='b19333f57c1c15b788e29ff6751dac20'
ARCHIVE_BASE_MULTILANG_0_TYPE='innosetup'
ARCHIVE_BASE_MULTILANG_0_PART1_NAME='setup_anno_1404_gold_edition_2.01.5010_(13111)-1.bin'
ARCHIVE_BASE_MULTILANG_0_PART1_MD5='17933b44bdb2a26d8d82ffbfdc494210'
ARCHIVE_BASE_MULTILANG_0_PART2_NAME='setup_anno_1404_gold_edition_2.01.5010_(13111)-2.bin'
ARCHIVE_BASE_MULTILANG_0_PART2_MD5='2f71f5378b5f27a84a41cc481a482bd6'
ARCHIVE_BASE_MULTILANG_0_SIZE='6200000'
ARCHIVE_BASE_MULTILANG_0_VERSION='2.01.5010-gog13111'


# Archive contents

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_MULTILANG='app'

## Anno 1404 (base game)

CONTENT_GAME_BIN_FILES='
bin
tools
anno4.exe'
## This file is not fetched from the archive,
## but created later in this script.
CONTENT_GAME0_BIN_FILES='
engine.ini'
CONTENT_GAME_L10N_DE_FILES='
maindata/ger0.rda'
CONTENT_GAME_L10N_EN_FILES='
maindata/eng0.rda'
CONTENT_GAME_L10N_FR_FILES='
maindata/fra0.rda'
CONTENT_GAME_DATA_FILES='
data
maindata
resources'
CONTENT_DOC_DATA_FILES='
manual.pdf'

## Venice expansion

CONTENT_GAME_BIN_VENICE_FILES='
addon.exe'
CONTENT_GAME_L10N_DE_VENICE_FILES='
addon/ger0.rda'
CONTENT_GAME_L10N_EN_VENICE_FILES='
addon/eng0.rda'
CONTENT_GAME_L10N_FR_VENICE_FILES='
addon/fra0.rda'
CONTENT_GAME_DATA_VENICE_FILES='
addon'
CONTENT_DOC_DATA_FILES='
manual addon.pdf'


WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Ubisoft/Anno1404
users/${USER}/AppData/Roaming/Ubisoft/Anno1404Addon
users/${USER}/Documents/Anno 1404'
## Install native Direct3D 9 libraries,
## to prevent the engine from rendering only a black screen
## (WINE 10.0-rc2)
WINE_WINETRICKS_VERBS='d3dx9'

APP_MAIN_EXE='anno4.exe'

APP_VENICE_ID="$GAME_ID_VENICE"
APP_VENICE_NAME="$GAME_NAME_VENICE"
APP_VENICE_EXE='addon.exe'

# Packages

## Anno 1404 (base game)

PACKAGES_LIST_DE='
PKG_BIN
PKG_L10N_DE
PKG_DATA'
PACKAGES_LIST_EN='
PKG_BIN
PKG_L10N_EN
PKG_DATA'
PACKAGES_LIST_FR='
PKG_BIN
PKG_L10N_FR
PKG_DATA'
PACKAGES_LIST_MULTILANG='
PKG_BIN
PKG_L10N_DE
PKG_L10N_EN
PKG_L10N_FR
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_DE_ID="${PKG_L10N_BASE_ID}-de"
PKG_L10N_EN_ID="${PKG_L10N_BASE_ID}-en"
PKG_L10N_FR_ID="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
PKG_L10N_DE_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_EN_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_FR_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_DESCRIPTION='localization'
PKG_L10N_DE_DESCRIPTION="${PKG_L10N_DESCRIPTION} - German"
PKG_L10N_EN_DESCRIPTION="${PKG_L10N_DESCRIPTION} - English"
PKG_L10N_FR_DESCRIPTION="${PKG_L10N_DESCRIPTION} - French"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

## Venice expansion

PACKAGES_LIST_DE="$PACKAGES_LIST_DE
PKG_BIN_VENICE
PKG_L10N_DE_VENICE
PKG_DATA_VENICE"
PACKAGES_LIST_EN="$PACKAGES_LIST_EN
PKG_BIN_VENICE
PKG_L10N_EN_VENICE
PKG_DATA_VENICE"
PACKAGES_LIST_FR="$PACKAGES_LIST_FR
PKG_BIN_VENICE
PKG_L10N_FR_VENICE
PKG_DATA_VENICE"
PACKAGES_LIST_MULTILANG="$PACKAGES_LIST_MULTILANG
PKG_BIN_VENICE
PKG_L10N_DE_VENICE
PKG_L10N_EN_VENICE
PKG_L10N_FR_VENICE
PKG_DATA_VENICE"

PKG_BIN_VENICE_ID="$GAME_ID_VENICE"
PKG_BIN_VENICE_ARCH='32'
PKG_BIN_VENICE_DESCRIPTION="$GAME_NAME_VENICE"
PKG_BIN_VENICE_DEPENDENCIES_SIBLINGS='
PKG_BIN
PKG_L10N_VENICE_BASE
PKG_DATA_VENICE'

PKG_L10N_VENICE_BASE_ID="${GAME_ID_VENICE}-l10n"
PKG_L10N_DE_VENICE_ID="${PKG_L10N_VENICE_BASE_ID}-de"
PKG_L10N_EN_VENICE_ID="${PKG_L10N_VENICE_BASE_ID}-en"
PKG_L10N_FR_VENICE_ID="${PKG_L10N_VENICE_BASE_ID}-fr"
PKG_L10N_VENICE_PROVIDES="
$PKG_L10N_VENICE_BASE_ID"
PKG_L10N_DE_VENICE_PROVIDES="$PKG_L10N_VENICE_PROVIDES"
PKG_L10N_EN_VENICE_PROVIDES="$PKG_L10N_VENICE_PROVIDES"
PKG_L10N_FR_VENICE_PROVIDES="$PKG_L10N_VENICE_PROVIDES"
PKG_L10N_VENICE_DESCRIPTION="$GAME_NAME_VENICE - localization"
PKG_L10N_DE_VENICE_DESCRIPTION="$PKG_L10N_VENICE_DESCRIPTION - German"
PKG_L10N_EN_VENICE_DESCRIPTION="$PKG_L10N_VENICE_DESCRIPTION - English"
PKG_L10N_FR_VENICE_DESCRIPTION="$PKG_L10N_VENICE_DESCRIPTION - French"

PKG_DATA_VENICE_ID="${GAME_ID_VENICE}-data"
PKG_DATA_VENICE_DESCRIPTION="$GAME_NAME_VENICE - data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Set the rendering engine to Direct3D 9
	# cf. https://bugs.winehq.org/show_bug.cgi?id=45624
	cat > 'engine.ini' <<- EOF
	<InitFile>
	<DirectXVersion>9</DirectXVersion>
	</InitFile>
	EOF
)

# Include game data

content_inclusion_icons 'PKG_DATA' 'APP_MAIN'
content_inclusion_icons 'PKG_DATA_VENICE' 'APP_VENICE'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN' 'APP_MAIN'
launchers_generation 'PKG_BIN_VENICE' 'APP_VENICE'

# Build packages

packages_generation
case "$(current_archive)" in
	('ARCHIVE_BASE_DE_'*)
		print_instructions 'PKG_BIN' 'PKG_L10N_DE' 'PKG_DATA'
	;;
	('ARCHIVE_BASE_EN_'*)
		print_instructions 'PKG_BIN' 'PKG_L10N_EN' 'PKG_DATA'
	;;
	('ARCHIVE_BASE_FR_'*)
		print_instructions 'PKG_BIN' 'PKG_L10N_FR' 'PKG_DATA'
	;;
	('ARCHIVE_BASE_MULTILANG_'*)
		case "$(messages_language)" in
			('fr')
				lang_string='version %s :'
				lang_de='allemande'
				lang_en='anglaise'
				lang_fr='française'
			;;
			('en'|*)
				lang_string='%s version:'
				lang_de='German'
				lang_en='English'
				lang_fr='French'
			;;
		esac
		printf '\n'
		printf "$lang_string" "$lang_de"
		print_instructions 'PKG_BIN' 'PKG_L10N_DE' 'PKG_DATA'
		printf "$lang_string" "$lang_en"
		print_instructions 'PKG_BIN' 'PKG_L10N_EN' 'PKG_DATA'
		printf "$lang_string" "$lang_fr"
		print_instructions 'PKG_BIN' 'PKG_L10N_FR' 'PKG_DATA'
	;;
esac
(
	GAME_NAME="$GAME_NAME_VENICE"
	case "$(current_archive)" in
		('ARCHIVE_BASE_DE_'*)
			print_instructions 'PKG_BIN_VENICE' 'PKG_L10N_DE_VENICE' 'PKG_DATA_VENICE'
		;;
		('ARCHIVE_BASE_EN_'*)
			print_instructions 'PKG_BIN_VENICE' 'PKG_L10N_EN_VENICE' 'PKG_DATA_VENICE'
		;;
		('ARCHIVE_BASE_FR_'*)
			print_instructions 'PKG_BIN_VENICE' 'PKG_L10N_FR_VENICE' 'PKG_DATA_VENICE'
		;;
		('ARCHIVE_BASE_MULTILANG_'*)
			case "$(messages_language)" in
				('fr')
					lang_string='version %s :'
					lang_de='allemande'
					lang_en='anglaise'
					lang_fr='française'
				;;
				('en'|*)
					lang_string='%s version:'
					lang_de='German'
					lang_en='English'
					lang_fr='French'
				;;
			esac
			printf '\n'
			printf "$lang_string" "$lang_de"
			print_instructions 'PKG_BIN_VENICE' 'PKG_L10N_DE_VENICE' 'PKG_DATA_VENICE'
			printf "$lang_string" "$lang_en"
			print_instructions 'PKG_BIN_VENICE' 'PKG_L10N_EN_VENICE' 'PKG_DATA_VENICE'
			printf "$lang_string" "$lang_fr"
			print_instructions 'PKG_BIN_VENICE' 'PKG_L10N_FR_VENICE' 'PKG_DATA_VENICE'
		;;
	esac
)

# Clean up

working_directory_cleanup

exit 0
