#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2019 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Fantasy General
# send your bug reports to contact@dotslashplay.it
###

script_version=20250129.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='fantasy-general'
GAME_NAME='Fantasy General'

ARCHIVE_BASE_EN_1_NAME='fantasy_general_1_0_20211006_50653.sh'
ARCHIVE_BASE_EN_1_MD5='386197b3a09d9d004b46698c30282e5d'
ARCHIVE_BASE_EN_1_SIZE='256857'
ARCHIVE_BASE_EN_1_VERSION='1.0-gog50653'
ARCHIVE_BASE_EN_1_URL='https://www.gog.com/game/fantasy_general'

ARCHIVE_BASE_FR_1_NAME='fantasy_general_french_1_0_20211006_50653.sh'
ARCHIVE_BASE_FR_1_MD5='8cfe4a811a85aab1e73011b8e0435852'
ARCHIVE_BASE_FR_1_SIZE='237356'
ARCHIVE_BASE_FR_1_VERSION='1.0-gog50653'
ARCHIVE_BASE_FR_1_URL='https://www.gog.com/game/fantasy_general'

ARCHIVE_BASE_EN_0_NAME='gog_fantasy_general_2.0.0.8.sh'
ARCHIVE_BASE_EN_0_MD5='59b86b9115ae013d2e23a8b4b7b771fd'
ARCHIVE_BASE_EN_0_SIZE='260000'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog2.0.0.8'

ARCHIVE_BASE_FR_0_NAME='gog_fantasy_general_french_2.0.0.8.sh'
ARCHIVE_BASE_FR_0_MD5='1b188304b4cca838e6918ca6e2d9fe2b'
ARCHIVE_BASE_FR_0_SIZE='240000'
ARCHIVE_BASE_FR_0_VERSION='1.0-gog2.0.0.8'

CONTENT_PATH_DEFAULT='data/noarch/game/data'
CONTENT_PATH_DEFAULT_EN_0='data/noarch/data'
CONTENT_PATH_DEFAULT_FR_0='data/noarch/data'
CONTENT_GAME_MAIN_FILES='
dat
exe
music
saves
shp
sound
game.gog
game.ins
*.bat'
CONTENT_DOC_MAIN_FILES='
manual.pdf
*.txt'
CONTENT_DOC0_MAIN_PATH='data/noarch/docs'
CONTENT_DOC0_MAIN_FILES='
Fantasy General - Manual.pdf'

USER_PERSISTENT_DIRECTORIES='
saves'
USER_PERSISTENT_FILES='
dat/prefs.dat'

GAME_IMAGE='game.ins'

APP_MAIN_TYPE='dosbox'
APP_MAIN_EXE='exe/barena.exe'
APP_MAIN_ICON='../../support/icon.png'
APP_MAIN_ICON_EN_0='../support/icon.png'
APP_MAIN_ICON_FR_0='../support/icon.png'

PKG_MAIN_ID="$GAME_ID"
PKG_MAIN_ID_EN="${PKG_MAIN_ID}-en"
PKG_MAIN_ID_FR="${PKG_MAIN_ID}-fr"
PKG_MAIN_PROVIDES="
$PKG_MAIN_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Convert all file paths to lowercase
	tolower .
)

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

## Run the game binary from its parent directory
game_exec_line() {
	cat <<- 'EOF'
	cd exe
	barena.exe $@
	EOF
}

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
