#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2021 Mopi
set -o errexit

###
# Möbius Front '83
# send your bug reports to contact@dotslashplay.it
###

script_version=20250119.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='mobius-front-83'
GAME_NAME="Möbius Front '83"

ARCHIVE_BASE_1_NAME='m_bius_front_83_march_2023_update_63923.sh'
ARCHIVE_BASE_1_MD5='2be4eb51833c3d72b5dd7f0857e3fbf4'
ARCHIVE_BASE_1_SIZE='1700000'
ARCHIVE_BASE_1_VERSION='2023.03-gog63923'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/mobius_front_83'

ARCHIVE_BASE_0_NAME='m_bius_front_83_03_01_2021_45297.sh'
ARCHIVE_BASE_0_MD5='e66950193c5308abd7b4fe2bec610d37'
ARCHIVE_BASE_0_SIZE='1700000'
ARCHIVE_BASE_0_VERSION='2021.03.01-gog45297'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
Ionic.Zip.Reduced.dll
MoonSharp.Interpreter.dll
System.Speech.dll
Content
PackedContent
monoconfig
monomachineconfig
MobiusFront83.exe
MobiusFront83.exe.config'
CONTENT_DOC_MAIN_FILES='
LICENSE.txt'

APP_MAIN_EXE='MobiusFront83.exe'
APP_MAIN_ICON='Content/icon.png'

PKG_MAIN_DEPENDENCIES_LIBRARIES='
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libSDL2_mixer-2.0.so.0
libvorbisfile.so.3'
PKG_MAIN_DEPENDENCIES_MONO_LIBRARIES='
mscorlib.dll
I18N.dll
I18N.West.dll
Mono.Posix.dll
Mono.Security.dll
System.dll
System.ComponentModel.DataAnnotations.dll
System.Configuration.dll
System.Core.dll
System.Data.dll
System.Drawing.dll
System.Numerics.dll
System.Runtime.Serialization.dll
System.Security.dll
System.Transactions.dll
System.Web.dll
System.Web.Extensions.dll
System.Web.Http.dll
System.Web.Services.dll
System.Xml.dll
System.Xml.Linq.dll'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
