#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Prison Architect
# send your bug reports to contact@dotslashplay.it
###

script_version=20250217.4

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='prison-architect'
GAME_NAME='Prison Architect'

ARCHIVE_BASE_GOG_0_NAME='prison_architect_the_jailhouse102_11056_64622.sh'
ARCHIVE_BASE_GOG_0_MD5='3eba98e972e30c9aa27090c4590f40dd'
ARCHIVE_BASE_GOG_0_SIZE='537900'
ARCHIVE_BASE_GOG_0_VERSION='1.0-gog64622'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/prison_architect'

## This DRM-free archive is no longer available for sale from humblebundle.com.
ARCHIVE_BASE_HUMBLE_0_NAME='prisonarchitect-the_slammer_1.03-linux.tar.gz'
ARCHIVE_BASE_HUMBLE_0_MD5='33234710874924d50ccb3719ae951583'
ARCHIVE_BASE_HUMBLE_0_SIZE='456965'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0-humble2'

ARCHIVE_BASE_MULTIARCH_GOG_0_NAME='prison_architect_clink_1_02_30664.sh'
ARCHIVE_BASE_MULTIARCH_GOG_0_MD5='f261f6121e3fe9ae5023624098d3946d'
ARCHIVE_BASE_MULTIARCH_GOG_0_SIZE='390000'
ARCHIVE_BASE_MULTIARCH_GOG_0_VERSION='1.0-gog30664'

ARCHIVE_BASE_MULTIARCH_HUMBLE_0_NAME='prisonarchitect-clink_1.02-linux.tar.gz'
ARCHIVE_BASE_MULTIARCH_HUMBLE_0_MD5='ecf4cf68e10069c3c2cb99bcc52ef417'
ARCHIVE_BASE_MULTIARCH_HUMBLE_0_SIZE='390000'
ARCHIVE_BASE_MULTIARCH_HUMBLE_0_VERSION='1.0-humble1'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME='prison-architect_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='b87d9f5b95458547f54daf19a1592cea'
ARCHIVE_OPTIONAL_ICONS_URL='http://downloads.dotslashplay.it/resources/prison-architect/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
32x32
48x48
64x64'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='prisonarchitect-the_slammer_1.0-linux'
CONTENT_PATH_DEFAULT_MULTIARCH_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_MULTIARCH_HUMBLE='prisonarchitect-clink_1.0-linux'
CONTENT_LIBS_BIN_FILES='
libpops_api.so'
CONTENT_LIBS_BIN64_RELATIVE_PATH='lib64'
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_LIBS_BIN32_RELATIVE_PATH='lib'
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_GAME_BIN64_FILES='
PrisonArchitect.x86_64'
CONTENT_GAME_BIN32_FILES='
PrisonArchitect.i686'
CONTENT_GAME_DATA_FILES='
*.dat'

APP_MAIN_EXE_BIN32='PrisonArchitect.i686'
APP_MAIN_EXE_BIN64='PrisonArchitect.x86_64'
APP_MAIN_ICON_GOG='../support/icon.png'
APP_MAIN_ICON_MULTIARCH_GOG='../support/icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_DATA'
PACKAGES_LIST_MULTIARCH='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libpthread.so.0
libresolv.so.2
libSDL2-2.0.so.0
libstdc++.so.6
libuuid.so.1
libz.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

case "$(current_archive)" in
	('ARCHIVE_BASE_MULTIARCH_'*)
		launchers_generation 'PKG_BIN64'
		launchers_generation 'PKG_BIN32'
	;;
	(*)
		launchers_generation 'PKG_BIN64'
	;;
esac

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
