#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Thea 2: The Shattering
# send your bug reports to contact@dotslashplay.it
###

script_version=20250223.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='thea-2'
GAME_NAME='Thea 2: The Shattering'

ARCHIVE_BASE_1_NAME='setup_thea_2_the_shattering_2.0601.0679_(64bit)_(64998).exe'
ARCHIVE_BASE_1_MD5='c97170923a801aa0fc3579d5802c755f'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_thea_2_the_shattering_2.0601.0679_(64bit)_(64998)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='d9d75f3cc2809688bdad4b50bfc07941'
ARCHIVE_BASE_1_SIZE='6366481'
ARCHIVE_BASE_1_VERSION='2.0601.0679-gog64998'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/thea_2_the_shattering'

ARCHIVE_BASE_0_NAME='setup_thea_2_the_shattering_2.0603.0666c_(64bit)_(38776).exe'
ARCHIVE_BASE_0_MD5='bbcbc5777263f2511d53374bb5799986'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_thea_2_the_shattering_2.0603.0666c_(64bit)_(38776)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='028c57b5a383336387c1de382416d24d'
ARCHIVE_BASE_0_SIZE='6200000'
ARCHIVE_BASE_0_VERSION='2.0603.0666-gog38776'

UNITY3D_NAME='thea2'

CONTENT_PATH_DEFAULT='.'

USER_PERSISTENT_DIRECTORIES="
${UNITY3D_NAME}_data/Profiles
${UNITY3D_NAME}_data/streamingassets/DataHistory"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
