*-----------------------------------------------------------------------
*     TMSTLC : THE ROUTINE FOR DRAWING STREAM LINES
*-----------------------------------------------------------------------
*     COPYRIGHT (C) 2000-2017 GFD DENNOU CLUB. ALL RIGHTS RESERVED.
*-----------------------------------------------------------------------
      SUBROUTINE TMZTLC( X, Y, U, V, NX, NY,TRX,TRY,NM )

      IMPLICIT NONE

*-- AGREENMENT
      INTEGER  NX        !* GRID NUMBERS FOR X-DIRECTION
      INTEGER  NY        !* GRID NUMBERS FOR Y-DIRECTION
      REAL     U(NX,NY)  !* VECTOR COMPONENT OF X-DIRECTION
      REAL     V(NX,NY)  !* VECTOR COMPONENT OF Y-DIRECTION
      REAL     X(NX)     !* GRID POINTS OF X-DIRECTION [UNIT:LENGTH]
      REAL     Y(NY)     !* GRID POINTS OF Y-DIRECTION [UNIT:LENGTH]

*-- INTERNAL VARIABLES
      REAL     TRX(2,NX*NY,*)  !* STREAM LINE OF X-COORDINATE
      REAL     TRY(2,NX*NY,*)  !* STREAM LINE OF Y-COORDINATE
      INTEGER  I, J, K             !* TMP VALUES
      INTEGER  COUNTER             !* NUMBER OF STREAM LINE
      INTEGER  NM(2,*)         !* ARRAY NUMBER IN EACH STREAM LINE
      REAL     ARROW_THRES
      REAL     DXA, DYA
      REAL     ARROW_LENG
      REAL     VXMIN, VXMAX, VYMIN, VYMAX
      REAL     UXMIN, UXMAX, UYMIN, UYMAX
      REAL     VXRATIO, VYRATIO
      REAL     CIRC_FLAG
      REAL     UNDEF
      INTEGER  N, M, IBLKGE, ARRCNT
      LOGICAL  NO_SHORT, END_ARR

*-- GETTING TMPACK'S PARAMETERS
      CALL TMRGET( 'ARRWINTV', ARROW_THRES )
      CALL TMLGET( 'NODRSHRT', NO_SHORT )
      CALL TMLGET( 'ENDARROW', END_ARR )
      CALL GLRGET( 'RMISS', UNDEF )
      CALL GLLSET( 'LMISS', .TRUE. )

*-- GETTING VIEWPORT PARAMETERS
      CALL SGQVPT( VXMIN, VXMAX, VYMIN, VYMAX)
      CALL SGQWND( UXMIN, UXMAX, UYMIN, UYMAX)
      VXRATIO=(VXMAX-VXMIN)/(UXMAX-UXMIN)
      VYRATIO=(VYMAX-VYMIN)/(UYMAX-UYMIN)

      DO 71 K=1,2
         DO 70 I=1,NX*NY
            NM(K,I)=0
 70      CONTINUE
 71   CONTINUE

*-- DOING TMSTLN ROUTINE
      CALL TMSTLN( X, Y, U, V, NX, NY, TRX, TRY, NM )

*-- GETTING STREAM LINE NUMBERS
      CALL TMIGET( 'STLNNUM', COUNTER )

*-- SETTING PARAMETER FOR ARROW. (NOW, CONSTANT VALUES)
      CALL SGLSET('LPROP',.FALSE.)
      CALL SGRSET('CONST',0.01)

*-- DRAWING STREAM LINES
      DO 82 K=1,2
         DO 81 I=1,COUNTER

*-- CALCULATING THE INTERVAL LENGTH OF DRAWING ARROWS.
            ARROW_LENG=0.0
            ARRCNT=0
            IF((NM(K,I).GT.1).AND.(NM(K,I).LE.NX*NY))THEN
               DO 80 J=2,NM(K,I)
                  IF(TRX(K,J,I).NE.UNDEF.AND.TRY(K,J,I).NE.UNDEF.AND.
     &               TRX(K,J-1,I).NE.UNDEF.AND.TRY(K,J-1,I).NE.UNDEF
     &               )THEN
                     DXA=(TRX(K,J,I)-TRX(K,J-1,I))*VXRATIO
                     DYA=(TRY(K,J,I)-TRY(K,J-1,I))*VYRATIO
                     ARROW_LENG=ARROW_LENG+SQRT(DXA*DXA+DYA*DYA)
                     IF(ARROW_LENG.GE.ARROW_THRES)THEN
                        CALL SGLAU( TRX(K,J-1,I), TRY(K,J-1,I),
     &                              TRX(K,J,I), TRY(K,J,I) )
                        ARROW_LENG=0.0
                        ARRCNT=ARRCNT+1
                     END IF
                  END IF
 80            CONTINUE

*-- IF NO_SHORT IS TRUE, NO DRAWING STREAM LINE WHOSE ARROW NUMBER IS ZERO
*-- ήλȽˤ, ĤήȤߤʤ.
*-- 𱩤Ͻ.
               IF(ARRCNT.EQ.0)THEN
                  IF(NO_SHORT.EQV..TRUE.)THEN
                     IF(NM(K,I).LE.2)THEN
                        GO TO 81
                     ELSE
                        N=IBLKGE( X, NX, TRX(K,1,I) )
                        M=IBLKGE( X, NX, TRX(K,NM(K,I),I) )
                        IF(ABS(N-M).GT.1)THEN
                           GO TO 81
                        ELSE
*-- ƤΤ, ûʤΤΥå
*--  , , νƤа.
                           CIRC_FLAG=
     &                        (TRX(K,NM(K,I),I)-TRX(K,NM(K,I)-1,I))
     &                        *(TRX(K,1,I)-TRX(K,NM(K,I),I))
                           IF(CIRC_FLAG.LT.0.0)THEN  ! ñû
                              GO TO 81
                           ELSE
                              N=IBLKGE( Y, NY, TRY(K,1,I) )
                              M=IBLKGE( Y, NY, TRY(K,NM(K,I),I) )
                              IF(ABS(N-M).GT.1)THEN
                                 GO TO 81
                              ELSE
                                 CIRC_FLAG=
     &                            (TRY(K,NM(K,I),I)-TRY(K,NM(K,I)-1,I))
     &                            *(TRY(K,1,I)-TRY(K,NM(K,I),I))
                                 IF(CIRC_FLAG.LT.0.0)THEN
                                    GO TO 81
!                                 ELSE
!                                 CALL SGLAU( TRX(NM(I)-1,I), TRY(NM(I)-1,I),
!     &                                       TRX(NM(I),I), TRY(NM(I),I) )
                                 END IF
                              END IF
                           END IF
                        END IF
                     END IF
                  ELSE
                     IF(END_ARR.EQV..TRUE.)THEN
                        CALL SGLAU( TRX(K,NM(K,I)-1,I),
     &                              TRY(K,NM(K,I)-1,I),
     &                              TRX(K,NM(K,I),I),
     &                              TRY(K,NM(K,I),I) )
                     END IF
                  END IF
               END IF

               CALL UULIN( NM(K,I), TRX(K,1:NM(K,I),I),
     &                     TRY(K,1:NM(K,I),I) )

            END IF

 81      CONTINUE

 82   CONTINUE

      CALL MSGDMP( 'M', 'TMSTLC', 'DRAWING FINISHED.' )

      END SUBROUTINE TMZTLC

