/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/version.cpp
 *
 * @brief [LEVEL: beta] Implementation of @ref
 * diagnostics::diagnostics_library_version
 *
 * $Id: version.cpp,v 1.5 2005/06/23 09:54:20 esdentem Exp $
 *
 * @author Christian Schallhart
 */

#include <diagnostics/frame/version.hpp>

#ifdef HAVE_CONFIG_H
#  include <diagnostics/features.hpp>
#else
#  define DIAGNOSTICS_VERSION  "unknown"
#endif


DIAGNOSTICS_NAMESPACE_BEGIN;

char const * diagnostics_library_version(bool const svn_version)
{
    if(svn_version)
		return "$Id: version.cpp,v 1.5 2005/06/23 09:54:20 esdentem Exp $";
    else
		return DIAGNOSTICS_VERSION;
}

DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
