# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2016-10-17 20:17
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Vassal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=250, verbose_name='Name')),
                ('name', models.CharField(db_column='name', editable=False, help_text='Name of uwsgi config file', max_length=255, verbose_name='Filename')),
                ('extension', models.CharField(choices=[('.ini', 'INI file'), ('.yml', 'YAML file'), ('.xml', 'XML file'), ('.json', 'JSON file')], default=('.ini', 'INI file'), max_length=4, verbose_name='Extension')),
                ('config', models.TextField(db_column='config', help_text='Config file blob', verbose_name='Config')),
                ('ts', models.FloatField(db_column='ts', editable=False, help_text='A number representing the modification time of this row in UNIX format', verbose_name='Unix Timestamp')),
                ('uid', models.PositiveSmallIntegerField(blank=True, db_column='uid', help_text='Required in Tyrant mode (secure multi-user hosting) mode only.', null=True, verbose_name='The UID of the vassal instance')),
                ('gid', models.PositiveSmallIntegerField(blank=True, db_column='gid', help_text='Required in Tyrant mode (secure multi-user hosting) mode only.', null=True, verbose_name='The GID of the vassal instance')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated', models.DateTimeField(auto_now=True, null=True, verbose_name='Updated')),
                ('enabled', models.BooleanField(default=True, verbose_name='Enabled')),
            ],
            options={
                'verbose_name': "Emperor's Vassal",
                'verbose_name_plural': "Emperor's Vassals",
                'db_table': 'vassals',
            },
        ),
    ]
