
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQItemSelectionModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QItemSelectionModel>
#include <QAbstractItemModel>
#include <QChildEvent>
#include <QEvent>
#include <QItemSelection>
#include <QMetaMethod>
#include <QModelIndex>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QItemSelectionModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QItemSelectionModel::staticMetaObject);
}


// void QItemSelectionModel::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel *)cls)->clear ();
}


// void QItemSelectionModel::clearCurrentIndex()


static void _init_f_clearCurrentIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearCurrentIndex_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel *)cls)->clearCurrentIndex ();
}


// void QItemSelectionModel::clearSelection()


static void _init_f_clearSelection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearSelection_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel *)cls)->clearSelection ();
}


// bool QItemSelectionModel::columnIntersectsSelection(int column, const QModelIndex &parent)


static void _init_f_columnIntersectsSelection_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_columnIntersectsSelection_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->columnIntersectsSelection (arg1, arg2));
}


// QModelIndex QItemSelectionModel::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QModelIndex > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QModelIndex > ((QModelIndex)((QItemSelectionModel *)cls)->currentIndex ());
}


// bool QItemSelectionModel::hasSelection()


static void _init_f_hasSelection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasSelection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->hasSelection ());
}


// bool QItemSelectionModel::isColumnSelected(int column, const QModelIndex &parent)


static void _init_f_isColumnSelected_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isColumnSelected_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->isColumnSelected (arg1, arg2));
}


// bool QItemSelectionModel::isRowSelected(int row, const QModelIndex &parent)


static void _init_f_isRowSelected_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isRowSelected_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->isRowSelected (arg1, arg2));
}


// bool QItemSelectionModel::isSelected(const QModelIndex &index)


static void _init_f_isSelected_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isSelected_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->isSelected (arg1));
}


// const QAbstractItemModel *QItemSelectionModel::model()


static void _init_f_model_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QAbstractItemModel * > ();
}

static void _call_f_model_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QAbstractItemModel * > ((const QAbstractItemModel *)((QItemSelectionModel *)cls)->model ());
}


// QAbstractItemModel *QItemSelectionModel::model()


static void _init_f_model_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractItemModel * > ();
}

static void _call_f_model_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractItemModel * > ((QAbstractItemModel *)((QItemSelectionModel *)cls)->model ());
}


// void QItemSelectionModel::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel *)cls)->reset ();
}


// bool QItemSelectionModel::rowIntersectsSelection(int row, const QModelIndex &parent)


static void _init_f_rowIntersectsSelection_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_rowIntersectsSelection_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QItemSelectionModel *)cls)->rowIntersectsSelection (arg1, arg2));
}


// void QItemSelectionModel::select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_select_6758 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_select_6758 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg2 = gsi::arg_reader<QFlags<QItemSelectionModel::SelectionFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel *)cls)->select (arg1, arg2);
}


// void QItemSelectionModel::select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_select_7090 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_select_7090 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = gsi::arg_reader<const QItemSelection & >() (args, heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg2 = gsi::arg_reader<QFlags<QItemSelectionModel::SelectionFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel *)cls)->select (arg1, arg2);
}


// QList<QModelIndex> QItemSelectionModel::selectedColumns(int row)


static void _init_f_selectedColumns_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_f_selectedColumns_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QItemSelectionModel *)cls)->selectedColumns (arg1));
}


// QList<QModelIndex> QItemSelectionModel::selectedIndexes()


static void _init_f_selectedIndexes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_f_selectedIndexes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QItemSelectionModel *)cls)->selectedIndexes ());
}


// QList<QModelIndex> QItemSelectionModel::selectedRows(int column)


static void _init_f_selectedRows_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_f_selectedRows_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QItemSelectionModel *)cls)->selectedRows (arg1));
}


// const QItemSelection QItemSelectionModel::selection()


static void _init_f_selection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QItemSelection > ();
}

static void _call_f_selection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const QItemSelection > ((const QItemSelection)((QItemSelectionModel *)cls)->selection ());
}


// void QItemSelectionModel::setCurrentIndex(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)


static void _init_f_setCurrentIndex_6758 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_6758 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg2 = gsi::arg_reader<QFlags<QItemSelectionModel::SelectionFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel *)cls)->setCurrentIndex (arg1, arg2);
}


// void QItemSelectionModel::setModel(QAbstractItemModel *model)


static void _init_f_setModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel *)cls)->setModel (arg1);
}


// static QString QItemSelectionModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QItemSelectionModel::tr (arg1, arg2, arg3));
}


// static QString QItemSelectionModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QItemSelectionModel::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QItemSelectionModel () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QItemSelectionModel::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("clearCurrentIndex", "@brief Method void QItemSelectionModel::clearCurrentIndex()\n", false, &_init_f_clearCurrentIndex_0, &_call_f_clearCurrentIndex_0);
  methods += new qt_gsi::GenericMethod ("clearSelection", "@brief Method void QItemSelectionModel::clearSelection()\n", false, &_init_f_clearSelection_0, &_call_f_clearSelection_0);
  methods += new qt_gsi::GenericMethod ("columnIntersectsSelection", "@brief Method bool QItemSelectionModel::columnIntersectsSelection(int column, const QModelIndex &parent)\n", true, &_init_f_columnIntersectsSelection_c3054, &_call_f_columnIntersectsSelection_c3054);
  methods += new qt_gsi::GenericMethod (":currentIndex", "@brief Method QModelIndex QItemSelectionModel::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
  methods += new qt_gsi::GenericMethod (":hasSelection", "@brief Method bool QItemSelectionModel::hasSelection()\n", true, &_init_f_hasSelection_c0, &_call_f_hasSelection_c0);
  methods += new qt_gsi::GenericMethod ("isColumnSelected?", "@brief Method bool QItemSelectionModel::isColumnSelected(int column, const QModelIndex &parent)\n", true, &_init_f_isColumnSelected_c3054, &_call_f_isColumnSelected_c3054);
  methods += new qt_gsi::GenericMethod ("isRowSelected?", "@brief Method bool QItemSelectionModel::isRowSelected(int row, const QModelIndex &parent)\n", true, &_init_f_isRowSelected_c3054, &_call_f_isRowSelected_c3054);
  methods += new qt_gsi::GenericMethod ("isSelected?", "@brief Method bool QItemSelectionModel::isSelected(const QModelIndex &index)\n", true, &_init_f_isSelected_c2395, &_call_f_isSelected_c2395);
  methods += new qt_gsi::GenericMethod (":model", "@brief Method const QAbstractItemModel *QItemSelectionModel::model()\n", true, &_init_f_model_c0, &_call_f_model_c0);
  methods += new qt_gsi::GenericMethod (":model", "@brief Method QAbstractItemModel *QItemSelectionModel::model()\n", false, &_init_f_model_0, &_call_f_model_0);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Method void QItemSelectionModel::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
  methods += new qt_gsi::GenericMethod ("rowIntersectsSelection", "@brief Method bool QItemSelectionModel::rowIntersectsSelection(int row, const QModelIndex &parent)\n", true, &_init_f_rowIntersectsSelection_c3054, &_call_f_rowIntersectsSelection_c3054);
  methods += new qt_gsi::GenericMethod ("select", "@brief Method void QItemSelectionModel::select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_select_6758, &_call_f_select_6758);
  methods += new qt_gsi::GenericMethod ("select", "@brief Method void QItemSelectionModel::select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_select_7090, &_call_f_select_7090);
  methods += new qt_gsi::GenericMethod ("selectedColumns", "@brief Method QList<QModelIndex> QItemSelectionModel::selectedColumns(int row)\n", true, &_init_f_selectedColumns_c767, &_call_f_selectedColumns_c767);
  methods += new qt_gsi::GenericMethod (":selectedIndexes", "@brief Method QList<QModelIndex> QItemSelectionModel::selectedIndexes()\n", true, &_init_f_selectedIndexes_c0, &_call_f_selectedIndexes_c0);
  methods += new qt_gsi::GenericMethod ("selectedRows", "@brief Method QList<QModelIndex> QItemSelectionModel::selectedRows(int column)\n", true, &_init_f_selectedRows_c767, &_call_f_selectedRows_c767);
  methods += new qt_gsi::GenericMethod (":selection", "@brief Method const QItemSelection QItemSelectionModel::selection()\n", true, &_init_f_selection_c0, &_call_f_selection_c0);
  methods += new qt_gsi::GenericMethod ("setCurrentIndex", "@brief Method void QItemSelectionModel::setCurrentIndex(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)\n", false, &_init_f_setCurrentIndex_6758, &_call_f_setCurrentIndex_6758);
  methods += new qt_gsi::GenericMethod ("setModel|model=", "@brief Method void QItemSelectionModel::setModel(QAbstractItemModel *model)\n", false, &_init_f_setModel_2419, &_call_f_setModel_2419);
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex & > ("currentChanged(const QModelIndex &, const QModelIndex &)", "currentChanged", gsi::arg("current"), gsi::arg("previous"), "@brief Signal declaration for QItemSelectionModel::currentChanged(const QModelIndex &current, const QModelIndex &previous)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex & > ("currentColumnChanged(const QModelIndex &, const QModelIndex &)", "currentColumnChanged", gsi::arg("current"), gsi::arg("previous"), "@brief Signal declaration for QItemSelectionModel::currentColumnChanged(const QModelIndex &current, const QModelIndex &previous)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex &, const QModelIndex & > ("currentRowChanged(const QModelIndex &, const QModelIndex &)", "currentRowChanged", gsi::arg("current"), gsi::arg("previous"), "@brief Signal declaration for QItemSelectionModel::currentRowChanged(const QModelIndex &current, const QModelIndex &previous)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QItemSelectionModel::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QAbstractItemModel * > ("modelChanged(QAbstractItemModel *)", "modelChanged", gsi::arg("model"), "@brief Signal declaration for QItemSelectionModel::modelChanged(QAbstractItemModel *model)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QItemSelectionModel::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QItemSelection &, const QItemSelection & > ("selectionChanged(const QItemSelection &, const QItemSelection &)", "selectionChanged", gsi::arg("selected"), gsi::arg("deselected"), "@brief Signal declaration for QItemSelectionModel::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QItemSelectionModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QItemSelectionModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QItemSelectionModel> decl_QItemSelectionModel (qtdecl_QObject (), "QtCore", "QItemSelectionModel_Native",
  methods_QItemSelectionModel (),
  "@hide\n@alias QItemSelectionModel");

GSI_QTCORE_PUBLIC gsi::Class<QItemSelectionModel> &qtdecl_QItemSelectionModel () { return decl_QItemSelectionModel; }

}


class QItemSelectionModel_Adaptor : public QItemSelectionModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QItemSelectionModel_Adaptor();

  //  [adaptor ctor] QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model)
  QItemSelectionModel_Adaptor() : QItemSelectionModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model)
  QItemSelectionModel_Adaptor(QAbstractItemModel *model) : QItemSelectionModel(model)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model, QObject *parent)
  QItemSelectionModel_Adaptor(QAbstractItemModel *model, QObject *parent) : QItemSelectionModel(model, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QItemSelectionModel::emitSelectionChanged(const QItemSelection &newSelection, const QItemSelection &oldSelection)
  void fp_QItemSelectionModel_emitSelectionChanged_5346 (const QItemSelection &newSelection, const QItemSelection &oldSelection) {
    QItemSelectionModel::emitSelectionChanged(newSelection, oldSelection);
  }

  //  [expose] bool QItemSelectionModel::isSignalConnected(const QMetaMethod &signal)
  bool fp_QItemSelectionModel_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QItemSelectionModel::isSignalConnected(signal);
  }

  //  [expose] int QItemSelectionModel::receivers(const char *signal)
  int fp_QItemSelectionModel_receivers_c1731 (const char *signal) const {
    return QItemSelectionModel::receivers(signal);
  }

  //  [expose] QObject *QItemSelectionModel::sender()
  QObject * fp_QItemSelectionModel_sender_c0 () const {
    return QItemSelectionModel::sender();
  }

  //  [expose] int QItemSelectionModel::senderSignalIndex()
  int fp_QItemSelectionModel_senderSignalIndex_c0 () const {
    return QItemSelectionModel::senderSignalIndex();
  }

  //  [adaptor impl] void QItemSelectionModel::clear()
  void cbs_clear_0_0()
  {
    QItemSelectionModel::clear();
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QItemSelectionModel_Adaptor>(&QItemSelectionModel_Adaptor::cbs_clear_0_0);
    } else {
      QItemSelectionModel::clear();
    }
  }

  //  [adaptor impl] void QItemSelectionModel::clearCurrentIndex()
  void cbs_clearCurrentIndex_0_0()
  {
    QItemSelectionModel::clearCurrentIndex();
  }

  virtual void clearCurrentIndex()
  {
    if (cb_clearCurrentIndex_0_0.can_issue()) {
      cb_clearCurrentIndex_0_0.issue<QItemSelectionModel_Adaptor>(&QItemSelectionModel_Adaptor::cbs_clearCurrentIndex_0_0);
    } else {
      QItemSelectionModel::clearCurrentIndex();
    }
  }

  //  [emitter impl] void QItemSelectionModel::currentChanged(const QModelIndex &current, const QModelIndex &previous)
  void emitter_QItemSelectionModel_currentChanged_4682(const QModelIndex &current, const QModelIndex &previous)
  {
    emit QItemSelectionModel::currentChanged(current, previous);
  }

  //  [emitter impl] void QItemSelectionModel::currentColumnChanged(const QModelIndex &current, const QModelIndex &previous)
  void emitter_QItemSelectionModel_currentColumnChanged_4682(const QModelIndex &current, const QModelIndex &previous)
  {
    emit QItemSelectionModel::currentColumnChanged(current, previous);
  }

  //  [emitter impl] void QItemSelectionModel::currentRowChanged(const QModelIndex &current, const QModelIndex &previous)
  void emitter_QItemSelectionModel_currentRowChanged_4682(const QModelIndex &current, const QModelIndex &previous)
  {
    emit QItemSelectionModel::currentRowChanged(current, previous);
  }

  //  [emitter impl] void QItemSelectionModel::destroyed(QObject *)
  void emitter_QItemSelectionModel_destroyed_1302(QObject *arg1)
  {
    emit QItemSelectionModel::destroyed(arg1);
  }

  //  [adaptor impl] bool QItemSelectionModel::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QItemSelectionModel::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QItemSelectionModel_Adaptor, bool, QEvent *>(&QItemSelectionModel_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QItemSelectionModel::event(arg1);
    }
  }

  //  [adaptor impl] bool QItemSelectionModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QItemSelectionModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QItemSelectionModel_Adaptor, bool, QObject *, QEvent *>(&QItemSelectionModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QItemSelectionModel::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QItemSelectionModel::modelChanged(QAbstractItemModel *model)
  void emitter_QItemSelectionModel_modelChanged_2419(QAbstractItemModel *model)
  {
    emit QItemSelectionModel::modelChanged(model);
  }

  //  [emitter impl] void QItemSelectionModel::objectNameChanged(const QString &objectName)
  void emitter_QItemSelectionModel_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QItemSelectionModel::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QItemSelectionModel::reset()
  void cbs_reset_0_0()
  {
    QItemSelectionModel::reset();
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QItemSelectionModel_Adaptor>(&QItemSelectionModel_Adaptor::cbs_reset_0_0);
    } else {
      QItemSelectionModel::reset();
    }
  }

  //  [adaptor impl] void QItemSelectionModel::select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_select_6758_0(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    QItemSelectionModel::select(index, command);
  }

  virtual void select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_select_6758_0.can_issue()) {
      cb_select_6758_0.issue<QItemSelectionModel_Adaptor, const QModelIndex &, QFlags<QItemSelectionModel::SelectionFlag> >(&QItemSelectionModel_Adaptor::cbs_select_6758_0, index, command);
    } else {
      QItemSelectionModel::select(index, command);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_select_7090_0(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    QItemSelectionModel::select(selection, command);
  }

  virtual void select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_select_7090_0.can_issue()) {
      cb_select_7090_0.issue<QItemSelectionModel_Adaptor, const QItemSelection &, QFlags<QItemSelectionModel::SelectionFlag> >(&QItemSelectionModel_Adaptor::cbs_select_7090_0, selection, command);
    } else {
      QItemSelectionModel::select(selection, command);
    }
  }

  //  [emitter impl] void QItemSelectionModel::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  void emitter_QItemSelectionModel_selectionChanged_5346(const QItemSelection &selected, const QItemSelection &deselected)
  {
    emit QItemSelectionModel::selectionChanged(selected, deselected);
  }

  //  [adaptor impl] void QItemSelectionModel::setCurrentIndex(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_setCurrentIndex_6758_0(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    QItemSelectionModel::setCurrentIndex(index, command);
  }

  virtual void setCurrentIndex(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_setCurrentIndex_6758_0.can_issue()) {
      cb_setCurrentIndex_6758_0.issue<QItemSelectionModel_Adaptor, const QModelIndex &, QFlags<QItemSelectionModel::SelectionFlag> >(&QItemSelectionModel_Adaptor::cbs_setCurrentIndex_6758_0, index, command);
    } else {
      QItemSelectionModel::setCurrentIndex(index, command);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QItemSelectionModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QItemSelectionModel_Adaptor, QChildEvent *>(&QItemSelectionModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QItemSelectionModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QItemSelectionModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QItemSelectionModel_Adaptor, QEvent *>(&QItemSelectionModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QItemSelectionModel::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QItemSelectionModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QItemSelectionModel_Adaptor, const QMetaMethod &>(&QItemSelectionModel_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QItemSelectionModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QItemSelectionModel::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QItemSelectionModel::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QItemSelectionModel_Adaptor, QTimerEvent *>(&QItemSelectionModel_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QItemSelectionModel::timerEvent(arg1);
    }
  }

  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_clearCurrentIndex_0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_select_6758_0;
  gsi::Callback cb_select_7090_0;
  gsi::Callback cb_setCurrentIndex_6758_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QItemSelectionModel_Adaptor::~QItemSelectionModel_Adaptor() { }

//  Constructor QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model) (adaptor class)

static void _init_ctor_QItemSelectionModel_Adaptor_2419 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model", true, "0");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return_new<QItemSelectionModel_Adaptor> ();
}

static void _call_ctor_QItemSelectionModel_Adaptor_2419 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = args ? gsi::arg_reader<QAbstractItemModel * >() (args, heap) : gsi::arg_maker<QAbstractItemModel * >() (0, heap);
  ret.write<QItemSelectionModel_Adaptor *> (new QItemSelectionModel_Adaptor (arg1));
}


//  Constructor QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model, QObject *parent) (adaptor class)

static void _init_ctor_QItemSelectionModel_Adaptor_3613 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QItemSelectionModel_Adaptor> ();
}

static void _call_ctor_QItemSelectionModel_Adaptor_3613 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  QObject *arg2 = gsi::arg_reader<QObject * >() (args, heap);
  ret.write<QItemSelectionModel_Adaptor *> (new QItemSelectionModel_Adaptor (arg1, arg2));
}


// void QItemSelectionModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QItemSelectionModel::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_clear_0_0 = cb;
}


// void QItemSelectionModel::clearCurrentIndex()

static void _init_cbs_clearCurrentIndex_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clearCurrentIndex_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->cbs_clearCurrentIndex_0_0 ();
}

static void _set_callback_cbs_clearCurrentIndex_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_clearCurrentIndex_0_0 = cb;
}


// emitter void QItemSelectionModel::currentChanged(const QModelIndex &current, const QModelIndex &previous)

static void _init_emitter_currentChanged_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_currentChanged_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QItemSelectionModel_Adaptor *)cls)->emitter_QItemSelectionModel_currentChanged_4682 (arg1, arg2);
}


// emitter void QItemSelectionModel::currentColumnChanged(const QModelIndex &current, const QModelIndex &previous)

static void _init_emitter_currentColumnChanged_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_currentColumnChanged_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QItemSelectionModel_Adaptor *)cls)->emitter_QItemSelectionModel_currentColumnChanged_4682 (arg1, arg2);
}


// emitter void QItemSelectionModel::currentRowChanged(const QModelIndex &current, const QModelIndex &previous)

static void _init_emitter_currentRowChanged_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_currentRowChanged_4682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QItemSelectionModel_Adaptor *)cls)->emitter_QItemSelectionModel_currentRowChanged_4682 (arg1, arg2);
}


// void QItemSelectionModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QItemSelectionModel::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QItemSelectionModel_Adaptor *)cls)->emitter_QItemSelectionModel_destroyed_1302 (arg1);
}


// void QItemSelectionModel::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// exposed void QItemSelectionModel::emitSelectionChanged(const QItemSelection &newSelection, const QItemSelection &oldSelection)

static void _init_fp_emitSelectionChanged_5346 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newSelection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldSelection");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_emitSelectionChanged_5346 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = gsi::arg_reader<const QItemSelection & >() (args, heap);
  const QItemSelection &arg2 = gsi::arg_reader<const QItemSelection & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->fp_QItemSelectionModel_emitSelectionChanged_5346 (arg1, arg2);
}


// bool QItemSelectionModel::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QItemSelectionModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QItemSelectionModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QItemSelectionModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QItemSelectionModel::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QItemSelectionModel_Adaptor *)cls)->fp_QItemSelectionModel_isSignalConnected_c2394 (arg1));
}


// emitter void QItemSelectionModel::modelChanged(QAbstractItemModel *model)

static void _init_emitter_modelChanged_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_modelChanged_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  ((QItemSelectionModel_Adaptor *)cls)->emitter_QItemSelectionModel_modelChanged_2419 (arg1);
}


// emitter void QItemSelectionModel::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QItemSelectionModel_Adaptor *)cls)->emitter_QItemSelectionModel_objectNameChanged_4567 (arg1);
}


// exposed int QItemSelectionModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QItemSelectionModel_Adaptor *)cls)->fp_QItemSelectionModel_receivers_c1731 (arg1));
}


// void QItemSelectionModel::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_reset_0_0 = cb;
}


// void QItemSelectionModel::select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_select_6758_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_select_6758_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg2 = args.read<QFlags<QItemSelectionModel::SelectionFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->cbs_select_6758_0 (arg1, arg2);
}

static void _set_callback_cbs_select_6758_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_select_6758_0 = cb;
}


// void QItemSelectionModel::select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_select_7090_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_select_7090_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg2 = args.read<QFlags<QItemSelectionModel::SelectionFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->cbs_select_7090_0 (arg1, arg2);
}

static void _set_callback_cbs_select_7090_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_select_7090_0 = cb;
}


// emitter void QItemSelectionModel::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)

static void _init_emitter_selectionChanged_5346 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deselected");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_selectionChanged_5346 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = gsi::arg_reader<const QItemSelection & >() (args, heap);
  const QItemSelection &arg2 = gsi::arg_reader<const QItemSelection & >() (args, heap);
  ((QItemSelectionModel_Adaptor *)cls)->emitter_QItemSelectionModel_selectionChanged_5346 (arg1, arg2);
}


// exposed QObject *QItemSelectionModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QItemSelectionModel_Adaptor *)cls)->fp_QItemSelectionModel_sender_c0 ());
}


// exposed int QItemSelectionModel::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QItemSelectionModel_Adaptor *)cls)->fp_QItemSelectionModel_senderSignalIndex_c0 ());
}


// void QItemSelectionModel::setCurrentIndex(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_setCurrentIndex_6758_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setCurrentIndex_6758_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg2 = args.read<QFlags<QItemSelectionModel::SelectionFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->cbs_setCurrentIndex_6758_0 (arg1, arg2);
}

static void _set_callback_cbs_setCurrentIndex_6758_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_setCurrentIndex_6758_0 = cb;
}


// void QItemSelectionModel::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemSelectionModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemSelectionModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QItemSelectionModel> &qtdecl_QItemSelectionModel ();

static gsi::Methods methods_QItemSelectionModel_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model)\nThis method creates an object of class QItemSelectionModel.", &_init_ctor_QItemSelectionModel_Adaptor_2419, &_call_ctor_QItemSelectionModel_Adaptor_2419);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QItemSelectionModel::QItemSelectionModel(QAbstractItemModel *model, QObject *parent)\nThis method creates an object of class QItemSelectionModel.", &_init_ctor_QItemSelectionModel_Adaptor_3613, &_call_ctor_QItemSelectionModel_Adaptor_3613);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QItemSelectionModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QItemSelectionModel::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clearCurrentIndex", "@brief Virtual method void QItemSelectionModel::clearCurrentIndex()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clearCurrentIndex_0_0, &_call_cbs_clearCurrentIndex_0_0);
  methods += new qt_gsi::GenericMethod ("clearCurrentIndex", "@hide", false, &_init_cbs_clearCurrentIndex_0_0, &_call_cbs_clearCurrentIndex_0_0, &_set_callback_cbs_clearCurrentIndex_0_0);
  methods += new qt_gsi::GenericMethod ("emit_currentChanged", "@brief Emitter for signal void QItemSelectionModel::currentChanged(const QModelIndex &current, const QModelIndex &previous)\nCall this method to emit this signal.", false, &_init_emitter_currentChanged_4682, &_call_emitter_currentChanged_4682);
  methods += new qt_gsi::GenericMethod ("emit_currentColumnChanged", "@brief Emitter for signal void QItemSelectionModel::currentColumnChanged(const QModelIndex &current, const QModelIndex &previous)\nCall this method to emit this signal.", false, &_init_emitter_currentColumnChanged_4682, &_call_emitter_currentColumnChanged_4682);
  methods += new qt_gsi::GenericMethod ("emit_currentRowChanged", "@brief Emitter for signal void QItemSelectionModel::currentRowChanged(const QModelIndex &current, const QModelIndex &previous)\nCall this method to emit this signal.", false, &_init_emitter_currentRowChanged_4682, &_call_emitter_currentRowChanged_4682);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QItemSelectionModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QItemSelectionModel::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QItemSelectionModel::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*emitSelectionChanged", "@brief Method void QItemSelectionModel::emitSelectionChanged(const QItemSelection &newSelection, const QItemSelection &oldSelection)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_emitSelectionChanged_5346, &_call_fp_emitSelectionChanged_5346);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QItemSelectionModel::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QItemSelectionModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QItemSelectionModel::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_modelChanged", "@brief Emitter for signal void QItemSelectionModel::modelChanged(QAbstractItemModel *model)\nCall this method to emit this signal.", false, &_init_emitter_modelChanged_2419, &_call_emitter_modelChanged_2419);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QItemSelectionModel::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QItemSelectionModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QItemSelectionModel::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("select", "@brief Virtual method void QItemSelectionModel::select(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_select_6758_0, &_call_cbs_select_6758_0);
  methods += new qt_gsi::GenericMethod ("select", "@hide", false, &_init_cbs_select_6758_0, &_call_cbs_select_6758_0, &_set_callback_cbs_select_6758_0);
  methods += new qt_gsi::GenericMethod ("select", "@brief Virtual method void QItemSelectionModel::select(const QItemSelection &selection, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_select_7090_0, &_call_cbs_select_7090_0);
  methods += new qt_gsi::GenericMethod ("select", "@hide", false, &_init_cbs_select_7090_0, &_call_cbs_select_7090_0, &_set_callback_cbs_select_7090_0);
  methods += new qt_gsi::GenericMethod ("emit_selectionChanged", "@brief Emitter for signal void QItemSelectionModel::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nCall this method to emit this signal.", false, &_init_emitter_selectionChanged_5346, &_call_emitter_selectionChanged_5346);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QItemSelectionModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QItemSelectionModel::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setCurrentIndex", "@brief Virtual method void QItemSelectionModel::setCurrentIndex(const QModelIndex &index, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setCurrentIndex_6758_0, &_call_cbs_setCurrentIndex_6758_0);
  methods += new qt_gsi::GenericMethod ("setCurrentIndex", "@hide", false, &_init_cbs_setCurrentIndex_6758_0, &_call_cbs_setCurrentIndex_6758_0, &_set_callback_cbs_setCurrentIndex_6758_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QItemSelectionModel::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QItemSelectionModel_Adaptor> decl_QItemSelectionModel_Adaptor (qtdecl_QItemSelectionModel (), "QtCore", "QItemSelectionModel",
  methods_QItemSelectionModel_Adaptor (),
  "@qt\n@brief Binding of QItemSelectionModel");

}


//  Implementation of the enum wrapper class for QItemSelectionModel::SelectionFlag
namespace qt_gsi
{

static gsi::Enum<QItemSelectionModel::SelectionFlag> decl_QItemSelectionModel_SelectionFlag_Enum ("QtCore", "QItemSelectionModel_SelectionFlag",
    gsi::enum_const ("NoUpdate", QItemSelectionModel::NoUpdate, "@brief Enum constant QItemSelectionModel::NoUpdate") +
    gsi::enum_const ("Clear", QItemSelectionModel::Clear, "@brief Enum constant QItemSelectionModel::Clear") +
    gsi::enum_const ("Select", QItemSelectionModel::Select, "@brief Enum constant QItemSelectionModel::Select") +
    gsi::enum_const ("Deselect", QItemSelectionModel::Deselect, "@brief Enum constant QItemSelectionModel::Deselect") +
    gsi::enum_const ("Toggle", QItemSelectionModel::Toggle, "@brief Enum constant QItemSelectionModel::Toggle") +
    gsi::enum_const ("Current", QItemSelectionModel::Current, "@brief Enum constant QItemSelectionModel::Current") +
    gsi::enum_const ("Rows", QItemSelectionModel::Rows, "@brief Enum constant QItemSelectionModel::Rows") +
    gsi::enum_const ("Columns", QItemSelectionModel::Columns, "@brief Enum constant QItemSelectionModel::Columns") +
    gsi::enum_const ("SelectCurrent", QItemSelectionModel::SelectCurrent, "@brief Enum constant QItemSelectionModel::SelectCurrent") +
    gsi::enum_const ("ToggleCurrent", QItemSelectionModel::ToggleCurrent, "@brief Enum constant QItemSelectionModel::ToggleCurrent") +
    gsi::enum_const ("ClearAndSelect", QItemSelectionModel::ClearAndSelect, "@brief Enum constant QItemSelectionModel::ClearAndSelect"),
  "@qt\n@brief This class represents the QItemSelectionModel::SelectionFlag enum");

static gsi::QFlagsClass<QItemSelectionModel::SelectionFlag > decl_QItemSelectionModel_SelectionFlag_Enums ("QtCore", "QItemSelectionModel_QFlags_SelectionFlag",
  "@qt\n@brief This class represents the QFlags<QItemSelectionModel::SelectionFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QItemSelectionModel> inject_QItemSelectionModel_SelectionFlag_Enum_in_parent (decl_QItemSelectionModel_SelectionFlag_Enum.defs ());
static gsi::ClassExt<QItemSelectionModel> decl_QItemSelectionModel_SelectionFlag_Enum_as_child (decl_QItemSelectionModel_SelectionFlag_Enum, "SelectionFlag");
static gsi::ClassExt<QItemSelectionModel> decl_QItemSelectionModel_SelectionFlag_Enums_as_child (decl_QItemSelectionModel_SelectionFlag_Enums, "QFlags_SelectionFlag");

}

