// NOTICE.CPP

// Copyright (C) 2000 Tommi Hassinen.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#include "libghemicalconfig2.h"
#include "notice.h"

#include "local_i18n.h"

#include <cstring>
#include <sstream>
#include <cstdlib>
using namespace std;

/*################################################################################################*/

const char * get_lib_intro_notice_line(int line)
{
	ostringstream str;
	switch (line)
	{
		case 0:		str << _("libghemical-") << LIBVERSION << _(" released on ") << LIBRELEASEDATE << ends; break;
		case 1:		str << " " << ends; break;
		case 2:		str << _("For more information please visit ") << WEBSITE << ends; break;
		case 3:		str << " " << ends; break;
		
		default:	str << ends;
	}

	static char buffer[256];
	strcpy(buffer, str.str().c_str());
	
	return buffer;
};

const char * get_copyright_notice_line(int line)
{
	ostringstream str;
	switch (line)
	{
		case 0:		str << _("Copyright (C) 1998 Tommi Hassinen and others.") << ends; break;
		case 1:		str << " " << ends; break;
		case 2:		str << _("OpenBabel Copyright (C) 1998 OpenEye Scientific and others.") << ends; break;
		case 3:		str << _("OpenBabel homepage is http://openbabel.sourceforge.net/") << ends; break;
		case 4:		str << " " << ends; break;
		case 5:		str << _("MOPAC7 by James J.P. Stewart and others is in Public Domain.") << ends; break;
		case 6:		str << _("The MOPAC7 based code (libmopac7) included in this program") << ends; break;
		case 7:		str << _("is also in Public Domain.") << ends; break;
		case 8:		str << " " << ends; break;
		case 9:		str << _("MPQC Copyright (C) 1997 Limit Point Systems, Inc. and others.") << ends; break;
		case 10:	str << _("MPQC homepage is http://www.mpqc.org/") << ends; break;
		case 11:	str << " " << ends; break;
		case 12:	str << _("This program is free software; you can redistribute it and/or") << ends; break;
		case 13:	str << _("modify it under the terms of the GNU General Public License") << ends; break;
		case 14:	str << _("as published by the Free Software Foundation; either version") << ends; break;
		case 15:	str << _("2 of the License, or any later version.") << ends; break;
		case 16:	str << " " << ends; break;
		case 17:	str << _("This program is distributed in the hope that it will be useful,") << ends; break;
		case 18:	str << _("but WITHOUT ANY WARRANTY; without even the implied warranty of") << ends; break;
		case 19:	str << _("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the") << ends; break;
		case 20:	str << _("GNU General Public License for more details.") << ends; break;
		
		default:	str << ends;
	}
	
	static char buffer[256];
	strcpy(buffer, str.str().c_str());
	
	return buffer;
}

void print_lib_intro_notice(ostream & p1)
{
	for (int line = 0;line < LIB_INTRO_NOTICE_LINES;line++)
	{
		p1 << get_lib_intro_notice_line(line) << endl;
	}
}

void print_copyright_notice(ostream & p1)
{
	for (int line = 0;line < COPYRIGHT_NOTICE_LINES;line++)
	{
		p1 << get_copyright_notice_line(line) << endl;
	}
}

/*################################################################################################*/

void assertion_failed(const char * fn, int ln, const char * description)
{
	cout << _("FATAL ERROR : file ") << fn << _(" line ") << ln << _(" assertion failed : ");
	cout << (description != NULL ? description : _("<no description>")) << endl;
	cout << _("The program will now abort.") << endl;
	
	exit(EXIT_FAILURE);
}

/*################################################################################################*/

// eof
