/* ----- decode/1013xint32, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_1013xint32_checksums[] = {
  "1fbebd6317d03a06d94d96738bdeb71726b30ac841c8fb4dfbfaa5fcc73bbe9e",
  "ea9a0742c8a6d873850602d2d3cc30e7b645c79d06dd7a1948461c6a90c41029",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_1013xint32_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_1013xint32_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_1013xint32_ITEMBYTES

static void *storage_decode_1013xint32_x;
static unsigned char *test_decode_1013xint32_x;
static void *storage_decode_1013xint32_s;
static unsigned char *test_decode_1013xint32_s;
static void *storage_decode_1013xint32_x2;
static unsigned char *test_decode_1013xint32_x2;
static void *storage_decode_1013xint32_s2;
static unsigned char *test_decode_1013xint32_s2;

#define precomputed_decode_1013xint32_NUM 4

static const uint32_t precomputed_decode_1013xint32_x[precomputed_decode_1013xint32_NUM][crypto_decode_ITEMS] = {
  {3683207802,2347603561,158388801,1285801271,3782153938,3109810645,4257535385,234767729,503197654,2641183464,1361613230,1565406653,365321112,3237115988,509245037,3604445691,723259694,1357199679,1189523200,1037046178,3909856737,496549305,264813580,1766598188,3085089764,1653241277,3766059543,1713130718,3828068319,2140806324,2989798307,1738716830,215092808,1344999697,125857182,1364555036,2421728207,920198848,537472905,4238355504,737116119,4119892919,3972669685,2008323810,28593997,1776711156,3955477203,1018881011,4285492276,3877632797,3810332679,357050588,181237281,3088742314,271031553,3544421168,2825632309,1180620873,452405774,2103255292,2866537713,462648951,1601287448,1062151087,116045661,2481940510,3404986297,1951267562,1133685996,2756527209,4080859219,3530023717,2508798220,3442421455,3659300817,77382851,2041827395,308028322,3418037494,519374615,2459905548,3244021406,725225803,2579303292,3100007622,3882177155,2291878623,2817015586,1513710072,1107949483,2796883089,4042997556,2687907637,3550639726,3037100934,2267285276,1820165270,4175191281,2567240866,2552823577,3836842829,1924662423,4197047452,3033948836,2856971800,1763008928,681991858,2715093294,496674245,620091476,2069738487,1727146971,3079269457,322039565,433440646,511977476,1359801008,1343918899,4230318559,3761617992,3143443282,1729544036,4137870734,58328382,1916906673,3662957678,2373953367,2289389481,4230941915,302698469,3692051054,1498415351,3202648136,4215293018,1936016169,1210498334,550206621,3941157291,2012060352,3486002786,3579536364,3659900399,2224807493,332121838,2862206822,3543567742,2785653637,1365253855,1838532012,3771648588,2255695747,3622365093,864628972,823304149,1663632621,978996590,3027400000,1874761128,2636209610,1783129606,88865470,441722366,3762181157,1239048006,2765263714,3364722863,1284754723,3802149788,2893565246,1621140913,2877122378,2532478151,2606600408,407290391,816393269,3208652347,2033563933,2892864074,4149899373,3076705347,753368213,2384502016,3305047980,345762720,1016486480,1647427265,3501703256,3258541039,987899581,2038187766,3037048119,720142015,4037148040,429080686,1097134659,2712555914,3169238279,3692799183,2526494136,3137697904,2420921470,3797193067,2382390143,700427767,2117331025,3941174563,1446559059,1919106763,2367290685,2216586377,3946366980,33686852,1825960486,3518609319,692186056,3548553588,55910872,1073061415,2520856045,1694189272,1515809885,4143253598,1675172902,189315061,2522233786,151493771,2180688950,2761663766,3782975881,3250951460,2701119026,3105155897,334231351,1777261553,3182205685,1039206643,2306211606,1916472816,2092038430,2918224184,195152779,2620621370,4035621882,980204790,2511466716,1888891366,600423952,2579153905,1205287187,1564884444,4121273031,1265585615,457497345,2329028373,3273130469,296558932,3624271066,2739902008,1785187740,3741374019,2250065834,1959082938,2050928820,725763637,3032478068,4167593166,138099077,3693183088,3339697161,948451379,2478079195,3137509251,501322765,131392469,811192793,692712157,2674164556,167601758,1903805581,3601041073,1644174472,1470408422,501170279,2705271918,1104399449,880920445,1649131652,3365573381,3039832159,758723912,2304486236,1601632351,1304991851,4238741827,1609950348,2494955330,4268156971,384439993,1581049037,2099038618,1549899082,4059681389,585730311,406326636,3851415667,1551646414,4074449118,4202685014,988317188,3305499028,714738019,502058178,1757358191,2787370081,2478256663,995764956,3032604551,2021487073,3666466649,1225465291,3754094055,3291223666,3264631074,4040424413,3167920538,595708073,3097219098,3225451670,2904793189,1009805681,991271175,2294657878,1281858270,977983100,1622867398,3675447512,1649235808,3080322507,3373333348,4101540789,2920257718,3537384103,1757599870,1406755633,3498032542,641105744,1884024267,2748075350,1948259485,2979328043,650533144,3340235738,1824125344,1842990680,3695113894,4230835692,3493461963,3574186680,3584046065,761941867,2277166130,3833835061,2165630287,2941138029,2410166684,284075741,1908457888,4140543419,3312803370,3743200955,3106619810,2450274850,850593113,1439255401,4105202770,855364958,3460022406,4116601829,3347164730,2079400557,2393749919,1477104644,3321831259,972975751,2478666207,2516770746,3784950611,3881302852,822270046,1657534084,938261123,1888640964,1421243657,782777150,3710922011,3525405056,2774281972,3276451950,666779887,3946670729,2877526709,647971796,2608629108,24154386,4160879937,316395685,964169058,2189443987,1211874284,848638557,1606943477,4234970785,459875644,1777850566,446075274,511049072,442240423,3227768723,836626960,3242255788,2037775083,3131942402,4292018640,4001681452,138440376,1182245738,3729796520,1702999918,539923119,1840902124,80561764,3314664527,4235243965,3528823839,1549869184,1907239998,674313886,2854267227,1173135256,1742193675,2304250394,3700935196,2486136533,2125848756,274322966,2494277462,2017671954,174342820,934854012,672921174,4253182442,2354003410,2120912217,1492694134,1138608356,2732616058,2675611914,132743824,2930298498,2040778226,2413975103,348744792,3324592989,2079295191,1796267721,1674799161,1761090950,2573098401,3912010070,3255792911,1208986686,2862521920,776249239,1603834082,3250910409,1717949536,2203166485,168097428,1286186050,2934708004,221057875,285074963,502471747,797592994,688285191,1190995826,188197894,1470100122,2161294789,1102281868,3024280741,2754369187,4293429144,2368795251,1951653321,550811831,2507037762,3284974875,3098183134,1368147232,3389156917,1264562854,630229982,2784443266,2730860012,3474265997,3350508735,3769498211,4060996291,4249203660,2389246588,1839791834,492591397,3732068254,382063996,1437934192,1273785741,2246104655,2698707294,3019062137,4191501119,3032882736,3256724991,3155070193,867171051,193082669,956695144,3372426665,133487640,4050341009,2643301662,464600735,4026408287,2087485927,3818300682,160080195,1630884698,930630237,284322425,207650052,2658587092,1631675083,2197293072,3153731687,462710700,55759638,692139827,269161000,333544356,3620238058,3038025245,3406991823,3710193960,2681686795,2950637306,1873910172,1677869399,36028864,3972818262,1340684768,3218332833,3701715887,3379843311,958806254,30141402,3102136476,1590654664,3449604073,1448792376,2765233483,471432598,3847936617,1740938537,1814786309,1736659199,1490890592,1278831843,9686003,4188446508,3066427460,1773324483,522658032,2585884867,1397839630,207638341,1986349220,3026565293,1708022867,409549997,3950024400,1159520367,3232756939,4054531770,3260492262,1142959316,1363593543,1326136733,1291948417,672460489,3003734845,162310240,2907146887,2498392365,1149141831,330263121,2543784699,1453429624,994972195,1194556344,2609179091,4206684674,3438398439,3424964746,3787116872,1832026268,2977496982,1880850666,2403663622,2482797015,14152141,1093909812,3040040187,1218876170,3761600558,3308238390,2028509894,1746084342,2736005933,1343816499,3360794494,2644815314,177147617,2307210004,1630968589,3965220365,1681238579,258845337,3014260015,3963264833,1089876645,275169469,845383564,1262456749,191936671,3526257162,3666420743,4019475357,1960353777,2091722130,3060520856,629268271,3055755857,782959563,960820921,3116553731,228278655,634394397,3293734838,767138077,359272564,2698466774,180849271,95368662,2774269014,2235008889,3707248078,753469847,1268386631,3161785652,3061189034,526199470,2886770623,1145307807,3081404540,3014049140,2256672937,1248367299,88245688,3741397643,1446625837,3196276040,3220657073,3962813992,2447227860,1545103883,2376621969,298718398,1556406524,4213537727,3795679310,3355855253,1621685773,4218135429,2791839956,3561888849,666257638,583362493,2459226404,423440334,570712167,2245001373,4224270745,2549769606,1322204393,682624927,959281280,987371061,3208957322,595891309,2966152477,95805182,2259744063,1611370211,3794933149,3934589703,3523121062,2219460401,1024320719,3282867574,2686008777,2624681648,3247267326,1482384459,362017794,2996597318,2347264349,3808878695,3269398496,2783201816,1789609945,367237423,3564025494,29692267,181405972,1561242091,1914081092,1767615290,2453807868,2923935652,2200087004,3212901758,105786371,1159461731,1089978467,3712829537,3339141438,2257408520,1611850466,901241321,2994764783,1677050537,3989985073,374108229,209213480,3286038915,1076065462,1597180836,1225057876,3947502092,955870560,391294115,373345725,826560527,3689755575,4011043886,1800584929,1529896290,3515344964,1923605746,375078607,3082216337,412599778,865556582,3498761415,4214169577,2338141816,4205313122,1606096328,396623730,1201044104,4077556189,2447419459,273910585,3287975793,2451379520,3785991456,3882950439,1978078776,419929187,1908134748,2028397309,2028139748,1861764198,3713659834,1447972404,160963117,3513677920,4177553491,1290678287,3113230236,330247797,4073427329,2702092072,401642097,2951655147,523999344,3491382287,462020288,1365200980,2004234143,695638571,602913666,883784272,631909334,3931885835,1327505839,988899902,345822108,481419308,3131946039,3108388738,3382911281,898557381,2791164856,1332635967,2907529939,3345837349,1816204725,3235608015,1826945071,742703021,1806958630,4263984292,794668831,245898873,1738656777,1933630357,2542541041,275198005,2596899171,3491741647,921633828,4223647036,106662119,773831386,164555913,456211087,407713816,2351502971,1137472678,1540907859,147554015,3359735155,1338892084,1185089472,1735049723,653742243,2660325707,3056341036,1385058617,1523530869,484746333,290585933,3698114694,1375013284,710565249,535376450,1678853259,3433802895,3912935587,683309327,4209503159,2773150813,471455326,3872129605,240138560,3025651452,3203982902,221625989,4242524887,3175443477,2068932300,659077415,2436124146,947538409,3319402759,1562168783,961616074,3109759348,3900226712,1345343813,1605019654,1135704842,1493997244,910876970,2428280557,2645975652,1839856588,1449802316,3805875575,582843212,1164061435,1701716295,2987890733,1489685427,3743897722,2820288034,1916875978,1931365902,3650812564,4108960244,2193931304,4161890964,3493304644,2871157646,82283372,3487217661,910756506,790258106,2641503215,3467500719,1402088434,3065262611,577900626,1836765333,2474264166,474997880,2840258665,2640795557,1576239979,465341798,390950975,2665498427,2014441882,810656392,3630461828,1627825871,4253338589,510207744,541119797,271773166,3392229003,2818161272,2649912276,2906258873,1094650425,2910502938,371718350,1790330428,607599387,102574338,1357872716,517203474,2998630782,3242589547,3696748473,2034869565,2548294280,912004760,1123259166,86077434,4221789495,4126357485,793853075,85186390,824487624,155413849,2533919799,2696711241,3455636878,1570177211,4002153620,2279635505,3213078950,1816777055,2455811734,1954645214,3060422771,2584577294,969325005,851720272,1185666466,3169437906,3234921963,3864877494,4246715790,1835158227,1556178731,2057983089,4107048333,3079574869,1229356411,1197968690,3964619960,3215100877,995184454,869403849,2458507507,1248699713,4268916484,2025398405,4194477406,1750312754,4004349081,2186548871,2202048719,120900015,3457046132,2760252347,959146939,2117690732,3396241955,1108884107},
  {1432643529,2300825991,2898248508,3419693306,3708983887,587256126,69349686,1288714420,517920074,1519021011,3275398702,2611006201,2350449694,1058276636,3971916119,2419618251,651458163,3298770582,2195779955,816920594,1102081653,335355497,557227592,4038660023,2076967362,732723981,1951004516,3889557113,1893265240,3209968217,1374849549,1964517937,4051229032,402688493,3328571011,3729247198,3620774886,3073034449,3742350929,651990888,1151029786,3330438765,3875753213,835931468,4121862258,3071957746,4032030309,3727277971,1184801391,3513686103,2426623654,2434880803,2249383946,722693285,2471332606,511913741,3837622344,1716129454,502641582,389796015,2987845671,2304466548,2305335502,609342808,1384309983,3318908661,2301733532,703145891,3884008591,512145365,1587963112,3372879535,3559282714,3290318908,3950183551,162913148,2595991014,3640924100,3289684837,175562981,2798779452,2336709421,530959052,2711103261,1131380099,598172310,3765497736,1196025290,1735081758,2138035305,2820495125,817443353,859608090,3198233986,1911690164,16716460,2853508314,37818453,3136014338,111584796,4213268289,2711287827,627476468,1397583600,180754811,4124037954,559624035,1270960329,1038232112,427985027,3499957643,3959655784,4226436604,3673419919,4235694116,581177050,19554514,1201357913,4266957019,1646661923,1158124798,3485974881,3197080660,2014273268,2403848315,340309880,937054571,4008576117,2752414390,3916857314,1759958775,15470782,925616377,349964168,2265926817,975058713,534591980,790190886,3899322660,4247459490,3024474701,945861291,743379983,1374393188,3138326685,3703966952,2243890121,1141466518,1782034241,3835769099,1819222780,2527949165,1003357418,4162217419,2266226225,1721151398,939486063,1794104021,1150305904,481281387,3279734902,2349091962,3517261179,2867968114,1189321568,3310194474,432142972,1209054054,3530481554,1166033036,4093757205,1231632416,3236660957,1789945761,2363064437,2551325321,1590833321,2132059027,2646030598,1774218534,2796204682,129728583,2584386116,2633076664,435703208,3908647830,4219517448,1301439089,4178673606,252830520,3117837970,2396637452,4157128821,2761564894,221208148,721171432,3140216624,1380599992,460317769,596186776,1694043735,2260559946,459559552,3207624811,3783350001,1155066886,161247262,3796596625,1994366748,3619897648,1818872420,2894329289,821799999,1670185909,1026522367,3226784852,1141247869,834653731,3675284250,294049523,2444460464,813954753,445596864,667096792,2819207670,694793486,1849122342,2737441574,2556467929,2552100599,2428737462,1130865608,554481632,2146462639,3092194279,3625734707,101660996,2227458304,3303288669,1394183596,753487828,1288056119,3909358244,1990501073,1498693525,2336649821,2785939844,574199783,2386338048,289683330,1481854137,268373978,1822598684,1824633638,4012566502,1357744589,3758315991,533137837,809921320,1494303516,4198956257,2579734477,1156874056,1180896946,436139800,3761490179,2247588810,46381518,1047298549,1677095829,966586786,1748736945,2101231877,3385619098,4233647220,3234710175,2781372496,2637478514,649865573,59129060,4166480455,1373928084,2163826096,813050362,4138095386,3454085358,1212131121,2488235580,1612110468,4273616361,2350439093,1795268950,1525293582,2889734246,843710141,1043711356,462455905,39642432,944410426,2621395122,2767665700,4116768060,473048129,285606244,1707057289,1747972371,699067334,1202703396,1890609271,4062565840,1392264362,2086055302,2461805061,719558086,614565336,2231510805,412986861,3036668645,3244305560,3832464737,1139597479,2123218195,2395737711,1737020274,1535407371,2642359054,3425141212,964857077,3945987883,2154783301,2369091301,2649454789,2112602581,2002652980,1736798335,1591196681,1983688729,1488806268,17585950,448082216,4018216341,2722216260,2229166233,310330603,3414727006,2317107801,1869399147,1393154431,2950475171,2354745032,1795326943,1542721174,3069970398,20218703,3692311832,2465833851,517458672,3544096043,3369108128,1865744116,2555356077,2477617342,1180651973,1645772840,2238937241,1435018474,1774606592,1298200465,3954504301,2286025262,200075391,233242130,3605641472,2583987292,837391585,737887725,2152168710,2839420474,2184295934,1725225072,2486675769,2472790456,3348595059,1446947881,799787388,1822182580,1504948252,3052980014,1793655157,1191896004,1393182583,4089471121,3306179310,1050868548,354803034,2896998127,2753633968,3026809693,2425545967,4291137334,1691052523,1836419731,3247972715,3326192509,1082535785,2064447139,3994234404,2774162916,3859039499,2659709791,2126420380,491353137,3773035817,2205590729,4004281238,2024339820,425753846,3960298855,1417241146,247841978,1747298613,3698521423,422907527,78818900,3764403659,1749619665,4239143551,535032191,2419858701,3262903725,4253588399,262890020,1876212545,3780187964,766179887,4249098947,1096541320,816851590,2295797051,1445502145,2671300259,2805008285,1871869927,2268179126,3911556500,3419464656,1024333506,141098647,3016457387,2947290997,3328054430,509760891,2675753011,4133940856,953525974,1376487509,2617660520,3352318504,3078052464,2474085721,2020383499,3783641395,3662891579,1752838991,1201955992,1181281035,2688985570,3145070348,2632852569,4272071794,1954899366,2708208951,1072609461,3892981994,96114701,593285195,3039959216,3630185975,956901145,374540180,3804649824,3699039007,3009306616,1446890897,2949938501,3635595140,3007194275,333673730,2708321773,2801009480,2118916316,345840125,378832503,3758589759,2667063588,2001209654,337007619,3235276854,635781994,3150191352,3599074828,2645345925,981000928,3098878949,3362742294,648555476,1484321588,3778311817,2739962413,3612145738,627143888,2423597535,3886762067,804267914,3573647749,567788827,669205966,1284167975,3956947118,3898520303,2966689185,2240804685,2343249807,3711144739,3933795908,1427025808,1324096382,3088503118,2529095065,2881415429,3094743862,2866654614,202526809,3302277400,4283292772,2603121007,816586679,1436397213,2331840764,1582100787,1055769379,3796970054,563160103,3104999667,1813188715,3989854512,500504755,870099545,2192212039,4273847953,1294039182,1763155355,2224602312,19021913,3148129115,2124204124,3842162527,1346993949,1433643937,1940726998,720268863,3357120248,1676414203,4022482579,800813471,719465131,3098109332,2186711502,420654891,1795366326,3236835874,121570333,1607767207,1423272452,2024676508,1796985505,2516003497,2890899821,528068363,387796616,3262658160,4118798208,328380,427107074,1010194638,37075944,1117725589,762455913,1130568865,1336095631,2006372664,3422514581,3259302764,3810022251,3601214576,2458303682,3968219707,3720116242,2210074729,4269890940,3144538273,1192221456,571375500,517927297,1282061357,611207534,251251453,933918608,2459067181,1159262803,1354027441,3519473254,2258471600,2119025355,3285428356,4096272975,4044639197,4110398419,3475549305,1389141845,914593692,1483055197,3300196340,3147870201,1439820883,515621677,3706475664,3982370601,3407274581,3432470772,1395737323,3860787245,1363416440,1498696381,3672743808,891496969,2001939920,4081982838,3457941538,1251481941,987210760,1262576017,1432511453,3501988556,3156018084,666845964,1370243380,2718000217,1294669867,3467717564,1852062701,2863523172,1192560604,1063808464,3989268380,445014726,2088594321,4125787637,181397054,2770398212,494071864,3771808185,1793254103,1203082972,1578997481,3999034388,2790623177,3447645802,50701167,1053471540,2159892459,864619056,3856294375,2087640871,4051157913,996491910,1127949692,1814237847,2934242385,4061812867,141342564,290394215,202328453,2409660938,3472467032,2749092536,2003330922,3337583607,1358341188,402365011,1596036291,745196368,1442112107,1760605216,2005508386,662982475,3947949956,1641701705,3342763232,3285527679,1222325646,998262270,100709595,22942214,900276832,3634741337,4268292819,1979726517,2025385654,870943973,1280280107,1178645688,1240403994,3438736439,4121539097,3565811234,2439698568,2891053556,2665141939,3717881870,313674211,975176189,1126250379,135333764,3898938688,1719698087,255576456,1448836933,3926986923,2164746888,3902758453,4182617612,251846260,3996294085,3970287631,203391441,108730430,71818770,3392288095,1545655312,2251131183,4096352581,165042941,1094342729,3975373359,2519555170,2169719526,3257141980,1663504589,1809602100,2280296210,125952621,1715221365,998050047,1126147191,617699434,3528657876,2383741983,1774943058,645476413,4263117985,758507688,1087489354,2075920229,6556905,892420091,298522882,863336693,801438616,206386759,1338211325,3628672130,1903261579,1121625487,3913030843,3572456115,1395890627,3391796181,1635091279,3647848237,3484617505,620697468,601886757,1084163712,3295617842,2160995296,2089435744,736848273,1080643015,2650808625,737811816,3810646202,255060997,3206904149,2801446237,2198625904,265412020,4126264687,1115076529,2872327212,1387899040,2804756720,1798368953,1371383133,1711671470,1595135827,867469756,3264756234,1574985799,3071326931,1459363424,3609669131,1583664959,3494176508,3050114796,3083483240,2544875972,417813899,3575806928,2492059859,1878983635,3916025990,3179573106,3522656839,2610485209,1280802108,2618616706,2442064815,4055367128,2386087870,4043280710,2083045924,4087602392,989711456,2809433720,131740238,225521871,1119671248,227251108,2998790584,3407079052,280049522,3533451062,2819892185,59087798,4057012038,3235085922,4092129475,3799252069,1243203877,1395943054,213652084,3287852208,1207192906,3825041834,974803406,3334134726,2605010045,3947452624,3197213570,1490957899,1520756182,133301408,483566278,1225969467,1442102115,3601861535,2391260019,1219480328,1063742093,1010195766,1253303014,757102747,2531605374,1542585761,4098891849,965048848,167760100,1165258100,3111684910,300525720,492238044,3479865573,2372759868,2405082994,1055584999,2595452957,1064755718,720078520,3635309723,2372379629,2273659809,3401735261,2082910020,3171784574,3917134271,3820742072,2608626863,2120876480,3231520891,1294091783,1899888276,1573315711,204609799,4168530457,3599566201,1901514250,3992505334,1374193500,1587484130,3621066047,2049300651,3089276963,833853787,1600602494,2154154315,399294853,2643754732,1235631128,3372068517,603621273,748229165,2332180406,2945203337,1347469733,2231423813,1191848785,2393304228,146245199,3233021037,1386874860,497678804,4034654439,383966370,32623695,1776463932,4048131962,2618614377,384695443,2541130777,3021682657,895412180,570300311,2493410758,4143297035,3063446979,2950496344,2506695890,1792933801,766214309,3960690462,1113125225,3714718755,769965352,2421439729,3088550988,3237957972,4245420536,2649282247,2706914245,4160591993,1516382592,2481012253,1012821073,915311820,3211872688,3981117621,2713850512,770447065,3455514692,454094182,2209518075,2170817255,2585069167,1815236215,4070735673,2105797595,3478565405,2963444887,1591290928,4051599451,2740811401,4038333901,265709895,1981381296,896655973,1294024404,237310635,3898571497,3733743135,2865734601,1439052201,3285196965,1863682976,2576063241,433468877,1194489176,3539158423,964177813,415586709,2209803575,2001019887,3973110774,2690247626,2943824663,2212426291,2260451615,3632801732,1309478950,1699597208,1717579549,129227975,3492237906},
  {1585905481,3814713380,42223809,2639264575,3636649518,2987316586,1274058999,1298579448,2836782615,1390519563,1492536338,1235188023,495240223,2339028295,3850877731,3585260147,4030601484,149124635,1898281737,3567394678,3019199393,766668454,3381599098,48271524,1024596153,3167002861,2197538683,1455655168,874592589,696270483,561529933,3694078475,1776764192,77096925,2188580937,2523757220,868990597,3834443400,4291408234,3152600005,3525057394,2186260404,3421868046,1912114128,791545493,4231280352,3418594584,594437157,2173589575,3357034144,1723441490,3113758354,2322328584,2234385104,1260507730,1129803282,1210207485,4094980765,2653032605,1203720434,512062026,852219885,3640877777,312643093,224410508,470676113,1723175040,2154216973,2557814594,3704412481,2991329202,1715414791,1660955236,2765357974,4053583579,1677613721,1466818827,761341064,234987661,3407682633,1538173465,3680160918,880021284,3522114153,2512785953,1238471906,121130213,1494391244,2394426689,3596391678,3751799940,1629809751,2847750469,1286837609,2185455238,2216720230,612764650,2793802075,978270584,4239841176,2692969683,1536387320,2554030342,4016595440,3026755394,2078308023,419508198,2743374384,275411099,1530833245,2750957440,3795323694,50903409,3187709939,3952743484,605840152,3493491595,3667039418,1412721742,3882985696,2232697097,2975768835,3646926111,3306211492,1091092456,784354316,2402895933,2447437470,795728700,2880073346,1764584917,2749927874,2357508866,401140490,2299748482,1014871541,646712406,1096664153,4188697835,1101996995,72425403,3561822575,1434651514,1475189627,2754138108,3538648592,1310178395,3393193456,360576842,2060000158,2393158257,162962557,2220279063,613492847,296185726,3424329077,1161666565,1791528075,2779946334,836478989,1424408706,2067875682,2384566356,445988271,1064385255,3236299662,656906310,3400163428,2818430608,2568140552,3442550037,2920142998,1439763144,448414981,3622251720,57107715,3537834660,144192534,2454214250,2232368133,1463288284,1570845169,2687932438,2647055839,2252186002,1548794895,3268201719,401506511,3196418054,1503499302,4078810603,149069892,784075106,3961995268,1979607171,3337045596,3066184892,3311095897,4085424869,1790149370,1060686216,3818939450,2028385922,254477097,2141378117,3841501416,3486106143,2796541382,1613969284,1385517569,4289811233,294504054,2005267867,1683832394,4112717383,3306321297,2386358165,4031378288,1334782720,2356088789,1230280012,201263383,3793618057,107897897,2125273269,1654618474,574986876,1259138218,724122544,30789716,76365600,1254882417,3567547582,99897931,1561207989,594213333,602635175,4050435016,2939232320,2505472636,3863151461,2707986887,568123123,187572432,806048357,3653578962,2154218745,2048862214,2881464194,4006524628,368230061,2266834932,1974126336,200853363,1555644837,522142300,1335434930,301410839,4124130001,2117435325,4146551897,2443323978,428646590,3864745404,2724737667,2596718945,1955182479,1849453349,3826188381,1925244654,444707180,2199522291,4219138878,2382609783,1048752916,1131631420,3999131080,1389885653,3395840816,3640530514,1082753702,2030449640,33729731,3565617302,1423044054,1780331317,3053842758,585207011,2789168260,2365944877,3003393054,425043021,419544832,1172749268,501383651,1233642780,3961071626,1822192966,2357559391,1161406155,514907367,38003953,1345244902,839841343,1939661909,2495690281,2725719903,3293121472,1462482707,4077486034,3088136072,4127712847,1729261727,3223065619,3387930866,12111127,2445187609,544550317,2999785290,1796114548,2305494266,1410789909,40314854,48041558,3376071010,1422891115,2710366669,3902090292,2752116747,2884808816,3772495908,2310145096,3608211761,2975485889,828932493,1905096924,109758346,927367656,1436175043,1610426443,2031085762,852766359,1304223416,630375358,770893123,485670464,2012391262,850710979,4066873171,869982446,586577031,3726409928,743492968,2612541411,2010536542,1895304384,3422845560,2488274373,3639611689,999975599,1849100719,399476212,1820793632,181678781,1635191658,895509729,1670258238,4199683537,1939379285,1574461545,1681711123,2269207088,3571490373,616090400,1548720633,1395655126,3509513678,2919968941,4126326793,1259469911,347805534,4089401097,1227683753,1756592497,1879696716,4209739101,587316712,3435846829,3653288831,3677626672,4195748540,968598932,443531974,1324732056,4165400744,1005453871,945693171,2149457768,494535133,154888972,2228965569,460199831,440135820,345668502,21848478,1686956937,4098021825,86657903,1840489641,1129991134,382105117,3857572803,3972454071,4008017248,1182509924,2260914460,743271691,3706718768,964147793,3075785800,2435725629,2126059286,1296346937,4139422045,980306196,646479520,3721145641,783861443,3856942427,2615447836,2237210801,876365696,2674069323,2254675994,1237493037,2492644677,669410540,1335638418,3708010650,2458383351,688557695,2373493291,948717191,3333565136,2888364966,1103222149,37331407,2347920757,133164744,1322774794,3427758805,2445925758,2818953857,4115045321,2478316274,2531788120,2697208604,2080057254,3431488920,3187778857,2906133332,559834039,1073210020,834750413,2605104033,181665998,3005453566,4002113319,360698365,502389692,2722061116,1346587704,3769192819,3843236796,2762061720,1522775095,1438732169,4227800603,896241984,3155366706,3571780748,778589156,4222932565,3445321753,2934969819,3797944675,1511896413,3729640108,163962016,2346210776,1213151310,4058038083,2071755451,573264894,3814385575,2064494069,2085817344,1108522534,3461149167,1251867693,1244898925,530787081,1953199091,3857211819,1486720304,2150941770,1513177544,4143222321,2172504563,449551073,277311804,620758920,2566830636,2580023947,1281022208,680983239,141476498,3607539010,75821614,4220775128,388157491,936963708,3869431806,532019500,3697545479,4138858598,3137409531,2406138914,569574908,2402899039,4281951656,676247262,648634933,3122736700,3650679991,2733025505,1254069437,1456466040,3240653355,152741504,3787095921,209676543,3431960327,3800179285,3406581810,1761763086,1761815631,2579363899,2005673927,1933154648,4002230719,1616590159,2913244493,3186918379,1493541325,68230371,1143924054,316163948,3343915729,3087481700,684150072,2231981840,1647109681,2846340719,3096278488,407377410,3048161594,1737686957,4132080154,802498592,999111388,2878647827,1744663823,21819601,1691983666,2490912645,3022155154,3608305223,2235796032,673380379,1156646643,2728260675,863839941,1614365567,115004437,891106823,1547680045,2412571635,3110591774,2518396904,3287735677,2866823720,503878166,3278881933,1022229826,4129515300,252429459,3481368194,3152249677,1163108575,3621974914,266850740,3161420664,2708109210,2694560361,3270401188,3576890402,3809355169,3960811655,2909001427,28675493,3575466768,3100181200,2184484688,4137561312,3886089834,1853714183,2784781233,2295569742,585348870,2494360063,4208880068,602466948,3636718056,955447677,3345878427,4243299698,3443296740,62223556,204312061,4292440538,660806988,4128349582,796400781,2629367493,1302844523,412272327,2682796157,1526984260,2380949429,3694064678,3890759864,426669230,1066324324,175768705,95488651,1655417883,311477076,440998548,2342128972,2031862354,1672505939,107324783,2494396143,1329536323,3615302736,2817037708,2793845953,1926124746,1677692810,3848566594,3210403543,1603964759,695081481,1281640213,4203551889,574416199,163780132,444139711,347383527,3744794840,1871580992,1991024286,3196193953,1297749126,1075535196,2228129529,4125704690,3261095560,3133920637,3332329067,2851449028,534103208,4163448893,2098382652,3454756777,210728179,3483818996,3624231601,105409721,1236681984,1466726363,1157462015,3088916846,3094798644,2907937745,2378077656,3985216975,67353640,2289355121,2612439638,235491282,2890242119,2716347910,3668585139,2654119566,3537318480,4085283272,288997641,3896098242,2428444978,1240156737,219137897,751775767,3318484984,3692376736,1854146082,514208736,3138211192,2033574641,3293104078,3974995649,2708927840,2805974154,195304079,73494206,2393340205,776858646,959088224,2048995920,1978635864,2511326984,2918607014,2482353460,3941444091,1966370665,3661374563,838065858,1972853365,3681936970,4075018738,2174821546,3349245650,3627213398,2543433398,3282822305,892016211,2551660041,3041335960,771239629,2319254264,3627675869,1247329384,4254877166,2695702273,1032404407,2581024437,4026645095,1227423371,2128614254,1916202338,2193151623,3034044414,2022977307,2615187876,4117688119,2918003412,806160444,3497288206,635941427,2294339240,1737682843,3357923805,718331217,2399513102,2053428809,1606315974,2515698643,1602876020,1670662961,591988618,3294127964,2166503963,2648305165,2473257241,2304720840,1987890429,2280237564,997827492,4080760905,38740109,72576398,969883909,1603422042,195896963,83947419,1221413256,4294403598,3841470480,21712300,2134575539,1299260765,204357231,1373436325,1528702974,3385776593,1193944761,1934857034,4218303581,3194297584,578585530,447890946,981134794,729498602,1449357280,726051664,2678569933,2102027766,1642334530,274067209,2823375206,1580429719,134539648,683921904,903611332,3461100557,3499508499,2631225768,1063612096,1108369816,2702280377,472320440,3695300595,2766371234,3901034275,2540851892,2272915185,2573214949,2676858164,1396873612,3590312391,129483877,601832031,1629289989,722789610,1006323561,1135766732,3165958947,2811288210,457157053,873945555,1669876768,1757314126,529261130,2255882420,721293136,2547109481,2311081933,3292129996,10346659,966273403,2729321144,2200971180,3744019751,3756130710,3880989167,1959131716,2969504262,2067248155,3552073697,3843755547,557307918,3744928767,297645049,2016574619,4215155814,4083846119,3651553577,2576723169,651291061,2608614691,1408719415,1331494640,327901238,984208545,3720289819,713694234,1636442568,2346782578,1537168781,221267147,3918280446,1769974266,2584753475,2113890085,382279641,3732982796,926333162,3641786049,2089469758,1588766473,1546184242,402075196,1714820449,1414164814,3894662008,1300085101,3836771002,2803928393,3735668121,2238397290,3781531778,3103911293,209625264,1645203991,3374776838,3042932011,2882156770,3635106483,1644700862,2268275736,514732316,2988157432,2115127233,2552519396,1541300613,2879059172,2145594087,2160522689,2758607944,660855529,4282181065,1302330155,3460060634,1975885334,2321605434,3841110175,795065762,2403730561,3394253398,1998122913,1980749565,32100643,1259447967,2413205579,3683506041,2410758305,3979293991,3311019078,2568109126,2514718310,2028101843,60569389,2261094166,4063587819,2126268268,3525471424,916879618,2028961902,166306568,2122872786,15399743,1424970761,3007991624,3584439467,608147596,3974945661,1122615577,3325960329,3689568564,3322917340,3610383478,1215768993,3779505440,2744259293,2148732096,2265345378,2340846864,4180796913,2457120484,1628029934,980868081,2174044456,4081042475,1586404079,487729679,3055501254,190117575,2900316223,1978436271,1012582655,1313571951,3093321945,3267843745,485137692,3899432827,1672019519,1874484883,127489178,3746156388,3389917781,2765229216,840287702,4257005746,2383411241,3683637025,3641459453,288570242,4144214199,1372867291,622604020,2991945077,1674965042},
  {84940587,1743056002,1714035564,3742561236,253894427,756319949,1182287383,801179326,2867701346,58739408,469355830,694903749,2458549361,271391639,1523033221,1941284831,4214317188,2811075442,1048727631,340290267,2938917908,3907681806,2722010815,281614329,3724071389,2860558197,264960981,2626258306,2680065695,1331783491,981575872,2750167601,130665608,3259143990,3378620200,2398788603,1522238514,2084157098,2276619673,2850194195,1884180814,2388461031,949092780,1734701777,1721824735,1308214014,2686044375,2129131792,4127747069,1725152858,495445410,1004093999,2827057297,1740182094,3038234261,4254225197,3694551204,164547194,3971486226,940145192,3512050201,3761538577,1963744565,1706862866,3200334152,3124659762,3041648606,607709090,1405608692,1493304771,180740043,3812647597,1438738563,2798446416,3932597599,721066395,3546856548,3224696834,333727294,2141895372,316992711,2476582933,2042588261,2432002503,1755794490,2939919017,616557521,1474668306,919495026,795085678,853204660,901646232,150960176,1608525986,2049694128,3089632232,3285448711,393363755,2563668689,4022417279,3950438680,1007256149,1752060138,3361304323,1444697156,3568436982,1499999793,1325956911,2442396853,4186731853,62471118,2820160933,3948907064,3959560463,3891009173,3413323019,3566698345,2337102335,1196408421,3510114589,267804802,4008641858,4079782370,2714240341,3913905056,2002030193,2924152470,596307300,3576000063,2288557065,1873514489,2691699357,1617880167,4225714217,1056139098,273224406,4165553767,253381179,2039496417,1618325178,517493225,336049494,1256261104,3742755160,673924255,1078529609,1630067479,3101761666,659438744,162102822,2001721216,3302256416,3175762143,3686984151,2622299696,926371454,928592862,3540135711,2187149718,3958072120,1210577411,1957420153,3544571998,3545923792,3633624526,520741786,1044469626,3839662078,551814721,952996649,1029240013,2831882181,4081058135,2810670727,814928035,208846429,2962285348,2933605085,569222472,4032301377,1778138149,2108397396,3914174666,1509502479,2937769140,2181560065,1168773351,3149497461,1374578814,3294449568,3421747753,2554481352,2748421879,2618185512,186937453,3479789059,1238157286,3771864012,1563166248,1249150279,3358283914,520113981,348882980,765260656,3746712962,550073153,2750338908,2716882872,2407696273,1993479417,2010096620,1346121982,909422626,1001284471,3971784703,3720872466,4041722929,389744602,49540910,3034298494,521755529,1805724558,2509543374,3214194014,2122833621,1559351623,4000009052,784773379,1231536837,2970357109,390430478,25032201,1168261372,3912313852,1401858662,2851427066,2948557959,2507757935,476300715,1964149387,502266665,2710971136,4209376562,711668731,112104455,208243742,1068724162,3648677292,1466576180,2521179975,3349352437,1145334939,2919414640,97889749,3603783473,610099043,2762266581,2718688730,2553550067,1836432526,81133053,1627233204,2513527571,236671954,2602268353,2382657803,4147040849,1693245331,1915637342,168230931,3131564836,3964482527,3786618138,771387697,4109279290,2258692400,3114899319,315784199,429490053,4293885449,3484474194,4237711220,2122636739,1654440458,2209643118,1171145087,3194768515,91450032,4174839736,3000359415,3182545810,3840187712,1070910898,323450573,3422174583,507003980,3623359029,270099291,3441191802,2314009708,3362000704,3114084091,628286023,3435192976,3481866301,657967619,1307870342,2503648922,2942361875,3055609765,4024416442,2051772386,2943136387,2280348148,4079895505,2129614373,883824969,1594993648,4055346477,543981638,2325308262,170555749,3671276393,3585369019,2339910486,1446183539,1479520999,2961045756,3581960932,3791201490,2726309814,2445430258,4268029751,1285792525,2782972048,4173311618,3344263754,403169384,3331640143,2258352610,2868954534,1217038683,3943880375,81378554,3078108814,3501973708,3459982121,2793476350,2437374564,1153843269,627499807,1711750388,878361882,2424852969,2063397281,616430771,1960845954,1975396671,1083672861,2746514031,2726859801,2241935834,1019226152,833271499,2611717272,2689818809,155501762,3199958989,1399963053,1825337559,2313605402,3389214337,3361341642,167354717,3550458358,3187009567,3311634995,3110341804,2334708583,4121665977,1510562998,392606078,2766782202,2790807208,362956073,2233476957,1133019705,2981550185,2146954547,2627722666,1353577862,2637829069,957820791,1126751182,3080362506,3809473168,1218499797,787787713,1606538879,1914836898,1192702130,1355167694,4168533879,844140018,2898381740,2132860380,931711031,3875886626,1997879438,1688146901,288457466,2848692783,1859521174,1802988550,3452325891,2100843124,4292112979,3943729661,2381155540,3728252999,2524044304,3319673312,2777754198,3676035831,1823213760,2521612986,1590258061,1520583186,939568897,485478310,2150932025,4169961026,1466276661,21538370,3509943241,2796795830,2769988101,1265618499,675407406,451098208,3002761089,3051733180,3934999192,2698605893,3920785156,1206594549,1559035837,187059977,1572256844,1808429610,1905623120,42137027,2571603881,2979191784,3325284367,594562659,1007305669,212046623,2056151669,753178044,824616076,1674034093,555027341,31066237,2819740752,2388400870,4123118292,4119873258,1724564678,2142829442,747945709,343310482,2032422711,4149824231,2681638583,3474094119,3774782067,4244048885,3711216073,3802756830,1329449195,4022467115,3788922564,2263999791,3283944023,4015541158,1851038549,1835708641,3844601565,313439301,1354237894,2679114417,2886883477,1231220201,1865553025,441503479,942039137,350483556,435670284,1922776892,2947184635,3227224180,4218745384,581657342,4266526553,1624422062,1167634690,3027817503,3148254096,3987846360,2425659934,1311195818,1640219189,639679323,4247969330,2965844096,2500881227,4195831413,1382188369,3527679656,4083923084,2220107653,525868133,1416269342,2144053946,3111609327,754492223,2890354043,2444522978,1555082920,1795707598,2343070047,1901099204,211656060,355189676,3199289099,265383958,1553889541,180326465,4115557249,3293558832,1303414579,1712593891,1144524831,3455993807,2457839794,2417804605,3682081721,3006593631,2491971685,3593656930,3374526984,413615125,1178301956,3752904996,2269596141,2757477772,402074081,3366107575,3771516128,1995504783,3030739544,1603436571,1677458437,3726087761,136693151,3679440400,3244872459,2040134863,3012487923,1583780804,2643314515,500842201,4127874964,978678818,1882124684,1182637721,3904221948,806299632,186830287,600108355,720147559,4284577377,2398512293,1983965031,2599523042,2624616069,372385077,281978695,234699098,1646804209,2154708068,2320005034,2068933092,3431191276,3108206279,3597302321,1315566055,2422341142,3412951593,258232691,4043082517,4235355790,84391174,3751169951,3624800981,2723125083,3615448691,2720047203,3515658561,3370962788,2039582345,2596818194,1353185899,2575838825,2359636183,3435837203,3125197470,3209721037,2794853518,927014343,3381913013,1384046914,405116148,3037862123,1218377569,2583318754,4274649937,2991925424,3096804299,2243531025,501397022,785704286,3836479828,935392363,1086389481,1870117776,2111233601,2467544137,2612027963,2578011530,771305988,4171373213,1049586840,3834478350,3569203940,766521504,3248908430,3563493585,2396205804,3854834723,4080070474,346557891,1086357248,323560192,1139826752,482968351,451316833,2028708072,3456464816,886393236,1925529304,3466918072,3056533384,1099626342,2164269857,1090612105,3412683008,303339110,3766025658,2830722105,1024972868,2010366848,70504119,2242388562,705142073,4021209099,3673941921,3833716675,4134792218,3865282258,2963189837,1674446466,2793320925,1573707715,242139265,3602735569,3750219111,858215973,2061726804,3913531845,3091871028,22438811,3585463936,2462941705,1318283750,860326223,4207231832,3910274004,4183899427,3056790696,2887891361,216379398,1297232219,3013086942,3132423670,609695634,2179776452,3505082607,4171229514,206653034,607461807,3679330991,1384407598,1680034148,1224703838,990130746,3919176358,4276930248,2722758306,3422956529,274315873,3772028278,360376357,2777806809,4023842095,2358428883,3697941905,3667308621,1918881882,3343985055,576808164,613445610,2248692242,2066012617,166800743,4179628277,4226153413,1771549052,2754301214,3326157290,3644057615,872213682,2156025126,810872150,2024455112,680421731,1032938652,1137393763,2837971500,1604219432,3026693777,707837735,3486231661,2558527593,1626545304,462187035,1530461153,2548274685,3863003462,87356188,3783581047,1049065115,606170761,29080594,631795860,734792164,3392149695,2130613330,1044808790,3715630415,45534310,1030939104,426207454,2380855301,877021592,4202311139,2181218397,1002550934,2171545806,4243522108,2163655997,4146589549,2716537182,3769351184,1003800437,1898155199,2326163378,501121912,146774151,2861982381,541171881,2783374996,1962520873,3253504561,432373625,3136765559,1146544708,1297226348,420217555,632044027,3425853737,1516809026,2299551944,3091586062,2026083021,2098840435,2815692259,3391997496,3315017061,11620429,3602151070,879047178,3825530903,2487732025,395030861,966863622,896004673,246308757,719356007,3546483579,4262955139,2421177290,3561399244,3808740694,3647948725,869967629,3656354840,1036060583,2210315568,1533576979,3904559037,19153124,1465267236,1927464257,2487524493,2217903391,2748103134,1726485587,3471130513,2668136778,36079918,3036028386,1598228561,649108897,3998138738,319716528,1185693710,2812497516,4196472812,3791144109,3584755661,3201551602,4129601996,605823627,3372249844,890537252,1262234577,710512297,1318236205,3473445236,1108797163,4290651809,2759871094,1504926738,2588401689,975322197,685946918,1347541306,1052472613,1769650802,659696826,2578469910,2485733846,162506862,3824197084,102576543,1193285075,2255250235,2375252588,537736302,3704023405,1910984065,3423154395,3357044390,1462919572,3722217983,2858501089,3231600642,1649459451,3500251595,1911717458,1915873149,3068224398,695852834,3548539651,2634156808,3958366774,3384687279,2200184080,2992450597,532540800,1849618812,3278241270,3522274356,3226153549,1661076016,4289404462,1158825600,156868445,2085338143,1462242222,2662271725,3676069026,217498880,1948392313,1048426156,1680620698,265273965,2671070106,629062588,300514990,3719502543,3358510600,800358782,1832166695,4181081021,402302275,495287173,2376122986,1555017040,1633882515,95411817,1667702964,1910285419,1632403629,2287818243,3630394080,1387926771,2663632573,3870776129,2595251677,392678420,2210126511,4079199701,870109275,1875401108,544509420,527841475,76288606,4179934835,3558425263,2831142557,2741082410,3922317285,134646871,993397053,659747167,1473960942,128311428,1428622975,916926704,3701264118,4019295417,4268207515,2062521595,1565409476,883232103,3581643044,1190390993,503998696,3392528607,2539044185,363093104,1407218391,1775877010,230193239,3387879861,3746343713,1482595949,631321090,1479193820,1309110408,3264473652,2521404065,1507698953,2338670235,3868408198,2999158714,1697897315,2804018326,1970539412,2832040383,327125578,134252466,4086456046,2964017573,2059619969,1937050509,2543904950,1998357256,2049347085,1224317484,653951829,1031094397,448150525,1001918240,1478094778,2856708514,3960013812,2824330936,3338936638,1446718968},
} ;

static const unsigned char precomputed_decode_1013xint32_s[precomputed_decode_1013xint32_NUM][crypto_decode_STRBYTES] = {
  {122,74,137,219,105,150,237,139,65,210,112,9,55,197,163,76,210,22,111,225,213,241,91,185,153,213,196,253,113,69,254,13,214,47,254,29,232,66,109,157,174,145,40,81,189,53,78,93,152,91,198,21,84,120,242,192,109,118,90,30,251,121,215,214,46,17,28,43,63,57,229,80,0,175,230,70,162,17,208,61,225,173,11,233,185,189,152,29,12,188,200,15,44,38,76,105,228,187,226,183,189,117,138,98,23,130,121,224,222,76,28,102,223,175,43,228,180,28,154,127,163,179,52,178,158,182,162,103,72,14,210,12,17,17,43,80,158,109,128,7,28,117,85,81,207,163,88,144,192,30,217,54,137,47,9,32,48,44,160,252,215,127,239,43,183,147,144,245,245,32,202,236,226,150,180,119,77,79,180,1,244,117,230,105,211,202,195,235,243,227,186,60,52,108,111,255,29,251,31,231,7,16,29,227,220,40,72,21,33,118,205,10,170,119,26,184,1,157,39,16,48,147,67,211,53,186,107,168,73,216,94,70,14,42,247,26,252,32,93,125,241,228,219,170,119,118,147,27,24,181,113,95,175,35,79,63,93,183,234,6,30,104,239,147,185,247,243,202,234,250,77,116,236,172,146,67,105,68,77,164,83,248,60,243,37,227,103,210,12,57,137,149,207,46,47,205,209,127,28,218,195,196,156,4,67,208,179,121,162,35,92,18,246,28,187,203,23,7,245,30,12,46,159,146,158,214,91,193,75,17,58,43,124,11,189,153,198,92,198,184,131,82,101,231,223,74,155,136,34,63,232,167,248,97,57,90,171,247,9,66,145,12,181,166,52,63,251,240,53,55,54,160,110,118,162,211,134,123,6,181,28,7,36,135,150,132,125,108,241,92,220,248,162,252,4,153,25,255,40,152,77,147,177,228,151,4,184,114,156,220,41,250,164,98,214,180,24,238,73,170,160,97,21,105,178,94,166,40,46,9,213,161,197,165,154,29,84,216,245,36,247,179,93,123,219,43,242,102,81,236,137,183,13,239,49,19,134,199,213,25,4,40,132,30,176,234,12,81,51,147,26,80,223,137,37,252,72,188,53,224,82,35,93,187,100,191,22,103,142,229,162,246,62,5,122,3,177,172,65,114,110,76,84,218,87,167,127,141,169,79,117,136,219,12,47,252,229,207,10,18,110,58,16,220,247,0,80,89,72,136,228,190,90,68,64,251,41,67,101,115,30,189,38,72,157,124,203,32,171,73,233,234,192,154,237,119,98,46,200,207,236,99,91,213,239,165,37,218,69,222,155,132,238,198,203,19,102,207,153,170,126,141,54,211,133,179,9,166,223,30,96,81,172,197,149,109,76,202,206,224,131,47,115,134,165,231,232,215,236,48,137,51,213,159,18,49,237,4,41,99,110,77,90,58,64,117,114,180,168,149,190,111,202,93,33,157,6,102,72,106,190,250,75,5,254,37,84,26,37,84,62,224,70,95,218,73,98,147,210,164,175,152,141,200,35,205,147,76,156,51,160,226,62,77,120,172,177,165,160,96,74,103,125,171,199,140,242,150,216,144,93,155,23,194,70,24,53,44,169,48,59,38,64,191,29,185,53,121,74,154,109,172,109,112,90,247,67,204,98,183,149,124,231,44,0,157,32,142,172,7,255,196,160,235,155,20,80,90,150,60,193,190,49,98,88,192,183,208,239,99,57,194,189,38,226,58,246,70,124,121,55,173,5,181,191,126,236,42,136,253,161,240,110,64,147,25,67,242,100,65,138,81,174,161,7,189,230,188,207,164,27,220,184,61,151,150,112,120,5,187,126,84,76,144,107,145,84,226,127,99,0,142,247,173,191,41,81,232,51,126,35,141,233,234,83,189,56,86,203,62,99,114,61,253,25,141,137,108,30,132,4,200,56,235,68,5,2,2,38,242,213,108,167,183,185,209,200,235,65,41,116,161,130,211,216,33,85,3,39,158,245,63,237,53,65,150,216,70,251,100,93,108,89,90,94,8,245,246,38,28,217,99,245,183,72,11,186,59,86,150,139,156,7,9,54,172,250,129,22,165,155,164,137,161,123,225,36,149,197,193,50,206,255,160,57,235,20,185,55,247,235,19,241,219,238,105,245,154,172,189,243,8,241,61,22,255,117,137,240,13,59,114,30,249,177,124,56,145,240,173,139,203,161,11,58,130,51,156,250,179,138,240,246,188,108,58,220,240,177,149,230,49,150,112,16,190,201,35,241,195,186,153,19,57,215,71,220,61,70,93,199,162,165,245,207,77,111,75,1,219,68,27,21,39,210,138,229,1,24,195,84,33,173,17,218,252,5,216,56,150,79,163,156,205,103,106,67,214,0,223,170,71,29,134,186,59,197,116,180,176,62,122,53,70,66,43,116,241,191,180,206,108,104,248,133,57,59,8,112,128,33,220,9,188,15,199,51,56,136,56,219,124,180,147,131,151,2,187,13,148,225,29,213,227,212,7,217,209,89,48,221,242,73,41,76,131,100,159,94,102,253,9,141,196,121,113,177,134,163,214,136,28,0,98,230,166,164,87,103,64,223,29,110,44,63,161,89,204,211,65,125,199,129,52,132,192,75,98,5,147,154,200,95,40,48,181,72,53,57,45,92,171,91,137,95,248,118,95,107,152,200,77,67,17,166,252,140,228,245,95,66,255,181,148,43,232,102,254,185,22,234,22,205,228,60,94,154,201,28,125,74,149,97,92,109,210,249,241,7,137,233,34,108,13,56,24,115,240,143,229,206,62,124,92,222,40,219,242,86,226,127,250,4,134,232,58,148,233,5,197,99,9,154,42,194,204,236,29,111,40,191,104,97,228,35,166,23,50,183,147,220,42,90,59,135,223,193,180,225,113,125,120,89,215,137,218,203,29,11,73,231,237,194,223,114,22,44,196,34,81,150,194,221,251,211,240,154,161,210,188,169,200,129,35,26,208,155,184,150,124,64,192,101,160,35,173,113,105,48,60,7,153,21,59,86,179,197,136,222,154,103,76,124,214,74,58,198,253,186,96,216,224,18,219,96,87,77,98,203,253,153,183,100,251,16,201,181,139,120,244,182,152,15,174,167,50,216,210,126,216,194,104,49,99,217,83,158,189,127,208,80,127,54,38,203,237,75,112,86,77,204,163,157,20,32,116,43,240,148,177,24,89,198,38,218,243,23,199,160,241,185,108,88,206,217,109,166,246,62,220,236,109,45,252,203,255,57,208,184,194,9,213,241,51,160,213,107,79,106,45,50,204,186,135,53,174,131,228,79,229,20,129,109,52,78,175,156,57,168,143,221,166,238,16,160,193,192,113,187,173,203,246,42,94,117,197,187,182,28,223,162,65,43,185,34,58,12,146,89,5,179,50,105,75,201,85,82,108,176,244,94,213,251,50,134,192,59,206,229,91,94,245,58,174,129,199,109,34,241,123,159,185,173,142,4,212,10,88,91,31,255,197,135,110,254,57,223,113,189,147,186,223,2,150,83,195,153,225,68,251,87,231,94,216,2,49,132,246,203,98,131,186,236,55,196,95,146,112,9,117,182,84,62,59,168,46,27,45,48,221,128,105,33,210,244,46,92,165,110,176,74,195,239,64,190,39,137,106,61,235,181,146,131,171,212,67,159,38,116,133,124,155,18,145,112,1,65,253,1,248,165,208,219,18,98,13,120,57,147,67,128,130,236,187,59,72,93,50,149,50,245,2,200,95,161,134,108,252,60,37,105,27,198,216,247,105,138,145,150,26,112,253,117,30,167,13,92,26,147,215,99,192,16,234,221,49,172,229,64,193,235,250,117,121,2,166,173,186,208,1,211,255,44,208,132,238,184,110,64,8,106,163,119,70,168,45,80,222,110,183,129,101,175,146,46,32,236,239,185,109,100,70,205,4,79,196,145,197,189,177,112,252,31,148,85,210,128,32,97,92,62,44,174,113,158,54,49,40,91,169,32,170,152,159,236,69,11,196,215,103,26,18,88,137,28,202,151,220,213,110,47,148,180,224,181,126,22,214,89,16,86,167,171,148,18,59,67,120,164,66,100,10,124,189,184,55,86,246,27,40,234,105,130,253,210,61,79,140,89,141,106,126,118,180,248,88,228,200,221,67,122,105,224,162,10,153,122,159,144,130,233,7,130,206,168,174,242,205,163,121,63,86,226,143,88,108,201,20,93,67,41,198,215,134,239,123,201,222,16,107,57,104,211,99,134,29,248,104,161,93,94,153,86,137,44,233,15,117,15,194,62,172,15,72,64,158,158,170,151,159,68,46,226,144,152,95,201,244,196,193,96,212,101,102,21,167,81,131,148,246,4,10,66,164,169,76,36,23,236,174,83,19,45,13,19,230,253,16,67,28,243,29,162,77,138,47,7,102,6,41,114,39,253,70,6,172,55,11,154,242,159,87,197,189,210,128,140,124,179,65,165,220,66,180,163,86,44,164,152,135,232,255,115,242,48,141,201,221,83,116,183,184,212,32,66,92,110,149,27,189,204,195,222,133,170,184,32,69,140,81,53,110,2,202,166,178,95,75,222,139,144,37,130,59,247,165,236,157,197,162,141,23,21,207,191,180,180,199,99,250,173,224,195,226,13,242,204,179,69,253,124,2,105,142,218,254,168,109,37,89,92,29,158,215,114,222,124,213,197,22,112,34,181,85,141,109,236,75,79,214,224,133,94,1,219,160,121,59,243,179,63,59,213,249,48,30,198,180,255,173,29,194,241,140,14,188,235,250,175,51,45,53,130,11,104,2,6,57,169,37,3,201,24,220,244,7,145,76,107,241,30,149,141,157,159,62,177,27,95,29,254,239,231,129,108,124,10,165,150,227,67,161,138,9,90,83,53,97,93,74,120,55,121,106,242,16,4,125,96,12,212,209,118,158,203,98,65,97,16,8,248,130,103,32,250,187,172,103,148,27,22,211,82,3,51,55,65,41,40,18,11,16,164,123,225,19,234,114,200,215,29,150,20,181,207,145,18,203,40,17,37,221,11,75,215,159,250,38,223,175,156,153,177,111,87,65,2,100,192,193,37,2,86,101,204,236,224,57,233,79,161,220,211,191,175,179,163,220,239,80,116,201,238,56,38,57,218,235,203,1,156,216,230,184,200,118,207,94,233,199,156,205,56,209,90,86,75,29,210,164,150,125,25,28,105,218,90,229,41,157,196,103,5,113,43,108,255,80,131,103,96,47,221,88,227,108,57,76,243,203,147,0,44,159,166,249,68,248,197,182,195,200,178,105,240,32,39,31,195,120,33,154,14,87,81,83,69,79,96,12,164,72,101,118,173,184,101,180,83,92,206,101,173,60,105,24,208,150,112,235,111,224,28,69,203,244,175,192,186,62,171,241,230,41,87,194,212,44,32,68,71,201,70,81,157,61,11,79,129,145,1,77,201,238,20,40,61,91,9,179,96,168,172,9,135,138,71,173,45,113,234,148,71,131,126,68,81,106,175,19,251,18,159,151,120,147,161,86,35,18,78,59,184,123,51,71,211,233,132,155,2,234,188,250,231,203,241,204,138,208,36,204,72,209,186,225,156,128,50,109,150,255,120,177,234,128,27,112,6,255,68,143,215,121,252,147,205,241,215,0,52,189,51,65,251,84,51,181,10,147,166,72,46,120,53,224,54,182,47,197,198,154,232,120,246,33,19,104,45,35,20,163,51,3,25,80,126,167,81,200,210,173,164,157,225,14,143,10,20,59,133,137,13,155,54,97,13,118,88,236,51,170,53,100,153,170,109,15,47,245,169,179,65,159,58,236,165,50,246,64,189,192,102,16,140,135,99,50,173,143,63,75,159,184,112,11,10,106,46,210,7,36,137,218,157,83,148,239,241,159,216,116,146,37,173,124,152,215,107,182,47,223,129,37,81,34,35,182,203,3,171,46,185,246,68,57,3,214,194,185,127,65,155,13,29,23,208,37,182,103,82,196,29,153,185,45,116,16,106,21,214,85,215,160,119,138,199,10,214,53,175,5,86,252,91,165,121,135,55,133,206,29,248,220,151,9,233,44,71,11,154,75,52,5,117,188,170,9,118,182,174,42,93,31,191,159,16,172,159,2,68,68,124,128,170,183,116,189,166,179,169,24,130,134,195,146,104,74,184,133,66,5,139,50,1,223,45,194,57,86,72,77,131,190,177,83,247,191,40,190,51,236,212,187,221,145,11,106,24,92,145,95,168,141,190,20,206,17,252,224,196,92,191,123,37,251,78,120,61,226,149,73,6,200,13,246,168,96,133,163,107,251,212,24,104,166,81,28,78,212,230,72,182,39,189,103,197,34,36,209,148,146,206,47,61,25,103,96,4,34,157,0,208,133,153,65,201,251,134,101,250,151,233,60,207,78,159,7,176,40,128,120,45,57,53,22,218,58,138,205,68,191,109,148,132,35,29,229,203,176,254,222,181,5,63,245,176,134,227,142,11,96,157,21,50,226,7,19,133,234,166,143,254,209,49,71,74,132,207,228,13,61,118,149,172,195,201,61,25,160,176,118,113,156,254,93,141,193,75,100,91,88,2,244,147,21,70,114,156,178,93,105,232,139,103,224,6,227,224,15,223,194,24,74,228,165,217,71,171,106,47,153,227,21,150,182,110,212,107,17,197,1,20,9,208,10,235,169,14,93,68,143,22,114,58,171,91,105,252,34,66,146,164,183,71,174,220,169,34,131,126,253,128,191,3,44,78,6,99,251,27,69,99,192,247,64,97,72,77,221,62,65,7,199,8,82,141,134,226,226,18,96,233,217,183,53,239,123,128,178,169,194,245,99,49,87,210,237,69,112,76,22,40,88,120,12,131,249,220,195,182,116,35,64,164,11,51,95,84,230,4,73,12,26,74,235,96,109,249,56,163,172,82,23,189,205,64,22,15,80,68,49,183,51,237,219,46,172,19,239,225,190,82,107,98,93,48,91,68,232,135,209,242,228,167,114,207,62,91,22,145,227,182,183,226,197,151,24,102,88,151,51,199,220,138,208,233,31,47,251,120,54,93,139,98,252,167,250,200,21,187,95,114,255,163,23,136,122,150,71,221,145,10,243,67,168,224,145,57,139,83,16,113,135,250,195,64,21,29,146,32,165,169,225,39,31,113,231,56,22,231,117,99,156,7,25,92,211,187,113,253,226,230,120,228,244,226,120,102,68,248,110,186,243,89,221,52,78,78,86,45,26,152,9,96,120,110,209,83,104,0,249,15,48,238,76,156,31,144,185,117,46,175,19,129,145,203,242,40,167,14,161,113,146,240,23,235,174,238,175,112,152,59,31,15,68,26,208,192,222,137,27,84,80,95,81,159,47,118,119,43,154,118,41,130,187,239,35,80,122,173,52,214,43,170,37,11,209,91,234,175,33,32,79,62,106,241,58,156,211,156,20,44,224,177,28,55,180,173,186,130,63,70,185,49,33,163,201,197,229,142,53,184,203,93,166,63,105,110,79,211,98,77,173,37,109,109,199,181,21,65,108,207,117,219,192,47,248,228,108,173,191,68,44,38,0,180,107,164,60,39,254,31,175,93,47,121,30,168,14,9,204,161,103,149,219,64,115,241,24,140,151,53,48,103,16,99,137,201,154,207,191,31,208,36,4,239,54,60,189,191,251,231,136,91,6,218,186,31,46,137,236,206,9,143,58,49,27,24,56,77,24,123,22,41,140,166,116,204,67,83,99,216,91,223,126,203,8,115,125,65,200,52,223,205,79,192,7,163,70,251,193,106,103,163,80,247,38,75,89,145,158,44,16,44,182,57,81,142,82,117,60,207,90,93,164,228,28,77,253,81,17,134,192,108,220,164,9,245,81,129,93,90,42,66,50,233,31,139,68,17,100,143,172,171,204,163,168,58,233,15,121,186,40,183,235,231,250,93,236,74,165,94,214,25,28,69,2,204,230,64,57,80,14,252,198,87,180,54,230,248,190,133,190,53,13,215,202,223,252,21,108,69,189,204,102,81,123,39,185,72,39,242,77,52,145,233,73,122,56,7,17,218,197,207,205,28,93,202,24,81,57,116,41,91,185,152,188,120,232,69,81,48,80,6,168,170,95,10,123,177,67,188,150,12,89,42,225,74,54,237,158,188,144,100,98,182,157,204,251,169,109,76,58,106,86,119,13,217,226,76,123,189,34,251,42,98,69,71,33,110,101,45,152,23,178,179,203,202,88,122,88,39,223,34,46,26,168,202,52,65,114,14,78,30,115,148,250,154,217,244,193,233,244,40,188,196,130,148,106,17,248,68,153,55,208,142,99,34,171,108,139,231,4,253,183,218,207,154,10,73,54,186,97,26,47,239,35,114,157,175,220,173,206,242,43,146,83,19,50,180,182,82,16,114,34,149,208,122,109,102,70,122,147,120,228,79,28,105,232,74,169,165,87,103,157,107,131,243,93,102,141,188,27,63,112,77,23,59,71,224,158,154,241,17,120,136,162,81,48,132,115,100,216,207,166,6,97,221,203,132,253,0,39,105,30,53,213,64,32,238,237,50,16,139,78,49,202,120,186,249,167,212,115,242,157,185,253,57,173,57,10,63,65,26,192,122,173,206,248,39,22,60,70,182,106,27,59,55,36,2,41,29,6,76,126,239,80,18,230,211,30,126,121,187,178,107,253,69,193,185,231,87,220,61,165,73,121,136,226,227,151,152,22,92,54,30,147,243,66,250,111,33,5,55,101,163,251,237,55,243,245,147,60,81,47,86,215,19,5,200,174,36,49,89,109,67,9,55,140,8,151,73,140,188,160,142,213,248,205,187,0,151,93,148,4,140,238,49,122,224,135,166,177,131,191,95,209,73,108,150,182,96,146,222,132,129,116,115,88,106,182,14,133,13,154,205,185,198,57,80,56,196,50,162,213,171,70,210,200,233,188,235,253,208,192,182,89,93,230,142,189,31,253,211,74,98,109,43,103,193,92,113,84,170,122,141,149,204,244,85,149,142,183,123,125,70,73,50,141,103,71,184,76,79,236,205,139,162,191,70,79,81,59,201,12,210,51,243,216,137,146,65,165,109,74,4,127,114,254,133,32,185,120,94,165,2,250,50,167,83,104,153,132,173,238,135,22,84,130,207,152,64,131,175,201,52,7,116,86,14,206,187,27,134,164,187,107,43,57,108,101,57,126,35,138,110,202,139,58,24,66},
  {201,103,100,85,135,209,35,137,60,195,191,172,250,96,212,203,79,154,18,221,62,209,0,35,54,49,34,4,180,56,208,76,74,213,222,30,211,107,138,90,46,158,58,195,249,202,160,155,30,4,25,140,28,5,20,63,87,161,190,236,203,113,56,144,115,118,212,38,150,62,159,196,115,241,224,130,18,56,177,48,117,110,176,65,105,30,253,19,72,158,54,33,183,15,185,240,194,1,204,123,13,123,172,43,100,247,73,116,121,238,213,231,88,239,216,112,89,58,84,191,13,138,242,81,49,42,24,117,104,217,120,241,237,137,0,24,131,246,101,198,222,203,71,222,230,163,208,215,209,200,42,183,81,190,15,223,104,151,220,38,26,82,155,68,109,118,130,198,253,76,3,231,76,77,211,49,114,160,174,245,242,90,26,183,101,230,83,240,147,191,41,222,111,162,158,70,87,152,110,209,166,86,163,144,35,85,33,145,10,224,18,134,165,108,19,43,254,138,77,147,13,47,131,30,72,120,189,228,174,14,74,102,174,179,245,29,175,208,59,23,39,232,22,178,116,94,91,137,206,160,104,137,88,213,81,36,223,228,130,82,245,134,210,197,156,170,49,137,163,39,233,41,143,68,129,231,213,183,134,30,232,100,166,94,175,14,10,201,26,88,38,212,60,72,30,196,127,4,115,235,124,219,181,9,230,173,187,154,196,23,4,217,101,155,20,196,229,224,118,10,60,252,209,166,45,91,71,139,204,202,165,31,29,39,152,161,131,125,111,67,150,98,167,35,136,239,112,224,202,229,73,71,30,63,107,103,105,212,111,127,21,87,29,168,25,50,185,48,26,148,60,51,130,45,161,190,180,19,242,113,172,18,255,0,218,20,21,170,85,16,65,2,2,200,235,186,28,166,166,6,65,95,33,251,19,248,154,161,244,135,102,37,240,110,77,83,123,25,198,10,66,211,207,245,99,47,91,33,201,80,193,75,48,42,226,61,131,136,130,25,139,29,157,208,104,141,3,236,252,77,234,251,143,240,243,218,36,144,119,252,218,14,164,34,210,96,42,1,89,68,155,71,219,152,84,254,35,17,38,98,254,148,7,69,97,193,199,207,84,148,143,190,244,94,15,120,123,208,71,143,120,183,72,20,107,81,218,55,117,4,238,238,182,130,14,164,226,127,118,233,247,214,230,104,190,16,236,0,249,200,43,55,136,7,220,20,161,76,15,135,25,55,30,58,236,57,221,31,38,91,25,47,36,241,106,232,162,22,43,253,77,210,69,180,171,178,96,56,15,20,79,44,100,147,235,81,157,16,15,187,232,12,198,220,201,11,191,133,150,101,9,68,65,175,55,106,11,49,161,228,252,34,111,108,109,113,173,150,234,4,206,59,203,101,22,248,49,222,19,135,166,175,150,102,111,107,255,55,213,218,239,106,112,70,144,68,107,197,175,28,118,200,124,195,122,76,4,140,123,37,165,209,114,184,241,170,96,155,227,70,42,143,77,197,124,250,193,25,102,179,16,72,146,223,110,210,140,64,128,69,21,199,1,244,32,56,105,73,221,134,235,192,161,103,176,106,117,128,217,140,137,34,18,152,169,48,210,94,147,163,20,127,6,57,183,157,38,109,192,105,138,178,170,166,71,128,187,7,68,154,10,154,184,143,241,156,168,77,248,25,150,59,249,232,8,186,128,251,113,98,146,77,198,127,17,249,56,227,17,15,146,110,214,185,12,201,217,142,117,192,200,247,222,34,154,164,84,94,47,13,232,51,252,42,48,231,43,187,184,72,74,82,73,228,111,27,152,22,137,35,87,14,249,100,74,104,189,134,128,82,100,27,107,120,48,191,241,86,129,225,6,236,216,68,30,112,156,9,145,119,75,226,28,159,223,118,48,65,195,215,100,202,105,108,201,245,131,172,63,172,251,48,181,3,141,99,255,124,47,61,84,212,84,192,125,15,6,68,35,206,191,49,26,99,16,219,243,214,134,17,176,129,179,145,193,246,131,48,192,68,143,26,216,22,195,39,246,177,9,168,14,181,105,41,38,94,55,110,38,11,42,163,217,154,96,152,247,246,29,152,182,151,195,144,200,163,103,67,224,183,12,33,175,107,240,127,231,35,79,184,51,82,28,216,68,57,15,6,0,81,196,132,93,47,228,196,172,141,25,83,212,79,233,44,55,45,198,76,164,18,4,233,209,162,164,118,149,63,84,89,93,114,70,139,132,17,14,166,231,151,57,34,0,161,60,142,130,55,68,17,185,76,83,88,218,15,255,15,28,166,162,108,38,179,193,108,230,231,42,239,205,137,237,80,215,89,3,224,173,9,199,31,40,107,70,48,28,67,17,89,225,252,70,250,205,159,195,153,72,127,244,68,178,14,99,70,24,247,254,25,3,201,51,224,202,123,247,133,206,185,195,2,245,129,108,62,149,115,246,99,162,241,156,57,177,155,59,104,5,65,62,125,154,114,204,201,116,84,88,252,159,194,205,192,80,96,200,165,114,186,52,157,101,41,188,38,228,60,134,3,71,114,87,248,148,122,228,81,176,93,249,128,250,41,118,48,26,83,166,246,238,40,225,205,49,167,63,72,60,118,79,148,132,218,22,96,233,53,186,254,181,218,24,140,86,161,1,107,14,34,234,90,102,216,61,172,189,254,73,50,124,197,53,62,97,132,144,27,64,229,92,2,58,143,74,56,178,80,63,156,36,58,247,164,60,229,96,245,65,36,50,28,100,1,6,17,137,160,191,101,19,241,47,104,198,235,170,41,36,204,175,71,119,104,176,112,208,213,37,242,170,68,252,82,134,173,86,124,5,42,188,146,198,149,227,42,216,133,161,36,21,39,2,133,237,173,157,24,229,226,255,180,152,44,96,193,97,197,110,228,167,224,236,67,19,189,141,126,111,14,204,142,114,211,136,103,11,117,132,91,14,51,127,157,220,129,39,204,245,140,130,57,43,255,50,235,69,98,111,128,229,118,53,141,197,120,235,157,213,193,235,125,52,15,94,119,127,112,133,103,9,188,215,94,25,176,60,118,124,97,189,88,30,87,12,1,40,49,181,26,149,29,129,239,68,185,65,162,153,96,222,132,235,68,127,18,94,153,136,203,89,66,28,138,107,196,108,111,127,217,9,83,163,173,220,175,200,142,90,140,223,131,2,107,150,14,244,91,222,7,252,182,79,131,52,1,24,53,20,220,123,163,249,146,240,202,215,30,43,157,62,211,160,130,208,200,244,254,52,111,173,163,79,152,190,112,173,147,197,81,95,70,40,128,24,98,153,120,115,133,234,164,136,85,0,89,198,105,145,247,96,77,109,242,180,235,46,250,65,136,127,232,236,11,18,254,230,13,0,185,233,214,92,132,4,154,225,148,233,49,237,69,251,43,6,125,71,128,58,30,62,169,254,181,49,130,112,216,212,102,57,169,55,148,184,201,99,147,115,129,151,199,41,172,62,86,124,201,171,47,180,76,156,108,28,176,179,89,46,199,248,181,117,1,233,106,196,227,10,71,119,71,10,83,145,96,192,243,238,74,16,197,68,251,162,62,90,221,37,21,239,174,172,172,176,30,33,164,93,115,105,180,239,228,146,144,54,143,197,255,235,105,203,100,147,138,117,109,107,33,152,193,125,171,65,198,105,47,134,64,163,246,12,123,36,46,19,238,228,93,90,165,11,69,4,230,95,243,135,158,156,153,190,126,49,116,73,29,41,245,227,224,201,164,118,131,150,123,172,238,108,249,168,120,246,124,96,25,103,93,13,236,58,98,121,84,186,196,197,14,53,169,37,104,79,245,114,220,135,14,53,25,84,174,178,4,203,61,96,224,209,19,73,104,127,50,172,252,127,241,227,31,13,29,60,144,173,245,123,194,175,155,136,253,36,98,171,15,65,187,212,111,60,23,81,225,47,250,170,45,195,26,68,253,136,228,91,65,134,42,176,48,59,21,215,136,193,156,40,86,163,206,56,159,157,7,49,167,231,119,146,111,182,170,49,135,148,157,37,233,208,227,208,203,194,22,14,61,151,254,104,8,171,124,203,179,117,23,172,175,158,20,94,198,123,85,98,30,51,192,124,159,120,238,102,246,214,166,213,56,85,136,11,82,104,84,6,156,40,82,208,199,112,90,119,183,89,141,119,147,11,155,108,120,51,201,133,225,59,74,83,218,79,51,122,104,152,100,164,71,11,235,104,70,226,169,70,160,12,247,117,187,89,36,238,156,114,164,162,254,166,101,133,116,55,253,107,161,181,184,238,63,234,48,10,232,13,152,186,5,75,208,92,35,176,24,50,181,247,61,96,216,25,39,9,57,148,7,83,22,96,89,198,226,31,219,122,220,248,95,94,179,145,205,61,86,69,125,212,175,132,199,178,216,163,36,62,179,2,117,227,19,237,181,109,161,72,3,244,166,220,24,76,126,253,25,157,20,119,134,148,22,63,135,7,224,36,41,248,158,54,9,72,119,3,84,22,20,54,104,214,192,106,67,229,37,248,26,196,187,12,134,133,214,133,198,172,157,224,226,120,58,229,35,181,184,22,96,111,200,212,43,168,38,52,243,120,88,137,118,52,225,45,130,80,163,74,248,76,215,208,116,97,37,223,41,117,144,83,72,171,231,138,39,240,47,133,137,1,213,27,197,215,33,206,69,227,39,39,217,138,76,174,56,218,235,239,178,94,232,161,21,212,176,77,247,143,133,143,39,171,139,35,147,51,221,68,246,120,234,144,175,14,85,126,27,236,78,78,209,22,184,153,237,190,150,5,233,190,171,54,11,118,184,150,173,221,170,89,80,18,12,24,193,212,196,100,220,77,255,111,121,40,155,183,31,172,48,157,174,157,85,252,16,253,138,51,241,76,94,35,195,237,62,70,42,81,226,39,36,145,33,243,136,18,185,107,16,19,108,48,89,208,237,179,24,213,29,89,170,220,51,71,128,170,130,145,190,189,254,142,120,33,77,155,157,23,105,200,188,152,132,89,64,34,1,91,163,164,187,92,200,156,126,95,191,2,229,29,127,73,80,161,171,115,85,214,36,173,115,63,110,238,42,248,150,25,200,251,12,236,99,147,54,194,239,159,113,187,47,171,42,226,42,148,101,169,184,206,145,86,130,43,175,18,25,182,29,3,107,34,50,238,192,29,4,63,7,167,148,212,95,4,106,213,84,156,28,174,120,161,210,27,107,169,42,247,149,109,161,79,172,11,175,121,31,136,78,29,23,112,54,120,194,128,223,127,245,188,2,5,0,2,35,117,25,206,88,54,60,232,187,53,2,149,35,159,66,105,39,114,45,161,28,99,67,143,51,163,79,56,209,150,119,149,109,255,203,108,3,69,194,107,83,24,227,112,44,166,214,194,188,134,146,59,58,134,236,18,120,188,221,105,16,187,131,124,93,129,254,161,216,109,187,16,219,15,71,140,127,14,34,129,241,222,30,45,180,106,76,110,73,110,36,253,202,249,14,144,119,170,55,45,99,146,146,83,242,24,69,177,209,180,80,102,230,198,209,176,138,157,134,203,194,77,126,132,168,211,195,79,42,40,244,221,75,20,241,211,179,255,244,121,172,40,207,85,159,204,82,156,151,131,54,93,160,101,88,244,255,180,196,249,175,160,187,83,236,209,85,45,195,187,30,144,84,236,220,41,39,94,237,85,226,22,203,244,88,151,204,235,66,49,83,45,240,30,230,120,21,68,81,189,74,84,89,128,159,233,218,9,42,35,53,208,45,83,119,118,29,78,243,34,0,28,206,85,25,152,74,8,164,215,58,145,97,65,75,221,99,98,85,204,26,188,208,164,3,29,188,12,67,191,39,52,65,172,81,89,100,1,162,43,24,43,77,188,43,177,206,237,59,100,110,100,229,173,170,220,7,21,71,208,109,104,63,156,103,199,237,198,98,134,26,145,107,125,124,245,133,234,245,62,230,207,10,4,236,32,165,56,240,114,29,185,57,209,224,215,226,226,106,220,150,181,71,233,150,29,94,20,108,92,238,201,135,85,166,106,230,126,205,111,163,5,3,52,179,202,62,235,87,189,128,48,10,137,51,231,97,218,229,39,223,110,124,153,195,119,241,134,66,101,59,124,37,59,67,151,18,35,108,81,252,228,174,131,88,26,242,100,183,108,8,103,16,79,17,133,73,15,12,10,130,160,143,88,164,249,206,184,210,219,163,106,103,104,119,247,123,239,198,68,164,246,80,83,154,251,23,195,148,33,95,80,203,106,44,107,226,244,85,32,180,240,104,34,161,137,119,75,79,132,39,132,239,80,235,73,97,218,97,224,132,62,199,127,44,213,195,142,53,219,72,254,69,128,59,219,180,0,6,6,18,94,1,96,34,169,53,89,192,165,216,211,250,104,254,181,58,0,118,182,238,184,120,229,140,233,51,43,134,79,76,184,180,64,70,26,16,239,73,55,244,246,204,25,178,169,245,34,246,137,212,136,216,106,145,244,249,81,172,179,214,218,158,14,96,154,221,227,73,178,18,253,1,32,58,139,55,33,67,132,7,17,8,64,21,101,232,167,130,128,102,136,201,59,15,69,127,91,86,171,16,17,234,136,106,7,129,53,94,159,232,12,174,77,249,116,222,2,15,197,155,50,238,15,200,165,236,209,129,31,12,62,24,123,6,18,222,71,4,95,53,50,202,16,212,32,92,47,137,45,134,69,97,41,244,253,90,214,9,73,88,58,65,47,98,243,236,98,92,45,150,230,74,83,129,220,10,36,194,205,16,39,99,52,86,220,107,18,143,234,135,109,226,129,7,117,51,60,102,255,8,125,59,119,164,31,67,106,88,209,36,212,11,83,210,31,4,21,142,82,123,203,105,61,48,121,38,161,4,26,254,168,232,53,45,74,197,209,64,101,7,188,123,233,12,100,0,251,63,49,53,2,25,203,17,245,120,117,51,152,251,196,47,71,54,77,12,253,123,195,79,130,36,73,216,139,119,113,113,143,165,218,66,187,28,60,233,179,90,239,212,195,153,51,83,213,179,42,202,79,131,117,97,45,191,109,217,33,11,179,207,124,23,255,36,37,16,224,35,128,6,159,64,50,35,111,196,224,43,206,128,96,66,138,124,145,105,235,43,199,77,105,64,49,33,0,158,104,29,250,43,186,216,33,227,5,236,51,15,85,121,37,191,93,173,250,166,112,94,12,131,180,221,209,15,111,205,241,245,177,183,118,66,44,60,52,171,160,168,185,82,240,48,45,167,185,238,48,107,93,165,189,81,174,8,6,102,83,215,19,95,188,137,180,51,10,58,152,194,71,96,224,93,211,186,16,183,96,30,252,86,11,46,39,215,63,207,100,94,252,230,68,208,236,14,205,181,104,56,202,183,196,185,175,151,139,85,231,24,208,123,34,213,211,208,137,148,211,3,255,111,134,208,105,233,114,111,132,189,71,122,247,209,217,215,152,155,60,125,87,76,130,235,20,156,175,243,142,145,216,253,183,241,190,207,56,142,70,145,255,240,36,194,40,124,216,220,163,243,96,204,253,58,120,142,116,167,78,50,218,7,207,48,113,13,208,211,188,66,164,147,139,13,184,233,189,178,140,230,19,203,114,55,177,16,54,47,156,210,217,35,20,168,182,155,133,3,70,23,209,241,98,126,211,192,195,240,232,243,101,252,115,226,37,201,25,74,142,102,52,83,116,18,188,12,176,164,248,195,74,77,244,71,170,129,253,227,206,81,26,58,198,219,186,198,125,76,69,155,208,88,73,235,130,155,145,190,75,54,222,88,214,229,164,90,160,4,242,7,198,162,210,28,59,207,18,73,99,187,244,85,159,11,176,214,115,187,135,142,8,203,175,72,141,106,103,63,54,93,54,60,230,226,179,74,155,120,32,45,126,59,229,150,161,253,241,91,73,32,80,244,16,122,133,57,228,208,255,9,116,109,116,69,46,139,120,185,152,168,233,17,220,244,86,29,229,136,106,207,60,113,109,141,114,167,90,143,231,242,234,62,29,120,179,154,6,226,118,63,184,134,235,42,155,108,174,216,237,163,103,141,161,75,133,135,93,92,194,202,68,175,38,124,126,151,13,189,191,185,122,233,184,229,187,227,175,124,124,155,192,1,106,126,123,24,157,192,7,70,34,77,148,254,61,113,127,228,198,93,7,25,50,12,25,186,118,248,121,5,141,214,10,206,86,113,246,203,248,237,92,135,232,81,226,21,159,94,63,21,213,215,171,216,37,122,35,160,34,184,91,153,179,49,126,65,103,95,75,201,101,128,133,193,204,23,236,126,148,157,24,60,166,73,165,174,253,200,153,135,250,35,45,18,153,44,182,63,2,139,137,60,140,175,165,193,80,80,69,211,0,133,81,43,10,71,164,236,166,142,79,134,183,8,109,252,179,192,236,7,170,82,212,249,169,29,231,240,123,240,162,220,226,22,79,204,241,1,60,176,226,105,122,151,73,241,105,226,20,156,147,252,237,22,25,148,118,151,225,55,27,180,212,231,94,53,151,23,254,33,198,109,158,148,11,178,245,246,195,125,152,182,88,0,221,175,210,36,105,149,169,255,221,106,165,128,171,45,30,87,19,236,105,241,88,66,35,28,106,221,40,189,228,45,241,60,84,144,76,140,23,184,84,81,255,192,248,249,11,253,199,214,232,157,197,59,88,161,121,152,253,247,128,41,98,90,29,62,225,147,81,108,94,60,204,140,142,54,176,73,113,191,181,8,75,237,144,18,194,161,217,22,236,45,68,248,246,205,102,237,16,27,251,145,178,131,231,10,100,129,111,6,21,154,119,78,50,108,57,127,162,242,219,235,131,125,29,178,86,207,151,148,162,176,48,44,217,94,91,128,126,241,137,118,93,163,205,21,180,240,71,105,214,15,176,122,25,118,101,226,113,53,212,62,33,77,171,18,37,14,233,122,95,232,31,102,140,222,201,163,207,170,169,49,198,85,165,32,208,195,160,139,21,111,9,155,139,153,205,53,214,25,88,117,50,71,151,69,243,210,149,47,120,57,149,89,197,24,55,237,182,131,239,35,69,119,246,219,208,236,202,235,89,160,23,51,119,175,51,242,222,131,31,193,187,134,196,39,136,216,38,16,13,78,152,203,77,101,29,47,96,102,199,220,179,7,82,82,39,208},
  {73,255,134,94,36,232,95,227,193,72,132,2,63,251,79,157,46,222,194,216,106,213,14,178,247,152,240,75,248,191,102,77,23,222,21,169,11,165,225,82,18,76,246,88,55,121,159,73,31,196,132,29,71,189,106,139,35,187,135,229,115,186,178,213,12,25,62,240,27,118,227,8,9,123,37,113,118,31,162,212,161,83,245,179,166,110,178,45,122,27,143,201,164,144,224,2,185,24,18,61,237,160,196,188,123,199,251,130,0,137,195,86,77,57,33,52,147,62,128,41,77,68,120,33,11,42,47,220,32,69,231,105,221,103,152,4,73,24,115,130,164,122,109,150,133,190,203,51,136,246,140,228,106,177,201,255,197,219,232,187,114,27,28,210,180,175,79,130,14,144,245,203,208,139,248,113,149,6,46,47,224,54,52,252,24,157,195,203,37,100,110,35,71,88,142,129,160,70,24,200,82,161,185,102,146,46,152,185,8,236,107,138,208,2,46,133,82,210,33,75,18,110,87,67,253,76,34,72,157,114,20,244,157,16,34,158,242,80,191,71,74,114,133,30,237,215,203,50,209,98,3,217,21,142,162,18,140,59,96,13,145,242,13,28,128,144,181,102,13,190,102,128,66,39,117,152,65,217,204,220,178,15,76,178,7,39,63,102,100,42,0,99,150,3,212,164,219,198,156,241,153,90,254,99,11,225,109,87,136,36,97,45,141,160,1,14,73,28,29,203,25,170,174,91,150,204,90,219,36,15,116,52,105,50,239,209,33,18,198,149,226,148,209,73,229,76,56,7,204,153,18,89,65,13,184,142,254,148,92,214,132,236,159,223,87,236,36,97,69,57,189,169,105,149,179,76,134,102,67,130,102,119,32,132,234,11,134,36,91,9,134,166,120,57,79,58,152,215,182,252,211,116,131,160,248,104,147,91,6,105,59,152,240,97,104,239,66,159,104,180,183,118,224,123,230,47,1,25,48,146,132,163,155,112,106,16,93,169,62,91,128,71,248,163,46,11,56,226,113,185,8,3,243,151,0,190,60,20,154,235,24,99,28,36,139,115,58,208,186,148,146,218,78,108,52,84,224,168,113,231,9,65,20,133,3,161,94,177,31,173,95,217,164,200,16,197,232,191,8,65,12,76,192,46,61,72,57,143,158,238,224,145,60,219,109,47,130,110,170,171,213,109,45,105,194,145,232,163,2,187,132,140,10,235,232,23,130,96,19,137,245,181,125,60,86,12,140,38,89,196,93,65,235,116,170,249,195,35,175,65,187,31,81,4,111,25,77,212,122,11,131,85,123,155,237,87,252,207,40,164,16,126,235,210,91,188,23,78,240,5,64,202,74,247,125,21,158,27,201,122,113,178,164,142,125,156,182,9,23,197,86,132,111,40,145,36,126,111,167,17,117,29,27,204,5,160,61,69,139,140,200,106,94,157,178,165,13,168,219,49,130,192,230,84,98,71,65,123,84,152,33,142,175,61,149,26,231,58,113,63,142,3,230,192,70,152,39,39,100,96,170,202,144,214,253,167,8,183,18,153,21,37,49,205,150,216,13,174,200,10,209,85,5,69,186,26,200,44,231,215,3,101,103,3,164,18,223,210,22,52,152,8,106,86,72,146,5,60,15,133,220,1,56,87,241,49,161,93,22,152,54,160,223,221,198,157,146,161,61,134,15,188,80,92,247,204,204,194,207,128,238,23,6,120,133,190,38,148,157,89,235,181,29,243,68,160,226,8,98,9,188,46,4,64,39,236,131,104,254,117,92,70,231,198,188,68,194,182,89,80,91,197,229,162,130,243,250,130,179,106,136,201,56,63,58,100,160,227,130,182,230,120,41,3,43,15,69,214,162,127,232,168,248,228,31,194,201,207,198,213,175,166,132,55,51,96,1,82,149,82,33,83,177,255,118,198,141,17,155,245,133,119,74,62,93,100,71,22,35,245,145,117,18,197,149,239,60,142,112,243,73,240,0,43,143,79,213,15,111,140,76,149,84,73,23,9,255,11,137,4,30,226,41,100,110,6,181,24,173,126,106,121,159,98,124,154,69,34,170,236,12,75,176,59,41,43,84,208,213,1,32,63,141,4,113,252,203,74,190,116,164,212,75,82,244,5,181,36,14,93,213,249,106,35,167,123,235,35,200,187,108,241,64,32,49,175,124,122,86,149,101,3,67,230,199,153,104,161,243,222,220,33,208,32,46,11,101,82,11,48,210,48,197,217,249,196,102,128,6,40,31,122,130,167,191,171,212,182,206,238,173,190,242,21,244,39,29,135,0,199,170,117,115,199,248,11,165,65,185,92,92,66,31,31,178,30,153,79,23,42,247,17,209,58,209,245,189,127,53,126,89,92,39,247,74,42,162,145,190,160,140,25,188,85,91,230,131,50,104,162,97,201,198,154,143,183,137,116,37,107,60,110,93,0,15,228,238,230,192,114,108,177,129,26,243,11,26,131,62,243,122,251,119,189,3,142,20,179,130,62,60,83,115,67,200,229,93,238,213,248,215,82,48,107,104,202,82,22,254,216,166,130,137,64,232,51,6,121,195,172,2,2,150,0,135,212,214,237,209,84,53,179,29,106,70,241,5,182,227,140,225,34,132,84,63,166,45,116,5,141,30,36,4,179,77,164,85,25,0,191,1,25,212,187,230,69,227,129,226,29,28,229,135,73,10,40,25,236,70,117,156,108,95,128,133,140,203,166,57,69,231,220,176,30,241,228,67,2,230,206,46,80,63,246,14,50,85,228,156,115,41,54,193,148,95,47,119,162,192,11,73,196,19,183,43,87,210,127,9,243,136,55,17,184,79,230,7,246,159,112,18,103,19,20,28,192,242,184,239,201,23,205,184,0,25,154,190,145,173,45,117,32,74,23,205,178,116,136,14,107,250,12,107,137,21,242,22,84,230,39,103,2,86,14,221,2,98,193,58,201,107,152,207,84,205,233,140,161,52,44,149,232,11,248,9,164,112,176,242,171,36,184,219,224,72,4,178,137,49,241,16,215,193,79,90,177,141,129,104,49,220,120,141,113,138,199,138,6,232,129,70,55,195,74,154,85,75,40,253,95,194,232,15,121,151,46,212,50,184,222,188,77,190,195,146,37,67,229,242,45,64,190,242,28,94,167,242,119,195,209,180,50,83,143,103,242,238,224,218,51,135,116,246,34,200,128,28,222,104,205,80,44,227,55,184,155,94,90,214,119,192,12,248,112,120,122,4,204,197,13,80,148,41,17,240,216,175,106,154,59,175,9,55,110,244,133,207,23,32,27,135,108,189,50,212,10,106,11,119,97,225,100,96,53,62,30,142,99,209,21,82,250,85,148,152,115,105,96,216,93,19,224,60,100,48,90,65,135,69,158,224,212,32,203,184,36,249,153,79,92,214,1,48,83,206,237,46,209,173,48,11,174,9,192,242,245,87,252,17,75,94,23,187,20,9,79,191,243,169,247,44,73,113,121,179,104,76,229,9,112,93,133,235,250,232,189,1,35,173,220,202,204,127,195,192,217,48,33,52,219,188,10,22,250,148,165,187,57,198,194,111,26,152,206,245,78,168,248,70,248,47,2,238,59,243,33,94,56,104,31,30,128,221,1,122,29,12,107,59,9,193,80,219,132,151,23,110,27,140,240,59,26,150,123,154,20,158,97,77,1,137,235,140,100,193,217,66,244,111,75,42,5,169,164,179,109,222,75,90,67,29,118,198,22,195,227,237,229,183,214,198,236,96,125,229,238,100,171,123,70,28,209,194,134,11,109,77,44,48,10,240,220,81,186,119,57,72,196,84,183,61,57,46,145,22,23,185,126,57,175,68,77,93,145,186,246,20,73,110,58,160,126,136,38,41,45,204,221,195,198,184,46,91,69,228,229,28,145,228,155,177,32,89,133,128,71,60,52,75,15,99,159,26,160,99,134,45,165,194,73,69,189,146,148,236,100,230,39,146,57,156,79,154,192,3,221,247,243,135,146,127,142,10,41,43,162,120,141,135,70,140,56,208,42,178,198,166,243,40,172,133,213,193,65,207,161,57,2,117,109,242,139,200,238,239,7,10,241,215,78,213,114,79,204,126,221,201,145,129,210,5,168,201,155,70,245,242,26,184,147,88,5,232,150,28,35,196,160,166,39,251,123,152,93,136,204,41,165,1,190,84,19,56,173,183,99,94,33,164,226,247,63,205,71,193,49,161,187,70,155,206,0,212,10,254,148,35,179,39,103,139,238,253,209,127,21,188,219,241,29,60,91,63,162,56,76,67,80,115,81,169,224,188,35,19,229,152,183,161,164,55,180,195,90,137,79,193,85,27,30,255,251,64,145,107,53,50,19,19,188,140,12,229,212,228,83,104,46,85,214,180,251,25,112,91,205,219,21,240,174,99,9,96,226,93,181,29,90,172,202,77,222,160,220,197,9,216,85,216,139,78,56,79,72,67,191,224,241,187,122,124,123,254,83,43,34,167,231,90,227,245,173,13,123,0,12,83,124,38,182,18,66,239,241,76,206,45,252,157,74,109,166,51,74,9,43,163,31,243,115,107,116,171,97,232,229,48,141,157,88,74,196,52,128,200,65,49,90,49,142,244,246,243,201,125,129,225,154,203,26,60,113,135,16,136,7,0,37,44,186,254,152,139,10,200,153,0,217,90,76,199,250,150,40,146,194,110,8,66,173,6,215,46,242,132,4,216,234,147,251,51,208,34,23,124,238,216,55,254,215,162,230,44,249,181,31,7,17,100,220,102,248,177,246,251,17,1,187,34,196,106,143,252,5,243,33,95,84,57,143,168,101,57,255,222,182,78,40,53,98,169,38,60,46,33,186,183,244,152,217,225,168,230,162,189,148,191,74,120,232,207,86,43,114,40,193,128,166,26,9,113,127,186,225,255,104,127,12,7,143,143,204,85,34,130,226,50,80,12,203,14,95,2,105,79,44,3,105,59,248,189,153,199,39,140,119,88,153,57,115,191,49,141,238,79,53,91,96,77,149,164,173,235,131,244,189,205,161,5,89,227,28,17,4,86,229,46,68,108,71,216,18,209,26,80,199,100,59,7,184,56,77,199,40,16,87,9,133,49,230,44,98,111,182,167,169,216,117,141,184,2,22,72,24,58,65,175,181,173,255,146,103,26,138,74,246,32,40,213,47,220,58,141,59,19,174,148,171,15,117,253,103,209,240,76,1,50,159,217,100,133,79,120,148,146,109,34,180,71,94,18,215,64,138,67,133,27,248,34,40,243,6,241,68,67,244,157,162,197,38,125,51,127,67,57,96,21,212,218,6,7,54,29,53,45,185,63,92,243,235,204,143,30,221,103,185,232,175,27,150,125,221,246,195,40,66,224,170,22,146,8,30,141,196,111,195,66,253,237,60,36,103,35,246,147,196,11,15,130,118,129,207,77,131,227,187,223,160,83,69,130,243,226,215,180,209,231,15,120,115,111,188,154,119,106,161,105,186,155,160,164,92,238,194,34,4,51,213,161,37,14,227,135,48,21,236,211,214,99,173,165,141,181,1,16,75,29,213,208,2,201,184,80,151,52,130,224,44,158,246,106,6,161,231,7,111,125,110,177,99,252,165,78,157,211,136,6,183,227,34,255,233,172,148,196,105,222,250,132,234,232,35,232,233,195,216,125,249,242,56,155,13,110,199,114,157,235,252,228,137,60,205,196,116,181,3,253,141,45,12,218,113,217,255,76,29,99,39,142,157,17,246,141,28,120,47,197,246,184,156,107,212,167,77,199,198,146,24,125,56,232,159,68,238,3,91,181,103,234,141,38,244,46,220,184,72,232,231,174,116,110,25,100,209,142,63,129,4,122,10,139,10,177,5,27,172,171,98,84,195,144,18,148,26,73,26,76,13,154,139,82,194,27,121,83,106,176,99,111,165,101,6,239,118,173,148,67,29,63,79,80,36,125,215,140,149,232,167,193,180,134,166,202,84,206,114,138,143,255,99,66,119,100,229,215,222,90,191,87,143,154,95,9,26,110,41,21,71,100,76,145,28,141,250,71,229,60,34,36,22,195,9,191,8,121,26,231,166,180,20,216,8,53,223,64,15,142,111,158,158,172,118,161,12,130,190,134,20,90,77,92,93,27,64,249,142,206,132,242,65,233,245,136,94,96,194,125,213,203,186,107,78,159,198,196,168,245,169,168,196,213,31,61,48,41,248,60,199,18,125,169,103,235,205,243,116,143,12,244,219,166,207,177,98,5,216,185,108,72,6,0,69,182,73,219,119,108,87,255,119,253,68,110,33,29,184,52,225,118,184,209,155,83,173,216,149,190,141,207,149,137,237,40,188,3,4,113,201,116,136,86,170,182,155,210,79,9,14,71,152,69,172,6,46,232,161,179,42,170,218,142,166,50,158,80,50,215,210,200,121,128,243,9,193,57,17,194,189,57,232,50,33,191,144,65,74,235,73,105,199,15,13,23,48,207,44,248,15,204,197,160,50,21,220,34,6,132,110,224,51,166,30,120,77,13,187,241,226,53,121,206,199,72,196,193,158,237,236,96,245,118,161,138,196,63,167,143,26,164,11,190,110,97,4,45,121,167,142,22,236,77,46,96,134,42,57,80,50,33,122,88,150,239,117,8,207,175,149,166,104,246,173,52,181,245,147,251,169,237,234,105,111,52,117,99,36,60,218,194,222,243,49,117,90,151,117,74,230,117,219,242,217,227,242,170,36,161,129,210,110,161,199,86,226,50,216,182,182,153,151,161,228,171,195,83,22,43,53,9,62,23,152,152,26,71,181,205,46,248,45,248,2,61,138,221,240,57,216,104,188,88,74,238,69,156,253,1,39,173,160,183,61,137,61,181,78,215,153,103,186,1,240,139,254,40,73,110,19,224,126,98,237,54,114,135,214,184,130,254,215,215,180,27,47,148,120,164,153,224,155,55,239,110,245,212,50,237,173,60,8,13,48,14,98,116,208,51,178,231,37,168,214,192,136,155,239,146,103,221,217,37,200,81,221,208,42,14,170,5,143,73,214,100,122,198,111,190,95,211,131,242,149,116,242,137,95,49,75,148,99,138,7,73,35,92,103,88,196,27,58,34,129,13,238,217,157,25,233,106,147,200,63,95,137,253,204,124,118,252,169,233,135,164,163,121,59,73,120,59,243,141,32,79,2,142,109,83,4,5,65,207,57,90,71,146,95,131,38,173,11,155,239,0,5,136,73,205,72,14,102,247,255,16,48,248,228,172,77,75,1,179,9,59,127,93,37,113,77,111,62,46,12,165,249,220,81,254,39,30,91,209,217,206,201,185,38,42,71,74,147,83,115,93,52,110,251,240,28,101,190,186,131,124,34,2,70,178,26,202,237,122,58,234,67,123,43,224,111,99,86,80,171,70,43,205,187,167,159,246,101,74,125,66,9,228,97,9,239,85,16,102,73,73,168,151,113,51,94,128,233,4,8,240,209,195,40,196,3,220,53,13,52,76,206,19,67,150,208,168,81,213,156,192,110,101,63,152,97,16,66,185,134,17,161,184,9,39,28,243,207,65,220,162,121,227,164,35,15,133,232,180,82,114,151,241,238,121,135,229,36,96,153,52,157,141,159,140,153,66,83,199,209,255,213,101,196,183,7,95,58,223,35,5,254,28,97,234,228,20,43,105,71,251,59,204,108,178,67,35,179,180,188,146,218,144,167,189,169,63,27,211,89,23,52,32,76,136,99,78,124,190,104,74,226,139,31,180,8,118,134,80,15,254,42,105,206,209,151,205,79,192,137,204,234,57,196,163,224,157,0,123,41,152,57,184,34,174,162,172,39,48,131,39,53,41,223,150,1,226,223,239,49,83,231,68,250,197,116,6,10,255,176,27,180,55,123,225,87,184,211,27,14,27,229,14,216,55,33,255,19,55,223,249,179,189,17,155,124,50,120,102,44,62,251,231,139,106,243,41,73,166,217,225,172,149,153,181,233,209,38,35,77,124,155,55,90,247,83,240,254,92,79,54,96,139,19,161,212,169,58,27,30,191,221,26,28,138,42,200,33,138,97,114,15,225,139,141,85,159,91,203,68,48,13,254,54,140,233,250,169,127,105,67,53,16,154,37,103,255,125,217,31,201,22,12,204,128,222,234,184,54,55,193,62,17,217,62,199,138,124,9,167,178,94,50,230,40,92,60,46,247,23,97,21,54,102,78,113,74,84,120,211,35,232,109,185,125,77,186,122,176,228,73,141,32,167,153,197,169,222,106,59,107,133,130,152,101,225,125,237,1,185,176,160,126,12,23,210,15,98,6,2,39,201,43,117,95,181,226,56,202,171,179,82,171,216,190,36,8,98,24,36,51,135,28,49,174,30,248,169,27,178,193,71,18,126,228,90,36,152,133,97,222,91,228,244,154,171,231,42,227,127,193,245,198,128,72,4,109,164,233,218,99,39,201,229,60,255,43,251,159,77,218,85,60,206,22,158,197,117,58,227,96,138,159,176,242,228,162,189,99,47,129,4,70,143,86,50,80,202,161,239,24,119,253,214,15,118,35,209,233,1,159,166,17,75,75,152,214,143,121,215,141,219,161,64,177,143,39,53,47,237,70,36,90,197,70,60,18,153,102,142,227,149,211,96,226,120,45,55,156,3,22,143,197,134,235,109,53,242,108,71,188,126,192,108,34,210,2,121,166,54,110,128,239,120,8,163,233,9,210,119,136,126,63,251,234,0,9,84,239,84,72,79,74,179,171,52,166,213,140,152,63,36,125,219,236,236,25,193,233,66,137,32,62,198,52,89,234,219,220,177,15,198,118,20,50,215,161,41,119,72,32,173,70,225,221,18,146,163,192,12,19,128,98,109,6,135,16,125,134,139,241,229,49,249,228,174,116,146,238,195,9,97,241,219,118,58,40,73,149,129,43,196,63,243,239,154,142,94,15,42,18,29,198,63,31,182,199,246,84,11,63,80,223,172,175,138,236,117,255,200,90,60,111,132,75,78,217,88,96,184,161,86,199,194,28,157,234,28,123,159,108,232,63,254,168,99,147,94,186,111,154,84,153,7,100,207,73,223,85,10,14,202,160,12,210,164,214,197,21,50,178,192,188,253,41,248,15,142,33,215,143,219,253,66,12,217,130,59,51,17,183,176,3,247,219,74,212,81,244,46,28,37,117,117,85,178,50,240,213,99},
  {43,23,16,5,130,236,228,103,108,27,42,102,212,243,18,223,27,31,34,15,205,134,20,45,23,70,120,70,190,6,193,47,98,166,237,170,208,74,128,3,54,205,249,27,197,99,107,41,113,124,138,146,151,27,45,16,133,164,199,90,223,167,181,115,132,96,49,251,114,155,141,167,79,80,130,62,219,106,72,20,20,84,44,175,14,126,234,232,191,150,62,162,249,23,201,16,221,209,248,221,117,167,128,170,213,251,202,15,130,133,137,156,159,142,190,159,67,103,97,79,192,168,129,58,49,58,236,163,136,204,201,7,54,151,66,194,40,167,97,201,251,155,250,142,50,132,187,90,170,182,57,124,153,117,178,135,19,131,226,169,78,81,78,112,231,5,93,142,172,1,146,56,209,114,101,103,223,245,160,102,254,194,249,77,215,200,25,160,16,249,231,126,253,107,8,246,90,190,211,102,162,229,135,29,47,66,217,59,145,120,129,168,78,18,185,103,149,198,23,181,45,83,146,253,164,96,54,220,122,202,206,9,18,18,184,236,40,122,9,56,25,162,85,209,17,134,52,224,53,93,12,117,18,169,188,101,72,57,193,190,50,134,62,186,222,223,75,181,162,231,56,36,244,226,199,83,195,5,2,89,203,223,197,10,173,98,64,227,131,104,193,85,80,231,204,166,95,173,102,234,155,153,250,42,100,188,104,211,2,248,52,192,62,70,228,19,204,186,170,127,199,236,228,18,21,168,157,147,101,108,191,121,199,105,245,144,58,76,167,104,169,154,59,175,209,235,191,36,18,167,229,87,114,97,206,54,110,11,100,47,180,222,218,50,152,7,190,53,48,120,255,8,162,40,224,95,176,217,43,122,232,11,40,184,7,248,211,195,43,65,114,23,209,122,206,152,127,55,193,239,24,233,118,235,85,130,9,60,234,80,110,104,3,111,89,200,68,84,28,86,246,6,178,212,49,46,104,89,47,127,8,79,181,4,148,145,77,117,140,249,206,59,185,3,165,61,24,168,56,138,95,235,15,25,2,236,149,22,236,231,11,45,115,203,105,127,151,212,255,89,77,139,101,190,79,71,29,25,56,209,130,96,246,15,66,5,239,238,226,137,44,243,85,5,200,161,160,115,73,233,113,142,84,119,150,6,75,174,100,237,138,35,63,110,37,213,9,156,104,136,249,143,171,111,157,18,112,160,103,228,110,96,41,72,223,251,90,103,243,62,214,18,73,16,103,78,73,248,59,74,26,15,225,62,144,121,186,174,117,96,233,81,216,30,86,181,7,20,240,5,225,74,88,233,21,223,159,68,43,40,73,14,73,64,23,219,40,97,130,32,225,184,152,60,78,39,38,126,169,9,128,215,79,119,32,111,212,196,223,72,74,189,215,233,194,219,48,30,77,156,126,78,55,55,222,51,89,55,31,47,2,211,150,65,93,130,56,99,235,235,3,242,39,72,121,220,171,116,94,224,69,211,208,128,90,211,206,181,148,216,154,227,9,31,122,87,65,62,254,151,220,228,65,6,228,32,41,147,205,56,205,244,88,61,197,23,203,168,87,1,64,243,135,110,135,167,163,208,146,48,93,190,114,12,36,227,144,176,221,66,219,174,72,165,237,33,65,9,88,240,37,60,252,105,84,151,171,125,202,144,77,233,15,46,249,89,180,204,26,175,1,247,7,130,231,16,170,69,117,132,185,187,126,104,238,81,160,79,93,196,41,186,243,203,200,74,66,152,247,150,209,163,40,87,14,156,109,112,36,11,3,94,105,207,230,199,204,73,204,19,210,224,40,6,44,93,71,133,116,74,138,88,43,200,61,79,0,31,36,136,203,20,112,243,156,45,130,77,82,223,65,115,201,32,92,215,238,163,184,87,240,161,145,135,130,143,249,20,210,118,236,163,207,119,254,48,60,80,34,176,52,54,119,99,174,59,255,159,188,236,18,2,200,221,49,204,231,240,218,7,59,23,46,239,243,2,126,184,219,180,137,91,25,31,142,43,161,107,206,151,148,149,94,181,148,191,213,222,135,126,71,209,241,92,92,75,107,238,3,177,198,46,197,194,103,73,117,13,12,177,14,127,69,23,9,246,125,1,252,64,162,69,252,43,49,233,102,170,142,83,250,82,245,169,135,108,191,175,111,89,121,149,171,197,99,28,139,138,18,117,41,251,239,29,0,35,150,161,50,253,229,250,251,51,107,42,7,148,174,6,30,140,105,12,194,111,179,63,172,101,122,217,52,45,106,87,71,39,70,150,245,15,163,199,155,108,68,68,112,187,2,174,213,173,213,5,49,95,205,214,99,95,93,36,213,215,164,164,218,229,11,162,243,20,52,152,142,188,117,109,253,253,213,4,180,155,253,96,19,99,209,149,210,83,27,14,193,118,27,155,11,121,4,142,81,210,46,247,147,223,236,100,94,78,46,114,19,0,7,10,36,227,167,186,223,51,77,236,26,53,179,225,49,113,250,45,58,160,238,244,48,233,160,134,119,151,169,185,7,124,210,18,133,127,153,25,9,126,239,255,82,219,176,207,116,87,150,252,195,221,132,126,10,194,156,98,110,122,180,131,127,65,206,69,131,76,108,190,176,106,115,5,184,255,214,248,247,217,213,178,146,203,177,189,64,157,228,228,178,205,212,63,205,118,71,19,119,61,250,203,76,68,56,30,53,18,248,215,91,99,25,16,122,107,28,205,108,252,236,137,64,15,100,200,251,38,157,185,71,226,114,37,144,226,192,204,61,16,137,207,3,202,55,39,134,132,244,77,154,166,58,149,19,225,96,175,165,231,32,182,186,184,223,239,226,143,75,122,131,178,108,175,244,89,235,135,209,67,46,243,37,86,239,126,73,25,174,52,240,171,17,95,45,173,183,241,70,128,108,32,102,99,153,138,101,121,42,10,105,59,211,218,187,99,180,213,86,51,120,139,115,2,51,86,231,178,47,88,252,248,125,176,228,98,128,213,210,36,249,225,182,47,128,162,242,77,194,145,55,247,100,254,13,163,163,76,144,200,224,165,130,174,191,248,74,106,85,199,104,224,7,24,79,203,148,198,226,185,155,134,166,197,0,171,91,137,138,72,183,214,18,235,250,188,217,4,142,54,120,183,204,224,187,208,41,35,59,206,254,16,129,166,100,98,71,145,69,64,198,68,31,227,102,37,244,60,7,102,26,189,90,52,233,81,136,144,161,241,252,122,179,252,189,36,130,34,224,116,63,41,190,117,29,137,151,64,111,122,180,163,25,148,136,162,218,57,161,133,40,40,192,60,203,182,170,49,152,164,171,155,185,96,83,160,194,196,68,9,205,127,187,190,173,189,113,83,215,112,204,108,26,209,230,137,129,78,3,202,202,0,90,200,93,161,249,9,246,177,159,211,31,232,245,189,51,138,99,197,172,12,100,185,103,211,40,139,185,161,171,245,182,92,9,90,126,177,102,23,250,190,233,164,168,86,88,166,41,69,162,21,93,39,32,133,57,130,136,67,105,216,182,177,51,237,247,127,170,221,159,156,134,245,173,80,205,19,58,157,119,47,23,57,206,219,40,67,10,154,154,183,144,242,15,227,213,212,160,72,193,175,244,46,127,214,193,95,162,23,34,114,178,48,23,71,206,55,198,80,119,199,118,248,242,141,80,50,172,203,193,172,220,221,32,127,55,200,136,55,34,86,5,231,142,56,21,119,213,19,159,100,250,130,49,17,47,154,203,169,150,10,214,110,6,108,119,107,3,80,198,205,116,82,56,125,83,114,212,255,253,137,16,235,212,140,237,141,71,160,56,222,16,220,113,150,224,49,222,197,86,42,145,165,247,218,27,219,192,8,172,108,186,194,76,150,141,105,201,94,18,66,162,90,1,175,0,56,166,207,239,28,57,158,52,128,66,142,140,248,53,155,101,87,66,166,72,1,201,123,53,209,182,183,179,166,5,170,26,165,67,206,111,75,46,230,65,40,96,54,227,26,129,127,250,178,188,192,229,181,152,82,139,234,69,117,217,160,4,111,178,233,245,43,235,71,189,255,236,92,9,79,38,11,76,188,182,93,42,114,202,107,80,128,149,113,195,245,130,2,169,143,71,153,232,219,146,177,15,208,51,198,99,78,112,35,197,67,10,60,31,147,163,12,117,98,142,122,188,149,228,44,140,164,38,49,173,187,199,99,141,11,21,33,125,8,218,1,80,212,17,168,230,26,92,142,212,202,193,245,234,70,144,245,198,196,202,102,130,251,184,127,237,190,148,44,146,128,118,20,55,79,36,121,231,74,89,247,183,142,214,159,39,120,18,207,115,154,254,224,245,11,247,252,201,169,52,221,222,118,169,226,235,200,61,79,43,250,193,239,196,94,214,225,47,229,241,134,87,2,189,195,166,75,88,239,85,155,84,110,225,176,106,109,221,246,39,229,69,180,174,18,198,7,184,80,177,10,176,159,149,88,18,172,233,237,98,73,129,20,50,111,247,206,80,26,97,96,38,56,100,244,227,20,12,205,247,25,60,63,155,114,251,119,170,175,116,136,91,192,40,242,116,251,254,98,171,34,89,7,78,254,174,182,210,96,2,177,152,69,31,212,120,180,144,139,166,187,216,180,177,237,30,162,148,144,170,66,39,78,53,194,195,97,91,187,32,38,50,222,50,253,128,48,199,176,75,107,16,149,117,78,23,250,81,133,98,82,168,30,68,210,140,184,107,243,133,39,84,132,101,28,88,31,30,142,106,84,186,170,203,127,239,99,119,185,63,163,248,44,123,77,71,172,226,117,180,145,168,174,176,92,206,82,8,107,95,105,168,139,196,120,80,113,124,157,157,12,172,195,43,21,11,71,177,190,22,112,209,15,5,121,158,92,65,144,191,10,129,107,78,245,48,184,79,196,51,135,176,77,227,27,20,102,31,16,56,68,207,71,254,205,178,168,127,146,61,197,28,144,185,27,120,219,95,250,52,179,101,120,136,148,98,218,50,214,8,50,35,201,21,68,167,24,4,118,59,70,36,201,176,223,237,73,71,135,140,197,91,164,225,41,247,23,183,185,162,200,224,196,204,224,143,252,240,118,88,106,165,180,27,128,146,95,5,252,251,99,81,150,23,222,159,197,37,8,16,206,79,219,11,211,104,193,207,252,153,121,243,234,142,179,196,147,102,94,83,199,141,157,217,62,218,29,148,95,10,246,34,116,85,58,140,241,46,112,153,158,125,70,252,178,181,232,240,39,15,48,207,205,34,11,67,237,196,35,103,148,236,42,97,118,97,255,165,100,246,142,103,231,64,118,226,146,241,154,133,118,112,156,53,37,50,22,71,167,206,16,90,57,253,13,241,60,40,98,100,60,110,128,170,119,72,138,228,105,81,123,236,210,131,204,199,118,67,185,49,122,106,214,231,241,105,78,22,254,97,144,41,130,109,203,115,81,100,15,21,139,252,240,142,102,114,252,6,181,7,5,159,79,150,223,213,18,14,216,91,151,79,162,115,94,127,215,99,160,32,162,65,177,140,209,100,207,236,200,137,142,145,121,18,77,200,154,107,250,167,80,105,46,136,153,215,48,165,140,19,183,202,204,158,186,70,186,205,116,80,191,142,20,150,166,199,29,65,55,181,229,147,201,66,225,126,82,244,148,37,24,235,24,18,181,97,247,158,72,226,80,250,153,81,251,201,254,176,40,85,178,203,123,149,184,17,145,185,133,30,182,226,29,94,229,212,46,84,9,172,228,107,244,192,55,233,252,192,64,144,187,119,111,65,222,214,125,73,188,19,147,59,98,176,155,138,85,169,153,4,50,249,45,157,26,162,248,152,108,143,62,14,127,141,228,228,186,189,212,160,48,176,45,142,104,166,193,209,152,102,212,236,50,211,142,35,28,196,229,74,239,48,243,195,13,168,20,0,127,192,64,0,35,73,19,64,96,240,67,31,131,201,28,97,140,230,26,232,160,235,120,176,119,5,206,148,73,213,52,216,62,197,114,184,248,164,206,136,255,46,182,102,247,138,65,33,35,0,129,137,107,1,65,0,105,105,203,102,150,20,18,186,253,120,224,57,100,185,168,68,216,23,61,128,195,211,119,183,206,51,4,82,34,168,133,57,157,7,42,11,200,174,239,161,231,251,218,195,223,129,228,26,236,115,246,210,134,99,230,77,176,158,176,130,6,206,99,221,177,126,166,195,223,204,93,129,192,110,14,209,97,189,214,103,205,135,223,37,86,39,51,84,116,227,122,197,193,67,233,52,53,74,184,155,99,86,1,128,214,181,213,9,130,205,146,230,105,147,78,79,137,71,51,88,67,197,250,212,11,18,233,35,61,97,249,168,236,50,182,161,185,33,172,6,176,229,12,91,49,82,77,222,14,152,179,246,253,180,186,146,55,87,36,196,191,236,129,239,80,235,208,74,233,159,248,106,70,81,12,175,33,53,36,175,34,78,219,46,98,132,82,100,73,35,100,94,127,255,72,58,50,4,59,166,226,153,233,200,198,236,254,162,254,73,162,241,43,6,204,97,186,89,16,118,149,212,224,37,232,122,21,217,247,145,165,47,245,214,239,211,196,146,140,145,29,106,220,77,176,150,218,90,208,95,114,159,41,81,199,228,100,97,34,234,111,144,36,18,82,8,134,201,217,36,123,103,45,241,9,245,16,32,249,197,251,229,251,124,177,151,105,30,77,43,164,234,33,65,198,15,232,51,217,178,236,252,51,38,85,130,128,86,237,84,48,200,187,170,120,99,105,142,40,156,100,145,61,99,64,203,67,44,2,40,169,40,114,158,95,145,174,103,180,39,191,48,42,109,172,203,207,105,8,128,152,152,28,243,96,27,106,140,27,225,251,56,91,253,149,227,151,70,193,64,230,28,243,52,5,119,221,132,225,155,118,135,62,137,110,33,36,18,188,187,1,148,112,168,37,228,9,204,43,191,24,48,202,82,148,254,126,86,132,70,62,79,5,120,221,102,204,182,2,224,225,114,61,222,104,103,25,5,248,232,141,152,73,70,52,227,45,122,250,93,192,2,130,150,182,193,59,206,40,111,129,60,2,239,252,61,197,246,128,109,239,39,247,94,17,235,161,16,188,171,224,117,199,212,59,191,140,35,113,178,111,166,138,120,131,222,29,135,152,191,8,173,98,150,170,169,160,65,32,148,238,230,165,41,177,249,116,49,138,236,193,121,127,197,25,119,62,247,186,68,226,86,68,108,26,82,77,211,2,12,25,251,57,172,37,41,97,50,204,66,171,104,90,200,96,16,137,14,220,69,184,205,146,195,120,115,195,25,125,227,13,212,167,56,198,45,202,101,37,151,197,77,80,177,0,158,118,180,214,10,50,101,52,23,248,4,228,57,199,71,148,77,177,139,23,6,43,161,57,65,242,103,53,149,95,174,14,103,128,224,42,123,11,99,211,131,136,23,254,202,59,80,144,204,163,70,212,86,197,4,227,181,71,111,217,13,167,218,51,24,140,239,217,167,7,193,61,48,189,190,131,19,135,104,91,189,215,186,232,228,64,36,1,36,52,86,87,65,197,226,114,141,156,68,148,31,133,50,132,222,185,204,163,83,20,232,102,145,63,229,206,74,137,8,159,46,137,38,2,226,29,246,180,81,8,67,95,161,157,176,38,114,193,78,238,176,124,14,19,14,64,172,70,108,78,163,167,236,23,33,250,173,68,248,225,205,7,171,213,242,204,211,190,204,185,36,246,139,34,28,36,244,114,0,201,36,133,20,53,209,43,60,75,169,142,89,42,45,176,146,78,116,145,8,207,235,230,22,66,161,38,190,255,118,74,128,164,18,92,179,89,25,224,71,154,85,60,34,58,38,184,226,40,58,217,81,80,37,117,187,62,114,186,122,105,186,44,82,39,22,84,176,153,214,73,41,148,110,168,175,9,220,157,240,227,159,49,29,6,211,21,32,71,59,99,108,134,108,122,147,141,110,52,13,32,109,233,198,220,129,77,231,113,219,48,9,204,166,110,24,200,148,97,50,87,255,137,220,221,225,67,97,170,2,80,158,192,251,192,80,98,203,153,161,208,82,126,242,113,125,231,49,114,142,99,225,182,34,223,121,41,3,107,130,211,8,11,2,157,54,226,239,235,175,58,190,201,16,37,36,131,37,44,93,178,128,237,189,31,124,241,62,110,246,253,101,195,52,164,241,209,77,50,75,192,48,2,2,99,46,30,171,255,128,70,18,69,93,159,89,9,31,188,75,124,174,11,40,87,237,10,175,158,162,92,28,219,0,197,246,12,121,27,34,116,172,182,125,62,154,60,44,100,109,194,207,15,154,75,53,159,188,187,126,37,174,126,233,17,207,26,179,221,8,206,46,200,126,129,180,47,39,165,52,109,189,59,54,249,67,165,250,23,133,123,133,29,106,194,160,141,80,173,175,92,147,17,99,97,105,222,175,5,180,32,103,99,107,164,220,113,173,128,76,97,3,86,93,136,224,106,99,216,243,20,186,82,189,206,195,158,65,91,183,230,221,101,176,154,20,204,103,23,175,218,187,131,213,165,35,243,91,208,220,51,148,89,200,111,236,141,116,32,195,56,118,31,94,18,140,4,115,190,36,249,175,66,25,212,157,206,191,168,42,153,97,163,229,207,201,233,87,140,6,8,61,9,54,59,95,241,82,39,238,219,218,87,132,224,165,7,127,14,39,85,240,48,167,54,246,206,156,220,185,148,145,239,155,173,103,254,251,148,239,122,196,64,78,93,103,13,165,52,36,137,123,213,209,236,243,70,232,104,10,30,223,224,53,202,89,189,86,151,112,92,164,21,215,114,224,83,146,187,217,105,87,120,184,13,181,241,238,201,33,171,76,223,109,158,94,88,2,50,161,37,220,180,42,88,136,112,7,78,52,234,147,194,161,146,73,150,9,169,221,89,155,70,101,139,134,57,147,230,186,135,195,178,99,219,51,101,150,236,33,167,148,11,116,117,191,129,205,168,74,138,127,19,178,135,0,8,238,94,146,243,165,81,171,176,129,78,195,122,141,11,117,115,182,232,160,151,8,131,28,119,13,142,38,122,44,154,249,72,85,131,250,38,125,64,117,61,253,59,182,26,32,15,184,59,186,239,25,88,162,233,69,170,244,3,9,236,184,222,87,168,62,33,4,199,248,45,59,86},
} ;

static void test_decode_1013xint32_impl(long long impl)
{
  unsigned char *x = test_decode_1013xint32_x;
  unsigned char *s = test_decode_1013xint32_s;
  unsigned char *x2 = test_decode_1013xint32_x2;
  unsigned char *s2 = test_decode_1013xint32_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_1013xint32_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_1013xint32(impl);
    printf("decode_1013xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1013xint32_implementation(impl),ntruprime_dispatch_decode_1013xint32_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_1013xint32;
    printf("decode_1013xint32 selected implementation %s compiler %s\n",ntruprime_decode_1013xint32_implementation(),ntruprime_decode_1013xint32_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_1013xint32_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_1013xint32_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_1013xint32_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_1013xint32_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_1013xint32_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_1013xint32_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_1013xint32(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1013xint32")) return;
  storage_decode_1013xint32_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_1013xint32_x = aligned(storage_decode_1013xint32_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_1013xint32_s = callocplus(crypto_decode_STRBYTES);
  test_decode_1013xint32_s = aligned(storage_decode_1013xint32_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_1013xint32_x2 = callocplus(maxalloc);
  test_decode_1013xint32_x2 = aligned(storage_decode_1013xint32_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_1013xint32_s2 = callocplus(maxalloc);
  test_decode_1013xint32_s2 = aligned(storage_decode_1013xint32_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_1013xint32 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_1013xint32();++impl)
      forked(test_decode_1013xint32_impl,impl);
    ++test_decode_1013xint32_x;
    ++test_decode_1013xint32_s;
    ++test_decode_1013xint32_x2;
    ++test_decode_1013xint32_s2;
  }
  free(storage_decode_1013xint32_s2);
  free(storage_decode_1013xint32_x2);
  free(storage_decode_1013xint32_s);
  free(storage_decode_1013xint32_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

