// -*- mode: c++ -*-
#ifndef SINCCOEFFS_H
#define SINCCOEFFS_H

enum { 
  resampleSincSize = 5286,
  resampleSincRes = 128,
  resampleSincSamples = 41 };

namespace _sbsms_ {
float sincTable[resampleSincSize] = 
{
0.920381425342433f,
0.920302993473145f,
0.920067721990721f,
0.919675683262634f,
0.919126997871811f,
0.918421834572361f,
0.91756041022763f,
0.916542989730571f,
0.915369885906517f,
0.914041459398341f,
0.912558118534085f,
0.910920319177104f,
0.909128564558774f,
0.907183405093832f,
0.905085438178449f,
0.902835307971073f,
0.900433705156165f,
0.897881366690907f,
0.895179075534992f,
0.892327660363588f,
0.889327995263616f,
0.886180999413434f,
0.882887636746086f,
0.879448915596223f,
0.87586588833086f,
0.8721396509641f,
0.868271342755988f,
0.864262145795659f,
0.860113284568922f,
0.855826025510501f,
0.851401676541053f,
0.846841586589208f,
0.842147145098761f,
0.837319781521271f,
0.832360964794223f,
0.827272202804995f,
0.822055041840814f,
0.816711066024967f,
0.811241896739414f,
0.805649192034132f,
0.799934646023336f,
0.794099988268876f,
0.788146983151029f,
0.782077429226949f,
0.775893158577015f,
0.769596036139359f,
0.763187959032823f,
0.756670855868614f,
0.750046686050943f,
0.74331743906691f,
0.736485133765944f,
0.729551817629037f,
0.722519566028119f,
0.715390481475825f,
0.708166692865973f,
0.700850354705043f,
0.693443646334978f,
0.685948771147588f,
0.678367955790895f,
0.670703449367724f,
0.662957522626847f,
0.655132467147014f,
0.647230594514183f,
0.639254235492289f,
0.631205739187853f,
0.623087472208794f,
0.614901817817741f,
0.606651175080214f,
0.598337958007979f,
0.589964594697926f,
0.581533526466823f,
0.573047206982255f,
0.56450810139012f,
0.555918685439004f,
0.54728144460179f,
0.538598873194839f,
0.529873473495092f,
0.521107754855427f,
0.512304232818645f,
0.503465428230394f,
0.494593866351407f,
0.48569207596938f,
0.476762588510854f,
0.467807937153435f,
0.458830655938691f,
0.449833278886095f,
0.440818339108329f,
0.431788367928309f,
0.422745893998278f,
0.413693442421282f,
0.404633533875401f,
0.395568683741051f,
0.386501401231699f,
0.377434188528327f,
0.368369539917981f,
0.359309940936732f,
0.350257867517365f,
0.341215785142159f,
0.332186148001037f,
0.323171398155437f,
0.314173964708215f,
0.305196262979899f,
0.296240693691588f,
0.287309642154844f,
0.278405477468841f,
0.269530551725108f,
0.260687199220141f,
0.251877735676207f,
0.243104457470604f,
0.234369640873684f,
0.225675541295929f,
0.217024392544336f,
0.208418406088417f,
0.199859770336071f,
0.191350649919593f,
0.182893184992099f,
0.17448949053461f,
0.166141655674063f,
0.157851743012483f,
0.149621787967589f,
0.141453798125034f,
0.133349752602549f,
0.125311601426209f,
0.117341264919035f,
0.109440633102171f,
0.101611565108827f,
0.0938558886112235f,
0.0861753992607111f,
0.0785718601412871f,
0.0710470012366835f,
0.0636025189112218f,
0.0562400754046094f,
0.0489612983408536f,
0.0417677802514581f,
0.0346610781130688f,
0.027642712899719f,
0.0207141691498255f,
0.0138768945480801f,
0.00713229952237053f,
0.000481756855863834f,
-0.00607339868562557f,
-0.0125318707108654f,
-0.0188924015449201f,
-0.0251537725552469f,
-0.0313148044620756f,
-0.03737435763298f,
-0.0433313323615559f,
-0.0491846691301276f,
-0.054933348856413f,
-0.0605763931240776f,
-0.0661128643971269f,
-0.0715418662180771f,
-0.0768625433898662f,
-0.0820740821414636f,
-0.0871757102771481f,
-0.0921666973094308f,
-0.0970463545756019f,
-0.101814035337896f,
-0.106469134867263f,
-0.111011090510758f,
-0.115439381742549f,
-0.119753530198566f,
-0.123953099694804f,
-0.128037696229328f,
-0.132006967967991f,
-0.135860605213926f,
-0.13959834036086f,
-0.143219947830288f,
-0.146725243992596f,
-0.150114087072177f,
-0.153386377036634f,
-0.156542055470134f,
-0.159581105431021f,
-0.162503551293762f,
-0.165309458575341f,
-0.167998933746201f,
-0.170572124025849f,
-0.173029217163239f,
-0.175370441202068f,
-0.177596064231103f,
-0.179706394119684f,
-0.181701778238549f,
-0.183582603166115f,
-0.185349294380385f,
-0.187002315936636f,
-0.188542170131047f,
-0.189969397150449f,
-0.191284574708361f,
-0.192488317667501f,
-0.193581277648966f,
-0.194564142628253f,
-0.195437636518337f,
-0.19620251874f,
-0.196859583779615f,
-0.197409660734602f,
-0.197853612846779f,
-0.1981923370238f,
-0.198426763348949f,
-0.19855785457948f,
-0.198586605633759f,
-0.198514043067442f,
-0.198341224538922f,
-0.198069238264313f,
-0.197699202462185f,
-0.197232264788348f,
-0.1966696017609f,
-0.196012418175829f,
-0.195261946513421f,
-0.19441944633574f,
-0.193486203675456f,
-0.192463530416289f,
-0.191352763665353f,
-0.190155265117665f,
-0.188872420413117f,
-0.187505638486185f,
-0.186056350908662f,
-0.18452601122571f,
-0.182916094285512f,
-0.181228095562824f,
-0.179463530476727f,
-0.177623933702856f,
-0.17571085848043f,
-0.173725875914356f,
-0.171670574272733f,
-0.169546558280039f,
-0.167355448406313f,
-0.165098880152636f,
-0.162778503333212f,
-0.160395981354361f,
-0.15795299049072f,
-0.155451219158975f,
-0.15289236718941f,
-0.150278145095599f,
-0.147610273342536f,
-0.144890481613517f,
-0.142120508076075f,
-0.139302098647282f,
-0.136437006258713f,
-0.133526990121391f,
-0.130573814991001f,
-0.127579250433698f,
-0.12454507009279f,
-0.121473050956606f,
-0.118364972627861f,
-0.115222616594795f,
-0.112047765504399f,
-0.108842202438022f,
-0.105607710189641f,
-0.102346070547107f,
-0.0990590635766376f,
-0.0957484669108493f,
-0.0924160550406252f,
-0.0890635986110882f,
-0.0856928637219669f,
-0.082305611232631f,
-0.0789035960720733f,
-0.0754885665541077f,
-0.072062263698056f,
-0.0686264205551892f,
-0.0651827615411846f,
-0.0617330017748624f,
-0.058278846423457f,
-0.0548219900546751f,
-0.0513641159957935f,
-0.0479068957000384f,
-0.044451988120494f,
-0.0410010390917734f,
-0.0375556807196898f,
-0.0341175307791583f,
-0.0306881921205521f,
-0.0272692520847378f,
-0.0238622819270072f,
-0.0204688362501168f,
-0.017090452446647f,
-0.0137286501508832f,
-0.0103849307004177f,
-0.00706077660767134f,
-0.00375765104151933f,
-0.000476997319211795f,
0.00277976159123424f,
0.00601122355799482f,
0.00921600776157955f,
0.0123927551599898f,
0.0155401289427332f,
0.0186568149735395f,
0.0217415222216296f,
0.0247929831813924f,
0.0278099542803314f,
0.0307912162751492f,
0.0337355746358384f,
0.0366418599176616f,
0.0395089281209001f,
0.0423356610382613f,
0.0451209665898422f,
0.0478637791455434f,
0.0505630598348475f,
0.0532177968438653f,
0.0558270056995736f,
0.0583897295411674f,
0.0609050393784495f,
0.0633720343372027f,
0.0657898418914747f,
0.0681576180827297f,
0.070474547725818f,
0.0727398446017178f,
0.0749527516370186f,
0.0771125410701129f,
0.0792185146040738f,
0.0812700035461998f,
0.0832663689342141f,
0.0852070016491116f,
0.0870913225146552f,
0.0889187823835221f,
0.0906888622101165f,
0.0924010731100602f,
0.0940549564063881f,
0.0956500836624715f,
0.0971860567017111f,
0.0986625076140278f,
0.10007909874921f,
0.101435522697154f,
0.102731502255068f,
0.103966790381692f,
0.1051411701386f,
0.106254454618665f,
0.107306486861763f,
0.108297139757793f,
0.109226315937109f,
0.110093947648454f,
0.110899996624499f,
0.11164445393509f,
0.112327339828307f,
0.112948703559463f,
0.113508623208143f,
0.11400720548343f,
0.114444585517426f,
0.114820926647216f,
0.11513642018541f,
0.115391285179402f,
0.115585768159498f,
0.115720142876066f,
0.11579471002586f,
0.115809796967682f,
0.11576575742755f,
0.115662971193528f,
0.115501843800413f,
0.115282806204435f,
0.115006314448161f,
0.114672849315792f,
0.114282915979024f,
0.113837043633693f,
0.113335785127364f,
0.1127797165781f,
0.112169436984582f,
0.111505567827804f,
0.110788752664544f,
0.110019656712823f,
0.109198966429571f,
0.108327389080707f,
0.107405652303865f,
0.106434503663974f,
0.105414710201933f,
0.104347057976597f,
0.103232351600301f,
0.102071413768163f,
0.100865084781398f,
0.0996142220648654f,
0.0983196996791074f,
0.0969824078270986f,
0.0956032523559593f,
0.0941831542538693f,
0.0927230491424269f,
0.0912238867646962f,
0.089686630469191f,
0.0881122566900392f,
0.0865017544235756f,
0.0848561247016157f,
0.0831763800616523f,
0.0814635440142294f,
0.079718650507745f,
0.0779427433909264f,
0.076136875873236f,
0.0743021099834537f,
0.0724395160266886f,
0.070550172040069f,
0.0686351632473628f,
0.0666955815127786f,
0.0647325247941936f,
0.062747096596062f,
0.0607404054222478f,
0.0587135642290348f,
0.056667689878554f,
0.0546039025928779f,
0.0525233254090291f,
0.0504270836351378f,
0.048316304307999f,
0.0461921156522659f,
0.044055646541517f,
0.0419080259614387f,
0.0397503824753537f,
0.037583843692335f,
0.0354095357381317f,
0.0332285827291375f,
0.0310421062496354f,
0.028851224832534f,
0.0266570534438273f,
0.024460702970993f,
0.0222632797155505f,
0.0200658848899929f,
0.0178696141193048f,
0.0156755569472778f,
0.0134847963478306f,
0.0112984082415343f,
0.00911746101754993f,
0.00694301506117043f,
0.00477612228716621f,
0.00261782567912161f,
0.000469158834953931f,
-0.00166885448120184f,
-0.00379520078056329f,
-0.0059088772845451f,
-0.00800889235270582f,
-0.0100942659036281f,
-0.0121640298285632f,
-0.0142172283976796f,
-0.0162529186587561f,
-0.0182701708281668f,
-0.0202680686740045f,
-0.0222457098911985f,
-0.0242022064684846f,
-0.0261366850470883f,
-0.0280482872709882f,
-0.0299361701286295f,
-0.0317995062859638f,
-0.0336374844106956f,
-0.0354493094876133f,
-0.0372342031249026f,
-0.0389914038513265f,
-0.0407201674041749f,
-0.0424197670078825f,
-0.0440894936432238f,
-0.0457286563069959f,
-0.0473365822621031f,
-0.0489126172779674f,
-0.0504561258611889f,
-0.0519664914763842f,
-0.053443116757141f,
-0.0548854237070259f,
-0.0562928538905927f,
-0.0576648686143374f,
-0.0590009490975559f,
-0.0603005966330639f,
-0.0615633327377405f,
-0.062788699292866f,
-0.0639762586742272f,
-0.065125593871967f,
-0.0662363086001637f,
-0.0673080273961252f,
-0.0683403957093937f,
-0.0693330799804545f,
-0.0702857677091563f,
-0.071198167512846f,
-0.0720700091742301f,
-0.0729010436789824f,
-0.0736910432431144f,
-0.07443980133014f,
-0.0751471326580581f,
-0.0758128731961966f,
-0.0764368801519492f,
-0.0770190319474562f,
-0.0775592281862733f,
-0.0780573896100858f,
-0.078513458045522f,
-0.0789273963411314f,
-0.0792991882945931f,
-0.0796288385702248f,
-0.0799163726068679f,
-0.08016183651623f,
-0.0803652969717649f,
-0.0805268410881817f,
-0.0806465762916719f,
-0.0807246301809524f,
-0.0807611503792238f,
-0.080756304377146f,
-0.0807102793669423f,
-0.0806232820677406f,
-0.0804955385422674f,
-0.0803272940050135f,
-0.0801188126219959f,
-0.0798703773022373f,
-0.0795822894810978f,
-0.0792548688955872f,
-0.0788884533517974f,
-0.0784833984845914f,
-0.0780400775096938f,
-0.0775588809683272f,
-0.0770402164645425f,
-0.0764845083953963f,
-0.0758921976741284f,
-0.0752637414464976f,
-0.0745996128004336f,
-0.0739003004691713f,
-0.0731663085280283f,
-0.0723981560849959f,
-0.0715963769653113f,
-0.0707615193901859f,
-0.0698941456498595f,
-0.0689948317711623f,
-0.0680641671797574f,
-0.0671027543572484f,
-0.0661112084933319f,
-0.065090157133178f,
-0.0640402398202279f,
-0.0629621077345898f,
-0.0618564233272276f,
-0.0607238599501279f,
-0.0595651014826367f,
-0.058380841954162f,
-0.0571717851634285f,
-0.0559386442944869f,
-0.0546821415296655f,
-0.053403007659665f,
-0.0521019816909916f,
-0.0507798104509244f,
-0.0494372481902171f,
-0.0480750561837305f,
-0.046694002329195f,
-0.045294860744302f,
-0.0438784113623226f,
-0.0424454395264524f,
-0.040996735583082f,
-0.0395330944741913f,
-0.038055315329066f,
-0.0365642010555345f,
-0.0350605579309239f,
-0.0335451951929297f,
-0.032018924630599f,
-0.030482560175621f,
-0.0289369174941192f,
-0.0273828135791425f,
-0.0258210663440446f,
-0.0242524942169475f,
-0.0226779157364766f,
-0.0210981491489598f,
-0.0195140120072785f,
-0.0179263207715556f,
-0.016335890411869f,
-0.0147435340131726f,
-0.0131500623826067f,
-0.0115562836593809f,
-0.00996300292740479f,
-0.00837102183084636f,
-0.00678113819279113f,
-0.00519414563717416f,
-0.00361083321415952f,
-0.00203198502912983f,
-0.000458379875457017f,
0.00110920912878408f,
0.00267001489999789f,
0.00422327674398739f,
0.00576824070645193f,
0.00730415991891263f,
0.00883029493991307f,
0.0103459140913472f,
0.0118502937897689f,
0.0133427188725395f,
0.0148224829186761f,
0.016288888564263f,
0.0177412478122899f,
0.0191788823367922f,
0.0206011237811589f,
0.0220073140504912f,
0.0233968055978847f,
0.024768961704522f,
0.02612315675346f,
0.0274587764969989f,
0.0287752183175303f,
0.0300718914817559f,
0.0313482173881796f,
0.0326036298077742f,
0.0338375751177299f,
0.0350495125281968f,
0.0362389143019323f,
0.0374052659667743f,
0.0385480665208594f,
0.0396668286305131f,
0.0407610788207385f,
0.0418303576582401f,
0.0428742199269153f,
0.0438922347957571f,
0.0448839859791099f,
0.0458490718892285f,
0.0467871057810913f,
0.0476977158894239f,
0.0485805455578928f,
0.0494352533604325f,
0.0502615132146747f,
0.0510590144874505f,
0.0518274620923405f,
0.0525665765792537f,
0.0532760942160162f,
0.05395576706196f,
0.0546053630334999f,
0.0552246659616955f,
0.0558134756417962f,
0.0563716078747733f,
0.0568988945008436f,
0.0573951834249974f,
0.0578603386345438f,
0.0582942402086914f,
0.0586967843201877f,
0.0590678832290408f,
0.0594074652683551f,
0.0597154748223121f,
0.0599918722963358f,
0.0602366340794796f,
0.0604497524990823f,
0.0606312357677403f,
0.0607811079226447f,
0.0608994087573431f,
0.0609861937459786f,
0.0610415339600736f,
0.06106551597792f,
0.0610582417866455f,
0.0610198286770287f,
0.0609504091311374f,
0.0608501307028684f,
0.0607191558914731f,
0.0605576620081493f,
0.060365841035792f,
0.0601438994819913f,
0.0598920582253713f,
0.0596105523553696f,
0.0592996310055547f,
0.0589595571805846f,
0.0585906075769136f,
0.058193072397353f,
0.0577672551595986f,
0.0573134724988378f,
0.0568320539645518f,
0.0563233418116318f,
0.0557876907859302f,
0.0552254679043692f,
0.0546370522297332f,
0.0540228346402718f,
0.0533832175942438f,
0.052718614889534f,
0.0520294514184752f,
0.0513161629180134f,
0.0505791957153526f,
0.0498190064692186f,
0.0490360619068818f,
0.0482308385570846f,
0.0474038224790149f,
0.0465555089874726f,
0.0456864023743757f,
0.0447970156267561f,
0.0438878701413918f,
0.0429594954362301f,
0.0420124288587509f,
0.0410472152914242f,
0.0400644068544164f,
0.0390645626056997f,
0.0380482482387189f,
0.0370160357777762f,
0.0359685032712855f,
0.0349062344830575f,
0.0338298185817733f,
0.0327398498288029f,
0.0316369272645303f,
0.0305216543933421f,
0.0293946388674391f,
0.0282564921696315f,
0.0271078292952748f,
0.025949268433509f,
0.0247814306479556f,
0.0236049395570361f,
0.0224204210140672f,
0.0212285027872916f,
0.0200298142400041f,
0.0188249860109281f,
0.0176146496949992f,
0.0163994375247132f,
0.0151799820521929f,
0.0139569158321289f,
0.0127308711057459f,
0.0115024794859494f,
0.0102723716438035f,
0.00904117699648874f,
0.00780952339689282f,
0.0065780368249771f,
0.00534734108107065f,
0.00411805748123312f,
0.00289080455483251f,
0.00166619774448026f,
0.000444849108462394f,
-0.000772632974192619f,
-0.00198564409587129f,
-0.00319358410962516f,
-0.00439585741537519f,
-0.00559187324294384f,
-0.00678104593178024f,
-0.00796279520725374f,
-0.00913654645338902f,
-0.0103017309819179f,
-0.0114577862975281f,
-0.0126041563591889f,
-0.0137402918374363f,
-0.0148656503675044f,
-0.0159796967981879f,
-0.0170819034363292f,
-0.0181717502868205f,
-0.0192487252880176f,
-0.0203123245424604f,
-0.021362052542804f,
-0.0223974223928606f,
-0.0234179560236593f,
-0.024423184404432f,
-0.0254126477484354f,
-0.0263858957135253f,
-0.0273424875973972f,
-0.0282819925274153f,
-0.0292039896449517f,
-0.0301080682841611f,
-0.0309938281451183f,
-0.0318608794612527f,
-0.0327088431610127f,
-0.0335373510236956f,
-0.0343460458293886f,
-0.0351345815029585f,
-0.0359026232520415f,
-0.0366498476989807f,
-0.0373759430066653f,
-0.0380806089982259f,
-0.0387635572705482f,
-0.0394245113015638f,
-0.0400632065512871f,
-0.040679390556566f,
-0.0412728230195162f,
-0.0418432758896181f,
-0.0423905334394522f,
-0.042914392334055f,
-0.043414661693881f,
-0.0438911631513571f,
-0.0443437309010235f,
-0.044772211743252f,
-0.0451764651215424f,
-0.0455563631533958f,
-0.0459117906547692f,
-0.0462426451581186f,
-0.046548836924042f,
-0.0468302889465326f,
-0.0470869369518625f,
-0.0473187293911136f,
-0.0475256274263798f,
-0.0477076049106652f,
-0.0478646483615089f,
-0.0479967569283661f,
-0.0481039423537814f,
-0.0481862289283918f,
-0.048243653439801f,
-0.0482762651153661f,
-0.048284125558947f,
-0.0482673086816636f,
-0.0482259006267172f,
-0.0481599996883274f,
-0.0480697162248445f,
-0.0479551725660973f,
-0.0478165029150386f,
-0.0476538532437558f,
-0.047467381183913f,
-0.0472572559116971f,
-0.0470236580273408f,
-0.0467667794292976f,
-0.0464868231831489f,
-0.0461840033853221f,
-0.0458585450217043f,
-0.0455106838212355f,
-0.0451406661045703f,
-0.0447487486278968f,
-0.0443351984220054f,
-0.0439002926267012f,
-0.0434443183206557f,
-0.0429675723467969f,
-0.0424703611333365f,
-0.0419530005105377f,
-0.0414158155233246f,
-0.0408591402398425f,
-0.0402833175560728f,
-0.0396886989966126f,
-0.0390756445117305f,
-0.0384445222708086f,
-0.0377957084522857f,
-0.0371295870302152f,
-0.036446549557556f,
-0.0357469949463107f,
-0.0350313292446328f,
-0.0342999654110218f,
-0.0335533230857263f,
-0.0327918283594782f,
-0.0320159135396809f,
-0.0312260169141752f,
-0.0304225825127069f,
-0.0296060598662241f,
-0.028776903764128f,
-0.0279355740096047f,
-0.0270825351731674f,
-0.026218256344534f,
-0.0253432108829717f,
-0.024457876166236f,
-0.0235627333382326f,
-0.0226582670555347f,
-0.0217449652328814f,
-0.0208233187877915f,
-0.0198938213844194f,
-0.0189569691767836f,
-0.0180132605515006f,
-0.0170631958701489f,
-0.016107277211399f,
-0.015146008113033f,
-0.0141798933139869f,
-0.0132094384965427f,
-0.0122351500287978f,
-0.0112575347075429f,
-0.0102770995016708f,
-0.00929435129624721f,
-0.00830979663736668f,
-0.00732394147791956f,
-0.00633729092439598f,
-0.00535034898484767f,
-0.0043636183181326f,
-0.00337759998456234f,
-0.00239279319807447f,
-0.00140969508004874f,
-0.000428800414884482f,
0.000549398592542026f,
0.00152441255742493f,
0.00249575515346705f,
0.00346294334909421f,
0.00442549764133481f,
0.00538294228725485f,
0.00633480553283812f,
0.00728061983920615f,
0.00821992210606954f,
0.00915225389230991f,
0.0100771616335885f,
0.0109941968568804f,
0.011902916391837f,
0.0128028825788794f,
0.0136936634739278f,
0.0145748330496735f,
0.0154459713933036f,
0.0163066649005877f,
0.0171565064662419f,
0.0179950956704824f,
0.0188220389616894f,
0.019636949835098f,
0.0204394490074385f,
0.0212291645874509f,
0.0220057322421994f,
0.0227687953591133f,
0.0235180052036899f,
0.0242530210727861f,
0.0249735104434401f,
0.0256791491171583f,
0.0263696213596067f,
0.0270446200356535f,
0.0277038467397033f,
0.0283470119212749f,
0.0289738350057704f,
0.02958404451039f,
0.030177378155147f,
0.0307535829689406f,
0.0313124153906489f,
0.0318536413652032f,
0.0323770364346098f,
0.0328823858238901f,
0.0333694845219051f,
0.0338381373570427f,
0.0342881590677419f,
0.0347193743678329f,
0.0351316180066747f,
0.0355247348240743f,
0.0358985797999757f,
0.0362530180989058f,
0.0365879251091717f,
0.0369031864768027f,
0.0371986981342348f,
0.0374743663237385f,
0.0377301076155912f,
0.0379658489210016f,
0.038181527499791f,
0.0383770909628458f,
0.0385524972693506f,
0.0387077147188212f,
0.0388427219379517f,
0.038957507862301f,
0.0390520717128379f,
0.0391264229673738f,
0.0391805813269093f,
0.0392145766769267f,
0.0392284490436607f,
0.0392222485453834f,
0.0391960353387427f,
0.0391498795601926f,
0.0390838612625587f,
0.0389980703467861f,
0.0388926064889138f,
0.0387675790623279f,
0.0386231070553441f,
0.0384593189841745f,
0.038276352801333f,
0.038074355799542f,
0.0378534845111942f,
0.0376139046034402f,
0.0373557907689584f,
0.0370793266124798f,
0.0367847045331337f,
0.0364721256026844f,
0.0361417994397319f,
0.0357939440799517f,
0.0354287858424473f,
0.0350465591922946f,
0.0346475065993586f,
0.0342318783934602f,
0.0337999326159794f,
0.033351934867976f,
0.0328881581549164f,
0.0324088827280907f,
0.0319143959228117f,
0.0314049919934835f,
0.030880971945632f,
0.0303426433649903f,
0.029790320243732f,
0.0292243228039485f,
0.0286449773184645f,
0.0280526159290918f,
0.0274475764624172f,
0.0268302022432251f,
0.0262008419056547f,
0.0255598492021924f,
0.0249075828106016f,
0.0242444061388932f,
0.0235706871284385f,
0.022886798055331f,
0.0221931153300989f,
0.021490019295875f,
0.0207778940251304f,
0.0200571271150767f,
0.0193281094818434f,
0.0185912351535375f,
0.017846901062294f,
0.0170955068354215f,
0.0163374545857532f,
0.0155731487013096f,
0.0148029956343802f,
0.0140274036901342f,
0.0132467828148645f,
0.0124615443839753f,
0.0116721009898197f,
0.010878866229494f,
0.0100822544926968f,
0.00928268074975849f,
0.00848056033994836f,
0.00767630876016376f,
0.00687034145410842f,
0.00606307360206417f,
0.00525491991135925f,
0.00444629440763855f,
0.00363761022703795f,
0.00282927940936458f,
0.00202171269238638f,
0.00121531930732854f,
0.000410506775680379f,
-0.000392319292591773f,
-0.00119275539932617f,
-0.0019904003568439f,
-0.0027848554849301f,
-0.00357572480602225f,
-0.00436261523851059f,
-0.0051451367880615f,
-0.0059229027368688f,
-0.00669552983074627f,
-0.00746263846397085f,
-0.00822385286178995f,
-0.00897880126050736f,
-0.00972711608506233f,
-0.0104684341240196f,
-0.0112023967018897f,
-0.0119286498486974f,
-0.0126468444667235f,
-0.0133566364943391f,
-0.0140576870668615f,
-0.0147496626743549f,
-0.0154322353163073f,
-0.0161050826531121f,
-0.0167678881542856f,
-0.0174203412433572f,
-0.0180621374393646f,
-0.0186929784948938f,
-0.0193125725306023f,
-0.0199206341661661f,
-0.0205168846475966f,
-0.0211010519708691f,
-0.0216728710018125f,
-0.0222320835922094f,
-0.0227784386920557f,
-0.0233116924579366f,
-0.0238316083574713f,
-0.0243379572697852f,
-0.0248305175819706f,
-0.0253090752814939f,
-0.0257734240445179f,
-0.0262233653201023f,
-0.0266587084102499f,
-0.0270792705457726f,
-0.0274848769579454f,
-0.0278753609459267f,
-0.0282505639399193f,
-0.0286103355600531f,
-0.02895453367097f,
-0.029283024432094f,
-0.0295956823435738f,
-0.029892390287885f,
-0.0301730395670819f,
-0.0304375299356923f,
-0.0306857696292481f,
-0.0309176753884519f,
-0.0311331724789745f,
-0.0313321947068879f,
-0.0315146844297365f,
-0.0316805925632501f,
-0.03182987858371f,
-0.0319625105259754f,
-0.0320784649771836f,
-0.0321777270661381f,
-0.0322602904484012f,
-0.0323261572871093f,
-0.0323753382295314f,
-0.0324078523793953f,
-0.0324237272650037f,
-0.0324229988031694f,
-0.0324057112589975f,
-0.0323719172015455f,
-0.0323216774553951f,
-0.0322550610481696f,
-0.0321721451540349f,
-0.0320730150332222f,
-0.0319577639676131f,
-0.0318264931924307f,
-0.0316793118240799f,
-0.0315163367841841f,
-0.0313376927198668f,
-0.0311435119203262f,
-0.0309339342297567f,
-0.0307091069566693f,
-0.0304691847796661f,
-0.0302143296497258f,
-0.0299447106890591f,
-0.0296605040865921f,
-0.029361892990141f,
-0.0290490673953409f,
-0.0287222240313915f,
-0.028381566243687f,
-0.0280273038733983f,
-0.0276596531340729f,
-0.0272788364853266f,
-0.0268850825036951f,
-0.0264786257507203f,
-0.0260597066383421f,
-0.0256285712916748f,
-0.0251854714092403f,
-0.0247306641207374f,
-0.0242644118424243f,
-0.0237869821301947f,
-0.0232986475304263f,
-0.0227996854286841f,
-0.0222903778963592f,
-0.021771011535327f,
-0.0212418773207075f,
-0.0207032704418132f,
-0.0201554901413684f,
-0.019598839553086f,
-0.0190336255376889f,
-0.0184601585174618f,
-0.0178787523094215f,
-0.017289723957194f,
-0.0166933935616847f,
-0.0160900841106333f,
-0.0154801213071404f,
-0.0148638333972561f,
-0.0142415509967193f,
-0.0136136069169392f,
-0.0129803359903073f,
-0.0123420748949298f,
-0.0116991619788734f,
-0.011051937084011f,
-0.0104007413695593f,
-0.00974591713539885f,
-0.00908780764526554f,
-0.00842675694990374f,
-0.00776310971027038f,
-0.00709721102088f,
-0.0064294062333792f,
-0.00576004078043931f,
-0.00508946000005613f,
-0.0044180089603443f,
-0.00374603228491339f,
-0.00307387397891339f,
-0.00240187725583507f,
-0.00173038436515273f,
-0.00105973642089168f,
-0.000390273231208218f,
0.000277666870936983f,
0.000943747195927376f,
0.00160763286437935f,
0.00226899097268967f,
0.00292749075716241f,
0.00358280375663249f,
0.00423460397351205f,
0.00488256803317746f,
0.00552637534162358f,
0.00616570824130806f,
0.00680025216511183f,
0.00742969578834302f,
0.00805373117871052f,
0.0086720539441988f,
0.00928436337877218f,
0.00989036260584077f,
0.010489758719422f,
0.0110822629229305f,
0.0116675906655331f,
0.0122454617760051f,
0.0128156005940267f,
0.0133777360988594f,
0.0139316020353439f,
0.0144769370371622f,
0.015013484747307f,
0.0155409939357074f,
0.0160592186139548f,
0.0165679181470811f,
0.0170668573623377f,
0.0175558066549289f,
0.0180345420906533f,
0.0185028455054086f,
0.0189605046015186f,
0.0194073130408385f,
0.0198430705346032f,
0.0202675829299774f,
0.0206806622932754f,
0.0210821269898129f,
0.0214718017603625f,
0.0218495177941796f,
0.0222151127985721f,
0.0225684310649855f,
0.022909323531581f,
0.023237647842281f,
0.0235532684022619f,
0.0238560564298757f,
0.0241458900049818f,
0.0244226541136733f,
0.0246862406893854f,
0.0249365486503725f,
0.0251734839335446f,
0.0253969595246556f,
0.0256068954848355f,
0.0258032189734641f,
0.0259858642673823f,
0.0261547727764399f,
0.0263098930553838f,
0.0264511808120857f,
0.0265785989121173f,
0.0266921173796785f,
0.0267917133948868f,
0.0268773712874393f,
0.0269490825266584f,
0.0270068457079359f,
0.0270506665355912f,
0.0270805578021602f,
0.0270965393641366f,
0.0270986381141831f,
0.0270868879498387f,
0.027061329738745f,
0.0270220112804172f,
0.0269689872645892f,
0.0269023192261613f,
0.0268220754967821f,
0.0267283311530974f,
0.0266211679617004f,
0.02650067432082f,
0.0263669451987833f,
0.0262200820692939f,
0.0260601928435634f,
0.0258873917993413f,
0.0257017995068857f,
0.0255035427519194f,
0.0252927544556185f,
0.0250695735916822f,
0.0248341451005308f,
0.0245866198006853f,
0.0243271542973778f,
0.0240559108884488f,
0.0237730574675825f,
0.0234787674249386f,
0.0231732195452361f,
0.0228565979033475f,
0.0225290917574612f,
0.0221908954398751f,
0.0218422082454798f,
0.0214832343179955f,
0.0211141825340239f,
0.0207352663849829f,
0.0203467038569849f,
0.0199487173087275f,
0.0195415333474633f,
0.0191253827031149f,
0.0187005001006056f,
0.018267124130473f,
0.0178254971178374f,
0.0173758649897937f,
0.0169184771412997f,
0.0164535862996304f,
0.0159814483874738f,
0.0155023223847373f,
0.0150164701891418f,
0.0145241564756738f,
0.0140256485549719f,
0.0135212162307227f,
0.0130111316561379f,
0.0124956691895912f,
0.0119751052494879f,
0.0114497181684446f,
0.0109197880468538f,
0.0103855966059087f,
0.00984742704016562f,
0.00930556386971926f,
0.00876029279206605f,
0.00821190053373426f,
0.00766067470175299f,
0.00710690363503945f,
0.00655087625577791f,
0.00599288192086684f,
0.0054332102735096f,
0.00487215109502279f,
0.00430999415693893f,
0.00374702907347535f,
0.00318354515444554f,
0.00261983125868588f,
0.00205617564807024f,
0.00149286584218636f,
0.000930188473745678f,
0.000368429144797911f,
-0.000192127716177123f,
-0.00075119899623179f,
-0.00130850303889563f,
-0.00186375978403549f,
-0.00241669090655966f,
-0.00296701995390177f,
-0.00351447248221492f,
-0.00405877619121137f,
-0.00459966105758125f,
-0.00513685946692752f,
-0.00567010634415242f,
-0.00619913928223348f,
-0.00672369866932763f,
-0.00724352781414226f,
-0.00775837306951439f,
-0.00826798395413882f,
-0.0087721132723888f,
-0.00927051723217174f,
-0.00976295556076585f,
-0.0102491916185829f,
-0.010728992510805f,
-0.0112021291968433f,
-0.011668376597568f,
-0.012127513700262f,
-0.0125793236612476f,
-0.0130235939061431f,
-0.0134601162277011f,
-0.0138886868811863f,
-0.01430910667725f,
-0.0147211810722588f,
-0.0151247202560408f,
-0.0155195392370066f,
-0.0159054579246124f,
-0.016282301209127f,
-0.0166498990386691f,
-0.0170080864934834f,
-0.0173567038574233f,
-0.0176955966866107f,
-0.0180246158752456f,
-0.0183436177185377f,
-0.0186524639727363f,
-0.0189510219122339f,
-0.0192391643837213f,
-0.0195167698573758f,
-0.0197837224750605f,
-0.0200399120955206f,
-0.020285234336558f,
-0.0205195906141727f,
-0.0207428881786562f,
-0.0209550401476275f,
-0.0211559655360013f,
-0.0213455892828807f,
-0.0215238422753687f,
-0.021690661369293f,
-0.0218459894068419f,
-0.0219897752311082f,
-0.0221219736975437f,
-0.0222425456823232f,
-0.022351458087623f,
-0.0224486838438175f,
-0.0225342019086017f,
-0.0226079972630452f,
-0.0226700609045897f,
-0.0227203898369986f,
-0.0227589870572723f,
-0.0227858615395437f,
-0.022801028215968f,
-0.022804507954624f,
-0.0227963275344473f,
-0.0227765196172116f,
-0.0227451227165837f,
-0.0227021811642712f,
-0.0226477450732896f,
-0.0225818702983737f,
-0.0225046183935598f,
-0.0224160565669675f,
-0.022316257632811f,
-0.0222052999606713f,
-0.0220832674220598f,
-0.02195024933431f,
-0.02180634040183f,
-0.021651640654752f,
-0.0214862553850185f,
-0.0213102950799412f,
-0.0211238753532741f,
-0.0209271168738413f,
-0.0207201452917622f,
-0.0205030911623162f,
-0.0202760898674933f,
-0.0200392815352739f,
-0.0197928109566856f,
-0.0195368275006853f,
-0.0192714850269128f,
-0.0189969417963675f,
-0.0187133603800582f,
-0.0184209075656767f,
-0.018119754262348f,
-0.0178100754035098f,
-0.0174920498479764f,
-0.0171658602792401f,
-0.016831693103066f,
-0.0164897383434382f,
-0.0161401895369109f,
-0.0157832436254263f,
-0.0154191008476533f,
-0.0150479646289088f,
-0.01467004146972f,
-0.0142855408330878f,
-0.0138946750305117f,
-0.0134976591068377f,
-0.0130947107239892f,
-0.0126860500436456f,
-0.0122718996089275f,
-0.0118524842251538f,
-0.0114280308397327f,
-0.0109987684212487f,
-0.0105649278378112f,
-0.0101267417347275f,
-0.0096844444115627f,
-0.0092382716986541f,
-0.00878846083313997f,
-0.0083352503345707f,
-0.00787887988016375f,
-0.00741959017977004f,
-0.00695762285061262f,
-0.00649322029186454f,
-0.00602662555912889f,
-0.00555808223888623f,
-0.00508783432297227f,
-0.00461612608315054f,
-0.0041432019458434f,
-0.00366930636708469f,
-0.00319468370775774f,
-0.00271957810918098f,
-0.00224423336910424f,
-0.00176889281817742f,
-0.00129379919695379f,
-0.000819194533489142f,
-0.000345320021597831f,
0.000127584100174339f,
0.000599278668799195f,
0.00106952571617924f,
0.00153808858766556f,
0.00200473205962055f,
0.00246922245597072f,
0.00293132776369035f,
0.00339081774716058f,
0.00384746406134855f,
0.00430104036375061f,
0.00475132242504707f,
0.00519808823841396f,
0.00564111812743961f,
0.00608019485259522f,
0.00651510371620631f,
0.00694563266587838f,
0.00737157239632471f,
0.00779271644955021f,
0.00820886131334328f,
0.00861980651802962f,
0.00902535473144288f,
0.00942531185206835f,
0.00981948710031542f,
0.0102076931078787f,
0.0105897460051442f,
0.0109654655066033f,
0.0113346749942337f,
0.0116972015988115f,
0.012052876279115f,
0.0124015338989891f,
0.0127430133022313f,
0.013077157385271f,
0.0134038131676064f,
0.0137228318599706f,
0.014034068930197f,
0.0143373841667557f,
0.014632641739935f,
0.01491971026064f,
0.0151984628367875f,
0.0154687771272713f,
0.0157305353934762f,
0.0159836245483238f,
0.0162279362028256f,
0.01646336671013f,
0.0166898172070445f,
0.0169071936530183f,
0.0171154068665722f,
0.0173143725591621f,
0.0175040113664656f,
0.0176842488770823f,
0.0178550156586383f,
0.0180162472812887f,
0.018167884338611f,
0.018309872465887f,
0.0184421623557679f,
0.0185647097713225f,
0.0186774755564665f,
0.0187804256437758f,
0.0188735310596837f,
0.0189567679270676f,
0.019030117465229f,
0.0190935659872729f,
0.0191471048948949f,
0.0191907306705839f,
0.0192244448672514f,
0.0192482540952976f,
0.0192621700071291f,
0.0192662092791391f,
0.0192603935911679f,
0.0192447496034598f,
0.0192193089311318f,
0.0191841081161767f,
0.0191391885970174f,
0.0190845966756357f,
0.0190203834822978f,
0.0189466049378991f,
0.0188633217139549f,
0.0187705991902617f,
0.0186685074102565f,
0.0185571210341025f,
0.0184365192895309f,
0.0183067859204682f,
0.0181680091334815f,
0.0180202815420732f,
0.0178637001088602f,
0.0176983660856705f,
0.0175243849515933f,
0.0173418663490196f,
0.01715092401771f,
0.016951675726928f,
0.016744243205679f,
0.0165287520710933f,
0.016305331754996f,
0.0160741154287042f,
0.0158352399260948f,
0.0155888456649855f,
0.0153350765668743f,
0.0150740799750811f,
0.0148060065713377f,
0.0145310102908722f,
0.0142492482360351f,
0.0139608805885139f,
0.0136660705201842f,
0.0133649841026483f,
0.0130577902155067f,
0.0127446604534163f,
0.0124257690319824f,
0.0121012926925373f,
0.0117714106058561f,
0.0114363042748611f,
0.0110961574363676f,
0.010751155961922f,
0.0104014877577871f,
0.0100473426641261f,
0.00968891235343915f,
0.00932639022830554f,
0.00895997131848668f,
0.00858985217744296f,
0.00821623077831776f,
0.00783930640944577f,
0.00745927956943648f,
0.00707635186189118f,
0.00669072588980389f,
0.00630260514970595f,
0.00591219392560345f,
0.00551969718276637f,
0.00512532046142244f,
0.00472926977040892f,
0.00433175148083997f,
0.0039329722198398f,
0.00353313876439927f,
0.00313245793540826f,
0.00273113649191582f,
0.00232938102567641f,
0.00192739785602901f,
0.00152539292516795f,
0.00112357169385325f,
0.000722139037616026f,
0.000321299143509566f,
-7.87445925439102e-05f,
-0.000477789667756481f,
-0.000875634573781077f,
-0.00127207889726798f,
-0.00166692341962379f,
-0.00205997021592246f,
-0.0024510227529216f,
-0.00283988598613406f,
-0.00322636645590846f,
-0.00361027238247303f,
-0.00399141375989388f,
-0.00436960244890573f,
-0.00474465226856735f,
-0.00511637908669945f,
-0.00548460090906132f,
-0.00584913796722293f,
-0.00620981280509261f,
-0.00656645036405622f,
-0.00691887806669127f,
-0.00726692589901343f,
-0.0076104264912184f,
-0.0079492151968822f,
-0.00828313017058056f,
-0.00861201244389523f,
-0.00893570599976737f,
-0.00925405784516927f,
-0.00956691808205708f,
-0.00987413997657404f,
-0.0101755800264738f,
-0.0104710980267317f,
-0.0107605571333162f,
-0.011043823925092f,
-0.0113207684638271f,
-0.0115912643522783f,
-0.0118551887903295f,
-0.012112422629159f,
-0.0123628504234125f,
-0.0126063604813613f,
-0.0128428449130214f,
-0.0130721996762183f,
-0.0132943246205751f,
-0.0135091235294078f,
-0.0137165041595128f,
-0.013916378278827f,
-0.0141086617019519f,
-0.014293274323524f,
-0.0144701401494217f,
-0.014639187325798f,
-0.0148003481659278f,
-0.0149535591748634f,
-0.0150987610718883f,
-0.0152358988107658f,
-0.0153649215977745f,
-0.015485782907529f,
-0.0155984404965815f,
-0.0157028564148031f,
-0.0157989970145448f,
-0.0158868329575775f,
-0.0159663392198137f,
-0.0160374950938136f,
-0.016100284189079f,
-0.0161546944301414f,
-0.0162007180524483f,
-0.0162383515960573f,
-0.0162675958971449f,
-0.0162884560773407f,
-0.0163009415308957f,
-0.0163050659096987f,
-0.0163008471061524f,
-0.0162883072339218f,
-0.016267472606573f,
-0.0162383737141145f,
-0.0162010451974609f,
-0.0161555258208357f,
-0.0161018584421317f,
-0.0160400899812505f,
-0.0159702713864408f,
-0.0158924575986573f,
-0.0158067075139647f,
-0.0157130839440085f,
-0.0156116535745792f,
-0.0155024869222945f,
-0.015385658289426f,
-0.0152612457168996f,
-0.015129330935495f,
-0.0149899993152762f,
-0.0148433398132821f,
-0.0146894449195071f,
-0.0145284106012046f,
-0.0143603362455461f,
-0.0141853246006673f,
-0.014003481715137f,
-0.0138149168758828f,
-0.0136197425446085f,
-0.0134180742927402f,
-0.013210030734937f,
-0.0129957334612042f,
-0.0127753069676474f,
-0.0125488785859041f,
-0.0123165784112954f,
-0.0120785392297338f,
-0.0118348964434313f,
-0.0115857879954438f,
-0.0113313542930995f,
-0.0110717381303458f,
-0.0108070846090634f,
-0.0105375410593866f,
-0.0102632569590728f,
-0.009984383851968f,
-0.00970107526560753f,
-0.00941348662799972f,
-0.00912177518363594f,
-0.00882609990877025f,
-0.00852662142601712f,
-0.0082235019183083f,
-0.00791690504225832f,
-0.00760699584098105f,
-0.00729394065640554f,
-0.00697790704113637f,
-0.00665906366990342f,
-0.00633758025065011f,
-0.00601362743530315f,
-0.00568737673027296f,
-0.0053590004067294f,
-0.0050286714107004f,
-0.00469656327303836f,
-0.00436285001930248f,
-0.0040277060796026f,
-0.00369130619844927f,
-0.0033538253446594f,
-0.00301543862135968f,
-0.00267632117613655f,
-0.00233664811137679f,
-0.00199659439484433f,
-0.00165633477053924f,
-0.00131604366988201f,
-0.000975895123270568f,
-0.000636062672051198f,
-0.000296719280950014f,
4.19627489923029e-05f,
0.000379811866940294f,
0.000716657358192284f,
0.00105232942947911f,
0.00138665929358587f,
0.00171947925326048f,
0.00205062278436349f,
0.00237992461822022f,
0.00270722082313579f,
0.00303234888503091f,
0.0033551477871623f,
0.00367545808888596f,
0.00399312200342837f,
0.00430798347462561f,
0.00461988825259516f,
0.00492868396830372f,
0.00523422020699499f,
0.00553634858044424f,
0.00583492279800283f,
0.00612979873640211f,
0.00642083450828168f,
0.00670789052941064f,
0.00699082958457223f,
0.00726951689207744f,
0.00754382016688266f,
0.00781360968227803f,
0.0080787583301217f,
0.00833914167959037f,
0.00859463803442024f,
0.00884512848861381f,
0.0090904969805854f,
0.00933063034572383f,
0.00956541836734724f,
0.00979475382602877f,
0.0100185325472712f,
0.0102366534475113f,
0.010449018578432f,
0.0106555331695659f,
0.0108561056691723f,
0.0110506477833682f,
0.0112390745135014f,
0.0114213041917481f,
0.0115972585149209f,
0.0117668625764763f,
0.0119300448967067f,
0.012086737451109f,
0.0122368756969161f,
0.0123803985977855f,
0.0125172486466337f,
0.0126473718866118f,
0.0127707179302138f,
0.0128872399765134f,
0.0129968948265257f,
0.0130996428966874f,
0.0131954482304574f,
0.0132842785080317f,
0.0133661050541769f,
0.0134409028441778f,
0.013508650507905f,
0.0135693303320019f,
0.0136229282601955f,
0.0136694338917359f,
0.0137088404779684f,
0.0137411449170453f,
0.0137663477467848f,
0.013784453135684f,
0.013795468872096f,
0.0137994063515803f,
0.0137962805624378f,
0.0137861100694423f,
0.0137689169957797f,
0.0137447270032108f,
0.0137135692704695f,
0.0136754764699141f,
0.0136304847424457f,
0.0135786336707118f,
0.013519966250613f,
0.0134545288611308f,
0.0133823712324961f,
0.0133035464127194f,
0.0132181107325022f,
0.0131261237685533f,
0.0130276483053306f,
0.0129227502952339f,
0.0128114988172705f,
0.01269396603422f,
0.0125702271483237f,
0.0124403603555234f,
0.0123044467982785f,
0.0121625705169872f,
0.0120148184000414f,
0.0118612801325425f,
0.0117020481437095f,
0.0115372175530078f,
0.0113668861150299f,
0.01119115416316f,
0.0110101245520525f,
0.0108239025989582f,
0.0106325960239306f,
0.0104363148889449f,
0.0102351715359648f,
0.0100292805239893f,
0.0098187585651169f,
0.00960372445965929f,
0.00938429903034274f,
0.00916060505563078f,
0.00893276720220603f,
0.00870091195664717f,
0.00846516755633744f,
0.00822566391964303f,
0.00798253257539762f,
0.00773590659173174f,
0.0074859205042846f,
0.0072327102438365f,
0.00697641306340084f,
0.00671716746481301f,
0.00645511312485713f,
0.00619039082096706f,
0.00592314235654277f,
0.00565351048592053f,
0.00538163883903519f,
0.00510767184581618f,
0.00483175466035329f,
0.0045540330848758f,
0.00427465349357983f,
0.0039937627563468f,
0.00371150816239089f,
0.00342803734387407f,
0.00314349819952992f,
0.00285803881833284f,
0.00257180740325433f,
0.00228495219514193f,
0.00199762139676367f,
0.00170996309705199f,
0.00142212519558895f,
0.00113425532736956f,
0.000846500787880119f,
0.000559008458531536f,
0.000271924732482214f,
-1.46045591101362e-05f,
-0.000300434220371862f,
-0.000585419763496916f,
-0.00086941748099089f,
-0.00115228451734445f,
-0.00143387894009652f,
-0.00171405981025575f,
-0.00199268725204318f,
-0.00226962252192313f,
-0.0025447280768894f,
-0.0028178676419714f,
-0.00308890627693019f,
-0.00335771044210987f,
-0.00362414806341412f,
-0.00388808859637569f,
-0.00414940308928949f,
-0.00440796424537761f,
-0.0046636464839576f,
-0.00491632600058568f,
-0.00516588082614467f,
-0.00541219088485123f,
-0.00565513805115323f,
-0.00589460620549209f,
-0.00613048128890367f,
-0.00636265135643233f,
-0.00659100662933489f,
-0.00681543954604841f,
-0.00703584481190112f,
-0.00725211944754226f,
-0.00746416283606952f,
-0.00767187676883409f,
-0.00787516548990105f,
-0.00807393573914805f,
-0.00826809679398036f,
-0.00845756050964779f,
-0.0086422413581431f,
-0.00882205646566693f,
-0.00899692564864383f,
-0.00916677144827267f,
-0.00933151916359955f,
-0.00949109688309758f,
-0.00964543551474288f,
-0.00979446881457346f,
-0.00993813341372092f,
-0.0100763688439045f,
-0.010209117561378f,
-0.0103363249693214f,
-0.0104579394386686f,
-0.0105739123273658f,
-0.0106841979980529f,
-0.0107887538341635f,
-0.0108875402544387f,
-0.0109805207258519f,
-0.0110676617749403f,
-0.0111489329975425f,
-0.0112243070669403f,
-0.0112937597404047f,
-0.0113572698641464f,
-0.0114148193766721f,
-0.0114663933105489f,
-0.0115119797925796f,
-0.0115515700423923f,
-0.0115851583694502f,
-0.0116127421684842f,
-0.011634321913358f,
-0.0116499011493693f,
-0.0116594864839974f,
-0.0116630875761036f,
-0.0116607171235953f,
-0.0116523908495633f,
-0.0116381274869016f,
-0.0116179487614245f,
-0.01159187937349f,
-0.011559946978144f,
-0.0115221821637997f,
-0.0114786184294646f,
-0.0114292921605328f,
-0.0113742426031564f,
-0.0113135118372135f,
-0.0112471447478901f,
-0.0111751889958936f,
-0.0110976949863162f,
-0.0110147158361677f,
-0.010926307340598f,
-0.0108325279378291f,
-0.0107334386728173f,
-0.010629103159669f,
-0.0105195875428304f,
-0.010404960457075f,
-0.0102852929863125f,
-0.0101606586212424f,
-0.0100311332158768f,
-0.00989679494295863f,
-0.0097577242482986f,
-0.00961400380405963f,
-0.00946571846101251f,
-0.00931295519979207f,
-0.00915580308117954f,
-0.00899435319544003f,
-0.00882869861074312f,
-0.00865893432069448f,
-0.00848515719100898f,
-0.00830746590535331f,
-0.00812596091038898f,
-0.00794074436004472f,
-0.00775192005904976f,
-0.00755959340575842f,
-0.00736387133429605f,
-0.00716486225605968f,
-0.00696267600060248f,
-0.00675742375593618f,
-0.00654921800828116f,
-0.00633817248129907f,
-0.00612440207483747f,
-0.00590802280322156f,
-0.00568915173312446f,
-0.00546790692104879f,
-0.00524440735045367f,
-0.00501877286855874f,
-0.00479112412285956f,
-0.00456158249738753f,
-0.00433027004874617f,
-0.00409730944195998f,
-0.00386282388616572f,
-0.00362693707018273f,
-0.00338977309799299f,
-0.003151456424166f,
-0.0029121117892613f,
-0.00267186415524059f,
-0.00243083864092491f,
-0.00218916045752725f,
-0.00194695484429555f,
-0.00170434700429766f,
-0.00146146204038147f,
-0.0012184248913417f,
-0.000975360268326886f,
-0.000732392591517812f,
-0.000489645927108687f,
-0.000247243924624318f,
-5.30975460243513e-06f,
0.000236033953325795f,
0.000476665171927516f,
0.000716462537401301f,
0.000955305409921098f,
0.00119307393366231f,
0.00142964909627861f,
0.00166491278780243f,
0.00189874785893866f,
0.00213103817872366f,
0.00236166869152247f,
0.00259052547333456f,
0.00281749578738374f,
0.00304246813896196f,
0.00326533232950441f,
0.00348597950986719f,
0.00370430223278326f,
0.00392019450447253f,
0.00413355183537976f,
0.00434427129001857f,
0.00455225153589615f,
0.00475739289149763f,
0.00495959737330628f,
0.00515876874183869f,
0.00535481254667346f,
0.00554763617045255f,
0.00573714887183583f,
0.00592326182738836f,
0.00610588817238264f,
0.0062849430404968f,
0.00646034360239086f,
0.0066320091031453f,
0.00679986089854376f,
0.00696382249018553f,
0.00712381955941148f,
0.00727978000003043f,
0.00743163394983033f,
0.00757931382086227f,
0.00772275432848474f,
0.00786189251915527f,
0.00799666779695974f,
0.00812702194886731f,
0.00825289916870263f,
0.00837424607982448f,
0.00849101175650416f,
0.0086031477439945f,
0.00871060807728278f,
0.00881334929852171f,
0.00891133047313174f,
0.00900451320457065f,
0.00909286164776552f,
0.00917634252120344f,
0.00925492511767886f,
0.00932858131369381f,
0.00939728557751129f,
0.00946101497585938f,
0.00951974917928708f,
0.00957347046617182f,
0.00962216372537994f,
0.00966581645758253f,
0.00970441877522852f,
0.009737963401179f,
0.00976644566600632f,
0.0097898635039628f,
0.00980821744762438f,
0.00982151062121513f,
0.00982974873261936f,
0.00983294006408858f,
0.00983109546165142f,
0.00982422832323481f,
0.00981235458550606f,
0.00979549270944552f,
0.00977366366466025f,
0.00974689091245019f,
0.00971520038763806f,
0.00967862047917592f,
0.00963718200954081f,
0.00959091821293355f,
0.00953986471229418f,
0.00948405949514948f,
0.00942354288830723f,
0.00935835753141334f,
0.00928854834938809f,
0.00921416252375845f,
0.0091352494629039f,
0.0090518607712336f,
0.00896405021731353f,
0.00887187370096227f,
0.0087753892193352f,
0.00867465683201655f,
0.00856973862514042f,
0.0084606986745602f,
0.00834760300808965f,
0.00823051956683513f,
0.00810951816564266f,
0.00798467045268168f,
0.00785604986818808f,
0.00772373160239066f,
0.00758779255264339f,
0.00744831127978855f,
0.00730536796377458f,
0.00715904435855267f,
0.00700942374627865f,
0.00685659089084313f,
0.00670063199075772f,
0.00654163463142106f,
0.00637968773679228f,
0.00621488152049734f,
0.00604730743639451f,
0.00587705812862679f,
0.00570422738118674f,
0.00552891006702204f,
0.00535120209670837f,
0.00517120036671732f,
0.00498900270730639f,
0.00480470783005945f,
0.00461841527510535f,
0.00443022535804147f,
0.00424023911659229f,
0.00404855825702851f,
0.00385528510037713f,
0.00366052252844892f,
0.00346437392971236f,
0.0032669431450421f,
0.00306833441336933f,
0.00286865231726372f,
0.00266800172847322f,
0.00246648775345124f,
0.00226421567889881f,
0.00206129091734865f,
0.001857818952821f,
0.00165390528657631f,
0.00144965538299551f,
0.00124517461561208f,
0.00104056821332573f,
0.000835941206823879f,
0.000631398375237409f,
0.000427044193058939f,
0.000222982777348388f,
1.93178352541884e-05f,
-0.000183847388125652f,
-0.000386410161515063f,
-0.000588268318839344f,
-0.000789320310186792f,
-0.000989465252327088f,
-0.00118860297876263f,
-0.00138663408928657f,
-0.00158345999902536f,
-0.00177898298694016f,
-0.00197310624376432f,
-0.00216573391935424f,
-0.00235677116942952f,
-0.00254612420168104f,
-0.00273370032122396f,
-0.00291940797537506f,
-0.00310315679773186f,
-0.00328485765153321f,
-0.00346442267228144f,
-0.00364176530960462f,
-0.00381680036834099f,
-0.00398944404882473f,
-0.00415961398635617f,
-0.00432722928983605f,
-0.00449221057954843f,
-0.00465448002407309f,
-0.0048139613763114f,
-0.00497058000860979f,
-0.00512426294696376f,
-0.0052749389042889f,
-0.00542253831274242f,
-0.00556699335508204f,
-0.00570823799504863f,
-0.00584620800675817f,
-0.00598084100309234f,
-0.00611207646307367f,
-0.00623985575821544f,
-0.00636412217783413f,
-0.00648482095331432f,
-0.00660189928131711f,
-0.00671530634592089f,
-0.00682499333968802f,
-0.00693091348364723f,
-0.00703302204618568f,
-0.00713127636084265f,
-0.00722563584299943f,
-0.00731606200545875f,
-0.00740251847290887f,
-0.007484970995268f,
-0.00756338745990427f,
-0.00763773790272864f,
-0.00770799451815706f,
-0.00777413166794024f,
-0.00783612588885893f,
-0.00789395589928373f,
-0.00794760260459901f,
-0.00799704910149072f,
-0.00804228068109908f,
-0.00808328483103711f,
-0.00812005123627679f,
-0.00815257177890557f,
-0.00818084053675577f,
-0.00820485378091061f,
-0.00822460997209095f,
-0.0082401097559274f,
-0.008251355957123f,
-0.00825835357251226f,
-0.00826110976302289f,
-0.00825963384454712f,
-0.00825393727773002f,
-0.00824403365668277f,
-0.00822993869662941f,
-0.0082116702204961f,
-0.00818924814445231f,
-0.00816269446241429f,
-0.00813203322952095f,
-0.00809729054459371f,
-0.00805849453159143f,
-0.0080156753200729f,
-0.00796886502467894f,
-0.0079180977236477f,
-0.00786340943637592f,
-0.00780483810004095f,
-0.00774242354529683f,
-0.0076762074710605f,
-0.00760623341840202f,
-0.00753254674355573f,
-0.00745519459006761f,
-0.00737422586009549f,
-0.00728969118487935f,
-0.00720164289439836f,
-0.00711013498623295f,
-0.00701522309364934f,
-0.00691696445292533f,
-0.00681541786993564f,
-0.0067106436860163f,
-0.00660270374312707f,
-0.00649166134833156f,
-0.00637758123761547f,
-0.0062605295390625f,
-0.00614057373540916f,
-0.00601778262599883f,
-0.0058922262881563f,
-0.00576397603800424f,
-0.00563310439074258f,
-0.00549968502041355f,
-0.00536379271917322f,
-0.00522550335609256f,
-0.00508489383551021f,
-0.00494204205495889f,
-0.00479702686268925f,
-0.00464992801481257f,
-0.00450082613208717f,
-0.00434980265636944f,
-0.00419693980675458f,
-0.00404232053542953f,
-0.00388602848326118f,
-0.00372814793514442f,
-0.00356876377513224f,
-0.00340796144137294f,
-0.00324582688087654f,
-0.00308244650413554f,
-0.00291790713962266f,
-0.00275229598818971f,
-0.00258570057739144f,
-0.00241820871575722f,
-0.00224990844703554f,
-0.00208088800443331f,
-0.00191123576487488f,
-0.00174104020330362f,
-0.00157038984704899f,
-0.00139937323028345f,
-0.0012280788485914f,
-0.00105659511367404f,
-0.000885010308212022f,
-0.000713412540909905f,
-0.000541889701744389f,
-0.000370529417438411f,
-0.000199419007184688f,
-2.86454386391724e-05f,
0.000141704715791932f,
0.000311545322351528f,
0.000480790728994517f,
0.000649355808093498f,
0.000817155998766742f,
0.000984107348806231f,
0.00115012655618751f,
0.00131513101013779f,
0.00147903883174615f,
0.00164176891409281f,
0.00180324096188044f,
0.00196337553054684f,
0.00212209406484084f,
0.00227931893684354f,
0.00243497348341522f,
0.00258898204305202f,
0.00274126999213338f,
0.00289176378054382f,
0.00304039096665289f,
0.00318708025163551f,
0.00333176151311843f,
0.00347436583813595f,
0.00361482555538014f,
0.00375307426673132f,
0.00388904687805323f,
0.00402267962924054f,
0.00415391012350339f,
0.00428267735587738f,
0.00440892174094537f,
0.00453258513975951f,
0.00465361088595093f,
0.00477194381101678f,
0.0048875302687727f,
0.00500031815896078f,
0.00511025695000341f,
0.00521729770089245f,
0.005321393082206f,
0.00542249739624305f,
0.00552056659626851f,
0.00561555830486112f,
0.00570743183135652f,
0.00579614818837955f,
0.00588167010745905f,
0.00596396205371965f,
0.00604299023964567f,
0.006118722637912f,
0.0061911289932778f,
0.00626018083353982f,
0.00632585147954145f,
0.00638811605423505f,
0.00644695149079577f,
0.0065023365397841f,
0.00655425177535714f,
0.00660267960052678f,
0.00664760425146518f,
0.00668901180085765f,
0.00672689016030345f,
0.00676122908176597f,
0.00679202015807388f,
0.0068192568224754f,
0.00684293434724847f,
0.00686304984136987f,
0.00687960224724698f,
0.00689259233651608f,
0.00690202270491214f,
0.00690789776621478f,
0.00691022374527592f,
0.00690900867013539f,
0.00690426236323048f,
0.00689599643170657f,
0.00688422425683606f,
0.00686896098255334f,
0.00685022350311395f,
0.00682803044988654f,
0.00680240217728674f,
0.00677336074786232f,
0.00674092991653943f,
0.00670513511404041f,
0.00666600342948348f,
0.00662356359217583f,
0.00657784595261114f,
0.00652888246268357f,
0.00647670665513047f,
0.00642135362221613f,
0.00636285999366974f,
0.00630126391389078f,
0.00623660501843537f,
0.00616892440979761f,
0.00609826463250009f,
0.00602466964750847f,
0.0059481848059844f,
0.00586885682239295f,
0.00578673374697901f,
0.00570186493762922f,
0.00561430103113523f,
0.00552409391387439f,
0.00543129669192503f,
0.0053359636606324f,
0.00523815027364322f,
0.00513791311142525f,
0.00503530984929013f,
0.00493039922493699f,
0.00482324100553433f,
0.00471389595435921f,
0.00460242579701116f,
0.00448889318721966f,
0.0043733616722642f,
0.00425589565802507f,
0.004136560373684f,
0.00401542183609403f,
0.00389254681383765f,
0.00376800279099204f,
0.00364185793062176f,
0.00351418103801726f,
0.00338504152369975f,
0.00325450936621163f,
0.00312265507471182f,
0.00298954965139679f,
0.00285526455376563f,
0.00271987165675057f,
0.00258344321473122f,
0.00244605182345363f,
0.00230777038187339f,
0.0021686720539424f,
0.00202883023036007f,
0.00188831849030696f,
0.00174721056318321f,
0.00160558029036844f,
0.00146350158702526f,
0.00132104840396418f,
0.00117829468959045f,
0.0010353143519519f,
0.000892181220906407f,
0.000748969010429438f,
0.000605751281079199f,
0.000462601402639519f,
0.000319592516958703f,
0.000176797501002549f,
3.42889301410701e-05f,
-0.000107860958314117f,
-0.000249580301302546f,
-0.000390797645920318f,
-0.000531441985020898f,
-0.000671442792492635f,
-0.000810730058197295f,
-0.000949234322550692f,
-0.00108688671073022f,
-0.00122361896649147f,
-0.00135936348557853f,
-0.00149405334871076f,
-0.00162762235413137f,
-0.00176000504970118f,
-0.00189113676452272f,
-0.00202095364007996f,
-0.00214939266087792f,
-0.00227639168456902f,
-0.0024018894715508f,
-0.00252582571402182f,
-0.00264814106448246f,
-0.0027687771636664f,
-0.00288767666789124f,
-0.00300478327581456f,
-0.00312004175458374f,
-0.00323339796536792f,
-0.00334479888826015f,
-0.00345419264653828f,
-0.00356152853027509f,
-0.00366675701928568f,
-0.00376982980540297f,
-0.00387069981407155f,
-0.00396932122525004f,
-0.00406564949361391f,
-0.00415964136804923f,
-0.0042512549104298f,
-0.00434044951367f,
-0.00442718591904523f,
-0.00451142623277396f,
-0.00459313394185402f,
-0.00467227392914711f,
-0.00474881248770633f,
-0.00482271733434035f,
-0.0048939576224102f,
-0.00496250395385362f,
-0.00502832839043273f,
-0.00509140446420189f,
-0.00515170718719161f,
-0.00520921306030623f,
-0.0052639000814326f,
-0.00531574775275781f,
-0.00536473708729396f,
-0.00541085061460937f,
-0.00545407238576448f,
-0.00549438797745298f,
-0.00553178449534731f,
-0.00556625057664943f,
-0.00559777639184753f,
-0.00562635364567969f,
-0.00565197557730641f,
-0.00567463695969378f,
-0.00569433409820979f,
-0.00571106482843655f,
-0.00572482851320177f,
-0.00573562603883286f,
-0.00574345981063785f,
-0.00574833374761739f,
-0.00575025327641265f,
-0.00574922532449426f,
-0.00574525831259774f,
-0.00573836214641151f,
-0.00572854820752344f,
-0.00571582934363289f,
-0.00570021985803501f,
-0.00568173549838472f,
-0.00566039344474815f,
-0.00563621229694942f,
-0.00560921206122126f,
-0.00557941413616825f,
-0.00554684129805166f,
-0.00551151768540502f,
-0.00547346878299081f,
-0.00543272140510751f,
-0.00538930367825778f,
-0.00534324502318837f,
-0.00529457613631248f,
-0.00524332897052591f,
-0.00518953671542864f,
-0.00513323377696331f,
-0.00507445575648276f,
-0.00501323942925908f,
-0.00494962272244652f,
-0.0048836446925111f,
-0.00481534550214016f,
-0.00474476639664476f,
-0.00467194967986881f,
-0.00459693868961849f,
-0.00451977777262569f,
-0.00444051225906017f,
-0.00435918843660394f,
-0.00427585352410332f,
-0.0041905556448125f,
-0.00410334379924412f,
-0.00401426783764162f,
-0.00392337843208837f,
-0.00383072704826952f,
-0.00373636591690094f,
-0.0036403480048426f,
-0.00354272698590992f,
-0.00344355721140095f,
-0.00334289368035381f,
-0.00324079200955149f,
-0.00313730840328953f,
-0.00303249962292274f,
-0.00292642295620788f,
-0.0028191361864577f,
-0.00271069756152356f,
-0.00260116576262272f,
-0.00249059987302637f,
-0.00237905934662593f,
-0.00226660397639285f,
-0.00215329386274949f,
-0.00203918938186721f,
-0.00192435115390781f,
-0.00180884001122575f,
-0.00169271696654636f,
-0.00157604318113799f,
-0.00145887993299307f,
-0.00134128858503559f,
-0.00122333055337023f,
-0.00110506727559064f,
-0.000986560179161664f,
-0.000867870649892684f,
-0.000749060000517654f,
-0.000630189439397319f,
-0.000511320039360377f,
-0.000392512706698102f,
-0.000273828150328942f,
-0.000155326851148112f,
-3.70690315771188e-05f,
8.08853746707291e-05f,
0.000198476752594946f,
0.000315645835666874f,
0.000432333735328773f,
0.000548481970218808f,
0.000664032495107181f,
0.000778927729529055f,
0.000893110586101436f,
0.00100652449850903f,
0.0011191134491462f,
0.00123082199640187f,
0.00134159530157362f,
0.001451379155399f,
0.00156012000419063f,
0.00166776497556304f,
0.00177426190373947f,
0.00187955935442585f,
0.00198360664924134f,
0.00208635388969324f,
0.00218775198068548f,
0.00228775265355017f,
0.00238630848859078f,
0.00248337293712777f,
0.00257890034303573f,
0.00267284596376264f,
0.0027651659908224f,
0.00285581756975022f,
0.00294475881951347f,
0.00303194885136837f,
0.00311734778715523f,
0.00320091677702331f,
0.00328261801657889f,
0.00336241476344813f,
0.00344027135324884f,
0.00351615321496371f,
0.00359002688570914f,
0.00366186002489375f,
0.00373162142776056f,
0.00379928103830807f,
0.00386480996158482f,
0.00392818047535296f,
0.00398936604111683f,
0.00404834131451196f,
0.00410508215505164f,
0.00415956563522717f,
0.00421177004895933f,
0.00426167491939793f,
0.00430926100606804f,
0.00435451031136012f,
0.00439740608636304f,
0.00443793283603874f,
0.00447607632373735f,
0.00451182357505271f,
0.00454516288101758f,
0.00457608380063932f,
0.00460457716277593f,
0.00463063506735364f,
0.00465425088592729f,
0.00467541926158465f,
0.00469413610819695f,
0.00471039860901749f,
0.00472420521463094f,
0.00473555564025633f,
0.00474445086240651f,
0.00475089311490802f,
0.00475488588428478f,
0.00475643390451008f,
0.00475554315113093f,
0.00475222083476989f,
0.00474647539400919f,
0.0047383164876626f,
0.0047277549864407f,
0.00471480296401554f,
0.00469947368749088f,
0.00468178160728458f,
0.00466174234643012f,
0.00463937268930397f,
0.00461469056978683f,
0.00458771505886558f,
0.00455846635168474f,
0.0045269657540549f,
0.00449323566842705f,
0.00445729957934127f,
0.00441918203835878f,
0.00437890864848652f,
0.00433650604810388f,
0.00429200189440092f,
0.00424542484633809f,
0.00419680454713777f,
0.00414617160631751f,
0.00409355758127593f,
0.0040389949584418f,
0.0039825171339971f,
0.00392415839418544f,
0.00386395389521697f,
0.00380193964278122f,
0.00373815247117977f,
0.00367263002209005f,
0.00360541072297291f,
0.00353653376513537f,
0.00346603908146142f,
0.00339396732382295f,
0.00332035984018316f,
0.00324525865140576f,
0.00316870642778174f,
0.00309074646528777f,
0.00301142266158806f,
0.00293077949179369f,
0.00284886198399182f,
0.00276571569455874f,
0.0026813866832694f,
0.0025959214882174f,
0.00250936710055862f,
0.00242177093909173f,
0.00233318082468987f,
0.00224364495459622f,
0.00215321187659778f,
0.00206193046309074f,
0.00196984988505084f,
0.00187701958592308f,
0.00178348925544365f,
0.00168930880340844f,
0.00159452833340149f,
0.00149919811649696f,
0.00140336856494826f,
0.0013070902058786f,
0.00121041365498514f,
0.00111338959027166f,
0.00101606872582252f,
0.000918501785631088f,
0.000820739477496859f,
0.000722832467003396f,
0.00062483135159124f,
0.000526786634738467f,
0.000428748700261665f,
0.000330767786750949f,
0.000232893962150942f,
0.000135177098501165f,
3.76668468481058e-05f,
-5.95873876588744e-05f,
-0.00015653647047473f,
-0.000253131562157722f,
-0.00034932414264742f,
-0.000445066035310076f,
-0.000540309430740104f,
-0.000635006910305014f,
-0.000729111469423506f,
-0.000822576540564631f,
-0.000915356015957641f,
-0.00100740427000084f,
-0.00109867618135962f,
-0.00118912715474223f,
-0.00127871314234389f,
-0.00136739066494837f,
-0.00145511683267735f,
-0.00154184936537829f,
-0.00162754661264048f,
-0.00171216757343079f,
-0.00179567191533962f,
-0.00187801999342816f,
-0.00195917286866889f,
-0.0020390923259702f,
-0.00211774089177778f,
-0.00219508185124424f,
-0.00227107926495982f,
-0.00234569798523625f,
-0.00241890367193749f,
-0.00249066280784943f,
-0.00256094271358263f,
-0.00262971156200169f,
-0.00269693839217459f,
-0.00276259312283698f,
-0.00282664656536508f,
-0.00288907043625251f,
-0.00294983736908551f,
-0.00300892092601204f,
-0.00306629560870053f,
-0.00312193686878331f,
-0.00317582111778178f,
-0.00322792573650879f,
-0.00327822908394536f,
-0.00332671050558862f,
-0.00337335034126783f,
-0.00341812993242641f,
-0.00346103162886747f,
-0.00350203879496073f,
-0.00354113581530953f,
-0.00357830809987641f,
-0.00361354208856589f,
-0.00364682525526395f,
-0.00367814611133359f,
-0.00370749420856603f,
-0.00373486014158784f,
-0.0037602355497241f,
-0.00378361311831824f,
-0.00380498657950949f,
-0.00382435071246891f,
-0.00384170134309564f,
-0.00385703534317483f,
-0.00387035062899941f,
-0.00388164615945781f,
-0.00389092193359018f,
-0.00389817898761587f,
-0.00390341939143523f,
-0.00390664624460901f,
-0.00390786367181894f,
-0.00390707681781324f,
-0.00390429184184127f,
-0.00389951591158146f,
-0.00389275719656734f,
-0.0038840248611162f,
-0.00387332905676573f,
-0.00386068091422367f,
-0.00384609253483634f,
-0.0038295769815814f,
-0.00381114826959134f,
-0.00379082135621343f,
-0.00376861213061302f,
-0.00374453740292646f,
-0.00371861489297091f,
-0.00369086321851783f,
-0.00366130188313755f,
-0.00362995126362248f,
-0.00359683259699653f,
-0.00356196796711878f,
-0.00352538029088928f,
-0.00348709330406542f,
-0.00344713154669716f,
-0.00340552034818985f,
-0.00336228581200324f,
-0.00331745479999584f,
-0.0032710549164236f,
-0.00322311449160199f,
-0.00317366256524133f,
-0.00312272886946436f,
-0.00307034381151609f,
-0.00301653845617577f,
-0.00296134450788043f,
-0.00290479429257074f,
-0.00284692073926871f,
-0.00278775736139795f,
-0.00272733823785673f,
-0.0026656979938541f,
-0.00260287178151994f,
-0.00253889526029965f,
-0.00247380457714373f,
-0.00240763634650355f,
-0.00234042763014414f,
-0.00227221591678448f,
-0.00220303910157702f,
-0.00213293546543682f,
-0.00206194365423175f,
-0.00199010265784497f,
-0.00191745178912041f,
-0.00184403066270314f,
-0.00176987917378505f,
-0.0016950374767678f,
-0.00161954596385396f,
-0.00154344524357734f,
-0.0014667761192845f,
-0.00138957956757772f,
-0.00131189671673157f,
-0.00123376882509378f,
-0.00115523725948149f,
-0.00107634347358468f,
-0.000997128986387144f,
-0.000917635360616649f,
-0.000837904181234896f,
-0.000757977033978788f,
-0.000677895483963236f,
-0.000597701054357152f,
-0.00051743520514265f,
-0.000437139311968778f,
-0.00035685464511021f,
-0.000276622348541154f,
-0.000196483419135613f,
-0.00011647868600357f,
-3.66487899740423e-05f,
4.29658367651342e-05f,
0.000122324990860947f,
0.000201388717811738f,
0.000280117331797545f,
0.000358471435313893f,
0.000436411938600041f,
0.000513900078851591f,
0.000590897439209056f,
0.000667365967512407f,
0.000743267994812951f,
0.000818566253633951f,
0.000893223895970637f,
0.000967204511021862f,
0.00104047214264425f,
0.0011129913065214f,
0.00118472700703947f,
0.00125564475386154f,
0.00132571057819342f,
0.00139489104873263f,
0.00146315328729405f,
0.00153046498410463f,
0.00159679441276025f,
0.00166211044483839f,
0.00172638256415947f,
0.00178958088069117f,
0.00185167614408906f,
0.00191263975686786f,
0.00197244378719761f,
0.00203106098131931f,
0.00208846477557452f,
0.00214462930804392f,
0.00219952942979019f,
0.0022531407157002f,
0.00230543947492238f,
0.00235640276089498f,
0.00240600838096101f,
0.0024542349055667f,
0.00250106167703914f,
0.00254646881794065f,
0.00259043723899602f,
0.00263294864659046f,
0.00267398554983521f,
0.00271353126719851f,
0.00275156993270003f,
0.00278808650166653f,
0.00282306675604716f,
0.00285649730928709f,
0.00288836561075817f,
0.00291865994974546f,
0.00294736945898929f,
0.0029744841177818f,
0.00299999475461814f,
0.00302389304940205f,
0.00304617153520602f,
0.00306682359958636f,
0.00308584348545405f,
0.00310322629150201f,
0.00311896797218987f,
0.00313306533728775f,
0.00314551605098039f,
0.00315631863053355f,
0.00316547244452441f,
0.00317297771063858f,
0.00317883549303572f,
0.00318304769928661f,
0.00318561707688457f,
0.00318654720933417f,
0.00318584251182051f,
0.00318350822646264f,
0.00317955041715474f,
0.00317397596399889f,
0.00316679255733362f,
0.00315800869136253f,
0.00314763365738724f,
0.00313567753664972f,
0.00312215119278839f,
0.00310706626391349f,
0.00309043515430657f,
0.00307227102574976f,
0.00305258778849026f,
0.00303140009184578f,
0.00300872331445699f,
0.00298457355419297f,
0.00295896761771582f,
0.002931923009711f,
0.00290345792178987f,
0.00287359122107116f,
0.00284234243844816f,
0.00280973175654866f,
0.0027757799973949f,
0.00274050860977058f,
0.00270393965630239f,
0.00266609580026379f,
0.00262700029210838f,
0.00258667695574077f,
0.00254515017453283f,
0.00250244487709332f,
0.00245858652279897f,
0.00241360108709495f,
0.00236751504657361f,
0.00232035536383918f,
0.00227214947216735f,
0.00222292525996793f,
0.00217271105505976f,
0.00212153560876561f,
0.00206942807983706f,
0.0020164180182168f,
0.00196253534864859f,
0.00190781035414268f,
0.0018522736593062f,
0.00179595621354771f,
0.0017388892741645f,
0.00168110438932177f,
0.00162263338093348f,
0.00156350832745304f,
0.00150376154658367f,
0.00144342557791727f,
0.00138253316551136f,
0.00132111724041281f,
0.00125921090313771f,
0.00119684740611688f,
0.00113406013611575f,
0.00107088259663795f,
0.00100734839032173f,
0.000943491201338451f,
0.000879344777802133f,
0.000814942914198998f,
0.000750319433846045f,
0.000685508171388118f,
0.000620542955341617f,
0.000555457590694125f,
0.000490285841569116f,
0.000425061413963795f,
0.000359817938569106f,
0.000294588953680933f,
0.000229407888210246f,
0.000164308044801349f,
9.93225830661221e-05f,
3.4484502943216e-05f,
-3.01733718103323e-05f,
-9.46184099865878e-05f,
-0.000158818189144902f,
-0.000222740511673599f,
-0.000286353420686934f,
-0.000349625215749474f,
-0.000412524468420491f,
-0.000475020037611034f,
-0.000537081084745967f,
-0.000598677088724102f,
-0.00065977786066875f,
-0.000720353558462379f,
-0.000780374701058222f,
-0.000839812182561742f,
-0.000898637286076073f,
-0.000956821697304657f,
-0.00101433751790445f,
-0.00107115727858425f,
-0.00112725395194157f,
-0.00118260096503266f,
-0.00123717221166939f,
-0.00129094206443821f,
-0.00134388538643542f,
-0.00139597754271322f,
-0.00144719441143245f,
-0.00149751239471598f,
-0.00154690842919921f,
-0.00159535999627204f,
-0.00164284513200889f,
-0.001689342436782f,
-0.00173483108455442f,
-0.00177929083184826f,
-0.0018227020263853f,
-0.00186504561539609f,
-0.00190630315359405f,
-0.00194645681081197f,
-0.0019854893792978f,
-0.00202338428066662f,
-0.00206012557250691f,
-0.00209569795463822f,
-0.00213008677501847f,
-0.00216327803529848f,
-0.00219525839602226f,
-0.00222601518147149f,
-0.00225553638415245f,
-0.0022838106689244f,
-0.00231082737676847f,
-0.00233657652819601f,
-0.00236104882629575f,
-0.00238423565941947f,
-0.00240612910350581f,
-0.00242672192404204f,
-0.00244600757766397f,
-0.00246398021339438f,
-0.00248063467352028f,
-0.00249596649410965f,
-0.00250997190516865f,
-0.00252264783044025f,
-0.00253399188684541f,
-0.00254400238356826f,
-0.00255267832078691f,
-0.0025600193880516f,
-0.00256602596231194f,
-0.00257069910559561f,
-0.0025740405623407f,
-0.002576052756384f,
-0.00257673878760806f,
-0.00257610242824963f,
-0.00257414811887259f,
-0.00257088096400837f,
-0.00256630672746716f,
-0.00256043182732342f,
-0.00255326333057917f,
-0.00254480894750898f,
-0.00253507702569033f,
-0.00252407654372366f,
-0.00251181710464613f,
-0.00249830892904353f,
-0.00248356284786476f,
-0.0024675902949436f,
-0.00245040329923257f,
-0.00243201447675358f,
-0.00241243702227061f,
-0.00239168470068965f,
-0.00236977183819085f,
-0.00234671331309871f,
-0.00232252454649548f,
-0.00229722149258377f,
-0.00227082062880381f,
-0.00224333894571131f,
-0.00221479393662224f,
-0.00218520358703004f,
-0.00215458636380176f,
-0.00212296120415961f,
-0.0020903475044537f,
-0.00205676510873304f,
-0.00202223429712087f,
-0.00198677577400133f,
-0.0019504106560238f,
-0.00191316045993189f,
-0.00187504709022398f,
-0.00183609282665203f,
-0.00179632031156572f,
-0.00175575253710895f,
-0.00171441283227574f,
-0.00167232484983292f,
-0.00162951255311623f,
-0.00158600020270753f,
-0.00154181234300042f,
-0.00149697378866115f,
-0.00145150961099237f,
-0.00140544512420743f,
-0.00135880587162187f,
-0.00131161761177007f,
-0.00126390630445442f,
-0.00121569809673419f,
-0.00116701930886167f,
-0.001117896420173f,
-0.00106835605494138f,
-0.00101842496819956f,
-0.000968130031539443f,
-0.000917498218896291f,
-0.000866556592324564f,
-0.000815332287772979f,
-0.000763852500866257f,
-0.00071214447270082f,
-0.000660235475661517f,
-0.000608152799267011f,
-0.00055592373605068f,
-0.000503575567484774f,
-0.000451135549954316f,
-0.000398630900788171f,
-0.000346088784354618f,
-0.000293536298227805f,
-0.000241000459432348f,
-0.000188508190773214f,
-0.000136086307257084f,
-8.37615026124415e-05f,
-3.15603359146759e-05f,
2.04907816767024e-05f,
7.23656000628413e-05f,
0.0001240380432256f,
0.000175482222116205f,
0.000226672447407072f,
0.000277583242099614f,
0.000328189353983021f,
0.000378465767937006f,
0.000428387718073508f,
0.000477930699711027f,
0.000527070481176294f,
0.00057578311542722f,
0.000624044951492278f,
0.000671832645720684f,
0.000719123172837889f,
0.000765893836801815f,
0.000812122281454607f,
0.000857786500964707f,
0.000902864850055145f,
0.000947336054012924f,
0.000991179218475345f,
0.00103437383898851f,
0.00107689981033425f,
0.00111873743562118f,
0.00115986743513579f,
0.00120027095494985f,
0.00123992957528063f,
0.00127882531860024f,
0.00131694065749045f,
0.00135425852224024f,
0.00139076230818267f,
0.00142643588276789f,
0.00146126359237004f,
0.00149523026882479f,
0.00152832123569548f,
0.00156052231426489f,
0.00159181982925111f,
0.001622200614245f,
0.00165165201686719f,
0.00168016190364333f,
0.00170771866459553f,
0.00173431121754877f,
0.00175992901215077f,
0.0017845620336043f,
0.00180820080611095f,
0.0018308363960253f,
0.00185246041471891f,
0.00187306502115368f,
0.00189264292416398f,
0.00191118738444733f,
0.00192869221626373f,
0.00194515178884347f,
0.00196056102750367f,
0.00197491541447399f,
0.00198821098943196f,
0.00200044434974861f,
0.0020116126504451f,
0.00202171360386142f,
0.0020307454790383f,
0.00203870710081329f,
0.0020455978486328f,
0.00205141765508121f,
0.00205616700412915f,
0.00205984692910231f,
0.0020624590103731f,
0.00206400537277705f,
0.00206448868275625f,
0.00206391214523208f,
0.00206227950020991f,
0.00205959501911819f,
0.00205586350088484f,
0.00205109026775366f,
0.00204528116084394f,
0.00203844253545627f,
0.00203058125612779f,
0.00202170469144041f,
0.00201182070858521f,
0.00200093766768696f,
0.00198906441589211f,
0.00197621028122439f,
0.00196238506621177f,
0.00194759904128888f,
0.00193186293797901f,
0.00191518794185986f,
0.0018975856853177f,
0.00187906824009385f,
0.00185964810962852f,
0.00183933822120627f,
0.00181815191790804f,
0.00179610295037442f,
0.00177320546838494f,
0.00174947401225873f,
0.00172492350408103f,
0.00169956923876105f,
0.00167342687492633f,
0.00164651242565861f,
0.00161884224907681f,
0.00159043303877221f,
0.00156130181410158f,
0.00153146591034349f,
0.00150094296872334f,
0.00146975092631301f,
0.00143790800581039f,
0.00140543270520465f,
0.00137234378733302f,
0.00133866026933477f,
0.00130440141200819f,
0.00126958670907637f,
0.00123423587636768f,
0.00119836884091695f,
0.00116200572999299f,
0.00112516686005846f,
0.00108787272566835f,
0.00105014398831246f,
0.00101200146520825f,
0.000973466118049983f,
0.000934559041719948f,
0.000895301452967916f,
0.000855714679064593f,
0.000815820146435422f,
0.000775639369280204f,
0.000735193938184692f,
0.000694505508730361f,
0.000653595790107611f,
0.000612486533739071f,
0.000571199521918073f,
0.000529756556468897f,
0.000488179447433948f,
0.000446490001794051f,
0.000404710012227306f,
0.00036286124591261f,
0.000320965433382993f,
0.00027904425743464f,
0.000237119342097373f,
0.000195212241671637f,
0.000153344429837704f,
0.000111537288842719f,
6.98120987704314e-05f,
2.81900268993453e-05f,
-1.3307882845838e-05f,
-5.46607203438826e-05f,
-9.58477196232063e-05f,
-0.000136848269099311f,
-0.00017764192169843f,
-0.00021820840486263f,
-0.000258527630431677f,
-0.000298579704396867f,
-0.000338344936521953f,
-0.000377803849827059f,
-0.000416937189930904f,
-0.00045572593424674f,
-0.000494151301028183f,
-0.000532194758260365f,
-0.000569838032392598f,
-0.000607063116908157f,
-0.000643852280727742f,
-0.000680188076442613f,
-0.00071605334837345f,
-0.000751431240451819f,
-0.000786305203920364f,
-0.000820659004848588f,
-0.000854476731460626f,
-0.000887742801272211f,
-0.00092044196803358f,
-0.000952559328475277f,
-0.00098408032885413f,
-0.00101499077129672f,
-0.00104527681993767f,
-0.00107492500685012f,
-0.00110392223776623f,
-0.00113225579758539f,
-0.00115991335566776f,
-0.00118688297091152f,
-0.00121315309661151f,
-0.00123871258509779f,
-0.00126355069215219f,
-0.00128765708120147f,
-0.00131102182728573f,
-0.00133363542080036f,
-0.00135548877101096f,
-0.00137657320933959f,
-0.00139688049242181f,
-0.0014164028049334f,
-0.00143513276218638f,
-0.00145306341249335f,
-0.00147018823930013f,
-0.00148650116308605f,
-0.00150199654303181f,
-0.00151666917845485f,
-0.00153051431001216f,
-0.00154352762067078f,
-0.00155570523644628f,
-0.00156704372690944f,
-0.00157754010546189f,
-0.00158719182938116f,
-0.00159599679963599f,
-0.00160395336047267f,
-0.00161106029877347f,
-0.00161731684318833f,
-0.00162272266304074f,
-0.0016272778670095f,
-0.00163098300158753f,
-0.00163383904931939f,
-0.00163584742681915f,
-0.00163700998257036f,
-0.00163732899451001f,
-0.00163680716739847f,
-0.00163544762997745f,
-0.00163325393191825f,
-0.00163023004056244f,
-0.00162638033745758f,
-0.00162170961469021f,
-0.00161622307101895f,
-0.00160992630781018f,
-0.00160282532477919f,
-0.00159492651553961f,
-0.00158623666296417f,
-0.00157676293435966f,
-0.00156651287645942f,
-0.00155549441023638f,
-0.00154371582554014f,
-0.00153118577556128f,
-0.00151791327112649f,
-0.00150390767482801f,
-0.00148917869499094f,
-0.00147373637948218f,
-0.00145759110936466f,
-0.00144075359240074f,
-0.00142323485640868f,
-0.00140504624247599f,
-0.00138619939803382f,
-0.00136670626979641f,
-0.00134657909656967f,
-0.00132583040193301f,
-0.00130447298679897f,
-0.00128251992185438f,
-0.00125998453988796f,
-0.00123688042800817f,
-0.00121322141975631f,
-0.00118902158711868f,
-0.0011642952324428f,
-0.00113905688026205f,
-0.00111332126903301f,
-0.00108710334279067f,
-0.00106041824272541f,
-0.00103328129868705f,
-0.00100570802062011f,
-0.000977714089935322f,
-0.00094931535082176f,
-0.000920527801504691f,
-0.000891367585453493f,
-0.000861850982544499f,
-0.000831994400183724f,
-0.000801814364393843f,
-0.000771327510870363f,
-0.000740550576011879f,
-0.000709500387928816f,
-0.000678193857435693f,
-0.000646647969031396f,
-0.000614879771872516f,
-0.000582906370744061f,
-0.000550744917032462f,
-0.000518412599705564f,
-0.00048592663630423f,
-0.000453304263950078f,
-0.000420562730374023f,
-0.000387719284970424f,
-0.00035479116988102f,
-0.000321795611113349f,
-0.000288749809698345f,
-0.000255670932891157f,
-0.000222576105419947f,
-0.000189482400786798f,
-0.000156406832625385f,
-0.000123366346119315f,
-9.03778094855688e-05f,
-5.74580055274083e-05f,
-2.46236232605249e-05f,
8.10875038316639e-06f,
4.07226387702898e-05f,
7.32016836950175e-05f,
0.000105529653418793f,
0.000137690450616703f,
0.000169668120226624f,
0.000201446857197505f,
0.000233011014133184f,
0.000264345108828066f,
0.000295433831690941f,
0.000326262053053822f,
0.000356814830362236f,
0.000387077415243467f,
0.000417035260449873f,
0.00044667402667381f,
0.000475979589231275f,
0.000504938044610982f,
0.000533535716886269f,
0.000561759163986836f,
0.000589595183827354f,
0.000617030820290652f,
0.00064405336906253f,
0.000670650383315963f,
0.000696809679241917f,
0.000722519341424928f,
0.000747767728060642f,
0.000772543476013703f,
0.000796835505713404f,
0.000820633025885535f,
0.000843925538118381f,
0.000866702841260925f,
0.000888955035651854f,
0.000910672527177615f,
0.000931846031157871f,
0.00095246657605724f,
0.000972525507021732f,
0.000992014489238878f,
0.00101092551112014f,
0.0010292508873049f,
0.00104698326148488f,
0.00106411560904814f,
0.00108064123954212f,
0.00109655379895475f,
0.0011118472718135f,
0.00112651598310146f,
0.00114055459999043f,
0.00115395813339071f,
0.00116672193931726f,
0.00117884172007231f,
0.00119031352524443f,
0.00120113375252423f,
0.00121129914833667f,
0.00122080680829065f,
0.00122965417744607f,
0.00123783905039883f,
0.00124535957118451f,
0.00125221423300136f,
0.00125840187775329f,
0.00126392169541391f,
0.00126877322321233f,
0.00127295634464211f,
0.00127647128829414f,
0.00127931862651491f,
0.00128149927389139f,
0.001283014485564f,
0.00128386585536898f,
0.00128405531381196f,
0.00128358512587417f,
0.00128245788865312f,
0.00128067652883962f,
0.00127824430003285f,
0.00127516477989559f,
0.00127144186715168f,
0.00126707977842767f,
0.00126208304494094f,
0.00125645650903667f,
0.00125020532057575f,
0.00124333493317623f,
0.00123585110031071f,
0.0012277598712622f,
0.00121906758694106f,
0.0012097808755657f,
0.00119990664820978f,
0.00118945209421861f,
0.00117842467649774f,
0.0011668321266765f,
0.0011546824401495f,
0.00114198387099919f,
0.00112874492680237f,
0.00111497436332383f,
0.00110068117910045f,
0.0010858746099186f,
0.00107056412318845f,
0.00105475941221828f,
0.00103847039039214f,
0.0010217071852543f,
0.00100448013250386f,
0.000986799769902909f,
0.000968676831101775f,
0.000950122239384843f,
0.000931147101340517f,
0.0009117627004588f,
0.000891980490660107f,
0.000871812089758989f,
0.000851269272866356f,
0.00083036396573377f,
0.00080910823804354f,
0.000787514296648406f,
0.000765594478764287f,
0.00074336124511991f,
0.000720827173067144f,
0.000698004949655534f,
0.000674907364674944f,
0.000651547303669901f,
0.000627937740929579f,
0.000604091732456894f,
0.000580022408920566f,
0.000555742968593997f,
0.000531266670284408f,
0.000506606826256191f,
0.000481776795151971f,
0.000456789974915333f,
0.000431659795718582f,
0.000406399712899355f,
0.000381023199909761f,
0.000355543741281616f,
0.000329974825611307f,
0.000304329938567905f,
0.000278622555928233f,
0.000252866136642139f,
0.000227074115931597f,
0.000201259898427255f,
0.000175436851345555f,
0.000149618297710086f,
0.000123817509620333f,
9.80477015714137e-05f,
7.23220238277868e-05f,
4.665355585432e-05f,
2.10552998080745e-05f,
-4.45982590633637e-06f,
-2.98789930144383e-05f,
-5.51894696797388e-05f,
-8.03786267385361e-05f,
-0.000105433943858797f,
-0.00013034301562024f,
-0.000155093557512704f,
-0.000179673411849814f,
-0.00020407055359547f,
-0.000228273096100299f,
-0.000252269296745275f,
-0.000276047562490194f,
-0.00029959645532431f,
-0.000322904697616544f,
-0.000345961177363105f,
-0.00036875495332996f,
-0.000391275260088007f,
-0.00041351151293851f,
-0.000435453312726917f,
-0.000457090450542803f,
-0.000478412912303817f,
-0.000499410883221916f,
-0.000520074752149767f,
-0.000540395115805737f,
-0.000560362782875298f,
-0.000579968777987699f,
-0.000599204345565892f,
-0.000618060953548384f,
-0.000636530296981365f,
-0.000654604301479925f,
-0.000672275126556943f,
-0.000689535168818291f,
-0.000706377065023391f,
-0.000722793695009926f,
-0.000738778184481572f,
-0.00075432390765802f,
-0.000769424489786242f,
-0.000784073809512325f,
-0.000798266001112986f,
-0.000811995456586321f,
-0.000825256827601124f,
-0.000838045027304191f,
-0.000850355231985366f,
-0.000862182882599891f,
-0.000873523686147765f,
-0.00088437361690996f,
-0.000894728917541413f,
-0.00090458610002068f,
-0.000913941946456356f,
-0.000922793509750267f,
-0.000931138114117751f,
-0.000938973355465201f,
-0.000946297101625169f,
-0.000953107492449535f,
-0.00095940293976115f,
-0.000965182127164484f,
-0.000970444009715949f,
-0.000975187813454563f,
-0.000979413034793724f,
-0.000983119439774883f,
-0.000986307063184082f,
-0.000988976207532292f,
-0.000991127441900545f,
-0.000992761600651051f,
-0.000993879782005379f,
-0.000994483346490993f,
-0.000994573915257406f,
-0.000994153368263331f,
-0.000993223842336247f,
-0.00099178772910585f,
-0.000989847672812951f,
-0.000987406567995412f,
-0.000984467557052783f,
-0.000981034027691368f,
-0.000977109610251478f,
-0.000972698174918704f,
-0.000967803828821116f,
-0.000962430913014279f,
-0.000956583999356123f,
-0.00095026788727365f,
-0.000943487600423628f,
-0.000936248383249343f,
-0.000928555697435623f,
-0.000920415218264346f,
-0.000911832830872734f,
-0.000902814626416679f,
-0.000893366898141494f,
-0.000883496137362504f,
-0.000873209029357859f,
-0.000862512449176021f,
-0.00085141345736053f,
-0.000839919295594453f,
-0.000828037382267177f,
-0.000815775307966064f,
-0.000803140830895734f,
-0.000790141872227454f,
-0.000776786511381427f,
-0.00076308298124471f,
-0.000749039663327391f,
-0.000734665082859875f,
-0.000719967903833962f,
-0.000704956923990644f,
-0.000689641069757283f,
-0.000674029391137055f,
-0.000658131056553546f,
-0.000641955347653323f,
-0.000625511654069285f,
-0.000608809468147721f,
-0.000591858379642031f,
-0.00057466807037584f,
-0.000557248308878483f,
-0.000539608944995842f,
-0.000521759904479256f,
-0.000503711183555555f,
-0.000485472843480995f,
-0.000467055005082172f,
-0.000448467843286586f,
-0.000429721581645849f,
-0.000410826486854523f,
-0.000391792863267231f,
-0.000372631047417096f,
-0.000353351402538234f,
-0.000333964313095239f,
-0.000314480179322442f,
-0.000294909411775696f,
-0.000275262425899514f,
-0.000255549636612444f,
-0.00023578145291323f,
-0.00021596827251059f,
-0.000196120476479426f,
-0.000176248423945934f,
-0.000156362446804383f,
-0.000136472844468305f,
-0.000116589878658459f,
-9.67237682303544e-05f,
-7.68846840437216e-05f,
-5.70827438766377e-05f,
-3.73280073865604e-05f,
-1.76304711208226e-05f,
1.99993642088864e-06f,
2.15533596699293e-05f,
4.10200208154243e-05f,
6.03902245722434e-05f,
7.96543628875891e-05f,
9.88029195844659e-05f,
0.000117826474939476f,
0.000136715710193024f,
0.000155461411989631f,
0.000174054476746553f,
0.00019248591494857f,
0.000210746855366906f,
0.000228828549200576f,
0.000246722374138184f,
0.000264419838338276f,
0.00028191258432668f,
0.00029919239280896f,
0.000316251186396444f,
0.00033308103324404f,
0.000349674150598494f,
0.000366022908255491f,
0.000382119831924034f,
0.000397957606496918f,
0.000413529079225828f,
0.000428827262799762f,
0.000443845338325565f,
0.00045857665820947f,
0.000473014748938413f,
0.000487153313760161f,
0.000500986235261103f,
0.000514507577840938f,
0.000527711590083255f,
0.000540592707021129f,
0.000553145552297088f,
0.000565364940216666f,
0.000577245877694798f,
0.000588783566094627f,
0.00059997340295804f,
0.000610810983627539f,
0.000621292102758917f,
0.000631412755724494f,
0.000641169139906554f,
0.000650557655880657f,
0.000659574908488804f,
0.000668217707802125f,
0.000676483069973211f,
0.000684368217977891f,
0.00069187058224664f,
0.000698987801185635f,
0.000705717721587661f,
0.000712058398933015f,
0.000718008097580768f,
0.000723565290850654f,
0.000728728660995955f,
0.000733497099067867f,
0.000737869704671835f,
0.000741845785616332f,
0.000745424857454791f,
0.000748606642921268f,
0.000751391071260577f,
0.000753778277453638f,
0.000755768601338869f,
0.000757362586630487f,
0.000758560979834606f,
0.000759364729064122f,
0.000759774982753388f,
0.000759793088273753f,
0.000759420590451042f,
0.000758659229986178f,
0.000757510941780111f,
0.000755977853164323f,
0.000754062282038195f,
0.000751766734914573f,
0.000749093904874909f,
0.000746046669435407f,
0.00074262808832562f,
0.000738841401181018f,
0.000734690025151058f,
0.000730177552424333f,
0.000725307747672431f,
0.000720084545414129f,
0.000714512047301645f,
0.000708594519330652f,
0.000702336388975791f,
0.000695742242253508f,
0.000688816820714019f,
0.000681565018364236f,
0.000673991878523528f,
0.000666102590614281f,
0.00065790248688911f,
0.000649397039096707f,
0.000640591855088355f,
0.000631492675367041f,
0.00062210536958124f,
0.000612435932965378f,
0.000602490482729133f,
0.000592275254397531f,
0.00058179659810402f,
0.00057106097483868f,
0.000560074952653592f,
0.000548845202827616f,
0.000537378495992672f,
0.000525681698223757f,
0.000513761767094866f,
0.000501625747702958f,
0.000489280768662212f,
0.00047673403807084f,
0.000463992839452548f,
0.000451064527674926f,
0.000437956524847057f,
0.000424676316198432f,
0.000411231445941475f,
0.000397629513119953f,
0.000383878167445365f,
0.000369985105123653f,
0.000355958064674343f,
0.000341804822744478f,
0.000327533189919382f,
0.00031315100653253f,
0.000298666138476795f,
0.000284086473019086f,
0.000269419914620704f,
0.000254674380765407f,
0.000239857797797613f,
0.000224978096772517f,
0.000210043209320516f,
0.000195061063527882f,
0.000180039579835931f,
0.000164986666960563f,
0.000149910217834334f,
0.00013481810557314f,
0.000119718179469377f,
0.000104618261013641f,
8.95261399470058e-05f,
7.4449570345654e-05f,
5.93962667399167e-05f,
4.43739002695007e-05f,
2.93900948769175e-05f,
1.44524235407681e-05f,
-4.31595449223616e-07f,
-1.52545021735662e-05f,
-3.00088987191677e-05f,
-4.46874527685018e-05f,
-5.92829011400602e-05f,
-7.3788053278475e-05f,
-8.81957946927382e-05f,
-0.000102499090340838f,
-0.00011669098795936f,
-0.000130764621336393f,
-0.000144713213526427f,
-0.000158530080005721f,
-0.000172208631766647f,
-0.000185742378349807f,
-0.000199124930812505f,
-0.000212350004632196f,
-0.00022541142254385f,
-0.000238303117309837f,
-0.000251019134421297f,
-0.000263553634729709f,
-0.000275900897007726f,
-0.000288055320438154f,
-0.000300011427029989f,
-0.000311763863960726f,
-0.000323307405843803f,
-0.000334636956920518f,
-0.000345747553175349f,
-0.000356634364374106f,
-0.000367292696023986f,
-0.000377717991254969f,
-0.000387905832621729f,
-0.000397851943825609f,
-0.000407552191355999f,
-0.000417002586050548f,
-0.000426199284573831f,
-0.000435138590813965f,
-0.000443816957196748f,
-0.000452230985917062f,
-0.000460377430087148f,
-0.000468253194801565f,
-0.000475855338118517f,
-0.000483181071957495f,
-0.000490227762913035f,
-0.000496992932984516f,
-0.000503474260221955f,
-0.000509669579287852f,
-0.000515576881935093f,
-0.000521194317400983f,
-0.000526520192717614f,
-0.000531552972938706f,
-0.000536291281283125f,
-0.0005407338991954f,
-0.000544879766323497f,
-0.000548727980414254f,
-0.000552277797126791f,
-0.000555528629764419f,
-0.000558480048925469f,
-0.000561131782073551f,
-0.000563483713027852f,
-0.000565535881373998f,
-0.000567288481796188f,
-0.000568741863331196f,
-0.000569896528545036f,
-0.000570753132632961f,
-0.000571312482443646f,
-0.000571575535428335f,
-0.000571543398515829f,
-0.000571217326914227f,
-0.000570598722840296f,
-0.000569689134177504f,
-0.000568490253063648f,
-0.000567003914409159f,
-0.000565232094347103f,
-0.000563176908616006f,
-0.000560840610876602f,
-0.000558225590963676f,
-0.000555334373074176f,
-0.000552169613892796f,
-0.000548734100656311f,
-0.000545030749157866f,
-0.000541062601692577f,
-0.000536832824945712f,
-0.000532344707824832f,
-0.000527601659237243f,
-0.000522607205814143f,
-0.000517364989582876f,
-0.000511878765588764f,
-0.000506152399467916f,
-0.000500189864972511f,
-0.000493995241450079f,
-0.00048757271127824f,
-0.000480926557256444f,
-0.000474061159956302f,
-0.000466980995031985f,
-0.000459690630492344f,
-0.000452194723936275f,
-0.000444498019752994f,
-0.000436605346288768f,
-0.000428521612981758f,
-0.000420251807466637f,
-0.000411800992650551f,
-0.000403174303762153f,
-0.000394376945375264f,
-0.000385414188409004f,
-0.000376291367105835f,
-0.000367013875989376f,
-0.000357587166803538f,
-0.000348016745434793f,
-0.000338308168819116f,
-0.000328467041835364f,
-0.000318499014186804f,
-0.000308409777272385f,
-0.000298205061049476f,
-0.00028789063088981f,
-0.000277472284430191f,
-0.000266955848419733f,
-0.000256347175565217f,
-0.000245652141376339f,
-0.000234876641012366f,
-0.000224026586131915f,
-0.000213107901747537f,
-0.000202126523086631f,
-0.000191088392460357f,
-0.000179999456142179f,
-0.000168865661257607f,
-0.000157692952686687f,
-0.000146487269980865f,
-0.000135254544295716f,
-0.000124000695341185f,
-0.000112731628350718f,
-0.000101453231070878f,
-9.01713707729725e-05f,
-7.88918912880573e-05f,
-6.76206100668248e-05f,
-5.63633152658753e-05f,
-4.51257628616543e-05f,
-3.39136737935609e-05f,
-2.2732731137515e-05f,
-1.1588577311449e-05f,
-4.86811313915871e-07f,
1.05670140028143e-05f,
2.15673946238211e-05f,
3.25088780256781e-05f,
4.33860657922279e-05f,
5.41936161910016e-05f,
6.49262467088871e-05f,
7.55787365460706e-05f,
8.6145929067006e-05f,
9.6622734207392e-05f,
0.000107004130835977f,
0.000117285169070277f,
0.000127460972545122f,
0.000137526740632994f,
0.000147477750615314f,
0.000157309359803685f,
0.000167017007610151f,
0.000176596217565704f,
0.00018604259928613f,
0.000195351850384441f,
0.000204519758329025f,
0.000213542202246907f,
0.000222415154671328f,
0.000231134683232959f,
0.000239696952294124f,
0.000248098224525462f,
0.000256334862424394f,
0.000264403329774837f,
0.000272300193047718f,
0.000280022122741781f,
0.000287565894664179f,
0.000294928391150552f,
0.000302106602224122f,
0.000309097626693513f,
0.000315898673188933f,
0.000322507061136496f,
0.00032892022167043f,
0.000335135698482898f,
0.000341151148611358f,
0.000346964343163231f,
0.000352573167977838f,
0.000357975624225448f,
0.000363169828943501f,
0.000368154015509882f,
0.00037292653405339f,
0.000377485851801332f,
0.000381830553364452f,
0.000385959340959241f,
0.000389871034567797f,
0.000393564572035445f,
0.000397039009106331f,
0.0004002935193972f,
0.000403327394309709f,
0.000406140042881527f,
0.000408730991576614f,
0.00041109988401501f,
0.00041324648064257f,
0.000415170658341089f,
0.000416872409979226f,
0.000418351843904798f,
0.000419609183378899f,
0.000420644765952442f,
0.000421459042785672f,
0.000422052577911267f,
0.000422426047441668f,
0.000422580238721292f,
0.000422516049424304f,
0.000422234486598678f,
0.000421736665657269f,
0.000421023809316662f,
0.000420097246484597f,
0.00041895841109675f,
0.000417608840903734f,
0.000416050176209156f,
0.000414284158559614f,
0.000412312629387525f,
0.000410137528607722f,
0.00040776089316874f,
0.000405184855559753f,
0.000402411642274163f,
0.000399443572230807f,
0.000396283055153818f,
0.00039293258991216f,
0.000389394762819914f,
0.000385672245898332f,
0.000381767795100793f,
0.000377684248501704f,
0.00037342452445052f,
0.000368991619691937f,
0.00036438860745344f,
0.000359618635501352f,
0.00035468492416652f,
0.000349590764340821f,
0.000344339515445694f,
0.000338934603373839f,
0.00033337951840533f,
0.000327677813099311f,
0.000321833100162537f,
0.000315849050295926f,
0.00030972939002039f,
0.000303477899483179f,
0.000297098410245953f,
0.000290594803055835f,
0.000283971005600701f,
0.000277230990249963f,
0.000270378771782053f,
0.00026341840509992f,
0.000256353982935729f,
0.000249189633546102f,
0.000241929518399064f,
0.000234577829853977f,
0.000227138788835771f,
0.000219616642504624f,
0.00021201566192238f,
0.000204340139716987f,
0.00019659438774611f,
0.00018878273476121f,
0.000180909524073276f,
0.000172979111221486f,
0.000164995861645939f,
0.000156964148365684f,
0.000148888349663314f,
0.000140772846777168f,
0.000132622021602488f,
0.000124440254402532f,
0.000116231921530969f,
0.000108001393166544f,
9.97530310612701e-05f,
9.14911863031805e-05f,
8.32201970948495e-05f,
7.49443865486734e-05f,
6.66680605000458e-05f,
5.83955053395394e-05f,
5.01309858650572e-05f,
4.18787431550387e-05f,
3.36429924637897e-05f,
2.5427921139845e-05f,
1.72376865684373e-05f,
9.07641413898225e-06f,
9.48195238618906e-07f,
-7.14291472735571e-06f,
-1.51928982871869e-05f,
-2.3197777825582e-05f,
-3.11536174769895e-05f,
-3.9056524988396e-05f,
-4.69026535507839e-05f,
-5.46882035983796e-05f,
-6.24094245749816e-05f,
-7.00626166665431e-05f,
-7.76441324992083e-05f,
-8.51503788021583e-05f,
-9.25778180344744e-05f,
-9.99229699753843e-05f,
-0.000107182413277144f,
-0.000114352786980001f,
-0.000121430791988571f,
-0.000128413192508979f,
-0.000135296817446292f,
-0.000142078561761593f,
-0.000148755387788244f,
-0.000155324326506732f,
-0.000161782478777755f,
-0.000168127016532938f,
-0.000174355183922887f,
-0.000180464298422044f,
-0.000186451751890066f,
-0.000192315011589317f,
-0.00019805162115811f,
-0.000203659201539462f,
-0.000209135451865035f,
-0.000214478150293975f,
-0.000219685154806484f,
-0.000224754403951855f,
-0.000229683917550825f,
-0.000234471797352043f,
-0.000239116227642562f,
-0.00024361547581224f,
-0.000247967892871911f,
-0.000252171913925349f,
-0.000256226058594915f,
-0.000260128931400936f,
-0.000263879222094778f,
-0.000267475705945676f,
-0.000270917243981399f,
-0.000274202783182808f,
-0.00027733135663242f,
-0.00028030208361713f,
-0.000283114169685247f,
-0.000285766906657991f,
-0.000288259672595703f,
-0.000290591931718978f,
-0.000292763234284939f,
-0.000294773216418979f,
-0.00029662159990223f,
-0.000298308191915087f,
-0.000299832884737118f,
-0.000301195655403732f,
-0.000302396565319991f,
-0.000303435759831934f,
-0.000304313467755884f,
-0.000305030000866148f,
-0.000305585753341585f,
-0.00030598120117152f,
-0.000306216901521509f,
-0.000306293492059488f,
-0.000306211690242816f,
-0.000305972292566803f,
-0.00030557617377527f,
-0.000305024286033762f,
-0.000304317658065994f,
-0.000303457394254184f,
-0.000302444673703895f,
-0.000301280749274063f,
-0.000299966946572862f,
-0.000298504662920124f,
-0.000296895366276984f,
-0.000295140594143504f,
-0.000293241952424973f,
-0.000291201114267648f,
-0.000289019818864695f,
-0.000286699870233075f,
-0.000284243135962188f,
-0.000281651545935046f,
-0.000278927091022785f,
-0.000276071821753329f,
-0.000273087846955029f,
-0.000269977332376106f,
-0.000266742499280753f,
-0.000263385623022736f,
-0.000259909031597333f,
-0.000256315104172533f,
-0.0002526062696003f,
-0.000248785004908818f,
-0.000244853833776615f,
-0.000240815324989414f,
-0.000236672090880646f,
-0.00023242678575649f,
-0.000228082104306389f,
-0.000223640779999902f,
-0.00021910558347082f,
-0.00021447932088949f,
-0.000209764832324188f,
-0.000204964990092552f,
-0.000200082697103894f,
-0.000195120885193399f,
-0.00019008251344906f,
-0.000184970566532297f,
-0.000179788052993172f,
-0.000174538003581127f,
-0.000169223469552129f,
-0.000163847520973146f,
-0.000158413245024881f,
-0.000152923744303642f,
-0.000147382135123237f,
-0.000141791545817854f,
-0.000136155115046731f,
-0.000130475990101566f,
-0.000124757325217511f,
-0.000119002279888661f,
-0.000113214017188868f,
-0.000107395702098747f,
-0.000101550499839755f,
-9.56815742161737e-05f,
-8.9792085965815e-05f,
-8.38851911202859e-05f,
-7.79640393756771e-05f,
-7.20317724744153e-05f,
-6.60915225991129e-05f,
-6.01464107792395e-05f,
-5.41995453113257e-05f,
-4.8254020193526e-05f,
-4.23129135752554e-05f,
-3.6379286222704e-05f,
-3.04561800008946e-05f,
-2.45466163730381e-05f,
-1.86535949179281e-05f,
-1.27800918660038e-05f,
-6.9290586548193e-06f,
-1.10342050454853e-06f,
4.69392498575835e-06f,
1.04601092206202e-05f,
1.6192293968531e-05f,
2.1887672699831e-05f,
2.75434719013334e-05f,
3.31569523672129e-05f,
3.87254104655552e-05f,
4.4246179379982e-05f,
4.97166303258814e-05f,
5.51341737406908e-05f,
6.04962604476993e-05f,
6.58003827929482e-05f,
7.10440757547034e-05f,
7.62249180250887e-05f,
8.13405330633889e-05f,
8.63885901206669e-05f,
9.13668052352641e-05f,
9.6272942198768e-05f,
0.000101104813492143f,
0.000105860281191626f,
0.00011053725784408f,
0.000115133707311479f,
0.00011964764558422f,
0.000124077141563023f,
0.000128420317809118f,
0.000132675351262483f,
0.000136840473927933f,
0.000140913973528842f,
0.000144894194128284f,
0.000148779536717474f,
0.000152568459771325f,
0.000156259479770981f,
0.00015985117169324f,
0.000163342169466755f,
0.000166731166394932f,
0.000170016915545461f,
0.000173198230106457f,
0.000176273983709174f,
0.000179243110717271f,
0.000182104606482673f,
0.000184857527568029f,
0.000187500991935842f,
0.000190034179104279f,
0.000192456330269823f,
0.000194766748396795f,
0.000196964798273909f,
0.000199049906537954f,
0.000201021561664791f,
0.000202879313927801f,
0.000204622775323984f,
0.000206251619467897f,
0.000207765581453664f,
0.000209164457685255f,
0.000210448105675328f,
0.000211616443812851f,
0.000212669451099813f,
0.000213607166857295f,
0.000214429690401231f,
0.000215137180688158f,
0.000215729855931309f,
0.000216207993187386f,
0.000216571927914394f,
0.000216822053500895f,
0.00021695882076709f,
0.000216982737438119f,
0.000216894367590012f,
0.000216694331068704f,
0.000216383302882574f,
0.000215962012568937f,
0.000215431243534989f,
0.000214791832373643f,
0.000214044668154779f,
0.000213190691692376f,
0.000212230894788063f,
0.000211166319451582f,
0.000209998057098713f,
0.000208727247727179f,
0.000207355079071099f,
0.000205882785734526f,
0.000204311648304645f,
0.0002026429924452f,
0.000200878187970726f,
0.000199018647902181f,
0.000197065827504565f,
0.000195021223307131f,
0.000192886372106789f,
0.000190662849955323f,
0.000188352271131036f,
0.000185956287095444f,
0.000183476585435659f,
0.000180914888793067f,
0.00017827295377898f,
0.000175552569877859f,
0.000172755558338776f,
0.000169883771055775f,
0.000166939089437739f,
0.000163923423268465f,
0.000160838709557554f,
0.000157686911382826f,
0.00015447001672486f,
0.00015119003729435f,
0.000147849007352939f,
0.000144448982528169f,
0.000140992038623225f,
0.000137480270422103f,
0.000133915790490909f,
0.000130300727975883f,
0.000126637227398849f,
0.000122927447450727f,
0.000119173559783752f,
0.000115377747803056f,
0.000111542205458249f,
0.000107669136035655f,
0.000103760750951826f,
9.98192685489614e-05f,
9.58469128929004e-05f,
9.18459125742598e-05f,
8.7818499513379e-05f,
8.3766907769656e-05f,
7.96933723559266e-05f,
7.5600128058426e-05f,
7.14894082630084e-05f,
6.7363443788134e-05f,
6.32244617252883e-05f,
5.90746842873462e-05f,
5.49163276654788e-05f,
5.07516008951872e-05f,
4.65827047319742e-05f,
4.24118305372229e-05f,
3.82411591748463e-05f,
3.40728599191875e-05f,
2.99090893747362e-05f,
2.5751990408141e-05f,
2.16036910930649e-05f,
1.7466303668328e-05f,
1.33419235098453e-05f,
9.23262811685928e-06f,
5.1404761128809e-06f,
1.06750626183723e-06f,
-2.98426350016023e-06f,
-7.01283701696615e-06f,
-1.10162408480615e-05f,
-1.49925251873214e-05f,
-1.89397647644821e-05f,
-2.28560597288928e-05f,
-2.67395365152196e-05f,
-3.0588348690713e-05f,
-3.44006777836603e-05f,
-3.81747340927275e-05f,
-4.19087574768357e-05f,
-4.56010181252311e-05f,
-4.92498173074901e-05f,
-5.28534881031252e-05f,
-5.64103961105393e-05f,
-5.99189401350207e-05f,
-6.33775528555675e-05f,
-6.67847014702765e-05f,
-7.01388883200426e-05f,
-7.34386514903965e-05f,
-7.66825653912348e-05f,
-7.98692413142891e-05f,
-8.29973279680875e-05f,
-8.60655119903289e-05f,
-8.90725184374467e-05f,
-9.2017111251262e-05f,
-9.48980937025603e-05f,
-9.77143088115188e-05f,
-0.000100464639744859f,
-0.000103148010189625f,
-0.000105763384703537f,
-0.000108309769041847f,
-0.000110786210460631f,
-0.000113191797996502f,
-0.000115525662722708f,
-0.000117786977981613f,
-0.000119974959593534f,
-0.000122088866041986f,
-0.000124127998635343f,
-0.000126091701644931f,
-0.000127979362419654f,
-0.000129790411477168f,
-0.000131524322571709f,
-0.000133180612738637f,
-0.000134758842315834f,
-0.000136258614942016f,
-0.000137679577532133f,
-0.000139021420229953f,
-0.000140283876337993f,
-0.000141466722224963f,
-0.000142569777210869f,
-0.000143592903429972f,
-0.000144536005671797f,
-0.000145399031200369f,
-0.000146181969551922f,
-0.000146884852311273f,
-0.000147507752867119f,
-0.000148050786146473f,
-0.000148514108328524f,
-0.000148897916538149f,
-0.000149202448519377f,
-0.000149427982289073f,
-0.000149574835771129f,
-0.000149643366411474f,
-0.000149633970774194f,
-0.000149547084119101f,
-0.000149383179961048f,
-0.000149142769611348f,
-0.000148826401701622f,
-0.000148434661690426f,
-0.000147968171353023f,
-0.000147427588254649f,
-0.00014681360520765f,
-0.000146126949712865f,
-0.000145368383385639f,
-0.000144538701366849f,
-0.000143638731719352f,
-0.00014266933481023f,
-0.000141631402679272f,
-0.000140525858394076f,
-0.000139353655392192f,
-0.000138115776810751f,
-0.000136813234803966f,
-0.000135447069848973f,
-0.000134018350040413f,
-0.000132528170374222f,
-0.000130977652021046f,
-0.000129367941589733f,
-0.000127700210381361f,
-0.000125975653634229f,
-0.000124195489760284f,
-0.000122360959573422f,
-0.000120473325510131f,
-0.000118533870842929f,
-0.000116543898887054f,
-0.000114504732200872f,
-0.000112417711780454f,
-0.000110284196248804f,
-0.00010810556104017f,
-0.000105883197579935f,
-0.000103618512460518f,
-0.000101312926613771f,
-9.89678744803232e-05f,
-9.65848031763287e-05f,
-9.41651716580905e-05f,
-9.17104498849976e-05f,
-8.92221179812628e-05f,
-8.67016653968825e-05f,
-8.41505900682881e-05f,
-8.15703975791493e-05f,
-7.89626003217505e-05f,
-7.63287166594104e-05f,
-7.36702700903664e-05f,
-7.09887884135878e-05f,
-6.82858028969257e-05f,
-6.55628474480433e-05f,
-6.2821457788569e-05f,
-6.00631706318681e-05f,
-5.72895228648757e-05f,
-5.45020507343893e-05f,
-5.17022890382489e-05f,
-4.88917703218012e-05f,
-4.60720240800406e-05f,
-4.32445759658306e-05f,
-4.04109470046086e-05f,
-3.75726528159311e-05f,
-3.47312028422512e-05f,
-3.18880995853173e-05f,
-2.90448378505281e-05f,
-2.62029039996194e-05f,
-2.33637752120534e-05f,
-2.05289187554216e-05f,
-1.76997912652335e-05f,
-1.48778380343994e-05f,
-1.20644923127653e-05f,
-9.26117461698226e-06f,
-6.46929205104167e-06f,
-3.69023763779291e-06f,
-9.25389661709246e-07f,
1.82388897678174e-06f,
4.55625139514286e-06f,
7.27036735044587e-06f,
9.96492384873171e-06f,
1.26386257417392e-05f,
1.52901963107384e-05f,
1.79183778372582e-05f,
2.05219321604611e-05f,
2.30996412209252e-05f,
2.56503075906517e-05f,
2.81727549890619e-05f,
3.06658287848129e-05f,
3.3128396483204e-05f,
3.55593481990333e-05f,
3.7957597114714e-05f,
4.03220799234942e-05f,
4.26517572576078e-05f,
4.49456141012435e-05f,
4.72026601881683e-05f,
4.94219303839002e-05f,
5.16024850522866e-05f,
5.37434104064079e-05f,
5.58438188436954e-05f,
5.79028492651571e-05f,
5.991966737866e-05f,
6.18934659861721e-05f,
6.38234652549182e-05f,
6.57089129723729e-05f,
6.75490847850721e-05f,
6.93432844211934e-05f,
7.10908438968675e-05f,
7.27911237062256e-05f,
7.4443512995159e-05f,
7.60474297187844e-05f,
7.76023207826403e-05f,
7.91076621676173e-05f,
8.05629590386577e-05f,
8.19677458372436e-05f,
8.33215863577353e-05f,
8.46240738076028e-05f,
8.58748308515986e-05f,
8.70735096399619e-05f,
8.82197918207153e-05f,
8.93133885361372e-05f,
9.03540404035137e-05f,
9.13415174802592e-05f,
9.2275619213524e-05f,
9.31561743743901e-05f,
9.39830409767967e-05f,
9.47561061813166e-05f,
9.54752861839191e-05f,
9.61405260898756e-05f,
9.67517997729505e-05f,
9.73091097200466e-05f,
9.78124868614686e-05f,
9.82619903869737e-05f,
9.86577075477993e-05f,
9.89997534448506e-05f,
9.92882708032378e-05f,
9.95234297333714e-05f,
9.9705427478815e-05f,
9.98344881511113e-05f,
9.9910862451795e-05f,
9.99348273818228e-05f,
9.99066859386447e-05f,
9.98267668011501e-05f,
9.96954240027345e-05f,
9.95130365927253e-05f,
9.92800082864198e-05f,
9.89967671039888e-05f,
9.86637649985054e-05f,
9.82814774733607e-05f,
9.78504031893375e-05f,
9.73710635616094e-05f,
9.68440023469432e-05f,
9.62697852213859e-05f,
9.56489993487134e-05f,
9.49822529399338e-05f,
9.42701748041286e-05f,
9.35134138909306e-05f,
9.27126388249273e-05f,
9.18685374322918e-05f,
9.09818162599413e-05f,
9.00532000875255e-05f,
8.90834314325463e-05f,
8.80732700489246e-05f,
8.70234924193122e-05f,
8.59348912414666e-05f,
8.4808274908995e-05f,
8.36444669867889e-05f,
8.24443056814471e-05f,
8.12086433070261e-05f,
7.99383457464085e-05f,
7.86342919086182e-05f,
7.72973731824044e-05f,
7.59284928863964e-05f,
7.45285657161543e-05f,
7.30985171884367e-05f,
7.16392830829907e-05f,
7.01518088821841e-05f,
6.86370492088033e-05f,
6.70959672623157e-05f,
6.55295342539231e-05f,
6.39387288407062e-05f,
6.23245365591873e-05f,
6.06879492586023e-05f,
5.90299645341967e-05f,
5.73515851608611e-05f,
5.56538185273923e-05f,
5.39376760716902e-05f,
5.22041727171986e-05f,
5.04543263108675e-05f,
4.8689157062949e-05f,
4.6909686988904e-05f,
4.51169393537251e-05f,
4.33119381189442e-05f,
4.14957073926132e-05f,
3.96692708825497e-05f,
3.78336513531005e-05f,
3.59898700857156e-05f,
3.41389463435848e-05f,
3.22818968406223e-05f,
3.04197352150379e-05f,
2.8553471507761e-05f,
2.66841116459819e-05f,
2.48126569320371e-05f,
2.2940103537894e-05f,
2.10674420054833e-05f,
1.91956567530948e-05f,
1.73257255880833e-05f,
1.54586192260934e-05f,
1.35953008170508e-05f,
1.17367254781075e-05f,
9.88383983376397e-06f,
8.03758156337068e-06f,
6.19887895622112e-06f,
4.36865047440966e-06f,
2.5478043236621e-06f,
7.37238032308926e-07f,
-1.06216196140182e-06f,
-2.8495207135011e-06f,
-4.6239751698272e-06f,
-6.38467455271441e-06f,
-8.1307807387077e-06f,
-9.86146862713565e-06f,
-1.15759264994109e-05f,
-1.32733563689023e-05f,
-1.49529743212685e-05f,
-1.66140108451148e-05f,
-1.82557111528465e-05f,
-1.98773354916211e-05f,
-2.14781594442845e-05f,
-2.30574742201769e-05f,
-2.46145869357363e-05f,
-2.61488208847895e-05f,
-2.76595157984633e-05f,
-2.91460280946187e-05f,
-3.06077311167596e-05f,
-3.20440153623401e-05f,
-3.34542887004033e-05f,
-3.48379765785163e-05f,
-3.61945222189482e-05f,
-3.75233868040389e-05f,
-3.8824049650746e-05f,
-4.00960083743248e-05f,
-4.13387790411312e-05f,
-4.25518963105175e-05f,
-4.37349135658282e-05f,
-4.48874030344821e-05f,
-4.60089558971416e-05f,
-4.70991823859845e-05f,
-4.81577118720844e-05f,
-4.91841929419275e-05f,
-5.01782934630889e-05f,
-5.11397006390925e-05f,
-5.20681210535035e-05f,
-5.29632807032924e-05f,
-5.38249250215107e-05f,
-5.46528188893462e-05f,
-5.5446746637607e-05f,
-5.62065120377057e-05f,
-5.69319382822058e-05f,
-5.76228679550161e-05f,
-5.82791629913088e-05f,
-5.89007046272429e-05f,
-5.94873933395923e-05f,
-6.00391487753712e-05f,
-6.05559096715516e-05f,
-6.10376337649892e-05f,
-6.14842976926593e-05f,
-6.18958968823238e-05f,
-6.22724454337409e-05f,
-6.26139759905511e-05f,
-6.29205396029613e-05f,
-6.31922055813587e-05f,
-6.34290613409974e-05f,
-6.36312122378911e-05f,
-6.37987813960626e-05f,
-6.39319095262928e-05f,
-6.40307547365266e-05f,
-6.4095492334089e-05f,
-6.41263146198697e-05f,
-6.41234306746412e-05f,
-6.40870661376763e-05f,
-6.40174629778309e-05f,
-6.391487925727e-05f,
-6.37795888880065e-05f,
-6.36118813814352e-05f,
-6.34120615910403e-05f,
-6.31804494484614e-05f,
-6.29173796931019e-05f,
-6.26232015954722e-05f,
-6.22982786744525e-05f,
-6.19429884086736e-05f,
-6.15577219422071e-05f,
-6.11428837847619e-05f,
-6.06988915065879e-05f,
-6.02261754282833e-05f,
-5.97251783057106e-05f,
-5.91963550102224e-05f,
-5.86401722044023e-05f,
-5.80571080135255e-05f,
-5.74476516929464e-05f,
-5.68123032916221e-05f,
-5.61515733119774e-05f,
-5.54659823663212e-05f,
-5.47560608300273e-05f,
-5.40223484916847e-05f,
-5.32653942004291e-05f,
-5.24857555106721e-05f,
-5.16839983244288e-05f,
-5.08606965314632e-05f,
-5.00164316474562e-05f,
-4.91517924504131e-05f,
-4.8267374615513e-05f,
-4.73637803486132e-05f,
-4.64416180186218e-05f,
-4.5501501788938e-05f,
-4.45440512481755e-05f,
-4.35698910403686e-05f,
-4.25796504948758e-05f,
-4.15739632561745e-05f,
-4.05534669137558e-05f,
-3.95188026323246e-05f,
-3.84706147824963e-05f,
-3.74095505721944e-05f,
-3.63362596789495e-05f,
-3.52513938832866e-05f,
-3.41556067034013e-05f,
-3.30495530313092e-05f,
-3.19338887706706e-05f,
-3.08092704764648e-05f,
-2.96763549967043e-05f,
-2.85357991163705e-05f,
-2.73882592037593e-05f,
-2.62343908594003e-05f,
-2.50748485677371e-05f,
-2.39102853517339e-05f,
-2.27413524305865e-05f,
-2.15686988806958e-05f,
-2.0392971300071e-05f,
-1.92148134763324e-05f,
-1.80348660584579e-05f,
-1.68537662324395e-05f,
-1.56721474009943e-05f,
-1.44906388674902e-05f,
-1.33098655242169e-05f,
-1.21304475451533e-05f,
-1.09530000833746e-05f,
-9.77813297322283e-06f,
-8.60645043737829e-06f,
-7.43855079896758e-06f,
-6.27502619881872e-06f,
-5.11646231799598e-06f,
-3.96343810572349e-06f,
-2.81652551282231e-06f,
-1.67628923075757e-06f,
-5.43286436407872e-07f,
5.81933457334323e-07f,
1.69882904504592e-06f,
2.80686716623921e-06f,
3.90552313671397e-06f,
4.99428097372264e-06f,
6.07263361485467e-06f,
7.14008313057028e-06f,
8.19614093029787e-06f,
9.24032796203801e-06f,
1.02721749054007e-05f,
1.12912223580112e-05f,
1.22970210152324e-05f,
1.32891318431441e-05f,
1.42671262447348e-05f,
1.52305862192578e-05f,
1.61791045147037e-05f,
1.71122847733627e-05f,
1.80297416704377e-05f,
1.89311010456724e-05f,
1.98160000279816e-05f,
2.06840871530522e-05f,
2.15350224739038e-05f,
2.23684776643877e-05f,
2.31841361156243e-05f,
2.39816930253701e-05f,
2.47608554803058e-05f,
2.55213425312607e-05f,
2.62628852613713e-05f,
2.69852268471836e-05f,
2.76881226127196e-05f,
2.83713400765207e-05f,
2.90346589916937e-05f,
2.9677871378978e-05f,
3.03007815528719e-05f,
3.0903206140848e-05f,
3.1484974095687e-05f,
3.20459267009823e-05f,
3.25859175698492e-05f,
3.31048126368919e-05f,
3.36024901434722e-05f,
3.40788406163417e-05f,
3.45337668396904e-05f,
3.49671838206697e-05f,
3.53790187484599e-05f,
3.57692109469452e-05f,
3.61377118210647e-05f,
3.64844847969168e-05f,
3.68095052556901e-05f,
3.71127604615012e-05f,
3.73942494832179e-05f,
3.76539831103606e-05f,
3.78919837631567e-05f,
3.81082853968512e-05f,
3.83029334003579e-05f,
3.84759844893474e-05f,
3.86275065938727e-05f,
3.87575787406302e-05f,
3.8866290929957e-05f,
3.89537440076728e-05f,
3.90200495318706e-05f,
3.90653296347648e-05f,
3.90897168797088e-05f,
3.9093354113495e-05f,
3.90763943140511e-05f,
3.90390004336481e-05f,
3.89813452377419e-05f,
3.89036111395636e-05f,
3.88059900305833e-05f,
3.86886831069695e-05f,
3.85519006921668e-05f,
3.83958620557194e-05f,
3.82207952284668e-05f,
3.80269368142382e-05f,
3.78145317981768e-05f,
3.75838333518232e-05f,
3.73351026350876e-05f,
3.70686085952445e-05f,
3.67846277630824e-05f,
3.64834440463399e-05f,
3.61653485205641e-05f,
3.58306392175243e-05f,
3.54796209113175e-05f,
3.51126049022989e-05f,
3.47299087989734e-05f,
3.43318562979864e-05f,
3.39187769623452e-05f,
3.34910059980102e-05f,
3.30488840289915e-05f,
3.25927568710847e-05f,
3.21229753043848e-05f,
3.16398948447076e-05f,
3.11438755140624e-05f,
3.06352816103032e-05f,
3.01144814760946e-05f,
2.95818472673267e-05f,
2.90377547211135e-05f,
2.84825829235032e-05f,
2.79167140770348e-05f,
2.73405332682702e-05f,
2.67544282354346e-05f,
2.61587891362892e-05f,
2.55540083163661e-05f,
2.49404800776967e-05f,
2.43186004481496e-05f,
2.36887669515123e-05f,
2.30513783784305e-05f,
2.24068345583368e-05f,
2.17555361324792e-05f,
2.10978843281734e-05f,
2.04342807343983e-05f,
1.97651270788444e-05f,
1.9090825006532e-05f,
1.84117758601162e-05f,
1.77283804619801e-05f,
1.70410388982337e-05f,
1.63501503047186e-05f,
1.56561126551312e-05f,
1.495932255136e-05f,
1.42601750161419e-05f,
1.35590632881393e-05f,
1.28563786195292e-05f,
1.21525100762026e-05f,
1.14478443406704e-05f,
1.07427655177589e-05f,
1.00376549431904e-05f,
9.33289099512935e-06f,
8.62884890878591e-06f,
7.92590059414905e-06f,
7.22441445693406e-06f,
6.52475522282227e-06f,
5.82728376506355e-06f,
5.13235693551779e-06f,
4.44032739920081e-06f,
3.75154347240349e-06f,
3.06634896445296e-06f,
2.38508302317038e-06f,
1.70807998408878e-06f,
1.03566922349158e-06f,
3.68175015318385e-07f,
-2.94083608003316e-07f,
-9.50792990756429e-07f,
-1.60164498510903e-06f,
-2.24633707822957e-06f,
-2.88457251529726e-06f,
-3.51606041836508e-06f,
-4.1405159010472e-06f,
-4.75766017899044e-06f,
-5.3672206761039e-06f,
-5.96893112651197e-06f,
-6.56253167221256e-06f,
-7.14776895641407e-06f,
-7.72439621252695e-06f,
-8.29217334879925e-06f,
-8.85086702857723e-06f,
-9.40025074617521e-06f,
-9.94010489835156e-06f,
-1.04702168513777e-05f,
-1.09903810036992e-05f,
-1.15003988441811e-05f,
-1.20000790059446e-05f,
-1.24892373157939e-05f,
-1.29676968392356e-05f,
-1.34352879211057e-05f,
-1.38918482218078e-05f,
-1.43372227491768e-05f,
-1.47712638859842e-05f,
-1.51938314131016e-05f,
-1.56047925283423e-05f,
-1.60040218609995e-05f,
-1.63914014821138e-05f,
-1.67668209104844e-05f,
-1.71301771144641e-05f,
-1.74813745095637e-05f,
-1.78203249518961e-05f,
-1.81469477275018e-05f,
-1.84611695375892e-05f,
-1.87629244797279e-05f,
-1.90521540250401e-05f,
-1.93288069914307e-05f,
-1.95928395129016e-05f,
-1.98442150049985e-05f,
-2.00829041264386e-05f,
-2.03088847369704e-05f,
-2.05221418515167e-05f,
-2.07226675906579e-05f,
-2.09104611275098e-05f,
-2.10855286310533e-05f,
-2.12478832059766e-05f,
-2.13975448290908e-05f,
-2.15345402823792e-05f,
-2.16589030827471e-05f,
-2.17706734085351e-05f,
-2.18698980228636e-05f,
-2.19566301938759e-05f,
-2.20309296119499e-05f,
-2.20928623039478e-05f,
-2.21425005445764e-05f,
-2.21799227649299e-05f,
-2.22052134582896e-05f,
-2.22184630832555e-05f,
-2.22197679642845e-05f,
-2.2209230189713e-05f,
-2.21869575073415e-05f,
-2.21530632176586e-05f,
-2.21076660647849e-05f,
-2.20508901252157e-05f,
-2.19828646944433e-05f,
-2.19037241715403e-05f,
-2.1813607941786e-05f,
-2.17126602574166e-05f,
-2.16010301165839e-05f,
-2.14788711406045e-05f,
-2.13463414495824e-05f,
-2.1203603536491e-05f,
-2.10508241397953e-05f,
-2.08881741147018e-05f,
-2.07158283031179e-05f,
-2.05339654024071e-05f,
-2.03427678330235e-05f,
-2.01424216051101e-05f,
-1.99331161841466e-05f,
-1.97150443557299e-05f,
-1.94884020895713e-05f,
-1.92533884027966e-05f,
-1.90102052226299e-05f,
-1.87590572485474e-05f,
-1.85001518139831e-05f,
-1.82336987476685e-05f,
-1.79599102346913e-05f,
-1.76790006773523e-05f,
-1.73911865559027e-05f,
-1.7096686289245e-05f,
-1.67957200956739e-05f,
-1.64885098537403e-05f,
-1.61752789633143e-05f,
-1.58562522069298e-05f,
-1.55316556114829e-05f,
-1.52017163103648e-05f,
-1.48666624061034e-05f,
-1.45267228335893e-05f,
-1.41821272239585e-05f,
-1.38331057692082e-05f,
-1.34798890876143e-05f,
-1.31227080900243e-05f,
-1.27617938470932e-05f,
-1.23973774575348e-05f,
-1.20296899174529e-05f,
-1.16589619908198e-05f,
-1.12854240811699e-05f,
-1.09093061045694e-05f,
-1.05308373639279e-05f,
-1.01502464247116e-05f,
-9.76776099211927e-06f,
-9.38360778978138e-06f,
-8.99801244003842e-06f,
-8.61119934585469e-06f,
-8.22339157442569e-06f,
-7.83481074252834e-06f,
-7.44567690366961e-06f,
-7.05620843708182e-06f,
-6.66662193861727e-06f,
-6.27713211358587e-06f,
-5.88795167158395e-06f,
-5.49929122336098e-06f,
-5.11135917976332e-06f,
-4.72436165279992e-06f,
-4.33850235886763e-06f,
-3.95398252417812e-06f,
-3.57100079241897e-06f,
-3.18975313468634e-06f,
-2.81043276172504e-06f,
-2.43323003850373e-06f,
-2.05833240115816e-06f,
-1.685924276333e-06f,
-1.31618700294526e-06f,
-9.49298756398598e-07f,
-5.85434475269598e-07f,
-2.24765790491996e-07f,
1.32539042944795e-07f,
4.86315211761806e-07f,
8.36401407601896e-07f,
1.18263988767471e-06f,
1.52487653281903e-06f,
1.86296090296814e-06f,
2.1967462900115e-06f,
2.52608976803993e-06f,
2.85085224096945e-06f,
3.17089848753367e-06f,
3.48609720364737e-06f,
3.79632104212865e-06f,
4.10144664978819e-06f,
4.40135470188026e-06f,
4.69592993391713e-06f,
4.98506117085352e-06f,
5.26864135364426e-06f,
5.54656756317972e-06f,
5.81874104161062e-06f,
6.08506721106972e-06f,
6.34545568979961e-06f,
6.59982030570251e-06f,
6.84807910732276e-06f,
7.09015437227939e-06f,
7.32597261316241e-06f,
7.55546458091406e-06f,
7.77856526571272e-06f,
7.99521389537843e-06f,
8.205353931325e-06f,
8.40893306208027e-06f,
8.60590319439753e-06f,
8.79622044198664e-06f,
8.97984511188938e-06f,
9.15674168852855e-06f,
9.32687881545793e-06f,
9.49022927484591e-06f,
9.64676996472302e-06f,
9.79648187402453e-06f,
9.9393500554642e-06f,
1.00753635962716e-05f,
1.02045155868301e-05f,
1.03268030872496e-05f,
1.04422270919149e-05f,
1.0550792492045e-05f,
1.06525080363035e-05f,
1.07473862895008e-05f,
1.08354435894281e-05f,
1.0916700001865e-05f,
1.09911792738028e-05f,
1.10589087849281e-05f,
1.11199194974072e-05f,
1.11742459040199e-05f,
1.12219259746839e-05f,
1.12630011014179e-05f,
1.12975160417894e-05f,
1.13255188608912e-05f,
1.13470608718987e-05f,
1.13621965752502e-05f,
1.13709835965034e-05f,
1.13734826229118e-05f,
1.13697573387741e-05f,
1.13598743596031e-05f,
1.13439031651642e-05f,
1.13219160314341e-05f,
1.12939879615282e-05f,
1.12601966156489e-05f,
1.12206222401028e-05f,
1.11753475954396e-05f,
1.11244578837615e-05f,
1.10680406752548e-05f,
1.10061858339947e-05f,
1.09389854430728e-05f,
1.08665337290994e-05f,
1.07889269861305e-05f,
1.07062634990703e-05f,
1.06186434666002e-05f,
1.05261689236834e-05f,
1.04289436636974e-05f,
1.03270731602418e-05f,
1.02206644886739e-05f,
1.01098262474198e-05f,
9.9946684791103e-06f,
9.87530259159214e-06f,
9.75184127886139e-06f,
9.62439844196833e-06f,
9.49308910994118e-06f,
9.35802936077671e-06f,
9.21933624254407e-06f,
9.07712769464879e-06f,
8.93152246930308e-06f,
8.78264005324777e-06f,
8.6306005897712e-06f,
8.47552480106908e-06f,
8.31753391098936e-06f,
8.15674956820604e-06f,
7.9932937698635e-06f,
7.82728878573374e-06f,
7.65885708292867e-06f,
7.48812125120668e-06f,
7.31520392891465e-06f,
7.14022772960352e-06f,
6.96331516935742e-06f,
6.78458859487235e-06f,
6.60417011232209e-06f,
6.42218151704837e-06f,
6.23874422410882e-06f,
6.05397919971873e-06f,
5.86800689361913e-06f,
5.68094717240549e-06f,
5.49291925384727e-06f,
5.30404164223008e-06f,
5.11443206475166e-06f,
4.9242074089991e-06f,
4.73348366153649e-06f,
4.54237584763148e-06f,
4.35099797214519e-06f,
4.15946296161273e-06f,
3.96788260753768e-06f,
3.7763675109258e-06f,
3.58502702807881e-06f,
3.39396921767065e-06f,
3.20330078912824e-06f,
3.01312705233424e-06f,
2.82355186867183e-06f,
2.63467760343009e-06f,
2.44660507958479e-06f,
2.25943353297212e-06f,
2.0732605688689e-06f,
1.88818211999487e-06f,
1.70429240594667e-06f,
1.52168389407997e-06f,
1.3404472618458e-06f,
1.16067136059361e-06f,
9.82443180850183e-07f,
8.05847819080474e-07f,
6.30968445938114e-07f,
4.57886276012498e-07f,
2.86680539075395e-07f,
1.17428452831953e-07f,
-4.97948028199512e-08f,
-2.14916110022078e-07f,
-3.77864435677152e-07f,
-5.38570852660314e-07f,
-6.96968559519905e-07f,
-8.5299289867131e-07f,
-1.00658137308564e-06f,
-1.15767366147596e-06f,
-1.30621163198739e-06f,
-1.45213935439567e-06f,
-1.59540311081939e-06f,
-1.73595140495523e-06f,
-1.87373496984243e-06f,
-2.00870677416658e-06f,
-2.14082202711105e-06f,
-2.27003818176826e-06f,
-2.39631493712127e-06f,
-2.51961423860721e-06f,
-2.63990027727693e-06f,
-2.75713948756333e-06f,
-2.87130054367384e-06f,
-2.98235435462072e-06f,
-3.0902740579069e-06f,
-3.19503501188303e-06f,
-3.29661478679242e-06f,
-3.39499315452328e-06f,
-3.4901520770861e-06f,
-3.58207569383478e-06f,
-3.67075030745277e-06f,
-3.75616436872432e-06f,
-3.83830846011025e-06f,
-3.91717527815299e-06f,
-3.99275961473001e-06f,
-4.06505833718047e-06f,
-4.13407036732752e-06f,
-4.19979665941946e-06f,
-4.2622401770152e-06f,
-4.32140586883761e-06f,
-4.37730064362061e-06f,
-4.42993334397458e-06f,
-4.47931471929708e-06f,
-4.52545739775463e-06f,
-4.56837585736177e-06f,
-4.60808639618528e-06f,
-4.6446071017002e-06f,
-4.67795781932549e-06f,
-4.708160120167e-06f,
-4.73523726799615e-06f,
-4.75921418549266e-06f,
-4.78011741977943e-06f,
-4.79797510727911e-06f,
-4.81281693792078e-06f,
-4.82467411872586e-06f,
-4.83357933680285e-06f,
-4.83956672177993e-06f,
-4.84267180770512e-06f,
-4.84293149444328e-06f,
-4.84038400859978e-06f,
-4.8350688640006e-06f,
-4.82702682175797e-06f,
-4.81629984995191e-06f,
-4.80293108295687e-06f,
-4.7869647804432e-06f,
-4.76844628608298e-06f,
-4.74742198598981e-06f,
-4.72393926692185e-06f,
-4.69804647427729e-06f,
-4.66979286991169e-06f,
-4.63922858980587e-06f,
-4.60640460161349e-06f,
-4.57137266211669e-06f,
-4.53418527461856e-06f,
-4.49489564630047e-06f,
-4.45355764557233e-06f,
-4.41022575944365e-06f,
-4.36495505094286e-06f,
-4.317801116612e-06f,
-4.26882004410401e-06f,
-4.21806836990897e-06f,
-4.16560303723581e-06f,
-4.11148135407526e-06f,
-4.05576095146995e-06f,
-3.99849974201672e-06f,
-3.9397558786259e-06f,
-3.87958771356254e-06f,
-3.81805375779311e-06f,
-3.75521264066175e-06f,
-3.691123069919e-06f,
-3.6258437921263e-06f,
-3.55943355345803e-06f,
-3.49195106092336e-06f,
-3.42345494402937e-06f,
-3.35400371690615e-06f,
-3.28365574091442e-06f,
-3.21246918775589e-06f,
-3.14050200310536e-06f,
-3.06781187078387e-06f,
-2.99445617749092e-06f,
-2.9204919781143e-06f,
-2.84597596163407e-06f,
-2.77096441763785e-06f,
-2.69551320346391e-06f,
-2.61967771198731e-06f,
-2.54351284006418e-06f,
-2.46707295764928e-06f,
-2.39041187760002e-06f,
-2.31358282618093e-06f,
-2.23663841428083e-06f,
-2.15963060935584e-06f,
-2.08261070810835e-06f,
-2.00562930991492e-06f,
-1.92873629101175e-06f,
-1.85198077944851e-06f,
-1.77541113081986e-06f,
-1.69907490478283e-06f,
-1.62301884236816e-06f,
-1.54728884409369e-06f,
-1.47192994888574e-06f,
-1.39698631381516e-06f,
-1.32250119465413e-06f,
-1.24851692725776e-06f,
-1.17507490977595e-06f,
-1.10221558569852e-06f,
-1.02997842773779e-06f,
-9.58401922550402e-07f,
-8.87523556300847e-07f,
-8.17379801068637e-07f,
-7.48006102099267e-07f,
-6.79436865899722e-07f,
-6.1170544917867e-07f,
-5.44844148629826e-07f,
-4.78884191557767e-07f,
-4.13855727343869e-07f,
-3.49787819750523e-07f,
-2.8670844005994e-07f,
-2.24644461044386e-07f,
-1.63621651764123e-07f,
-1.03664673187799e-07f,
-4.4797074630806e-08f,
0.0f
};

}

#endif
