/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public abstract class ChangeConnectionHandle
extends AbstractHandle {
    private Connector fOriginalTarget;
    private Figure myTarget;
    private ConnectionFigure myConnection;
    private Point fStart;

    protected ChangeConnectionHandle(ConnectionFigure connectionFigure) {
        super(connectionFigure);
        this.setConnection(connectionFigure);
        this.setTargetFigure(null);
    }

    protected abstract Connector target();

    protected abstract void disconnect();

    protected abstract void connect(Connector var1);

    protected abstract void setPoint(int var1, int var2);

    protected Connector source() {
        if (this.target() == this.getConnection().getStartConnector()) {
            return this.getConnection().getEndConnector();
        }
        return this.getConnection().getStartConnector();
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.fOriginalTarget = this.target();
        this.fStart = new Point(n, n2);
        this.setUndoActivity(this.createUndoActivity(drawingView));
        ((UndoActivity)this.getUndoActivity()).setOldConnector(this.target());
        this.disconnect();
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Connector connector;
        Point point = new Point(n, n2);
        Figure figure = this.findConnectableFigure(n, n2, drawingView.drawing());
        if (figure != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(false, null);
            }
            this.setTargetFigure(figure);
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(true, this.getConnection());
            }
        }
        if ((connector = this.findConnectionTarget(point.x, point.y, drawingView.drawing())) != null) {
            point = Geom.center(connector.displayBox());
        }
        this.setPoint(point.x, point.y);
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Connector connector = this.findConnectionTarget(n, n2, drawingView.drawing());
        if (connector == null) {
            connector = this.fOriginalTarget;
        }
        this.setPoint(n, n2);
        this.connect(connector);
        this.getConnection().updateConnection();
        Connector connector2 = ((UndoActivity)this.getUndoActivity()).getOldConnector();
        if (connector2 == null || this.target() == null || connector2.owner() == this.target().owner()) {
            this.setUndoActivity(null);
        } else {
            this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getConnection()));
        }
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().connectorVisibility(false, null);
            this.setTargetFigure(null);
        }
    }

    private Connector findConnectionTarget(int n, int n2, Drawing drawing) {
        Figure figure = this.findConnectableFigure(n, n2, drawing);
        if (figure != null && figure.canConnect() && figure != this.fOriginalTarget && !figure.includes(this.owner()) && this.canConnectTo(figure)) {
            return this.findConnector(n, n2, figure);
        }
        return null;
    }

    protected abstract boolean canConnectTo(Figure var1);

    protected Connector findConnector(int n, int n2, Figure figure) {
        return figure.connectorAt(n, n2);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.green);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private Figure findConnectableFigure(int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }

    protected void setConnection(ConnectionFigure connectionFigure) {
        this.myConnection = connectionFigure;
    }

    protected ConnectionFigure getConnection() {
        return this.myConnection;
    }

    protected void setTargetFigure(Figure figure) {
        this.myTarget = figure;
    }

    protected Figure getTargetFigure() {
        return this.myTarget;
    }

    protected abstract Undoable createUndoActivity(DrawingView var1);

    public static abstract class UndoActivity
    extends UndoableAdapter {
        private Connector myOldConnector;

        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.swapConnectors();
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.swapConnectors();
            return true;
        }

        private void swapConnectors() {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            if (figureEnumeration.hasNextFigure()) {
                ConnectionFigure connectionFigure = (ConnectionFigure)figureEnumeration.nextFigure();
                this.setOldConnector(this.replaceConnector(connectionFigure));
                connectionFigure.updateConnection();
            }
        }

        protected abstract Connector replaceConnector(ConnectionFigure var1);

        public void setOldConnector(Connector connector) {
            this.myOldConnector = connector;
        }

        public Connector getOldConnector() {
            return this.myOldConnector;
        }
    }
}

