/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.Collection;
import java.util.Iterator;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.util.CollectionsFactory;

public final class FigureEnumerator
implements FigureEnumeration {
    private Iterator myIterator;
    private Collection myInitialCollection;
    private static FigureEnumerator singletonEmptyEnumerator = new FigureEnumerator(CollectionsFactory.current().createList());

    public FigureEnumerator(Collection collection) {
        this.myInitialCollection = collection;
        this.reset();
    }

    public boolean hasNextFigure() {
        return this.myIterator.hasNext();
    }

    public Figure nextFigure() {
        return (Figure)this.myIterator.next();
    }

    public static FigureEnumeration getEmptyEnumeration() {
        return singletonEmptyEnumerator;
    }

    public void reset() {
        this.myIterator = this.myInitialCollection.iterator();
    }

    public boolean contains(Figure figure) {
        Iterator iterator = this.myInitialCollection.iterator();
        while (iterator.hasNext()) {
            if (!((Figure)iterator.next()).includes(figure)) continue;
            return true;
        }
        return false;
    }
}

